C         
C        This is an example of a FORTRAN program using the tools/comm
c       and processor subsets.
C
      subroutine worker()
      integer          top, pset
      double precision count, work, message(10)
      integer          pspartition, MSG_DBL, pimytid, pinumtids
      parameter ( MSG_DBL = 3 )
C
C     partition the processors into two groups
C
      if ( pimytid() .ge. pinumtids()/2 ) then
        top = 1
      else
        top = 0
      endif
      pset = pspartition(top+1,0)
c      
      print*, 'Processor ',pimytid(),' Set ',top,' Total ',pinumtids()
c
c     global sum over all processors
c
      count = pimytid()
      call pigdsum(count,1,work,0)
      print*, 'Processor ',pimytid(),' Sum on all ',count
      count = pimytid()
      call pigdmax(count,1,work,0)
      print*, 'Processor ',pimytid(),' Max on all ',count
c
c     global sum over top processors
c
      count = pimytid()
      if ( top .eq. 1 ) then 
        call pigdsum(count,1,work,pset)
        print*, 'Processor ',pimytid(),' Sum on subset ',count,top
      else
        call pigdmax(count,1,work,pset)
        print*, 'Processor ',pimytid(),' Max on subset ',count,top
      endif
C
      call psdestroy(pset)
C
c     send a message from last processor to first 
c
      if ( pimytid() .eq. pinumtids()-1 ) then
        message(1) = pimytid()
        call pibsend(1,message,10*8,0,MSG_DBL)
      endif
      if ( pimytid() .eq. 0 ) then
        call pibrecv(1,message,10*8,MSG_DBL)
        print*, 'Received message ',message(1)
      endif

      return 
      end
    

