#ifndef PIO_BUF_SIZE
#include <fcntl.h>
typedef struct {
    int     fd;
    long    fpos;
    int     mode, pmode;
    long    *sbuf;
    int     bsize;
    int     mtype;
    ProcSet *procset;
    int     rcnt;            /* Used to keep track of service requests */
    /* Here are the distributed writers and readers */
    void    (*diswriterSetup)(), (*disreaderSetup)();
    void    *disWctx, *disRctx;
    void    (*diswriter)(), (*diswriterwait)(), (*disflush)(),
            (*disreader)(), (*disreaderwait)();
    /* and the sequential seek, write, and read */
    int     (*lseek)(), (*write)(), (*read)();
    } PIFILE;

/* This assumes a 0 origin for the relative values of start,end */
typedef struct {
    int mdim,               /* size of global array in this dimension */
        ndim,               /* size of local array in this dimension */
        start,              /* starting index for local piece */
        end;                /* ending index for local piece */
    int gstart, gend;       /* GLOBAL indices for start and end */
    } PIArrayPart;

extern PIFILE *PIFopen();
extern void   PIFclose(), PIFflush();
extern void   PIWriteCommon();
extern void   PIReadCommon();
extern void   PIWriteDistributedArray();
extern void   PIReadDistributedArray();

#define PIO_BUF_SIZE 1024

/* PIO Modes.  Associated with each of these should be a default reader/writer
 */
#define PIO_AS_SEQUENTIAL 0
#define PIO_AS_PARALLEL   0x1
#define PIO_ANY_NUMBER    0x2
#endif
