#ifndef lint
static char SCCSid[] = "@(#) ./comm/pvfp.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/procset.h"

/* 
   This it the interface to the virtual front panel for the communication
   states logging code.
 */
/*
   Host is the host that is to display the output 
 */
static void *info = 0;

void VFPSetup( host )
char *host;
{
#if !defined(LOGCOMMDISABLE)
int  win, row;
char bhost[128];

if (MYPROCID == 0) {
    if (!host) {
	SYGetHostName( bhost, 128 );
	strcat( bhost, ":0" );
	host = bhost;
	GSCATTER( bhost, 128, 1, ALLPROCS, MSG_OTHER );
	}
    win = VFPInit( 0, host, NUMNODES, 5, 15 );
    GSCATTER( &win, sizeof(int), 1, ALLPROCS, MSG_INT );
    }
else {
    if (!host) {
	GSCATTER( bhost, 128, 0, ALLPROCS, MSG_OTHER );
	host = bhost;
	}
    GSCATTER( &win, sizeof(int), 0, ALLPROCS, MSG_INT );
    win = VFPInit( win, host, NUMNODES, 5, 15 );
    }

/* Define the states */
row = MYPROCID;

#ifndef NEW_VFP
VFPStateDefine( &_state_send,  VFPColor("green"),  row, 0, 15 );
VFPStateDefine( &_state_recv,  VFPColor("orange"),    row, 1, 15 );
VFPStateDefine( &_state_recvwait,  VFPColor("red"),    row, 2, 15 );
VFPStateDefine( &_state_gsync, VFPColor("yellow"), row, 3, 15 );
VFPStateDefine( &_state_gop,   VFPColor("blue"),   row, 4, 15 );
#else

#endif

#endif
}

#ifdef FOO
/* This needs to move to xtools/papps */
#include "xtools/basex11.h"
void PVFPSetup( host, nx, ny )
char *host;
int  nx, ny;
{
#if !defined(LOGCOMMDISABLE)
int    win, row;
int    wx, wy;
static XBWindow XBWin;
extern void VFPDrawForLog(), *VFPInit3();
char bhost[128];
static char *states[] = {"-- Waiting for Message","-- Sending Message",
		    "-- Receiving Message", "-- Processing" }  ;

wx = 300;
wy = 200;
if (nx <= 0 || ny <= 0) {
    nx = NUMNODES;
    ny = 1;
    /* Try to remove some powers of two */
    while (nx > 2*ny && !(nx & 0x1)) {
	nx = nx / 2;
	ny = 2 * ny;
	}
    }
wx = nx * 100;
wy = ny * 100;

/* Make wx wide enough for the messages */
/* This should really use the size of the expected font */
if (wx < 400) wx = 400;

if (!host) {
    SYGetHostName( bhost, 128 );
    strcat( bhost, ":0" );
    host = bhost;
    GSCATTER( bhost, 128, MYPROCID == 0, ALLPROCS, MSG_OTHER );
    }

/* I really want to open a parallel window but not a quick one */
XBPQuickWindow( &XBWin, 0, host, "pvfp", -1, -1, wx, wy + 100, ALLPROCS );
XBWin.h = wy;
info = VFPInit3( &XBWin, nx, ny, 0 );
VFPInitForLog( info );
XBWin.h = wy + 100;
VFPDrawIndex( &XBWin, info, 0, wy, wx, 100, states, 4 ) ;
PISetVFP( info, VFPDrawForLog );
#endif
}

#ifdef NEW_VFP
/* issues:
   have a stack of states, so that an "undo" restores the previous state

   Need to decide on whether pix is a pixval, pixmap, or index used to
   establish what to use (should be the latter)
 */
#define WORKING   0
#define SENDING   1
#define IDLE      2
#define RECEIVING 3
#define MESSAGE   4
void VFPDoState( vfpctx, from, to, len, ev )
void *vfpctx;
int  from, to, len, ev;
{
printf("BUG!\n");
switch (ev) {
    case LOG_RECVE:
        VFPDrawConnection( vfpctx, from, to, MESSAGE );
        VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_RECVS:
	VFPSetState( vfpctx, MYPROCID, RECEIVING );
	break;
    case LOG_RECVWE:
	VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_RECVWS:
	VFPSetState( vfpctx, MYPROCID, IDLE );
	break;
    case LOG_SENDE:
	VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_SENDS:
	VFPSetState( vfpctx, MYPROCID, SENDING );
        VFPDrawConnection( vfpctx, from, to, MESSAGE );
	break;
    }
}
#endif

#endif
