#ifndef lint
static char SCCSid[] = "@(#) ./doc/doc2lt.c 07/23/93";
#endif

#include <ctype.h>
#include <string.h>
#include "doc.h"

/* This is designed to work with comments in C programs.  Comments to
   be processed by this routine have the form:
    / * <char> .... <char> * /
   where <char> is one of the characters in MATCH_CHARS.  The definitions
   of the characters follows
 */

/*D
doc2lt - program to extract short descriptions in LaTeX format

Input:
. filenames - Names the files from which documents are to be extracted

Author: 
Bill Gropp
D*/
main( argc, argv )
int  argc;
char **argv;
{
char routine[MAX_ROUTINE_NAME];
char *infilename;
FILE *fd;
char kind;

/* process all of the files */
argc--; argv++;
while (argc--) {
    infilename = *argv++;
    /* Insert a routine to shorten file names here? */
    fd = fopen( infilename, "r" );
    if (!fd) {
    	fprintf( stderr, "Could not open file %s\n", infilename );
    	continue;
        }
    while (FoundLeader( fd, routine, &kind )) {
      if (kind == ROUTINE) {
	OutputTeXLineRoutine( fd, stdout, routine, infilename, kind );
	}
      else if (kind == MACRO) {
	OutputTeXLineMacro( fd, stdout, routine, infilename, kind );
        }
      }
    fclose( fd );
    }
return 0;
}

/* 
   There are a number of things to watch for.  One is that leading blanks are
   considered significant; since the text is being formated, we usually dont
   agree with that. 
 */
OutputTeXLineRoutine( fin, fout, name, filename, kind )
FILE *fin, *fout;
char *name, *filename, kind;
{
int c;
char buffer[1024], token[1024], *p;
int  i, nsp, newline, leadingm;

    /* Get the text that goes with the name and save it */
    p  = buffer;
    newline = 0;
    leadingm = 1;
    while (1) {
	*p = getc( fin );
	if (*p == '\n') {
	    if (newline) break;
	    *p = ' ';
	    newline = 1;
	    }
	if (*p == kind) {
	    ungetc( *p, fin );
	    break;
	    }
	if (!isspace(*p)) {
	    if (newline) 
		newline = 0;
	    if (leadingm && *p == '-') 
		p--;
	    leadingm = 0;
	    }
	p++;
	}
    *p = '\0';

    /* Skip to trailer */
    SkipText( fin, name, filename, kind );

    /* Now, hunt for the first open brace.  We use CoDe since \code is a 
       latexinfo macro*/
    fprintf( fout, "\\k{%s}{\\CoDe{", name );
    SkipWhite( fin );
    newline = 0;
    while (1) {
	c = FindNextToken( fin, token, &nsp );
	if (c == EOF || token[0] == '{') break;
	/* Don't output "register" */
	if (c == '\n') newline = 1;
	else {
	    if (strcmp( token, "register" ) != 0) {
		if (newline) {
		    fputs( "\\\\", fout );
		    newline = 0;
		    nsp     = 0;
		    }
		for (i=0; i<nsp; i++) putc( ' ', fout );
		fputs( token, fout );
		}
	    }
	}
    fprintf( fout, "}\\DeFn{%s}}\n", buffer );
}

/*
    This routine skips the text part of a text page.
 */        
SkipText( fin, name, filename, kind )
FILE *fin;
char *name, *filename;
char kind;
{
int  c;
char lineBuffer[MAX_LINE], *lp;
	
lineBuffer[0] = '+';   /* Sentinal on lineBuffer */
while (1) {
    lp = lineBuffer + 1;
    c  = getc( fin );
    if (c == EOF) break;
    if (c == ARGUMENT || c == VERBATIM)
	SkipLine( fin );
    else if (c == '\n')
	;
    else {
	if (isspace(c) && c != '\n')
	    SkipWhite( fin );
	else 
	    *lp++ = c;
    	/* Copy to end of line; do NOT include the EOL */
    	while ((c = getc( fin )) != EOF && c != '\n') 
    	    *lp++ = c;
    	lp--;
    	while (isspace(*lp)) lp--;
    	lp[1] = '\0';    /* Add the trailing null */
    	if (lineBuffer[1] == kind && strcmp(lineBuffer+2,"*/") == 0)
    	    break;
        }
    }
}

/* This is like skip text, except that it looks for a SYNOPSIS: for the
   definition of the format of the macro.

   Returns 1 if the closing item (<kind> * /) was read; 0 otherwise */
int FindSynopsis( fin, kind, has_synopsis, synopsis )
FILE *fin;
char kind;
int  *has_synopsis;
char *synopsis;
{
int  c, nc;
char lineBuffer[MAX_LINE], *lp, *sp;
int  rc;

rc = 0;
/* Note that the NAME field can't use a font changes */
lineBuffer[0] = '+';   /* Sentinal on lineBuffer */
while (1) {
    lp = lineBuffer + 1;
    c  = getc( fin );
    if (c == EOF) break;
    if (c == VERBATIM || c == ARGUMENT)
	SkipLine( fin );
    else if (c == '\n') 
	;
    else {
	/* Check for a "synopsis:" */
	if (isspace(c) && c != '\n')
	    SkipWhite( fin );
	else 
           *lp++ = c;
           
    	/* Copy to end of line; do NOT include the EOL */
    	while ((c = getc( fin )) != EOF && c != '\n') 
    	    *lp++ = c;
    	lp--;
    	while (isspace(*lp)) lp--;
    	lp[1] = '\0';    /* Add the trailing null */
    	if (lineBuffer[1] == kind && strcmp(lineBuffer+2,"*/") == 0) {
	    rc = 1;
	    break;
	    }
    	else if (lp[0] == ':') {
    	    *lp = '\0';
	    /* Need upper case to get it to look right */
	    UpperCase( lineBuffer + 1 );
	    /* If there is a "manual" SYNOPSIS, don't generate one later */
	    if (strcmp( lineBuffer+1, "SYNOPSIS" ) == 0) {
		/* enter read synopsis mode */
		sp = synopsis;
		strcpy( sp, "MACRO " );
		sp += 6;
		while (1) {
		    nc = GetLine( fin, sp );
		    nc = TrimLine( sp );
		    /* Look for end of synopsis */
		    if (nc == 0) break;
		    if (sp[0] == kind && sp[1] == '*' && sp[2] == '/') {
			rc    = 1;
			sp[0] = '\0';
			break;
			}
		    else {
			sp += nc;
			sp[0] = '\\'; sp[1] = '\\'; sp += 2;
			}
		    }
		*has_synopsis = 1;
		/* Undo the last \\ */
		if (sp[-1] == '\\' && sp[-2] == '\\') sp[-2] = '\0';
		}
	    if (rc == 1) break;
    	    }
    	}
    }
return rc;
}

/* a comment for a macro has the form 
  *M
       Name - short text 

      long text 
  
      Synopsis:
      declaration of the macro as if it was a function

      Potentially more stuff
   M*
 */
OutputTeXLineMacro( fin, fout, name, filename, kind )
FILE *fin, *fout;
char *name, *filename, kind;
{
char buffer[1024], *p, synopsis[1024];
int  newline, leadingm, has_synopsis;
int  rc;

/* Get the text that goes with the name and save it */
p  = buffer;
newline = 0;
leadingm = 1;
while (1) {
    *p = getc( fin );
    if (*p == '\n') {
        if (newline) break;
        *p = ' ';
        newline = 1;
        }
    if (*p == kind) {
        ungetc( *p, fin );
        break;
        }
    if (*p == '_') {
        *p++ = '\\';
    *p   = '_';
        }
    if (!isspace(*p)) {
        if (newline) 
    	newline = 0;
        if (leadingm && *p == '-') 
    	p--;
        leadingm = 0;
        }
    p++;
    }
*p = '\0';

/* Look for Synopsis: */
has_synopsis = 0;
rc = FindSynopsis( fin, kind, &has_synopsis, synopsis );

if (has_synopsis) {
    fprintf( fout, "\\k{%s}{\\CoDe{%s", name, synopsis );
    }
else {
    fprintf( fout, "\\k{%s}{\\CoDe{%s", name, name );
    }
fprintf( fout, "}\\DeFn{%s}}\n", buffer );
return rc;
}
