      subroutine dfcn(m,n,x,fvec,fjac,ldfjac,info,prob)
      integer m,n,ldfjac,info,prob
      double precision x(n),fvec(m),fjac(ldfjac,n)
c     *********
c
c     Subroutine dfcn
c
c     This subroutine selects the nonlinear least squares problem
c     specified by the variable prob in the common block specs.
c     Appropriate values for the dimensions m and n of the problem 
c     can be found in the comments of each least squares problem.
c
c     The subroutine statement is
c
c       subroutine dfcn(m,n,x,fvec,fjac,ldfjac,info)
c
c     where
c
c       m is an integer variable
c         On entry m is the number of functions.
c         On exit m is unchanged
c
c       n is an integer variable.
c         On entry n is the number of variables.
c         On exit n is unchanged.
c
c       x is a double precision array of dimension n.
c         On entry x specifies the vector of unknowns if info > 0.
c         On exit x is unchanged unless info < 0.
c
c       fvec is a double precision array of dimension m.
c         On entry fvec need not be specified.
c         On exit fvec is unchanged unless info = 1.
c
c       fjac is a double precision array of dimension (ldfjac,n).
c         On entry fjac need not be specified.
c         On exit fjac is unchanged unless info = 2.
c
c       ldfjac is an integer variable.
c          On entry ldfjac is the leading dimension of fjac.
c          On exit ldfjac is unchanged.
c
c       info is an integer variable.
c         On entry info specifies the action to be taken:
c
c         info               action
c         ----               ------
c           1       Evaluate the function at x.
c           2       Evaluate the Jacobian matrix at x.
c          -1       Set x to the standard starting point x0.
c          -2       Set x to 10*x0.
c          -3       Set x to 100*x0.
c
c     Subprograms called
c
c       MINPACK-supplied ... dosb1,dosb2,dmeyer,dkosb,ddgv,dcquad,
c                            dmorgf,dmorgr,drog,dflow,dswrl3,dapine
c
c     MINPACK-2 Project. October 1990
c     Argonne National Laboratory and University of Minnesota.
c     Brett M. Averick.
c
c     **********
      character*2 task
      integer nfev,njev,nint
      double precision param
      common /path/ param
      common /size/ nint
      common /count/ nfev,njev

c     Update counters for the number of function and Jacobian calls

     
      if (info .eq. 2) njev = njev + 1

      if (info .eq. -1) task = 'XS'
      if (info .eq.  1) task = 'F'
      if (info .eq.  2) task = 'J'

c     Select a problem

      if (prob .eq. 1) then
         call ddgv(n,x,fvec,fjac,ldfjac,task,'DDGV1')
      else if (prob .eq. 2) then
         call dmorgf(n,x,fvec,fjac,ldfjac,task)
      else if (prob .eq. 3) then
         call dmorgr(n,x,fvec,fjac,ldfjac,task)
      else if (prob .eq. 4) then
         nint = n/8
         param = 10
         call dflow(n,x,fvec,fjac,ldfjac,task,param,nint)
      else if (prob .eq. 5) then
         nint = n/14
         param = .1
         call dswrl3(n,x,fvec,fjac,ldfjac,task,param,nint)
      else
         print *,'not a valid function name'
         stop
      end if 

      return
      end
