/*
    Context for Newton's method for nonlinear solver using a Trust
 Region method.
*/

#ifndef __NEWTONTRUSTCONTEXT
#define __NEWTONTRUSTCONTEXT

typedef struct {
  /* ------- Parameters used by Trust region method ------------------*/
  double mu,eta,delta0,delta1,delta2,delta3,sigma,deltatol;     
} NLNewtonTRCntx;

NLCntx *NLNewtonTRCreate();
void NLNewtonTRSetUp( /* nlP, usrP */ );
int  NLNewtonTRSolve( /* nlP, usrP */ );
void NLNewtonTRDestroy( /* nlP, usrP */ );

#endif


