/* @(#) ./nonlin/nlfunc.h 07/23/93 */

#if !defined(__NLFUNCTION)
#define __NLFUNCTION

/* --------------Routines to Initialize and run a Solver-----------------*/

NLCntx *NLCreate(/* int NameofSolver */);

int  NLDefaultLineSearch();
int  NLSimpleLineSearch();
void NLDefaultMonitor();
int  NLDefaultConverged();

void NLRegisterAll();
void NLRegister();
void NLSetDefaults();

/*M
   NLSetUp - Sets up the internal data structures for the
   later use of a nonlinear solver.

   Input Parameters:
.   nlP   - iterative context obtained from NLCreate()
.   usrP  - user context

   Synopsis:
   void NLSetUp( nlP, usrP )
   NLCntx *nlP;
   void   *usrP;
M*/
#define NLSetUp(nlP,usrP)      (*(nlP)->setup)(nlP,usrP)

/*M
   NLSolve - Solves nonlinear system, call it after calling 
   NLCreate(), NLSetUp(), and NLSet*().

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate
.   usrP - User context
.   returns number of iterations required

   Synopsis:
   int NLSolve( nlP, usrP )
   NLCntx *nlP;
   void   *usrP;
M*/
#define NLSolve(nlP,usrP)      (*(nlP)->solver)(nlP,usrP)

/*M
   NLDestroy Destroys NLCntx created with NLCreate().

   Input Parameters:
.   nlP   - nonlinear context obtained from NLCreate
.   usrP  - user context

   Synopsis:
   void NLDestroy( nlP, usrP )
   NLCntx *nlP;
   void   *usrP;
M*/
#define NLDestroy(nlP,usrP)    (*(nlP)->destroy)(nlP,usrP)

/* ------------Routines (or Macros) to Set Solver Parameters------------*/

/*M
   NLSetIterations - Sets the maximum number of iterations to use.

   Input Parameters:
.   nlP  - nonlinear context obtained from NLCreate()
.   maxits - maximum iterations to use

   Synopsis:
   void NLSetIterations( nlP, its )
   NLCntx *nlP;
   int    its;
M*/
#define NLSetIterations(nlP, its)         (nlP)->max_it     = its

/*M
   NLSetFunctionTolerance - Sets the convergence tolerance of the norm of 
   the function.

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   tol - tolerance

   Synopsis:
   void NLSetFunctionTolerance( nlP, r )
   NLCntx *nlP;
   double r;
M*/
#define NLSetFunctionTolerance(nlP, r)    (nlP)->ftol       = r

/*M
   NLSetSolutionTolerance - Sets the convergence tolerance in terms of 
   the norm of the change in the solution between steps.

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   tol - tolerance

   Synopsis:
   void NLSetSolutionTolerance( nlP, a )
   NLCntx *nlP;
   double a;
M*/
#define NLSetSolutionTolerance(nlP, a)    (nlP)->xtol       = a

/*M
   NLSetSolution - Sets the location of the solution for the 
   system to be solved.

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   x   - the solution vector

   Synopsis:
   void NLSetSolution( nlP, b )
   NLCntx *nlP;
   void   *b;
M*/
#define NLSetSolution(nlP,b)              (nlP)->vec_sol    = b

/*M
   NLSetResidualHistory - Sets the location of where the norm of the 
   function should be stored at each iteration. (optional)

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   r   - the solution vector

   Synopsis:
   void NLSetResidualHistory( nlP, h )
   NLCntx *nlP;
   void   *h;
M*/
#define NLSetResidualHistory(nlP,h)      (nlP)->residual_history  = h

/*M
   NLSetVectorOps - Sets the vector context. (required)

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   VCCntx - vector context, obtained from VECreate().

   Synopsis:
   void NLSetVectorOps( nlP, vecntx )
   NLCntx *nlP;
   VECntx *vecntx;
M*/
#define NLSetVectorOps(nlP,vecntx)      (nlP)->vc  = vecntx

/*M
   NLSetFunction - Sets the function for nonlinear solver.

   Calling sequence of function:
.   fun(NLcntx *nlP, void *usrP, void *invector, void *outvector);

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   fun - pointer to void function

   Synopsis:
   void NLSetFunction( nlP, fun )
   NLCntx *nlP;
   void   (*fun)();
M*/
#define NLSetFunction(nlP,a)                 (nlP)->fun      = a

/*M
   NLSetInitialGuess - Sets the function which calculates the initial
   guess for nonlinear solver.

   Calling sequence of function:
.   fun(NLcntx *nlP, void *usrP, void *outvector);

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   fun - pointer to void function

   Synopsis:
   void NLSetInitialGuess( nlP, fun )
   NLCntx *nlP;
   void   (*fun)();
M*/
#define NLSetInitialGuess(nlP,a)           (nlP)->initial_guess   = a

/*M
   NLSetStepSetUp - A user provided setup routine which is called
   once before several calls to the StepCompute() routine. (optional)

   Calling sequence of function:
.   fun(NLcntx *nlP, void *usrP, void *invector);

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   fun - pointer to void function

   Synopsis:
   void NLSetStepSetUp( nlP, fun )
   NLCntx *nlP;
   void   (*fun)();
M*/
#define NLSetStepSetUp(nlP,a)            (nlP)->stepSetup   = a

/*M
   NLSetStepCompute - A user provided routine which is called
   to compute the next step to try.  


   Calling sequence of function:
.   fun(NLcntx *nlP, void *usrP, void *invector, void *outvector);

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   fun - pointer to void function

   Synopsis:
   void NLSetStepCompute( nlP, fun )
   NLCntx *nlP;
   void   (*fun)();

   Note: 
   There (will be/is) a version that applies the approximate inverse 
   Jacobian to a vector.
M*/
#define NLSetStepCompute(nlP,a)            (nlP)->stepCompute   = a

/*M
   NLSetStepDestroy - A user provided routine which is called
   after StepCompute has been applied to several vectors before 
   StepSetUp is called for another point.

   Calling sequence of function:
.   fun(NLcntx *nlP, void *usrP);

   Input Parameters:
.   nlP - nonlinear context obtained from NLCreate()
.   fun - pointer to void function

   Synopsis:
   void NLSetStepDestroy( nlP, fun )
   NLCntx *nlP;
   void   (*fun)();
M*/
#define NLSetStepDestroy(nlP,a)      (nlP)->stepDestroy    = a

/*M
   NLSetMonitor - Sets the function which is to be used at every
   iteration of the iterative solution. The default is to print 
   the residual.

   Calling sequence of function:
.   fun(NLcntx  *nlP, void *usrP, void *solution, void *F, double *norm of F);
   
   Input Parameters:
.   nlP -  nonlinear context obtained from NLCreate()
.   monitor - pointer to void function

   Synopsis:
   void NLSetMonitor( nlP, monitor )
   NLCntx *nlP;
   void   (*monitor)();
M*/
#define NLSetMonitor(nlP,a)                 (nlP)->usr_monitor      = a

/*M
   NLGetNumberVectorOpsUsed - Gets the number of vector operations used 
   by the nonlinear solver.

   
   Input Parameters:
.   nlP -  nonlinear context obtained from NLCreate()
.   a - variable to store number of vector ops used

   Synopsis:
   void NLGetNumberVectorOpsUsed( nlP, a )
   NLCntx *nlP;
   int    a;
M*/
#define NLGetNumberVectorOpsUsed(nlP,a)     a = (nlP)->nvectors

/*M
   NLGetNumberStepComputationsUsed - Gets the number of 
   applications of the StepCompute routine used. 

   
   Input Parameters:
.   nlP -  nonlinear context obtained from NLCreate()
.   a - variable to store number of applications used

   Synopsis:
   void NLGetNumberStepComputationsUsed( nlP, a )
   NLCntx *nlP;
   int    a;
M*/
#define NLGetNumberStepComputationsUsed(nlP,a)  a = (nlP)->nsteps

/*M
   NLGetNumberFunctionApplicationsUsed - Gets the number of 
   applications of the function used in the nonlinear solver. 

   
   Input Parameters:
.   nlP -  nonlinear context obtained from NLCreate()
.   a - variable to store number of applications used

   Synopsis:
   void NLGetNumberFunctionApplicationsUsed( nlP, a )
   NLCntx *nlP;
   int    a;
M*/
#define NLGetNumberFunctionApplicationsUsed(nlP,a)  a = (nlP)->nfunc

/*M
   NLSetTruncationTolerance - Sets the tolerance which may be used 
   by the Step routines to control the accuracy of the step computation.

   Input Parameters:
.   nlP -  nonlinear context obtained from NLCreate()
.   tol - tolerance 

   Synopsis:
   void NLSetTruncationTolerance( nlP, a )
   NLCntx *nlP;
   int    a;

   Note:
   If the step computation involves an application of the inverse
   Jacobian, this parameter may be used to control the accuracy
   of that application.
M*/
#define NLSetTruncationTolerance(nlP,a)   (nlP)->trunctol = a;

#endif

   
