#ifndef lint
static char SCCSid[] = "@(#) ./set/isetr.c 07/23/93";
#endif

#include "tools.h"
#include "set/iset.h"           /*I "set/iset.h" I*/

/*
    Routines for operations on sets, stored as a range.
 */
 
/*@
    ISRAlloc - Allocate an index set based on a range

    Input Parameter:
.   n - maximum number of indices in the set    
@*/
ISetRange *ISRAlloc( s, e, stride )
int s, e, stride;
{
ISetRange *is;

is         = NEW(ISetRange);    CHKPTRV(is,0);
is->is     = s;
is->ie     = e;
is->stride = stride;

return is;
}

/*@
    ISRDestroy - Deallocate an index set

    Input Parameter:
.   is  - pointer to index set
@*/    
void ISRDestroy( is )
ISet *is;
{
FREE( is );
}

/*@
    ISRUnion - Form the union of two index sets

    Input Parameters:
.   a,b   - sets to union
.   c      - set to place union in (should be preallocated)

    Note:
    A union of ranges is only a range in special cases.  If the union is
    not a range, an error is generated (in this case, convert to another
    representation such as the general index set form).
@*/
void ISRUnion( a, b, c )
ISetRange *a, *b, *c;
{
int s, e, stride;	
if (b->stride != a->stride) {
    SETERRC(1,"Can not union two ranges with different strides" );
    return;
    }
stride = a->stride;
#ifdef FOO
if () need to look for the case "[...] ... [...]"
if () need to look for |a->is - b->is| mod stride != 0
#endif
s = (a->is > b->is) ? b->is : a->is;
e = (a->ie > b->ie) ? a->ie : b->ie;
c->is     = s;
c->ie     = e;
c->stride = stride;
}

/*@
    ISRIntersection - Form the intersection of two index sets

    Input Parameters:
.   a,b   - sets to intersect
.   c      - set to place intersection in (should be preallocated)

    Note:
    An intersection of ranges is only a range in special cases.  If the
    intersection is not a range, an error is generated (in this case,
    convert to another representation such as the general index set form).
@*/
void ISRIntersection( a, b, c )
ISetRange *a, *b, *c;
{
int s, e, stride;	

}

/*@
    ISRIntersectionNotNull - Without forming the intersection, return whether 
    the two sets intersect.

    Input Parameters:
.   a,b   - sets to intersect

    Returns:
    1 if the sets intersect, 0 otherwise.
@*/
int ISRIntersectionNotNull( a, b )
ISetRange *a, *b;
{
}

/*@
    ISRCompIntersection - Intersect one set with the complement of another 

    Input Parameters:
.   a,b   - for a intersection complement(b)
.   c      - set to place result in (must be preallocated)
@*/
void ISRCompIntersection( a, b, c )
ISetRange *a, *b, *c;
{
}
