#ifndef lint
static char SCCSid[] = "@(#) ./solvers/ssord.c 07/23/93";
#endif

/*
     Routines needed for the SSOR preconditioner.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include <math.h>

void  *SViSSORBuildSolution( itP, ctx, v )
ITCntx *itP;
SVctx   *ctx;
double  *v;
{
  SVSSORctx *lctx = (SVSSORctx *) ctx->private;
  v = (*itP->BuildSolution)(itP, (void *) ctx, v); CHKERRN(1);
  SpTsolveRelaxU( lctx->split,lctx->omega,v,v ); CHKERRN(1);
  return v;
}

/*ARGSUSED*/
void SViCreateSSOR(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
  SVSSORctx *lctx;
  lctx = NEW(SVSSORctx); CHKPTR(lctx);
  lctx->omega = 1;
  ctx->method = ITGMRES; 
  ctx->private = (void *) lctx;
  ctx->is_iter = 1;

  ctx->setup   = SViSetupSSOR;
  ctx->solve   = SViSolveSSOR;
  ctx->destroy = SViDestroySSOR;
  ctx->BuildSolution = SViSSORBuildSolution;
}
/*------------------------------------------------------------------*/
void SViSetupSSOR(ctx)
SVctx *ctx;
{
  SVSSORctx *lctx = (SVSSORctx *) ctx->private;
  int         n = ctx->size;
  double      t1;

  t1 = SYGetCPUTime();
  ctx->itctx = ITCreate(ctx->method);  CHKERR(1);
  DVSetDefaultFunctions(ctx->itctx->vc); CHKERR(1);
  ctx->itctx->amult = SViEisenstat;
  ctx->itctx->binv  = ctx->itctx->vc->copy;
  /* put dummy values in vec_sol and vec_rhs */
  ctx->itctx->vec_sol = (void *) 1;
  ctx->itctx->vec_rhs = (void *) 1;
  ctx->itctx->usr_monitor = 0;
 
  lctx->split = SpSplitFromMat(ctx->mat);
  lctx->work = (*ctx->itctx->vc->obtain_vectors)(ctx,2); CHKERR(1);
  lctx->diag = (double *) MALLOC(n*sizeof(double)); CHKPTR(lctx->diag);
  SpGetDiagonal(ctx->mat,0,0,n-1,lctx->diag); CHKERR(1);
  (*ctx->itctx->vc->scal)(ctx,2.0/lctx->omega-1.0,lctx->diag); CHKERR(1);

  ctx->flops  = n + 2;
  ctx->memory = n*sizeof(double);
  ctx->nz     = SpNz(ctx->mat);
 
  ctx->setupcalled = 1;
  ctx->t_setup += SYGetCPUTime() - t1;
}
/*------------------------------------------------------------------*/
int SViSolveSSOR(ctx,b,x)
SVctx  *ctx;
double *b,*x;
{
  SVSSORctx *lctx = (SVSSORctx *) ctx->private;
  int       its;
  double    t1;

  if (!ctx->setupcalled) (*ctx->setup)(ctx); CHKERRV(1,-1);
  if (!ctx->solvecalled) {
      t1   = SYGetCPUTime();
      ITSetUp(ctx->itctx,(void *) ctx); CHKERRV(1,-1);
      ctx->t_setup += SYGetCPUTime() - t1;
      }
  ctx->solvecalled = 1;

  t1 = SYGetCPUTime();
  SViManageInitialGuess( ctx, x );
  if (ctx->use_initial_guess) {
    DVcopy(&ctx->size,x,lctx->work[1]);
    SpiApplyUpperTriangular(lctx->split,lctx->omega,lctx->work[1],x);
    }

  ctx->itctx->vec_sol = (void *) x;
  SpTsolveRelaxL( lctx->split,lctx->omega,b,lctx->work[1] ); CHKERRV(1,-1);
  ctx->itctx->vec_rhs = (void *) lctx->work[1];

  its = ITSolve(ctx->itctx,(void *) ctx);
  SVGetITFlops(ctx,2*ctx->nz+3*ctx->size,0); /* 5 * size? */

  SpTsolveRelaxU( lctx->split,lctx->omega,x,x ); CHKERRV(1,-1);
  ctx->flops += 2*(ctx->nz+ ctx->size);
  ctx->its = its;
  ctx->t_solve += SYGetCPUTime() - t1;
  return its;
}
/*------------------------------------------------------------------*/
void SViDestroySSOR(ctx)
SVctx *ctx;
{
  SVSSORctx *lctx = (SVSSORctx *) ctx->private;

  (*ctx->itctx->vc->release_vectors)(ctx,lctx->work,2);
  VEDestroy(ctx->itctx->vc);
  ITDestroy(ctx->itctx,ctx);
  FREE(lctx->split->nzl); 
  FREE(lctx->split);
  FREE(lctx->diag); 
  FREE(ctx->private); 
  FREE(ctx);
}
/*------------------------------------------------------------------*/
/*
   SViEisenstat - Let  A = L + U + E; where L is lower trianglar,
   U is upper triangular, E is diagonal; This routine applies

            (L + D)^{-1} A (U + D)^{-1}

   to a vector efficiently using Eisenstat's trick. This is for
   the case of SSOR preconditioner, so D is E/omega where omega
   is the relaxation factor.
 */

void SViEisenstat(ctx,x,y)
SVctx  *ctx;
double *x,*y;
{
  SVSSORctx *lctx = (SVSSORctx *) ctx->private;
  double    *t = (double *)(lctx->work[0]), *d = lctx->diag;
  int       n = ctx->size,i;

  ctx->nbinv++;

  /*  y = (D + U)^{-1} x */
  SpTsolveRelaxU( lctx->split,lctx->omega,x,y ); CHKERR(1);
/*   SpiBacksolve(lctx->split,lctx->omega,x,y); CHKERR(1); */

  /*  t = x - (2*D - E)y */
  for ( i=0; i<n; i++ ) { t[i] = x[i] - (*d++)*y[i]; }

  /*  t = (D + L)^{-1}t */
  SpTsolveRelaxL( lctx->split,lctx->omega,t,t ); CHKERR(1);
/*  SpiForwardsolve(lctx->split,lctx->omega,t,t); CHKERR(1); */

  /*  y = y + t */
  for ( i=0; i<n; i++ ) { y[i] += t[i]; }
}

