#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/default/dfsolve.c 07/23/93";
#endif

/*
    This file contains a simple sparse solve routine.
    These are intended for problems where the matrix is re-ordered
    to improve performance (e.g., numerical stability, reduction of fill)
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"

void SpiDfSolvePerm(), SpiDfSolveBase(), SpiDfSolvePermBase();

/*
  SpDfSolve - Solve a system of equations, the matrix must have been
            factored, by, for instance, SpDfComputeFactor().

  Input Parameters:
.  BB - Split matrix already processed by Factor
.  b  - Right-hand-side
.  x  - solution
 */
void SpDfSolve( BB, b, x )
SpMatSplit *BB;
double     *b, *x;
{
int err;
if (BB->factor->map) 
    SpiDfSolvePerm( BB, x, b );
else
    SpiDfSolveBase( BB, x, b );
}

/*
        [(R A C) Cinv] x = R b
 */
void SpiDfSolvePerm( BB, x, b )
SpMatSplit *BB;
double      *x, *b;
{
double *tmp;
tmp    = (double *)SPAllocTemp(BB->factor->rows * sizeof(double)); CHKPTR(tmp);
SpiDfSolvePermBase( BB, x, b, tmp );
SPFreeTemp( tmp );
}

void SpiDfSolvePermBase( BB, x, b, Tmp )
SpMatSplit *BB;
double      *x, *b, *Tmp;
{
int      i, n, *nzs, d, rnz;
double   *vv;
double   *v, sum, *tmp = Tmp;
int      *vi, nz;
SpMat    *B = BB->factor;
int      *r = B->map->rowmap, *c = B->map->colmap;

n      = B->rows;
/* forward solve the lower triangular */
nzs    = BB->nzl + 1;
tmp[0] = b[*r++];
for (i=1; i<n; i++) {
    SpScatterFromRow( B, i, &d, &vi, &v );
    nz   = *nzs++;
    sum  = b[*r++];
    SPARSEDENSEMDOT(sum,tmp,v,vi,nz);
    tmp[i] = sum;
    }

/* backward solve the upper triangular */
nzs--;
c = c + (n-1);
for (i=n-1; i>=0; i--) {
    nz   = *nzs-- + 1;
    SpScatterFromRow( B, i, &rnz, &vi, &vv );
    vv = v = vv + nz;
    vi   += nz;
    nz   = rnz - nz;
    sum  = tmp[i];
    SPARSEDENSEMDOT(sum,tmp,v,vi,nz);
    x[*c--] = tmp[i] = sum * vv[-1];
    }
}

/*
   This is a solve that does not involve any mappings 
 */
void SpiDfSolveBase( BB, x, b )
SpMatSplit  *BB;
double      *x, *b;
{
int      i, n, *nzs, d, rnz;
double   *vv;
double   *v, sum;
int      *vi, nz;
SpMat    *B = BB->factor;

n      = B->rows;
/* forward solve the lower triangular */
nzs    = BB->nzl + 1;
x[0]   = *b++;
for (i=1; i<n; i++) {
    SpScatterFromRow( B, i, &d, &vi, &v );
    nz   = *nzs++;
    sum  = *b++;
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum;
    }

/* backward solve the upper triangular */
nzs--;
for (i=n-1; i>=0; i--) {
    nz   = *nzs-- + 1;
    SpScatterFromRow( B, i, &rnz, &vi, &v );
    vv = v = v + nz;
    vi   += nz;
    nz   = rnz - nz;
    sum  = x[i];
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum * vv[-1];
    }
}


