/* @(#) ./sparse/diag/diag.h 07/23/93 */

/* The "USER" type allows the user to provide a routine to perform the
   matrix-vector multiply (for example, unrolling adjacent loads) */
#ifndef _DIAG
typedef enum { DIAG_UNKNOWN, 
	       DIAG_GENERAL, DIAG_CONSTANT, DIAG_UNITSTRIDE, DIAG_USER } 
        DIAGTYPE;
typedef struct {
    DIAGTYPE   kind;
    int        sr,         /* first row of block */
               nr,         /* number of rows */
               rinc,       /* increment between rows */
               dinc,       /* increment between diags */
               nd,         /* number of diagonals */
               *doff;      /* Offset of each diagonal from column "sr"
			      in row "sr" */
    double     **v;        /* values */
    } SpDiag;

typedef struct {
    int        nsd;        /* number of sparse diagonals */
    SpDiag     **sd;
    int        (*userMult)(); /* function to process a user diagonal */
    } SpMatDiag;

extern SpMat  *SpDCreate();
extern SpDiag *SpDAllocateBlock();
extern SpDiag *SpDAllocateBase();
extern SpMat  *SpDiagToSp();
extern SpMat  *SpDFromSpR();
#define _DIAG
#endif
