#ifndef lint
static char SCCSid[] = "@(#) ./sparse/order/spqmd.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"

#if defined(FORTRANCAPS)
#define genqmd_ GENQMD 
#elif !defined(FORTRANUNDERSCORE)
#define genqmd_ genqmd
#endif

/*@
    SpOrderQMD - Find the Quotient Minimum Degree ordering of a given matrix.

    Input Paramter:
.    Matrix - matrix to find ordering for

    Output Parameters:
.    perm   - permutation vector (0-origin)
.    iperm  - inverse permutation vector.  If NULL, ignored.
@*/    
void SpOrderQMD( Matrix, perm, iperm )
SpMat *Matrix;
int   *perm, *iperm;
{
int i, nrow, *ia, *ja, *deg, *marker, *rchset, *nbrhd, *qsize,
    *qlink, nofsub, hadiperm;

nrow= Matrix->rows;
SpToSymmetricIJ( Matrix, &ia, &ja ); CHKERR(0);

if (iperm) hadiperm = 1;
else {
    hadiperm = 0;
    iperm = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(iperm);
    }
deg    = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(deg);
marker = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(marker);
rchset = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(rchset);
nbrhd  = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(nbrhd);
qsize  = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(qsize);
qlink  = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(qlink);
/* WARNING - genqmd trashes ja */    
genqmd_( &nrow, ia, ja, perm, iperm, deg, marker, rchset, nbrhd, qsize,
	 qlink, &nofsub );
FREE( deg ); FREE( marker ); FREE( rchset ); FREE( nbrhd ); FREE( qsize );
FREE( qlink );
FREE( ia );  FREE( ja );
if (!hadiperm) {
    FREE(iperm);
    }
else
    for (i=0; i<nrow; i++) iperm[i]--;

for (i=0; i<nrow; i++) perm[i]--;
}

