#ifndef lint
static char SCCSid[] = "@(#) ./sparse/order/sprcm.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"

#if defined(FORTRANCAPS)
#define genrcm_ GENRCM
#elif !defined(FORTRANUNDERSCORE)
#define genrcm_ genrcm
#endif

/*@
    SpOrderRCM - Find the Reverse Cuthill-McGee ordering of a given matrix.

    Input Paramter:
.    Matrix - matrix to find ordering for

    Output Parameters:
.    perm   - permutation vector (0-origin)
.    iperm  - inverse permutation vector.  If NULL, ignored.
@*/    
void SpOrderRCM( Matrix, perm, iperm )
SpMat *Matrix;
int   *perm, *iperm;
{
int i, nrow, *ia, *ja, *mask, *xls;

nrow= Matrix->rows;
SpToSymmetricIJ( Matrix, &ia, &ja ); CHKERR(0);

mask = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(mask);
xls  = (int *)MALLOC( nrow * sizeof(int) ); CHKPTR(xls);

genrcm_( &nrow, ia, ja, perm, mask, xls );
FREE( mask ); FREE( xls );
FREE( ia );  FREE( ja );

for (i=0; i<nrow; i++) perm[i]--;
if (iperm) SpInverse( nrow, perm, iperm );
}
