#ifndef lint
static char SCCSid[] = "@(#) ./system/state.c 07/23/93";
#endif

#include "tools.h"
#include "system/state.h"     /*I "system/state.h" I*/

/* 
   This file contains routines for a simple state tracking facility.
 */

#define MAX_STACK 25
static SYusc_time_t timestk[MAX_STACK+1];
static int          sp = 0;           /* points to next free one */

/*@
  SYStateInit - initialize a state

  Input Parameter:
. state - state to initialize (all fields set to zero)
@*/
void SYStateInit( state )
SYstate *state;
{
state->time    = 0.0;
state->count   = 0;
state->data    = 0;
state->routine = 0;
state->rcontext= 0;
}

/*@
   SYStatePush - push a state 

    Input parameters:
.   state - state to use
.   data  - data to add into the states data field
@*/  
void SYStatePush( state, data )
SYstate *state;
int     data;
{
state->data += data;
if (sp < MAX_STACK) {
    SYusc_clock( timestk + sp );
    if (state->routine) (*state->routine)( state, 1 );
    sp ++;
    }
}

/*@
    SYStatePop - pop a state

    Input parameters:
.   state - state to use
.   data  - data to add into the states data field
@*/
void SYStatePop( state, data )
SYstate *state;
int     data;
{
SYusc_time_t t;

SYusc_clock( &t );
state->count++;
state->data += data;
if (sp) sp--;
state->time += SYuscDiff( timestk + sp, &t );
if (state->routine) (*state->routine)( state, 0 );
}

