#ifndef lint
static char SCCSid[] = "@(#) ./xtools/contour/bitmap.c 07/23/93";
#endif

/*
    Routine to write out a bitmap in "contour" colormap format
 */
#include "tools.h"
#include "xtools/basex11.h"
#include <stdio.h>

#ifndef FAST_MALLOC
extern char *malloc();
#endif

/* this is used elsewhere */
static unsigned char _reverse_byte[0x100] = {
	0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
	0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
	0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
	0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
	0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
	0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
	0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
	0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
	0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
	0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
	0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
	0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
	0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
	0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
	0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
	0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
	0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
	0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
	0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
	0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
	0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
	0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
	0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
	0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
	0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
	0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
	0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
	0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
	0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
	0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
	0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
	0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};

XB_w_map_off( XBwin, map, nx, ny, ix, iy )
XBWindow      *XBwin;
unsigned char *map;
int           nx, ny, ix, iy;
{
int n, j;
register int i;
register unsigned char *p, *mp;
unsigned char   *data;
XImage  *Image;
int     depth, offset, width, height, bitmap_pad, bytes_per_line;

depth           = DefaultDepth( XBwin->disp, XBwin->screen );
offset          = 0;
width           = nx;
height          = ny;
bitmap_pad      = 8;
bytes_per_line  = (nx * depth + 7) / 8;
/* first, assume that ordering is similar to sun; in pixel order */
/* Note that we MUST use the regular malloc, since the pointer becomes part
   of the XImage structure */
data    = (unsigned char *) malloc( (unsigned)(ny * bytes_per_line) );  
          CHKPTR(data)
Image   = XCreateImage( XBwin->disp, XBwin->vis,
			depth, (depth == 1) ? XYPixmap : ZPixmap, offset,
			data, width, height, bitmap_pad, bytes_per_line );
CHKPTR(Image);
/* printf( "Image data:\n" ); */
/* printf( "bitmap_unit %d\n", Image->bitmap_unit ); */
/* printf( "bits_per_pixel %d\n", Image->bits_per_pixel ); */

n   = nx * ny;
p   = data;
mp  = map;
/*  Handle monochrome images */
if (Image->bits_per_pixel == 1) {
    int black_is_one;
    black_is_one    = BlackPixel( XBwin->disp, XBwin->screen ) != 0;
    for (j=0; j < ny; j++) {
	p   = data + j * Image->bytes_per_line;
	i   = nx;
	mp  = map + j * nx;
	/* note that this assumes that sizof(char) == 8 */
	while (i > 0) {
#ifdef FOO
	    *p      = *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
	    *p      = ( *p << 1 ) | *mp++;
#else
	    unsigned char pp;
	    pp      = mp[0];
	    pp      = ( pp << 1 ) | mp[1];
	    pp      = ( pp << 1 ) | mp[2];
	    pp      = ( pp << 1 ) | mp[3];
	    pp      = ( pp << 1 ) | mp[4];
	    pp      = ( pp << 1 ) | mp[5];
	    pp      = ( pp << 1 ) | mp[6];
	    pp      = ( pp << 1 ) | mp[7];
	    *p      = pp;
	    mp      += 8;
#endif
	    if (Image->bitmap_bit_order == LSBFirst)
		*p  = _reverse_byte[*p];

	    /* make sure that the bits represent WHITE */
	    if (black_is_one)   *p  = ~*p;
	    p++;
	    i       -= 8;
	    }
#ifdef REV_BYTES
	/* this is a post-processing phase if byte_order is MSBFirst */
	if (Image->byte_order == MSBFirst) {
	    unsigned char t;
	    p   = data + j * Image->bytes_per_line;
	    i   = (nx + 7) / 8;     /* number of bytes */
	    if (Image->bitmap_unit == 32) {
		while (i > 0) {
		    t       = *p;
		    *p      = *(p+3);
		    *(p+3)  = t;
		    t       = *(p+1);
		    *(p+1)  = *(p+2);
		    *(p+2)  = t;
		    i       -= 4;
		    p       += 4;
		    }
		}
	    else if (Image->bitmap_unit == 16) {
		/* untested */
		while (i > 0) {
		    t       = *p;
		    *p      = *(p+1);
		    *(p+1)  = t;
		    i       -= 2;
		    p       += 2;
		    }
		}
	    }
#endif
	}
    }
else if (Image->bits_per_pixel != 8) {
    unsigned long pixel ;
    int           nc = XBwin->maxcolors-1;
    i   = 0;    j   = 0;
    while (n--) {
	pixel   = XBwin->cmapping[(*mp>nc)?nc:*mp];    mp++;
	XPutPixel( Image, i, j, pixel );
	i++;
	if (i >= nx) { i = 0; j++;}
	}
    }
else {
    register PixVal *xp = XBwin->cmapping;
    /* attempt to blast the pixels out */
    /* printf( "Using fast version\n" ); */
    for (j=0; j < ny; j++) {
	p    = data;
	data += Image->bytes_per_line;
	/* This could be unrolled; it is really a gather:
	   vout = xp[vin] */
	for (i=0; i<nx; i++)
	    p[i]    = (unsigned char) (xp[mp[i]]);
	mp += nx;
	}
    }
/* printf( "about to display\n" ); */
XPutImage( XBwin->disp, XBDrawable(XBwin), XBwin->gc.set,
	   Image, 0, 0, ix, iy, nx, ny );
XBFlush( XBwin );
XDestroyImage( Image );
}
#ifdef DUFF
/*
   This is a sample Duff's device, so I'll have one written down
 */
XtoolsDuff( p1, p2, n )
register int n;
register char *p1, *p2;
{
switch ( n & 0x8 ) {
    do {
	case 0: *p1++ = *p2++;
	case 1: *p1++ = *p2++;
	case 2: *p1++ = *p2++;
	case 3: *p1++ = *p2++;
	case 4: *p1++ = *p2++;
	case 5: *p1++ = *p2++;
	case 6: *p1++ = *p2++;
	case 7: *p1++ = *p2++;
	n  -= 8;
	} while (n > 0);
    }
}
#endif
