#ifndef lint
static char SCCSid[] = "@(#) ./comm/global/gsethalf.c 07/23/93";
#endif

#include "comm/comm.h"
#include "comm/procset.h"
#include "comm/global/global.h"
#include <stdio.h>

/*D
     GsetopHalf - apply a global operation on a subset of processors

     Algorithm: 
     All the hard stuff is in the ProcSet structure.  Basically,
     a virtual tree is constructed in the processor set structure; this
     tree is used in all operations.  In addition, the access to the
     tree is designed so that if messages are to be received from
     two children, they may be received in any order.

.     gsetop   - generic routine
.     gisumset - integer sum reduction
.     gdsumset - double sum reduction
.     gihighset - integer max reduction
.     gilowset  - integer min reduction
.     gsyncset  - barrier

     Notes:
     This is a "half" version of gsetop.  This is primarily provided so that
     programs written in PICL can be translated to Tools.
 D*/

/* root is the node that is to get the result value */
void gsetopHalfT( val, n, work, procset, elmsize, datatype, root, op )
void    *val, *work, (*op)();
int     n, elmsize, datatype, root;
ProcSet *procset;
{
int size = n * elmsize;
int l_child, r_child, parent, myid, np;
int msgup, lphase;

/* printf( "[%d] doing gsetopHalfT with size = %d\n", MYPROCID, size ); */
if (!procset) {
    myid    = MYPROCID;
    np      = NUMNODES;
    /* Rotate relative to root */
    if (root) {
	myid = myid - root;
	if (myid < 0) myid += np;
	}
    l_child = 2 * myid + 1;
    r_child = l_child + 1;
    parent  = (myid-1)/2;
    if (myid == 0)      parent = -1;
    if (l_child >= np) l_child = -1;
    if (r_child >= np) r_child = -1;
    _PIPHASE= _PIPHASE ? 0 : 1;
    lphase  = _PIPHASE;
    }
else {
    /* If root not zero, we need to work harder on this.  Basically,
       use the rotation trick, then access the values in node_nums */
    l_child = procset->l_child;
    r_child = procset->r_child;
    parent  = procset->parent;
    }
msgup = GMSGTYPE(procset,MSG_UP|lphase);

/* printf( "[%d] parent = %d, r_child = %d, l_child = %d\n", MYPROCID,
        parent, r_child, l_child ); */
/* Receive values from my children and accumulate */
if (l_child >= 0) {
    RECVSYNCNOMEM(msgup,work,size,datatype);
    (*op)( val, work, n );
    }
if (r_child >= 0) {
    RECVSYNCNOMEM(msgup,work,size,datatype);
    (*op)( val, work, n );
    }
/* Send to parent */
if (parent >= 0) {
    SENDSYNCNOMEM(msgup,val,size,parent,datatype);
    }
}
