#ifndef lint
static char SCCSid[] = "@(#) ./comm/gray.c 07/23/93";
#endif

/* 
    This routine generates a gray code recursively
 */

#include "tools.h"

#define MAX_CODE 1024
static int g[MAX_CODE];
static int ig[MAX_CODE];

/*
    PIGetGray - get a n-bit binary reflected gray code into g

    Input Parameter:
.   n  - number of bits in code

    Output Parameter:    
.   g  - array of 2^n gray-code values

    See Also:
    PIinitGray, PIinvGray, PIGray
 */
void PIGetGray( g, n )
int g[], n;
{
long    m;
int     *gpe, *gps;

if (n <= 1) {
    g[0]    = 0;
    g[1]    = 1;
    }
else {
    PIGetGray( g, n-1 );
    /* reflect into upper half, adding a leading bit */
    gpe = g + (1 << n) - 1;
    gps = g;
    m   = (1 << (n-1));
    while (gpe > gps)
	*gpe--  = *gps++ | m;
    }
}


/*
    PIinitGray - Initialize the local gray code and the inverse of it
    Input Parameter:
.   n  - number of bits in code
 */
void PIinitGray( n )
int     n;
{
int     i, m;

PIGetGray( g, n );

m   = (1 << n);
for (i=0; i<m; i++)
    ig[g[i]]    = i;
}

/*
   PIinvGray - Get the index of a previously initialized gray code

   Input Paramter:
.  c - value to find the inverve gray code of.

   Note:
   PIinitGray must have been called first.

   See Also:
   PIinitGray
 */
int PIinvGray( c )
int c;
{
return ig[c];
}

/*
   PIGray - Get gray code of a particular value

   Input Paramter:
.  c - value to find the gray code of.

   Note:
   PIinitGray must have been called first.

   See Also:
   PIinitGray
 */
int PIGray( v )
int v;
{
return g[v];
}
