##############################################################################
#
# Setup basic macros for build.
# You never know when or where you're going to need to hack the makefile,
# so these macros should be available regardless of the system.
#
# $Id: cf_basic.m4,v 1.10 1994/05/24 19:47:18 mjl Exp $
#
##############################################################################

changequote({,})dnl

dnl> System macros.

define(if_aix,	    {ifelse(SYSTEM, AIX,	{$1},{$2})})dnl
define(if_alphaosf, {ifelse(SYSTEM, ALPHAOSF,	{$1},{$2})})dnl
define(if_bsd,	    {ifelse(SYSTEM, BSD,	{$1},{$2})})dnl
define(if_convex,   {ifelse(SYSTEM, CONVEX,	{$1},{$2})})dnl
define(if_dgux,	    {ifelse(SYSTEM, DGUX,	{$1},{$2})})dnl
define(if_hpux,	    {ifelse(SYSTEM, HPUX,	{$1},{$2})})dnl
define(if_irix,     {ifelse(SYSTEM, IRIX,	{$1},{$2})})dnl
define(if_linux,    {ifelse(SYSTEM, LINUX,	{$1},{$2})})dnl
define(if_next,	    {ifelse(SYSTEM, NEXT,	{$1},{$2})})dnl
define(if_sunos,    {ifelse(SYSTEM, SUNOS,	{$1},{$2})})dnl
define(if_sx,	    {ifelse(SYSTEM, SX,		{$1},{$2})})dnl
define(if_sysv,	    {ifelse(SYSTEM, SYSV,	{$1},{$2})})dnl
define(if_ultrix,   {ifelse(SYSTEM, ULTRIX,	{$1},{$2})})dnl
define(if_unicos,   {ifelse(SYSTEM, UNICOS,	{$1},{$2})})dnl

define(if_unix,  {ifdef({UNIX},  {$1},{$2})})dnl
define(if_amiga, {ifdef({AMIGA}, {$1},{$2})})dnl

dnl> Aliases

ifelse(SYSTEM, HP,	{define({SYSTEM}, HPUX)})dnl
ifelse(SYSTEM, SUN,	{define({SYSTEM}, SUNOS)})dnl
ifelse(SYSTEM, ALPHA,	{define({SYSTEM}, ALPHAOSF)})dnl
ifelse(SYSTEM, DG,	{define({SYSTEM}, DGUX)})dnl
ifelse(SYSTEM, SGI,	{define({SYSTEM}, IRIX)})dnl
ifelse(SYSTEM, IBM,	{define({SYSTEM}, AIX)})dnl
ifelse(SYSTEM, CRAY,	{define({SYSTEM}, UNICOS)})dnl
ifelse(SYSTEM, M4,	{define({SYSTEM}, SX)})dnl
ifelse(SYSTEM, MONTE4,	{define({SYSTEM}, SX)})dnl

dnl> Dependent macros.

define(if_ranlib,{ifdef({RANLIB},{$1},{$2})})dnl
if_bsd(   {define({RANLIB},)})dnl
if_convex({define({RANLIB},)})dnl
if_linux( {define({RANLIB},)})dnl
if_next(  {define({RANLIB},)})dnl
if_sunos( {define({RANLIB},)})dnl
if_ultrix({define({RANLIB},)})dnl

dnl> Build settings.

define(if_debug,{ifdef({DEBUG},		{$1},{$2})})dnl
define(if_dbl,	{ifdef({DOUBLE},	{$1},{$2})})dnl
define(if_opt,	{ifdef({OPT},		{$1},{$2})})dnl
define(if_warn, {ifdef({WARN},		{$1},{$2})})dnl
define(if_prof,	{ifdef({PROF},		{$1},{$2})})dnl
define(if_shr,	{ifdef({NO_SHARE},	{$2},{$1})})dnl
define(if_gcc,	{ifdef({GCC},		{$1},{$2})})dnl
define(if_f2c,	{ifdef({F2C},		{$1},{$2})})dnl

dnl> Governs X support

ifdef({NO_X},{dnl
define({NO_TK})dnl
define(if_xwin,	 {$2})dnl
},{dnl
define(if_xwin,	 {ifdef({XWIN},  {$1},{$2})})dnl
})dnl

dnl> Governs Tcl/TK support

ifdef({NO_TK},{dnl
define({NO_DP})dnl
define(if_tk,    {$2})dnl
},{dnl
define(if_tk,    {ifdef({TK},    {$1},{$2})})dnl
})dnl

dnl> Governs Tcl-DP support

ifdef({NO_DP},{dnl
define(if_dp,    {$2})dnl
},{dnl
define(if_dp,    {ifdef({DP},    {$1},{$2})})dnl
})dnl

dnl> Governs Tcl-DP support

ifdef({NO_ITCL},{dnl
define(if_itcl,    {$2})dnl
},{dnl
define(if_itcl,    {ifdef({ITCL},    {$1},{$2})})dnl
})dnl

dnl> These are used to selectively turn on each capability.

define(DEF_TK,   {if_tk({-DTK})})
define(DEF_DP,   {if_dp({-DTCL_DP})})
define(DEF_XWIN, {if_xwin({-DXWIN})})
