/* complex.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef COMPLEX_H
#define COMPLEX_H

#include "rlab.h"

struct _complex
{
  double r;			/* Real part */
  double i;			/* Imaginary part */
};

typedef struct _complex Complex;


extern Complex complex_Multiply _PROTO ((double r1, double i1,
					 double r2, double i2));

extern Complex complex_Div _PROTO ((Complex a, Complex b));
extern Complex complex_div _PROTO ((double r1, double i1,
				    double r2, double i2));

extern Complex complex_Pow _PROTO ((Complex a, Complex b));
extern Complex complex_pow _PROTO ((double ar, double ai, double br, double bi));

extern double complex_Abs _PROTO ((Complex c));
extern double complex_abs _PROTO ((double real, double imag));

extern Complex complex_Sin _PROTO ((Complex z));
extern Complex complex_sin _PROTO ((double zr, double zi));
extern Complex complex_Asin _PROTO ((Complex z));
extern Complex complex_asin _PROTO ((double zr, double zi));

extern Complex complex_Cos _PROTO ((Complex z));
extern Complex complex_cos _PROTO ((double zr, double zi));
extern Complex complex_Acos _PROTO ((Complex z));
extern Complex complex_acos _PROTO ((double zr, double zi));

extern Complex complex_Tan _PROTO ((Complex z));
extern Complex complex_tan _PROTO ((double zr, double zi));
extern Complex complex_Atan _PROTO ((Complex z));

extern Complex complex_Log _PROTO ((Complex z));
extern Complex complex_log _PROTO ((double zr, double zi));

extern Complex complex_Sqrt _PROTO ((Complex z));
extern Complex complex_sqrt _PROTO ((double zr, double zi));

extern Complex complex_Exp _PROTO ((Complex z));
extern Complex complex_exp _PROTO ((double zr, double zi));

extern Complex complex_Mod _PROTO ((Complex c1, Complex c2));
extern Complex complex_mod _PROTO ((double xr, double xi, double yr, double yi));

extern double complex_le _PROTO ((double r1, double i1,
				  double r2, double i2));
extern double complex_lt _PROTO ((double r1, double i1,
				  double r2, double i2));
extern double complex_ge _PROTO ((double r1, double i1,
				  double r2, double i2));
extern double complex_gt _PROTO ((double r1, double i1,
				  double r2, double i2));

extern double complex_or _PROTO ((double r1, double i1,
				  double r2, double i2));

extern double complex_and _PROTO ((double r1, double i1,
				   double r2, double i2));

#endif /* COMPLEX_H */
