// house_qr.r
// Given A, with M >= N, the following function finds Householder
// matrices H1,...Hn, such that if Q = H1*...Hn, then Q'*A = R is
// upper triangular.

// House.qr returns a MxN matrix, with the upper triangular part 
// containing [R]

house_qr = function ( A )
{
  local (A, j, n, m, v);

  m = A.nr; n = A.nc;
  v = zeros(m,1);

  for(j in 1:n)
  {
    v[j:m] = house_v( A[j:m;j] );
    A[j:m;j:n] = house_row( A[j:m;j:n], v[j:m] );
    if (j < m) 
    {
      A[ (j+1):m;j ] = v[(j+1):m];
    }
  }
  return A;
};
