//
//  Integrate the Van der Pol equation
//

vdpol = function ( t , x ) 
{
  local(xdot);

  xdot[1;1] = x[1] * (1 - x[2]^2) - x[2];
  xdot[2;1] = x[1];
  return xdot;
};

vdpol_out = function ( t , x )
{
  return [t; x; 2*x];
};

// system( "/usr/ucb/ps -aux | grep rlab" );
t0 = 0;
tf = 20
x0 = [0; 0.25];
tic();
//out = ode23( vdpol, t0, tf, x0, vdpol_out);
//rfile ode78
//out = ode78( vdpol, t0, tf, x0, vdpol_out );
rfile ode4
out = ode4( vdpol, t0, tf, x0, vdpol_out );
//out = ode (vdpol, t0, tf, x0);
printf(" Elapsed integration time: %i\n", toc() );

plgrid ();
ptitle ( "RLaB ODE Example (vdpol)" );
xlabel ( "Time (seconds)" );
ylabel ( "States" );

plot( out );
