//
// Create and manipulate sparse matrices via RLaB lists.
//

//
// Given row and column indices, create a sparse matrix
// structure using lists.
//

make_sparse = function ( cm )
{
  local (i, ri, sm)

  sm = <<>>;  // Create initial list.

  ri = set (cm[;1]);  // Get a set of the row indices.
  for (i in 1:ri.n)   // Create the row lists.
  {
    sm.[ri[i]] = <<>>;
  }

  // Now load up the sparse matrix

  for (i in 1:cm.nr)
  {
    sm.[cm[i;1]].[cm[i;2]] = cm[i;3];
  }

  return sm;
};

//
// Print out a sparse matrix.
//

print_sparse = function ( sm )
{
  local (i, j);

  for (i in members (sm))
  {
    for (j in members (sm.[i]))
    {
      printf (" row: %6s\tcol: %6s\tvalue: %g\n", i, j, sm.[i].[j]);
    }
  }
};

//
// Add two sparse matrices.
//

//
// Multiply two sparse matrices.
//
