/* rlab.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1993  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_H
#define RLAB_H

#include "config.h"

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

#include "listnode.h"

/* ASSERTION MACRO, a cheap imitation of the ANSI assert() */

#ifndef ASSERT_OFF
#define ASSERT_ON     1
#endif

#define AssertPrintMessage   fprintf(stderr,\
                             "\nAssertion Failed: file %s, line %d",\
                             __FILE__, __LINE__)

#if ASSERT_ON
#define ASSERT(ex)     {if(!(ex)) {AssertPrintMessage; abort();}}
#else
#define ASSERT(ex)     ;
#endif

/*
 * Union for RLaB machine/interpreter
 */

union _inst
{
  int op_code;			/* machine op-code */
  VPTR ptr;			/* entity pointer  */
  double d_val;			/* NUMBER */
};

typedef union _inst Inst;


/*
 * Structure for holding variable info
 */
struct _var
{
  int type;
  ListNode *ent;
  int offset;
  char *name;
};

typedef struct _var Var;

/* Search path for rfiles */
extern char *search_path;
extern char *help_dir;
extern char *lib_dir;
extern char *pager;
extern char *ls_cmd;

/* To control output print formats */
extern int fwidth, fprec;
extern int FWIDTH_DEFAULT;
extern int FPREC_DEFAULT;

/* Controls diary output */
extern int write_diary;
extern FILE *diary_file_ptr;
extern char *diary_filenm;

/* Error and warning functions */
extern void error_1 _PROTO ((char *s, char *t));
extern void error_2 _PROTO ((char *s1, char *s2, char *t));
extern void error_3 _PROTO ((char *s1, char *s2, char *s3, char *t));
extern void warning_1 _PROTO ((char *s, char *t));
extern void warning_2 _PROTO ((char *s1, char *s2, char *t));
extern void warning_3 _PROTO ((char *s1, char *s2, char *s3, char *t));

/* Signal handling */
extern void intcatch _PROTO ((int));
extern void intcatch_wait _PROTO ((int));

extern int new_file _PROTO ((char *fn));

extern void init_symbol_table _PROTO ((void));
extern int rlab_cleanup _PROTO ((void));

/* types used in the parser */

#define GLOBAL 0		/* used when creating code for user-functions */
#define LOCAL  1
#define STATIC 2

#define STYPE(l, r)    (10*(l) + (r))

/* define RLaB types */

#define UNDEF      100		/* undefined something-or-another */

#define SCALAR     101
#define NUM        102		/* Numeric type (no dim spec) */
#define MATRIX     103
#define LIST       104		/* RLaB list */
#define BLTIN      105		/* Built-in function (C-code) */
#define LISTNODE   106		/* RLaB entities */
#define U_FUNCTION 107		/* User function (RLaB language) */
#define CONSTANT   108
#define iCONSTANT  114
#define ENTITY     109
#define STRING     110
#define ARG_VAR    111		/* User function arguments */
#define LOCAL_VAR  112		/* User function local variables */
#define BTREE      113		/* RLaB binary tree */

#define REAL       115
#define COMPLEX    116

#define D_VOID     117

#endif /* RLAB_H */
