/* util.h */

/*  This file is a part of RLaB ("Our"-LaB)
    Copyright (C) 1992  Ian R. Searle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file ./COPYING
 ***********************************************************************/

#ifndef RLAB_UTIL_H
#define RLAB_UTIL_H

#include "rlab.h"
#include "code.h"
#include "list.h"
#include "listnode.h"
#include "scalar.h"
#include "matrix.h"

#include <stdio.h>

extern char *cpstr _PROTO ((char *string));
extern char *cpstr_strip _PROTO ((char *string));
extern Datum new_stack_scalar _PROTO ((double val));
extern Datum new_stack_vector _PROTO ((int size));
extern Datum new_stack_matrix _PROTO ((int nrow, int ncol));
extern Datum new_stack_list _PROTO ((void));
extern Datum new_stack_btree _PROTO ((void));
extern double get_datum_value _PROTO ((Datum d, char *s));
extern Datum convert_const _PROTO ((Datum d));
extern Datum convert_to_scalar _PROTO ((Datum d));
extern double get_num_scalar_val _PROTO ((Datum d));
extern Datum convert_to_matrix_entity _PROTO ((Datum d));
extern Datum convert_to_matrix _PROTO ((Datum d));
extern Datum convert_to_matrix_d _PROTO ((Datum d));
extern Datum convert_all_to_matrix _PROTO ((Datum d));
extern Datum convert_all_to_matrix_d _PROTO ((Datum d));
extern Datum convert_to_rhs_matrix _PROTO ((Datum d));
extern Datum matrix_to_scalar _PROTO ((Datum d));

extern Matrix *btree_Print_What _PROTO ((Btree *));
extern Matrix *btree_Print_Who _PROTO ((Btree *));
extern Matrix *btree_members _PROTO ((Btree *));

extern Matrix *matrix_CreateFillSind _PROTO ((int nrow, int ncol));

extern VPTR call_rlab_script _PROTO ((char *fname, 
				      Datum *args, int nargs));

#endif /* RLAB_UTIL_H */
