/* code.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_CODE_H
#define RLAB_CODE_H

#include "rlab.h"
#include "list.h"
#include "symbol.h"

#include <stdio.h>

/*
 * The structure for a program
 */

struct _program
{
  int ncode;			/* The size of the progam array */
  Inst *prog;			/* The program array */
  Inst *progp;			/* Next free spot for code generation */
  int off;			/* Current instruction offset */
};

typedef struct _program Program;

extern void set_print_machine _PROTO ((int val));
extern void set_line_nos _PROTO ((int val));
extern void set_use_pager _PROTO ((int val));
extern void set_code_pager _PROTO ((char *pager));
extern int get_progoff _PROTO ((void));

extern Program *program_Create _PROTO ((int n));
extern void program_Destroy _PROTO ((Program * p));
extern void program_Set _PROTO ((Program * p));

extern void init_machine _PROTO ((void));
extern void initcode _PROTO ((void));
extern void execute _PROTO ((Inst * p));
extern int find_lineno _PROTO ((void));
extern char *find_file_name _PROTO ((void));
extern Datum get_eval_ret _PROTO ((void));

extern int code _PROTO ((int));
extern int codep _PROTO ((VPTR));
extern int coded _PROTO ((double));
extern void code_sp _PROTO ((int offset, int value));

extern void quit_code _PROTO ((void));
extern int delete_symbol_table _PROTO ((void));

/* define op-codes */

#define STOP                 0

#define OP_PUSH_VAR           1
#define OP_PUSH_ARG           2
#define OP_PUSH_LOCAL_VAR     3
#define OP_ADD                4
#define OP_SUB                5
#define OP_MUL                6
#define OP_DIV                7
#define OP_LDIV               8
#define OP_NEGATE             9
#define OP_POWER             10
#define OP_ASSIGN            11
#define OP_FOR               12
#define OP_EL_MUL            13
#define OP_EL_DIV            14
#define OP_EL_LDIV           15
#define OP_EL_POWER          16
#define OP_PUSH_CONSTANT     17
#define OP_PUSH_iCONSTANT    18
#define OP_PRINT             19

#define OP_GT                20
#define OP_LT                21
#define OP_EQ                22
#define OP_GE                23
#define OP_LE                24
#define OP_NE                25
#define OP_AND               26
#define OP_OR                27
#define OP_NOT               28
#define OP_IF                29
#define OP_WHILE             30
#define OP_SWAP              31
#define OP_INC               32
#define OP_DEC               33
#define OP_POP               34
#define OP_VECTOR_CREATE     35
#define OP_VEC_APPEND        36
#define OP_MATRIX_VEC_SUB    37
#define OP_MATRIX_VEC_ASSIGN 38
#define OP_MATRIX_CREATE     39
#define OP_MATRIX_APPEND     40
#define OP_MATRIX_ASSIGN     41
#define OP_MATRIX_SUB        42

#define OP_LIST_CREATE       43
#define OP_LIST_MEMB         44
#define OP_LIST_ASSIGN       45
#define OP_LIST_EL_CREATE    46
#define OP_FUNCTION_CALL     47
#define OP_FUNCTION_RETURN   48
#define OP_DEF_FUNC_RET      49
#define OP_BLTIN             50
#define OP_TRANSPOSE         51
#define OP_PUSH_STRING       52
#define OP_QUIT              53
#define OP_BREAK             54
#define OP_CONTINUE          55
#define OP_LINE_NO           56
#define OP_FILE_NAME         57

#define OP_FUNCTION_CALL_SELF 58
#define OP_JMP                59
#define OP_POP_CLEAN          60

#define OP_EMPTY_MATRIX_CREATE 61
#define OP_MATRIX_COL          62
#define OP_EL_TRANSPOSE        63

#define OP_RFILE               64
#define OP_RFILE_NAME          65

#define OP_HELP                66
#define OP_HELP_NAME           67

#define OP_PUSH_UNDEF          68
#define OP_EL_ADD              69
#define OP_EL_SUB              70

#define OP_SAVE_EVAL           71
#define OP_FUNCTION_CALL_1     72

#endif /* RLAB_CODE_H */
