/* function.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_FUNCTION
#define RLAB_FUNCTION

#include "rlab.h"
#include "list.h"

struct _function
{
  int type;
  char *name;
  int n_args;			/* number of arguments */
  List *args;			/* ptr to List of arguments */
  int n_local;			/* number of local variables */
  List *local;			/* ptr to List of local variables */
  int n_global;			/* number of global variables */
  List *global;			/* ptr to List of global variables */
  int ncode;			/* size of code */
  Inst *code;			/* ptr to code segment */
};

typedef struct _function Function;

/* We have two identical structs at the moment for debugging clarity */

struct _func_arg
{
  int type;
  char *name;
  int offset;			/* stack offset for variable location */
};

typedef struct _func_arg FArg;

struct _local_var
{
  int type;
  char *name;
  int offset;			/* stack offset for variable location */
};

typedef struct _local_var LVar;

extern Function *function_Create _PROTO ((void));
extern void function_Destroy _PROTO ((Function * f));
extern Function *function_Copy _PROTO ((Function * f));
extern void function_SetName _PROTO ((Function * f, char *name));
extern void function_SetCodePtr _PROTO ((Function * f, Inst * ptr));
extern Inst *function_GetCodePtr _PROTO ((Function * f));
extern void function_SetArgPtr _PROTO ((Function * f, List * arg_list));
extern void function_SetLocalPtr _PROTO ((Function * f, List * local_var_list));
extern void function_SetGlobalPtr _PROTO ((Function * f, List * local_var_list));
extern int function_HasLocalVar _PROTO ((Function * f));
extern int function_SetCodeSize _PROTO ((Function * f, int size));
extern int function_GetCodeSize _PROTO ((Function * f));

extern List *function_GetArgPtr _PROTO ((Function * f));
extern void function_SetNargs _PROTO ((Function * f, int n_args));
extern int function_GetNargs _PROTO ((Function * f));
extern void function_SetNlocal _PROTO ((Function * f, int n_local));
extern int function_GetNlocal _PROTO ((Function * f));
extern void function_SetNglobal _PROTO ((Function * f, int n_local));
extern int function_GetNglobal _PROTO ((Function * f));

extern List * function_GetLocalPtr _PROTO ((Function *f));
extern List * function_GetGlobalPtr _PROTO ((Function *f));

extern char *function_GetName _PROTO ((Function * f));
extern void function_SetName _PROTO ((Function * f, char *name));

extern LVar *lvar_Create _PROTO ((void));
extern void lvar_Destroy _PROTO ((LVar * l_var));
extern void lvar_SetOffset _PROTO ((LVar * l_var, int offset));
extern void lvar_SetName _PROTO ((LVar * l_var, char *name));
extern char *lvar_GetName _PROTO ((LVar * l_var));

List *local_var_push _PROTO ((List * list, char *s));
List *global_var_push _PROTO ((List * list, char *s));
List *arg_var_push _PROTO ((List * list, char *s));

#define lvar_GetOffset(lvar)   (((LVar *)(lvar))->offset)

extern int function_setup1 _PROTO ((int lsave, char *fn));
extern ListNode *function_setup2 _PROTO ((List *a4, List *a10, List *a13));

#endif /* RLAB_FUNCTION */
