/* fi_1.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef FI_1_H
#define FI_1_H

#include "matrix.h"

extern int matrix_is_symmetric _PROTO ((Matrix * m));
extern Matrix *matrix_Inverse _PROTO ((Matrix * m));
extern Matrix *solve_eq _PROTO ((Matrix * a, Matrix *b));
extern Matrix *matrix_solve_ge _PROTO ((Matrix * a, Matrix *b));
extern Matrix *matrix_solve_sy _PROTO ((Matrix * a, Matrix *b));
extern double matrix_Norm _PROTO ((Matrix * m, char *type));
extern double matrix_Rcond _PROTO ((Matrix * m));
extern Scalar *matrix_Det _PROTO ((Matrix * m));
extern void matrix_Svd _PROTO ((Matrix * m, Matrix ** rsv, Matrix ** lsv,
				Matrix ** sigma, int flag));

extern void matrix_Eig_SEP _PROTO ((Matrix *M, Matrix **val, Matrix **vec));
extern void matrix_Eig_NEP _PROTO ((Matrix * ma, Matrix ** val, Matrix ** vec,
				    Matrix ** lvec, int lflag));
extern void matrix_Eig_GSEP _PROTO ((Matrix * ma, Matrix * mb,
				     Matrix ** val, Matrix ** vec));
extern void matrix_Eig_GNEP _PROTO ((Matrix *MA, Matrix *MB, Matrix **val, 
				     Matrix **vecr));
extern void matrix_Eig_GNEPa _PROTO ((Matrix *MA, Matrix *MB, Matrix **alpha, 
				      Matrix **beta, Matrix **vecl, Matrix **vecr));

extern Matrix *matrix_Chol _PROTO ((Matrix * m));
extern void matrix_Qr _PROTO ((Matrix * m, Matrix ** q, Matrix ** r));
extern void matrix_QrP _PROTO ((Matrix * m, Matrix ** q, 
				Matrix ** r, Matrix **p));
extern void matrix_Hess _PROTO ((Matrix * m, Matrix ** p, Matrix ** h));
extern void matrix_Balance _PROTO ((Matrix * m, Matrix ** Ab, Matrix ** t));

#endif /* FI_1_H */
