/* list.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef  LIST_H
#define  LIST_H

#include "rlab.h"
#include "listnode.h"

struct _list
{
  int type;			/* identifies the object */
  char *name;
  int numNodes;			/* The number of ListNode's in the list   */
  ListNode *firstNode;		/* The first ListNode in the list         */
  ListNode *lastNode;		/* The last ListNode in the list          */
};

typedef struct _list List;

extern List *list_Create _PROTO ((void));
extern void list_Destroy _PROTO ((List *));
extern void list_DestroyAllNodes _PROTO ((List *));
extern int list_DestroyNodesOnly _PROTO ((List *));
extern void list_GarbageCollect _PROTO ((List *));
extern int list_DestroyNodeByPos _PROTO ((List *, int));
extern int list_DestroyNodeByAddr _PROTO ((List *, ListNode *));
extern int list_DestroyNodeOnlyByAddr _PROTO ((List *, ListNode *));
extern int list_Initialize _PROTO ((List * list));

extern ListNode *list_InsertNode _PROTO ((List *, ListNode *, int));

extern ListNode *list_EnqueueNode _PROTO ((List *, ListNode *));
extern ListNode *list_DequeueNode _PROTO ((List *));

extern ListNode *list_PushNode _PROTO ((List *, ListNode *));
extern ListNode *list_PopNode _PROTO ((List *));

extern ListNode *list_DetachNodeByPos _PROTO ((List *, int));
extern ListNode *list_DetachNodeByAddr _PROTO ((List *, ListNode *));

extern ListNode *list_GetNodeByPos _PROTO ((List *, int));
extern VPTR list_GetNodeDataByPos _PROTO ((List *, int));

extern void list_PrintToFile _PROTO ((List *, FILE *));
extern int list_IsPosValid _PROTO ((List *, int));

extern ListNode *list_GetLastNode _PROTO ((List *));
extern ListNode *list_GetFirstNode _PROTO ((List *));
extern ListNode *list_GetNodeByKey _PROTO ((List *, char *));

#define list_GetNumNodes(list)  (((List *)(list))->numNodes)

#endif /* LIST_H */
