/* mem.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef MEM_H
#define MEM_H

#include "rlab.h"

/* define these here so we can change them easily if we have to */

#define MALLOC(size)		  r_malloc(size)
#define CALLOC(nobj, size)	  calloc(nobj, size)
#define REALLOC(p, size)	  r_realloc(p, size)
#define FREE(p)		((p != 0) ? free(p), p = 0: 0)

extern VPTR r_malloc _PROTO ((size_t n));
extern VPTR r_realloc _PROTO ((VPTR p, size_t n));

/*
 * mem.c also contains
 * VPTR xmalloc _PROTO(( size_t n ));
 * VPTR xrealloc _PROTO(( (VPTR) ptr, size_t size ));
 * But, these are not declared here, cause alloca.c
 * usually declares them.
 */

#endif /* MEM_H */
