/* r_string.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_STRING_H
#define RLAB_STRING_H

#include "rlab.h"
#include <stdio.h>

struct _rlab_string
{
  int type;
  char *name;
  char *string;
};

typedef struct _rlab_string String;

extern String *string_Create _PROTO ((char *s));
extern void string_Destroy _PROTO ((String * s));
extern void string_Set _PROTO ((String * s, char *cptr));
extern String *string_Copy _PROTO ((String *));
extern void string_memcpy _PROTO ((String * s1, VPTR s2, int len));
extern String *string_Add _PROTO ((String * s1, String * s2));
extern int string_GetLength _PROTO ((String *));
extern int string_Compare _PROTO ((String *, String *));
extern void string_SetName _PROTO ((String *, char *name));
extern void string_Write _PROTO ((String *, FILE * fn));
extern String *string_Read _PROTO ((FILE * fn));
extern char *string_add _PROTO ((char *s1, char *s2));
extern void string_Print _PROTO ((String * s, FILE * fn));

#define  string_GetString(s)    (((String *) s)->string)
#define  STR(s)                 (((String *) s)->string)
#define  string_GetName(s)      (((String *) s)->name)

#endif /* RLAB_STRING_H */
