/* rdl.c */
/* rdl.c: RLaB Dynamic linking */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#include "rlab.h"
#include "symbol.h"
#include "bltin.h"
#include "util.h"
#include "mem.h"
#include "r_string.h"

#include <stdio.h>
#ifdef HAVE_SO

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif

typedef void (*VFPTR) ();

void
DLopen (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  char *errmsg, *fn, *fun_name;
  Bltin *newb;
  ListNode *FN, *FUNC;
  VPTR handle;
  VPTR fptr;

  if (n_args != 2)
    error_1 ("dlopen: requires 2 arguments", 0);

  FN = bltin_get_string ("dlopen", d_arg, 1);
  FUNC = bltin_get_string ("dlopen", d_arg, 2);

  fn = string_GetString (e_data (FN));
  fun_name = string_GetString (e_data (FUNC));

#ifdef RTLD_NOW
  handle = dlopen (fn, RTLD_NOW);
#else
  handle = dlopen (fn, RTLD_LAZY);
#endif
  if (handle == 0)
  {
    remove_tmp_destroy (FN);
    remove_tmp_destroy (FUNC);
    errmsg = dlerror ();
    error_1 ("dlopen", errmsg);
  }

  fptr = dlsym (handle, fun_name);
  if (fptr == 0)
  {
    remove_tmp_destroy (FN);
    remove_tmp_destroy (FUNC);
    errmsg = dlerror ();
    error_1 ("dlsym", errmsg);
  }

  /*
   * Now create and return the built-in function.
   */

  newb = (Bltin *) MALLOC (sizeof (Bltin));
  newb->type = BLTIN;
  newb->name = 0;
  newb->func = (VFPTR) fptr;

  *return_ptr = (VPTR) newb;

  remove_tmp_destroy (FN);
  remove_tmp_destroy (FUNC);
}

#endif  /* HAVE_SO */
