/* symbol.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_SYMBOL
#define RLAB_SYMBOL

#include "rlab.h"
#include "list.h"
#include "btree.h"
#include <stdio.h>

extern void symbol_table_create _PROTO ((void));
extern Btree *get_symtab_ptr _PROTO ((void));

extern ListNode *install _PROTO ((VPTR sym_table, char *s,
				  int type, VPTR data));
extern ListNode *install_tmp _PROTO ((int type, VPTR data, void (*freeFn) ()));
extern ListNode *install_tmp_switch _PROTO ((int type, VPTR data));
extern int delete_symbol_table _PROTO ((void));
extern ListNode *lookup _PROTO ((List * sym_table, char *s));
extern void clean_list _PROTO ((void));
extern int move _PROTO ((ListNode * ent));
extern VPTR remove_tmp _PROTO ((ListNode * ent));
extern int remove_tmp_destroy _PROTO ((ListNode * ent));
extern void reset_global_symbol_table_ptr _PROTO ((void));
extern void string_log _PROTO ((char *s));

extern VPTR print_object_list _PROTO ((Btree * root));
extern VPTR print_function_list _PROTO ((Btree * root));

extern Var *gst _PROTO ((void));

#endif /* RLAB_SYMBOL */
