/* dtgevc.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c__2 = 2;
static doublereal c_b34 = 1.;
static doublereal c_b36 = 0.;
static integer c__0 = 0;

/* Subroutine */ int dtgevc_(job, side, select, n, a, lda, b, ldb, vl, ldvl, 
	vr, ldvr, mm, m, work, info, job_len, side_len)
char *job, *side;
logical *select;
integer *n;
doublereal *a;
integer *lda;
doublereal *b;
integer *ldb;
doublereal *vl;
integer *ldvl;
doublereal *vr;
integer *ldvr, *mm, *m;
doublereal *work;
integer *info;
ftnlen job_len;
ftnlen side_len;
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, vl_dim1, vl_offset, vr_dim1, 
	    vr_offset, work_dim1, work_offset, i__1, i__2, i__3, i__4, i__5;
    doublereal d__1, d__2, d__3, d__4, d__5, d__6;

    /* Local variables */
    static integer ibeg, ieig, iend, ijob;
    static doublereal dmin_, temp, suma[4]	/* was [2][2] */, sumb[4]	
	    /* was [2][2] */, xmax;
    extern /* Subroutine */ int dlag2_();
    static doublereal cim2a, cim2b, cre2a, cre2b, temp2, bdiag[2];
    static integer i, j;
    static doublereal acoef, scale;
    static logical ilall;
    static integer iside;
    static doublereal sbeta;
    extern logical lsame_();
    extern /* Subroutine */ int dgemv_();
    static logical il2by2;
    static integer iinfo;
    static doublereal small;
    static logical compl;
    static doublereal anorm, bnorm;
    static logical compr;
    extern /* Subroutine */ int dlaln2_();
    static doublereal temp2i;
    extern /* Subroutine */ int dlabad_();
    static doublereal temp2r;
    static integer ja;
    static logical ilabad, ilbbad;
    static integer jc, je, na;
    static doublereal acoefa, bcoefa, cimaga, cimagb;
    static logical ilback;
    static integer im;
    static doublereal bcoefi, ascale, bscale, creala;
    static integer jr;
    static doublereal crealb;
    extern doublereal dlamch_();
    static doublereal bcoefr;
    static integer jw, nw;
    static doublereal salfar, safmin;
    extern /* Subroutine */ int dlacpy_();
    static doublereal xscale, bignum;
    extern /* Subroutine */ int xerbla_();
    static logical ilcomp, ilcplx;
    static doublereal big;
    static logical lsa, lsb;
    static doublereal ulp, sum[4]	/* was [2][2] */;


/*  -- LAPACK routine (version 1.1) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */
/*     March 31, 1993 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */


/*  Purpose */
/*  ======= */

/*  DTGEVC computes selected left and/or right generalized eigenvectors */
/*  of a pair of real upper triangular matrices (A,B).  The */
/*  j-th generalized left and right eigenvectors are  y  and  x, resp., */
/*  such that: */
/*       H                           H */
/*      y  (A - wB) = 0  or  (A - wB) y = 0   and    (A - wB)x = 0 */

/*                                                                      H 
*/
/*  Note: the left eigenvector is sometimes defined as the row vector  y 
*/
/*        but DTGEVC computes the column vector y. */
/*  Reminder: the eigenvectors may be real or complex.  If complex, the */
/*        eigenvector for the eigenvalue w s.t. Im(w) > 0 is computed. */

/*  Arguments */
/*  ========= */

/*  JOB     (input) CHARACTER*1 */
/*          = 'A': compute All (left/right/left+right) generalized */
/*                 eigenvectors of (A,B); */
/*          = 'S': compute Selected (left/right/left+right) generalized */
/*                 eigenvectors of (A,B) -- see the description of the */
/*                 argument SELECT; */
/*          = 'B' or 'T': compute all (left/right/left+right) generalized 
*/
/*                 eigenvectors of (A,B), and Back Transform them */
/*                 using the initial contents of VL/VR -- see the */
/*                 descriptions of the arguments VL and VR. */

/*  SIDE    (input) CHARACTER*1 */
/*          Specifies for which side eigenvectors are to be computed: */
/*          = 'R': compute right eigenvectors only; */
/*          = 'L': compute left eigenvectors only; */
/*          = 'B': compute both right and left eigenvectors. */

/*  SELECT  (input) LOGICAL array, dimension (N) */
/*          If JOB='S', then SELECT specifies the (generalized) */
/*          eigenvectors to be computed.  To get the eigenvector */
/*          corresponding to the j-th eigenvalue, set SELECT(j) to */
/*          .TRUE.  If the j-th and (j+1)-st eigenvalues are */
/*          conjugates, i.e., A(j+1,j) is nonzero, then only the */
/*          eigenvector for the first may be selected (the second being */
/*          just the conjugate of the first); this may be done by */
/*          setting either SELECT(j) or SELECT(j+1) to .TRUE. */

/*          If JOB='A', 'B', or 'T', SELECT is not referenced, and all */
/*          eigenvectors are selected. */

/*  N       (input) INTEGER */
/*          The order of the matrices A and B.  N >= 0. */

/*  A       (input) DOUBLE PRECISION array, dimension (LDA,N) */
/*          One of the pair of matrices whose generalized eigenvectors */
/*          are to be computed.  It must be block upper triangular, with 
*/
/*          1-by-1 or 2-by-2 blocks on the diagonal, the 1-by-1 blocks */
/*          corresponding to real generalized eigenvalues and the 2-by-2 
*/
/*          blocks corresponding to complex generalized eigenvalues. */
/*          The eigenvalues are computed from the diagonal blocks of A */
/*          and corresponding entries of B. */

/*  LDA     (input) INTEGER */
/*          The leading dimension of array A.  LDA >= max(1, N). */

/*  B       (input) DOUBLE PRECISION array, dimension (LDB,N) */
/*          The other of the pair of matrices whose generalized */
/*          eigenvectors are to be computed.  It must be upper */
/*          triangular, and if A has a 2-by-2 diagonal block in */
/*          rows/columns j,j+1, then the corresponding 2-by-2 block of B 
*/
/*          must be diagonal with positive entries. */

/*  LDB     (input) INTEGER */
/*          The leading dimension of array B.  LDB >= max(1, N). */

/*  VL      (input/output) DOUBLE PRECISION array, dimension (LDVL,MM) */
/*          On exit, the left eigenvectors (column vectors -- see the */
/*          note in "Purpose".)  Real eigenvectors take one column, */
/*          complex take two columns, the first for the real part and the 
*/
/*          second for the imaginary part. */
/*          If JOB='A', then all left eigenvectors of (A,B) will be */
/*             computed and stored in VL. */
/*          If JOB='S', then only the eigenvectors selected by SELECT */
/*             will be computed, and they will be stored one right after 
*/
/*             another in VL; the first selected eigenvector will go */
/*             in column 1 (and 2, if complex), the second in the next */
/*             column(s), etc. */
/*          If JOB='B' or 'T', then all left eigenvectors of (A,B) */
/*             will be computed and multiplied (on the left) by the */
/*             matrix found in VL on entry to DTGEVC.  Usually, this */
/*             will be the Q matrix computed by DGGHRD and DHGEQZ, */
/*             so that on exit, VL will contain the left eigenvectors */
/*             of the original matrix pair. */
/*          In any case, each eigenvector will be scaled so the largest */
/*          component of each vector has */
/*          abs(real part) + abs(imag. part)=1, *unless*  the diagonal */
/*          blocks in A and B corresponding to the eigenvector are both */
/*          zero (hence, 1-by-1), in which case the eigenvector will be */
/*          zero. */
/*          If SIDE = 'R', VL is not referenced. */

/*  LDVL    (input) INTEGER */
/*          The leading dimension of array VL.  LDVL >= 1; if SIDE = 'B' 
*/
/*          or 'L', LDVL >= N. */

/*  VR      (input/output) COMPLEX*16 array, dimension (LDVR,MM) */
/*          On exit, the right eigenvectors.  Real eigenvectors take one 
*/
/*          column, complex take two columns, the first for the real */
/*          part and the second for the imaginary part. */
/*          If JOB='A', then all right eigenvectors of (A,B) will be */
/*             computed and stored in VR. */
/*          If JOB='S', then only the eigenvectors selected by SELECT */
/*             will be computed, and they will be stored one right after 
*/
/*             another in VR; the first selected eigenvector will go */
/*             in column 1 (and 2, if complex), the second in the next */
/*             column(s), etc. */
/*          If JOB='B' or 'T', then all right eigenvectors of (A,B) */
/*             will be computed and multiplied (on the left) by the */
/*             matrix found in VR on entry to DTGEVC.  Usually, this */
/*             will be the Z matrix computed by DGGHRD and DHGEQZ, */
/*             so that on exit, VR will contain the right eigenvectors */
/*             of the original matrix pair. */
/*          In any case, each eigenvector will be scaled so the largest */
/*          component of each vector has */
/*          abs(real part) + abs(imag. part)=1, *unless*  the diagonal */
/*          blocks in A and B corresponding to the eigenvector are both */
/*          zero (hence, 1-by-1), in which case the eigenvector will be */
/*          zero. */
/*          If SIDE = 'L', VR is not referenced. */

/*  LDVR    (input) INTEGER */
/*          The leading dimension of array VR.  LDVR >= 1; if SIDE = 'B' 
*/
/*          or 'R', LDVR >= N. */

/*  MM      (input) INTEGER */
/*          The number of columns in VL and/or VR. */
/*          If JOB='A', 'B', or 'T', then MM >= N. */
/*          If JOB='S', then MM must be at least the number of columns */
/*             required, as computed from SELECT.  Each .TRUE. value in */
/*             SELECT corresponding to a real eigenvalue (i.e., A(j+1,j) 
*/
/*             and A(j,j-1) are zero) counts for one column, and each */
/*             .TRUE.  value corresponding to the first of a complex */
/*             conjugate pair (i.e., A(j+1,j) is not zero) counts for */
/*             two columns.  (.TRUE. values corresponding to the second */
/*             of a pair -- A(j,j-1) is not zero -- are ignored.) */

/*  M       (output) INTEGER */
/*          The number of columns in VL and/or VR actually */
/*          used to store the eigenvectors. */

/*  WORK    (workspace) DOUBLE PRECISION array, dimension ( N, 6 ) */

/*  INFO    (output) INTEGER */
/*          = 0:  successful exit. */
/*          < 0:  if INFO = -i, the i-th argument had an illegal value. */
/*          > 0:  the 2-by-2 block (INFO:INFO+1) does not have a complex 
*/
/*                eigenvalue. */

/*  Further Details */
/*  =============== */

/*  Allocation of workspace: */
/*  ---------- -- --------- */

/*     WORK( j, 1 ) = 1-norm of j-th column of A, above the diagonal */
/*     WORK( j, 2 ) = 1-norm of j-th column of B, above the diagonal */
/*     WORK( *, 3 ) = real part of eigenvector */
/*     WORK( *, 4 ) = imaginary part of eigenvector */
/*     WORK( *, 5 ) = real part of back-transformed eigenvector */
/*     WORK( *, 6 ) = imaginary part of back-transformed eigenvector */


/*  Rowwise vs. columnwise solution methods: */
/*  ------- --  ---------- -------- ------- */

/*  Finding a generalized eigenvector consists basically of solving the */
/*  singular triangular system */
/*                                                    H */
/*     (A - w B) x = 0     (for right) or:   (A - w B) y = 0  (for left) 
*/

/*  Consider finding the i-th right eigenvector (assume all eigenvalues */
/*  are real). The equation to be solved is: */
/*       n                   i */
/*  0 = sum  C(j,k) v(k)  = sum  C(j,k) v(k)     for j = i,. . .,1 */
/*      k=j                 k=j */

/*  where  C = (A - w B)  (The components v(i+1:n) are 0.) */

/*  The "rowwise" method is: */

/*  (1)  v(i) := 1 */
/*  for j = i-1,. . .,1: */
/*                          i */
/*      (2) compute  s = - sum C(j,k) v(k)   and */
/*                        k=j+1 */

/*      (3) v(j) := s / C(j,j) */

/*  Step 2 is sometimes called the "dot product" step, since it is an */
/*  inner product between the j-th row and the portion of the eigenvector 
*/
/*  that has been computed so far. */

/*  The "columnwise" method consists basically in doing the sums */
/*  for all the rows in parallel.  As each v(j) is computed, the */
/*  contribution of v(j) times the j-th column of C is added to the */
/*  partial sums.  Since FORTRAN arrays are stored columnwise, this has */
/*  the advantage that at each step, the entries of C that are accessed */
/*  are adjacent to one another, whereas with the rowwise method, the */
/*  entries accessed at a step are spaced LDA (and LDB) words apart. */

/*  When finding left eigenvectors, the matrix in question is the */
/*  transpose of the one in storage, so the rowwise method then */
/*  actually accesses columns of A and B at each step, and so is the */
/*  preferred method. */

/*  ===================================================================== 
*/

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Decode and Test the input parameters */

    /* Parameter adjustments */
    work_dim1 = *n;
    work_offset = work_dim1 + 1;
    work -= work_offset;
    vr_dim1 = *ldvr;
    vr_offset = vr_dim1 + 1;
    vr -= vr_offset;
    vl_dim1 = *ldvl;
    vl_offset = vl_dim1 + 1;
    vl -= vl_offset;
    b_dim1 = *ldb;
    b_offset = b_dim1 + 1;
    b -= b_offset;
    a_dim1 = *lda;
    a_offset = a_dim1 + 1;
    a -= a_offset;
    --select;

    /* Function Body */
    if (lsame_(job, "A", 1L, 1L)) {
	ijob = 1;
	ilall = TRUE_;
	ilback = FALSE_;
    } else if (lsame_(job, "S", 1L, 1L)) {
	ijob = 2;
	ilall = FALSE_;
	ilback = FALSE_;
    } else if (lsame_(job, "B", 1L, 1L) || lsame_(job, "T", 1L, 1L)) {
	ijob = 3;
	ilall = TRUE_;
	ilback = TRUE_;
    } else {
	ijob = -1;
	ilall = TRUE_;
    }

    if (lsame_(side, "R", 1L, 1L)) {
	iside = 1;
	compl = FALSE_;
	compr = TRUE_;
    } else if (lsame_(side, "L", 1L, 1L)) {
	iside = 2;
	compl = TRUE_;
	compr = FALSE_;
    } else if (lsame_(side, "B", 1L, 1L)) {
	iside = 3;
	compl = TRUE_;
	compr = TRUE_;
    } else {
	iside = -1;
    }

/*     Count the number of eigenvectors to be computed */

    if (! ilall) {
	im = 0;
	ilcplx = FALSE_;
	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
	    if (ilcplx) {
		ilcplx = FALSE_;
		goto L10;
	    }
	    if (j < *n) {
		if (a[j + 1 + j * a_dim1] != 0.) {
		    ilcplx = TRUE_;
		}
	    }
	    if (ilcplx) {
		if (select[j] || select[j + 1]) {
		    im += 2;
		}
	    } else {
		if (select[j]) {
		    ++im;
		}
	    }
L10:
	    ;
	}
    } else {
	im = *n;
    }

/*     Check 2-by-2 diagonal blocks of A, B */

    ilabad = FALSE_;
    ilbbad = FALSE_;
    i__1 = *n - 1;
    for (j = 1; j <= i__1; ++j) {
	if (a[j + 1 + j * a_dim1] != 0.) {
	    if (b[j + j * b_dim1] == 0. || b[j + 1 + (j + 1) * b_dim1] == 0. 
		    || b[j + (j + 1) * b_dim1] != 0.) {
		ilbbad = TRUE_;
	    }
	    if (j < *n - 1) {
		if (a[j + 2 + (j + 1) * a_dim1] != 0.) {
		    ilabad = TRUE_;
		}
	    }
	}
/* L20: */
    }

    *info = 0;
    if (ijob < 0) {
	*info = -1;
    } else if (iside < 0) {
	*info = -2;
    } else if (*n < 0) {
	*info = -4;
    } else if (ilabad) {
	*info = -5;
    } else if (*lda < max(1,*n)) {
	*info = -6;
    } else if (ilbbad) {
	*info = -7;
    } else if (*ldb < max(1,*n)) {
	*info = -8;
    } else if (compl && *ldvl < *n || *ldvl < 1) {
	*info = -10;
    } else if (compr && *ldvr < *n || *ldvr < 1) {
	*info = -12;
    } else if (*mm < im) {
	*info = -13;
    }
    if (*info != 0) {
	i__1 = -(*info);
	xerbla_("DTGEVC", &i__1, 6L);
	return 0;
    }

/*     Quick return if possible */

    *m = im;
    if (*n == 0) {
	return 0;
    }

/*     Machine Constants */

    safmin = dlamch_("Safe minimum", 12L);
    big = 1. / safmin;
    dlabad_(&safmin, &big);
    ulp = dlamch_("Epsilon", 7L) * dlamch_("Base", 4L);
    small = safmin * *n / ulp;
    big = 1. / small;
    bignum = 1. / (safmin * *n);

/*     Compute the 1-norm of each column of the strictly upper triangular 
*/
/*     part (i.e., excluding all entries belonging to the diagonal */
/*     blocks) of A and B to check for possible overflow in the */
/*     triangular solver. */

    anorm = (d__1 = a[a_dim1 + 1], abs(d__1));
    if (*n > 1) {
	anorm += (d__1 = a[a_dim1 + 2], abs(d__1));
    }
    bnorm = (d__1 = b[b_dim1 + 1], abs(d__1));
    work[work_dim1 + 1] = 0.;
    work[(work_dim1 << 1) + 1] = 0.;

    i__1 = *n;
    for (j = 2; j <= i__1; ++j) {
	temp = 0.;
	temp2 = 0.;
	if (a[j + (j - 1) * a_dim1] == 0.) {
	    iend = j - 1;
	} else {
	    iend = j - 2;
	}
	i__2 = iend;
	for (i = 1; i <= i__2; ++i) {
	    temp += (d__1 = a[i + j * a_dim1], abs(d__1));
	    temp2 += (d__1 = b[i + j * b_dim1], abs(d__1));
/* L30: */
	}
	work[j + work_dim1] = temp;
	work[j + (work_dim1 << 1)] = temp2;
/* Computing MIN */
	i__3 = j + 1;
	i__2 = min(i__3,*n);
	for (i = iend + 1; i <= i__2; ++i) {
	    temp += (d__1 = a[i + j * a_dim1], abs(d__1));
	    temp2 += (d__1 = b[i + j * b_dim1], abs(d__1));
/* L40: */
	}
	anorm = max(anorm,temp);
	bnorm = max(bnorm,temp2);
/* L50: */
    }

    ascale = 1. / max(anorm,safmin);
    bscale = 1. / max(bnorm,safmin);

/*     Left eigenvectors */

    if (compl) {
	ieig = 0;

/*        Main loop over eigenvalues */

	ilcplx = FALSE_;
	i__1 = *n;
	for (je = 1; je <= i__1; ++je) {

/*           Skip this iteration if (a) JOB='S' and SELECT=.FALSE.
, or */
/*           (b) this would be the second of a complex pair. */
/*           Check for complex eigenvalue, so as to be sure of whi
ch */
/*           entry(-ies) of SELECT to look at. */

	    if (ilcplx) {
		ilcplx = FALSE_;
		goto L220;
	    }
	    nw = 1;
	    if (je < *n) {
		if (a[je + 1 + je * a_dim1] != 0.) {
		    ilcplx = TRUE_;
		    nw = 2;
		}
	    }
	    if (ilall) {
		ilcomp = TRUE_;
	    } else if (ilcplx) {
		ilcomp = select[je] || select[je + 1];
	    } else {
		ilcomp = select[je];
	    }
	    if (! ilcomp) {
		goto L220;
	    }

/*           Decide if (a) singular pencil, (b) real eigenvalue, o
r */
/*           (c) complex eigenvalue. */

	    if (! ilcplx) {
		if ((d__1 = a[je + je * a_dim1], abs(d__1)) <= safmin && (
			d__2 = b[je + je * b_dim1], abs(d__2)) <= safmin) {

/*                 Singular matrix pencil -- zero eigenvec
tor */

		    ++ieig;
		    i__2 = *n;
		    for (jr = 1; jr <= i__2; ++jr) {
			vl[jr + ieig * vl_dim1] = 0.;
/* L60: */
		    }
		    goto L220;
		}
	    }

/*           Clear vector */

	    i__2 = nw * *n;
	    for (jr = 1; jr <= i__2; ++jr) {
		work[jr + work_dim1 * 3] = 0.;
/* L70: */
	    }
/*                                                 T */
/*           Compute coefficients in  ( a A - b B )  y = 0 */
/*              a  is  ACOEF */
/*              b  is  BCOEFR + i*BCOEFI */

	    if (! ilcplx) {

/*              Real eigenvalue */

/* Computing MAX */
		d__3 = (d__1 = a[je + je * a_dim1], abs(d__1)) * ascale, d__4 
			= (d__2 = b[je + je * b_dim1], abs(d__2)) * bscale, 
			d__3 = max(d__3,d__4);
		temp = 1. / max(d__3,safmin);
		salfar = temp * a[je + je * a_dim1] * ascale;
		sbeta = temp * b[je + je * b_dim1] * bscale;
		acoef = sbeta * ascale;
		bcoefr = salfar * bscale;
		bcoefi = 0.;

/*              Scale to avoid underflow */

		scale = 1.;
		lsa = abs(sbeta) >= safmin && abs(acoef) < small;
		lsb = abs(salfar) >= safmin && abs(bcoefr) < small;
		if (lsa) {
		    scale = small / abs(sbeta) * min(anorm,big);
		}
		if (lsb) {
/* Computing MAX */
		    d__1 = scale, d__2 = small / abs(salfar) * min(bnorm,big);
		    scale = max(d__1,d__2);
		}
		if (lsa || lsb) {
/* Computing MIN */
/* Computing MAX */
		    d__3 = 1., d__4 = abs(acoef), d__3 = max(d__3,d__4), d__4 
			    = abs(bcoefr);
		    d__1 = scale, d__2 = 1. / (safmin * max(d__3,d__4));
		    scale = min(d__1,d__2);
		    if (lsa) {
			acoef = ascale * (scale * sbeta);
		    } else {
			acoef = scale * acoef;
		    }
		    if (lsb) {
			bcoefr = bscale * (scale * salfar);
		    } else {
			bcoefr = scale * bcoefr;
		    }
		}
		acoefa = abs(acoef);
		bcoefa = abs(bcoefr);

/*              First component is 1 */

		work[je + work_dim1 * 3] = 1.;
		xmax = 1.;
	    } else {

/*              Complex eigenvalue */

		dlag2_(&a[je + je * a_dim1], lda, &b[je + je * b_dim1], ldb, &
			safmin, &acoef, &temp, &bcoefr, &temp2, &bcoefi);
		bcoefi = -bcoefi;
		if (bcoefi == 0.) {
		    *info = je;
		    return 0;
		}

/*              Scale to avoid overflow */

		acoefa = abs(acoef);
		bcoefa = abs(bcoefr) + abs(bcoefi);
		scale = 1.;
		if (safmin * acoefa > ascale) {
		    scale = ascale / (safmin * acoefa);
		}
		if (safmin * bcoefa > bscale) {
/* Computing MIN */
		    d__1 = scale, d__2 = bscale / (safmin * bcoefa);
		    scale = min(d__1,d__2);
		}
		if (scale < 1.) {
		    acoef = scale * acoef;
		    acoefa = abs(acoef);
		    bcoefr = scale * bcoefr;
		    bcoefi = scale * bcoefi;
		    bcoefa = abs(bcoefr) + abs(bcoefi);
		}

/*              Compute first two components of eigenvector */

		temp = acoef * a[je + 1 + je * a_dim1];
		temp2r = acoef * a[je + je * a_dim1] - bcoefr * b[je + je * 
			b_dim1];
		temp2i = -bcoefi * b[je + je * b_dim1];
		if (abs(temp) > abs(temp2r) + abs(temp2i)) {
		    work[je + work_dim1 * 3] = 1.;
		    work[je + (work_dim1 << 2)] = 0.;
		    work[je + 1 + work_dim1 * 3] = -temp2r / temp;
		    work[je + 1 + (work_dim1 << 2)] = -temp2i / temp;
		} else {
		    work[je + 1 + work_dim1 * 3] = 1.;
		    work[je + 1 + (work_dim1 << 2)] = 0.;
		    temp = acoef * a[je + (je + 1) * a_dim1];
		    work[je + work_dim1 * 3] = (bcoefr * b[je + 1 + (je + 1) *
			     b_dim1] - acoef * a[je + 1 + (je + 1) * a_dim1]) 
			    / temp;
		    work[je + (work_dim1 << 2)] = bcoefi * b[je + 1 + (je + 1)
			     * b_dim1] / temp;
		}
/* Computing MAX */
		d__5 = (d__1 = work[je + work_dim1 * 3], abs(d__1)) + (d__2 = 
			work[je + (work_dim1 << 2)], abs(d__2)), d__6 = (d__3 
			= work[je + 1 + work_dim1 * 3], abs(d__3)) + (d__4 = 
			work[je + 1 + (work_dim1 << 2)], abs(d__4));
		xmax = max(d__5,d__6);
	    }

/* Computing MAX */
	    d__1 = ulp * acoefa * anorm, d__2 = ulp * bcoefa * bnorm, d__1 = 
		    max(d__1,d__2);
	    dmin_ = max(d__1,safmin);

/*                                           T */
/*           Triangular solve of  (a A - b B)  y = 0 */

/*                                   T */
/*           (rowwise in  (a A - b B) , or columnwise in (a A - b 
B) ) */

	    il2by2 = FALSE_;

	    i__2 = *n;
	    for (j = je + nw; j <= i__2; ++j) {
		if (il2by2) {
		    il2by2 = FALSE_;
		    goto L160;
		}

		na = 1;
		bdiag[0] = b[j + j * b_dim1];
		if (j < *n) {
		    if (a[j + 1 + j * a_dim1] != 0.) {
			il2by2 = TRUE_;
			bdiag[1] = b[j + 1 + (j + 1) * b_dim1];
			na = 2;
		    }
		}

/*              Check whether scaling is necessary for dot pro
ducts */

		xscale = 1. / max(1.,xmax);
/* Computing MAX */
		d__1 = work[j + work_dim1], d__2 = work[j + (work_dim1 << 1)],
			 d__1 = max(d__1,d__2), d__2 = acoefa * work[j + 
			work_dim1] + bcoefa * work[j + (work_dim1 << 1)];
		temp = max(d__1,d__2);
		if (il2by2) {
/* Computing MAX */
		    d__1 = temp, d__2 = work[j + 1 + work_dim1], d__1 = max(
			    d__1,d__2), d__2 = work[j + 1 + (work_dim1 << 1)],
			     d__1 = max(d__1,d__2), d__2 = acoefa * work[j + 
			    1 + work_dim1] + bcoefa * work[j + 1 + (work_dim1 
			    << 1)];
		    temp = max(d__1,d__2);
		}
		if (temp > bignum * xscale) {
		    i__3 = nw - 1;
		    for (jw = 0; jw <= i__3; ++jw) {
			i__4 = j - 1;
			for (jr = je; jr <= i__4; ++jr) {
			    work[jr + (jw + 3) * work_dim1] = xscale * work[
				    jr + (jw + 3) * work_dim1];
/* L80: */
			}
/* L90: */
		    }
		    xmax *= xscale;
		}

/*              Compute dot products */

/*                    j-1 */
/*              SUM = sum  conjg( a*A(k,j) - b*B(k,j) )*x(k) 
*/
/*                    k=je */

/*              To reduce the op count, this is done as */

/*              _        j-1                  _        j-1 */
/*              a*conjg( sum  A(k,j)*x(k) ) - b*conjg( sum  B(
k,j)*x(k) ) */
/*                       k=je                          k=je */

/*              which may cause underflow problems if A or B a
re close */
/*              to underflow.  (E.g., less than SMALL.) */


/*              A series of compiler directives to defeat vect
orization */
/*              for the next loop */

/* $PL$ CMCHAR=' ' */
/* DIR$          NEXTSCALAR */
/* $DIR          SCALAR */
/* DIR$          NEXT SCALAR */
/* VD$L          NOVECTOR */
/* DEC$          NOVECTOR */
/* VD$           NOVECTOR */
/* VDIR          NOVECTOR */
/* VOCL          LOOP,SCALAR */
/* IBM           PREFER SCALAR */
/* $PL$ CMCHAR='*' */

		i__3 = nw;
		for (jw = 1; jw <= i__3; ++jw) {

/* $PL$ CMCHAR=' ' */
/* DIR$             NEXTSCALAR */
/* $DIR             SCALAR */
/* DIR$             NEXT SCALAR */
/* VD$L             NOVECTOR */
/* DEC$             NOVECTOR */
/* VD$              NOVECTOR */
/* VDIR             NOVECTOR */
/* VOCL             LOOP,SCALAR */
/* IBM              PREFER SCALAR */
/* $PL$ CMCHAR='*' */

		    i__4 = na;
		    for (ja = 1; ja <= i__4; ++ja) {
			suma[ja + (jw << 1) - 3] = 0.;
			sumb[ja + (jw << 1) - 3] = 0.;

			i__5 = j - 1;
			for (jr = je; jr <= i__5; ++jr) {
			    suma[ja + (jw << 1) - 3] += a[jr + (j + ja - 1) * 
				    a_dim1] * work[jr + (jw + 2) * work_dim1];
			    sumb[ja + (jw << 1) - 3] += b[jr + (j + ja - 1) * 
				    b_dim1] * work[jr + (jw + 2) * work_dim1];
/* L100: */
			}
/* L110: */
		    }
/* L120: */
		}

/* $PL$ CMCHAR=' ' */
/* DIR$          NEXTSCALAR */
/* $DIR          SCALAR */
/* DIR$          NEXT SCALAR */
/* VD$L          NOVECTOR */
/* DEC$          NOVECTOR */
/* VD$           NOVECTOR */
/* VDIR          NOVECTOR */
/* VOCL          LOOP,SCALAR */
/* IBM           PREFER SCALAR */
/* $PL$ CMCHAR='*' */

		i__3 = na;
		for (ja = 1; ja <= i__3; ++ja) {
		    if (ilcplx) {
			sum[ja - 1] = -acoef * suma[ja - 1] + bcoefr * sumb[
				ja - 1] - bcoefi * sumb[ja + 1];
			sum[ja + 1] = -acoef * suma[ja + 1] + bcoefr * sumb[
				ja + 1] + bcoefi * sumb[ja - 1];
		    } else {
			sum[ja - 1] = -acoef * suma[ja - 1] + bcoefr * sumb[
				ja - 1];
		    }
/* L130: */
		}

/*                                  T */
/*              Solve  ( a A - b B )  y = SUM(,) */
/*              with scaling and perturbation of the denominat
or */

		dlaln2_(&c__1, &na, &nw, &dmin_, &acoef, &a[j + j * a_dim1], 
			lda, bdiag, &bdiag[1], sum, &c__2, &bcoefr, &bcoefi, &
			work[j + work_dim1 * 3], n, &scale, &temp, &iinfo);
		if (scale < 1.) {
		    i__3 = nw - 1;
		    for (jw = 0; jw <= i__3; ++jw) {
			i__4 = j - 1;
			for (jr = je; jr <= i__4; ++jr) {
			    work[jr + (jw + 3) * work_dim1] = scale * work[jr 
				    + (jw + 3) * work_dim1];
/* L140: */
			}
/* L150: */
		    }
		    xmax = scale * xmax;
		}
		xmax = max(xmax,temp);
L160:
		;
	    }

/*           Copy eigenvector to VL, back transforming if */
/*           JOB='B' or 'T'. */

	    ++ieig;
	    if (ilback) {
		i__2 = nw - 1;
		for (jw = 0; jw <= i__2; ++jw) {
		    i__3 = *n + 1 - je;
		    dgemv_("N", n, &i__3, &c_b34, &vl[je * vl_dim1 + 1], ldvl,
			     &work[je + (jw + 3) * work_dim1], &c__1, &c_b36, 
			    &work[(jw + 5) * work_dim1 + 1], &c__1, 1L);
/* L170: */
		}
		dlacpy_(" ", n, &nw, &work[work_dim1 * 5 + 1], n, &vl[je * 
			vl_dim1 + 1], ldvl, 1L);
		ibeg = 1;
	    } else {
		dlacpy_(" ", n, &nw, &work[work_dim1 * 3 + 1], n, &vl[ieig * 
			vl_dim1 + 1], ldvl, 1L);
		ibeg = je;
	    }

/*           Scale eigenvector */

	    xmax = 0.;
	    if (ilcplx) {
		i__2 = *n;
		for (j = ibeg; j <= i__2; ++j) {
/* Computing MAX */
		    d__3 = xmax, d__4 = (d__1 = vl[j + ieig * vl_dim1], abs(
			    d__1)) + (d__2 = vl[j + (ieig + 1) * vl_dim1], 
			    abs(d__2));
		    xmax = max(d__3,d__4);
/* L180: */
		}
	    } else {
		i__2 = *n;
		for (j = ibeg; j <= i__2; ++j) {
/* Computing MAX */
		    d__2 = xmax, d__3 = (d__1 = vl[j + ieig * vl_dim1], abs(
			    d__1));
		    xmax = max(d__2,d__3);
/* L190: */
		}
	    }

	    if (xmax > safmin) {
		xscale = 1. / xmax;

		i__2 = nw - 1;
		for (jw = 0; jw <= i__2; ++jw) {
		    i__3 = *n;
		    for (jr = ibeg; jr <= i__3; ++jr) {
			vl[jr + (ieig + jw) * vl_dim1] = xscale * vl[jr + (
				ieig + jw) * vl_dim1];
/* L200: */
		    }
/* L210: */
		}
	    }
	    ieig = ieig + nw - 1;

L220:
	    ;
	}
    }

/*     Right eigenvectors */

    if (compr) {
	ieig = im + 1;

/*        Main loop over eigenvalues */

	ilcplx = FALSE_;
	for (je = *n; je >= 1; --je) {

/*           Skip this iteration if (a) JOB='S' and SELECT=.FALSE.
, or */
/*           (b) this would be the second of a complex pair. */
/*           Check for complex eigenvalue, so as to be sure of whi
ch */
/*           entry(-ies) of SELECT to look at -- if complex, SELEC
T(JE) */
/*           or SELECT(JE-1). */
/*           If this is a complex pair, the 2-by-2 diagonal block 
*/
/*           corresponding to the eigenvalue is in rows/columns JE
-1:JE */

	    if (ilcplx) {
		ilcplx = FALSE_;
		goto L500;
	    }
	    nw = 1;
	    if (je > 1) {
		if (a[je + (je - 1) * a_dim1] != 0.) {
		    ilcplx = TRUE_;
		    nw = 2;
		}
	    }
	    if (ilall) {
		ilcomp = TRUE_;
	    } else if (ilcplx) {
		ilcomp = select[je] || select[je - 1];
	    } else {
		ilcomp = select[je];
	    }
	    if (! ilcomp) {
		goto L500;
	    }

/*           Decide if (a) singular pencil, (b) real eigenvalue, o
r */
/*           (c) complex eigenvalue. */

	    if (! ilcplx) {
		if ((d__1 = a[je + je * a_dim1], abs(d__1)) <= safmin && (
			d__2 = b[je + je * b_dim1], abs(d__2)) <= safmin) {

/*                 Singular matrix pencil -- zero eigenvec
tor */

		    --ieig;
		    i__1 = *n;
		    for (jr = 1; jr <= i__1; ++jr) {
			vr[jr + ieig * vr_dim1] = 0.;
/* L230: */
		    }
		    goto L500;
		}
	    }

/*           Clear vector */

	    i__1 = nw - 1;
	    for (jw = 0; jw <= i__1; ++jw) {
		i__2 = *n;
		for (jr = 1; jr <= i__2; ++jr) {
		    work[jr + (jw + 3) * work_dim1] = 0.;
/* L240: */
		}
/* L250: */
	    }

/*           Compute coefficients in  ( a A - b B ) x = 0 */
/*              a  is  ACOEF */
/*              b  is  BCOEFR + i*BCOEFI */

	    if (! ilcplx) {

/*              Real eigenvalue */

/* Computing MAX */
		d__3 = (d__1 = a[je + je * a_dim1], abs(d__1)) * ascale, d__4 
			= (d__2 = b[je + je * b_dim1], abs(d__2)) * bscale, 
			d__3 = max(d__3,d__4);
		temp = 1. / max(d__3,safmin);
		salfar = temp * a[je + je * a_dim1] * ascale;
		sbeta = temp * b[je + je * b_dim1] * bscale;
		acoef = sbeta * ascale;
		bcoefr = salfar * bscale;
		bcoefi = 0.;

/*              Scale to avoid underflow */

		scale = 1.;
		lsa = abs(sbeta) >= safmin && abs(acoef) < small;
		lsb = abs(salfar) >= safmin && abs(bcoefr) < small;
		if (lsa) {
		    scale = small / abs(sbeta) * min(anorm,big);
		}
		if (lsb) {
/* Computing MAX */
		    d__1 = scale, d__2 = small / abs(salfar) * min(bnorm,big);
		    scale = max(d__1,d__2);
		}
		if (lsa || lsb) {
/* Computing MIN */
/* Computing MAX */
		    d__3 = 1., d__4 = abs(acoef), d__3 = max(d__3,d__4), d__4 
			    = abs(bcoefr);
		    d__1 = scale, d__2 = 1. / (safmin * max(d__3,d__4));
		    scale = min(d__1,d__2);
		    if (lsa) {
			acoef = ascale * (scale * sbeta);
		    } else {
			acoef = scale * acoef;
		    }
		    if (lsb) {
			bcoefr = bscale * (scale * salfar);
		    } else {
			bcoefr = scale * bcoefr;
		    }
		}
		acoefa = abs(acoef);
		bcoefa = abs(bcoefr);

/*              First component is 1 */

		work[je + work_dim1 * 3] = 1.;
		xmax = 1.;

/*              Compute contribution from column JE of A and B
 to sum */
/*              (See "Further Details", above.) */

		i__1 = je - 1;
		for (jr = 1; jr <= i__1; ++jr) {
		    work[jr + work_dim1 * 3] = bcoefr * b[jr + je * b_dim1] - 
			    acoef * a[jr + je * a_dim1];
/* L260: */
		}
	    } else {

/*              Complex eigenvalue */

		dlag2_(&a[je - 1 + (je - 1) * a_dim1], lda, &b[je - 1 + (je - 
			1) * b_dim1], ldb, &safmin, &acoef, &temp, &bcoefr, &
			temp2, &bcoefi);
		if (bcoefi == 0.) {
		    *info = je - 1;
		    return 0;
		}

/*              Scale to avoid overflow */

		acoefa = abs(acoef);
		bcoefa = abs(bcoefr) + abs(bcoefi);
		scale = 1.;
		if (safmin * acoefa > ascale) {
		    scale = ascale / (safmin * acoefa);
		}
		if (safmin * bcoefa > bscale) {
/* Computing MIN */
		    d__1 = scale, d__2 = bscale / (safmin * bcoefa);
		    scale = min(d__1,d__2);
		}
		if (scale < 1.) {
		    acoef = scale * acoef;
		    acoefa = abs(acoef);
		    bcoefr = scale * bcoefr;
		    bcoefi = scale * bcoefi;
		    bcoefa = abs(bcoefr) + abs(bcoefi);
		}

/*              Compute first two components of eigenvector */
/*              and contribution to sums */

		temp = acoef * a[je + (je - 1) * a_dim1];
		temp2r = acoef * a[je + je * a_dim1] - bcoefr * b[je + je * 
			b_dim1];
		temp2i = -bcoefi * b[je + je * b_dim1];
		if (abs(temp) >= abs(temp2r) + abs(temp2i)) {
		    work[je + work_dim1 * 3] = 1.;
		    work[je + (work_dim1 << 2)] = 0.;
		    work[je - 1 + work_dim1 * 3] = -temp2r / temp;
		    work[je - 1 + (work_dim1 << 2)] = -temp2i / temp;
		} else {
		    work[je - 1 + work_dim1 * 3] = 1.;
		    work[je - 1 + (work_dim1 << 2)] = 0.;
		    temp = acoef * a[je - 1 + je * a_dim1];
		    work[je + work_dim1 * 3] = (bcoefr * b[je - 1 + (je - 1) *
			     b_dim1] - acoef * a[je - 1 + (je - 1) * a_dim1]) 
			    / temp;
		    work[je + (work_dim1 << 2)] = bcoefi * b[je - 1 + (je - 1)
			     * b_dim1] / temp;
		}

/* Computing MAX */
		d__5 = (d__1 = work[je + work_dim1 * 3], abs(d__1)) + (d__2 = 
			work[je + (work_dim1 << 2)], abs(d__2)), d__6 = (d__3 
			= work[je - 1 + work_dim1 * 3], abs(d__3)) + (d__4 = 
			work[je - 1 + (work_dim1 << 2)], abs(d__4));
		xmax = max(d__5,d__6);

/*              Compute contribution from columns JE and JE-1 
*/
/*              of A and B to the sums. */

		creala = acoef * work[je - 1 + work_dim1 * 3];
		cimaga = acoef * work[je - 1 + (work_dim1 << 2)];
		crealb = bcoefr * work[je - 1 + work_dim1 * 3] - bcoefi * 
			work[je - 1 + (work_dim1 << 2)];
		cimagb = bcoefi * work[je - 1 + work_dim1 * 3] + bcoefr * 
			work[je - 1 + (work_dim1 << 2)];
		cre2a = acoef * work[je + work_dim1 * 3];
		cim2a = acoef * work[je + (work_dim1 << 2)];
		cre2b = bcoefr * work[je + work_dim1 * 3] - bcoefi * work[je 
			+ (work_dim1 << 2)];
		cim2b = bcoefi * work[je + work_dim1 * 3] + bcoefr * work[je 
			+ (work_dim1 << 2)];
		i__1 = je - 2;
		for (jr = 1; jr <= i__1; ++jr) {
		    work[jr + work_dim1 * 3] = -creala * a[jr + (je - 1) * 
			    a_dim1] + crealb * b[jr + (je - 1) * b_dim1] - 
			    cre2a * a[jr + je * a_dim1] + cre2b * b[jr + je * 
			    b_dim1];
		    work[jr + (work_dim1 << 2)] = -cimaga * a[jr + (je - 1) * 
			    a_dim1] + cimagb * b[jr + (je - 1) * b_dim1] - 
			    cim2a * a[jr + je * a_dim1] + cim2b * b[jr + je * 
			    b_dim1];
/* L270: */
		}
	    }

/* Computing MAX */
	    d__1 = ulp * acoefa * anorm, d__2 = ulp * bcoefa * bnorm, d__1 = 
		    max(d__1,d__2);
	    dmin_ = max(d__1,safmin);

/*           Columnwise triangular solve of  (a A - b B)  x = 0 */

	    il2by2 = FALSE_;
	    for (j = je - nw; j >= 1; --j) {

/*              If a 2-by-2 block, is in position j-1:j, wait 
until */
/*              next iteration to process it (when it will be 
j:j+1) */

		if (! il2by2 && j > 1) {
		    if (a[j + (j - 1) * a_dim1] != 0.) {
			il2by2 = TRUE_;
			goto L370;
		    }
		}
		bdiag[0] = b[j + j * b_dim1];
		if (il2by2) {
		    na = 2;
		    bdiag[1] = b[j + 1 + (j + 1) * b_dim1];
		} else {
		    na = 1;
		}

/*              Compute x(j) (and x(j+1), if 2-by-2 block) */

		dlaln2_(&c__0, &na, &nw, &dmin_, &acoef, &a[j + j * a_dim1], 
			lda, bdiag, &bdiag[1], &work[j + work_dim1 * 3], n, &
			bcoefr, &bcoefi, sum, &c__2, &scale, &temp, &iinfo);
		if (scale < 1.) {

		    i__1 = nw - 1;
		    for (jw = 0; jw <= i__1; ++jw) {
			i__2 = je;
			for (jr = 1; jr <= i__2; ++jr) {
			    work[jr + (jw + 3) * work_dim1] = scale * work[jr 
				    + (jw + 3) * work_dim1];
/* L280: */
			}
/* L290: */
		    }
/* Computing MAX */
		    d__1 = scale * xmax;
		    xmax = max(d__1,temp);
		}

		i__1 = nw;
		for (jw = 1; jw <= i__1; ++jw) {
		    i__2 = na;
		    for (ja = 1; ja <= i__2; ++ja) {
			work[j + ja - 1 + (jw + 2) * work_dim1] = sum[ja + (
				jw << 1) - 3];
/* L300: */
		    }
/* L310: */
		}

/*              w = w + x(j)*(a A(*,j) - b B(*,j) ) with scali
ng */

		if (j > 1) {

/*                 Check whether scaling is necessary for 
sum. */

		    xscale = 1. / max(1.,xmax);
		    temp = acoefa * work[j + work_dim1] + bcoefa * work[j + (
			    work_dim1 << 1)];
		    if (il2by2) {
/* Computing MAX */
			d__1 = temp, d__2 = acoefa * work[j + 1 + work_dim1] 
				+ bcoefa * work[j + 1 + (work_dim1 << 1)];
			temp = max(d__1,d__2);
		    }
		    if (temp > bignum * xscale) {

			i__1 = nw - 1;
			for (jw = 0; jw <= i__1; ++jw) {
			    i__2 = je;
			    for (jr = 1; jr <= i__2; ++jr) {
				work[jr + (jw + 3) * work_dim1] = scale * 
					work[jr + (jw + 3) * work_dim1];
/* L320: */
			    }
/* L330: */
			}
			xmax *= xscale;
		    }

/*                 Compute the contributions of the off-di
agonals of */
/*                 column j (and j+1, if 2-by-2 block) of 
A and B to the */
/*                 sums. */


		    i__1 = na;
		    for (ja = 1; ja <= i__1; ++ja) {
			if (ilcplx) {
			    creala = acoef * work[j + ja - 1 + work_dim1 * 3];
			    cimaga = acoef * work[j + ja - 1 + (work_dim1 << 
				    2)];
			    crealb = bcoefr * work[j + ja - 1 + work_dim1 * 3]
				     - bcoefi * work[j + ja - 1 + (work_dim1 
				    << 2)];
			    cimagb = bcoefi * work[j + ja - 1 + work_dim1 * 3]
				     + bcoefr * work[j + ja - 1 + (work_dim1 
				    << 2)];
			    i__2 = j - 1;
			    for (jr = 1; jr <= i__2; ++jr) {
				work[jr + work_dim1 * 3] = work[jr + 
					work_dim1 * 3] - creala * a[jr + (j + 
					ja - 1) * a_dim1] + crealb * b[jr + (
					j + ja - 1) * b_dim1];
				work[jr + (work_dim1 << 2)] = work[jr + (
					work_dim1 << 2)] - cimaga * a[jr + (j 
					+ ja - 1) * a_dim1] + cimagb * b[jr + 
					(j + ja - 1) * b_dim1];
/* L340: */
			    }
			} else {
			    creala = acoef * work[j + ja - 1 + work_dim1 * 3];
			    crealb = bcoefr * work[j + ja - 1 + work_dim1 * 3]
				    ;
			    i__2 = j - 1;
			    for (jr = 1; jr <= i__2; ++jr) {
				work[jr + work_dim1 * 3] = work[jr + 
					work_dim1 * 3] - creala * a[jr + (j + 
					ja - 1) * a_dim1] + crealb * b[jr + (
					j + ja - 1) * b_dim1];
/* L350: */
			    }
			}
/* L360: */
		    }
		}

		il2by2 = FALSE_;
L370:
		;
	    }

/*           Copy eigenvector to VR, back transforming if */
/*           JOB='B' or 'T'. */

	    ieig -= nw;
	    if (ilback) {

		i__1 = nw - 1;
		for (jw = 0; jw <= i__1; ++jw) {
		    i__2 = *n;
		    for (jr = 1; jr <= i__2; ++jr) {
			work[jr + (jw + 5) * work_dim1] = work[(jw + 3) * 
				work_dim1 + 1] * vr[jr + vr_dim1];
/* L380: */
		    }

/*                 A series of compiler directives to defe
at */
/*                 vectorization for the next loop */


		    i__2 = je;
		    for (jc = 2; jc <= i__2; ++jc) {
			i__3 = *n;
			for (jr = 1; jr <= i__3; ++jr) {
			    work[jr + (jw + 5) * work_dim1] += work[jc + (jw 
				    + 3) * work_dim1] * vr[jr + jc * vr_dim1];
/* L390: */
			}
/* L400: */
		    }
/* L410: */
		}

		i__1 = nw - 1;
		for (jw = 0; jw <= i__1; ++jw) {
		    i__2 = *n;
		    for (jr = 1; jr <= i__2; ++jr) {
			vr[jr + (ieig + jw) * vr_dim1] = work[jr + (jw + 5) * 
				work_dim1];
/* L420: */
		    }
/* L430: */
		}

		iend = *n;
	    } else {
		i__1 = nw - 1;
		for (jw = 0; jw <= i__1; ++jw) {
		    i__2 = *n;
		    for (jr = 1; jr <= i__2; ++jr) {
			vr[jr + (ieig + jw) * vr_dim1] = work[jr + (jw + 3) * 
				work_dim1];
/* L440: */
		    }
/* L450: */
		}

		iend = je;
	    }

/*           Scale eigenvector */

	    xmax = 0.;
	    if (ilcplx) {
		i__1 = iend;
		for (j = 1; j <= i__1; ++j) {
/* Computing MAX */
		    d__3 = xmax, d__4 = (d__1 = vr[j + ieig * vr_dim1], abs(
			    d__1)) + (d__2 = vr[j + (ieig + 1) * vr_dim1], 
			    abs(d__2));
		    xmax = max(d__3,d__4);
/* L460: */
		}
	    } else {
		i__1 = iend;
		for (j = 1; j <= i__1; ++j) {
/* Computing MAX */
		    d__2 = xmax, d__3 = (d__1 = vr[j + ieig * vr_dim1], abs(
			    d__1));
		    xmax = max(d__2,d__3);
/* L470: */
		}
	    }

	    if (xmax > safmin) {
		xscale = 1. / xmax;
		i__1 = nw - 1;
		for (jw = 0; jw <= i__1; ++jw) {
		    i__2 = iend;
		    for (jr = 1; jr <= i__2; ++jr) {
			vr[jr + (ieig + jw) * vr_dim1] = xscale * vr[jr + (
				ieig + jw) * vr_dim1];
/* L480: */
		    }
/* L490: */
		}
	    }
L500:
	    ;
	}
    }

    return 0;

/*     End of DTGEVC */

} /* dtgevc_ */

