/* dsteqr.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b7 = 0.;
static doublereal c_b8 = 1.;
static integer c__2 = 2;
static integer c__1 = 1;

/* Subroutine */ int dsteqr_(compz, n, d, e, z, ldz, work, info, compz_len)
char *compz;
integer *n;
doublereal *d, *e, *z;
integer *ldz;
doublereal *work;
integer *info;
ftnlen compz_len;
{
    /* System generated locals */
    integer z_dim1, z_offset, i__1, i__2;
    doublereal d__1, d__2;

    /* Builtin functions */
    double d_sign();

    /* Local variables */
    static integer lend, jtot;
    extern /* Subroutine */ int dlae2_();
    static doublereal b, c, f, g;
    static integer i, j, k, l, m;
    static doublereal p, r, s;
    extern logical lsame_();
    extern /* Subroutine */ int dlasr_(), dswap_();
    static integer l1;
    extern /* Subroutine */ int dlaev2_();
    static integer lendm1, lendp1;
    extern doublereal dlapy2_();
    static integer ii;
    extern doublereal dlamch_();
    static integer mm;
    extern /* Subroutine */ int dlartg_(), xerbla_(), dlazro_();
    static integer nmaxit, icompz, lm1, mm1, nm1;
    static doublereal rt1, rt2, eps, tst;


/*  -- LAPACK routine (version 1.1) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */
/*     March 31, 1993 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DSTEQR computes all eigenvalues and, optionally, eigenvectors of a */
/*  symmetric tridiagonal matrix using the implicit QL or QR method. */
/*  The eigenvectors of a full or band symmetric matrix can also be found 
*/
/*  if DSYTRD or DSPTRD or DSBTRD has been used to reduce this matrix to 
*/
/*  tridiagonal form. */

/*  Arguments */
/*  ========= */

/*  COMPZ   (input) CHARACTER*1 */
/*          = 'N':  Compute eigenvalues only. */
/*          = 'V':  Compute eigenvalues and eigenvectors of the original 
*/
/*                  symmetric matrix.  On entry, Z must contain the */
/*                  orthogonal matrix used to reduce the original matrix 
*/
/*                  to tridiagonal form. */
/*          = 'I':  Compute eigenvalues and eigenvectors of the */
/*                  tridiagonal matrix.  Z is initialized to the identity 
*/
/*                  matrix. */

/*  N       (input) INTEGER */
/*          The order of the matrix.  N >= 0. */

/*  D       (input/output) DOUBLE PRECISION array, dimension (N) */
/*          On entry, the diagonal elements of the tridiagonal matrix. */
/*          On exit, if INFO = 0, the eigenvalues in ascending order. */

/*  E       (input/output) DOUBLE PRECISION array, dimension (N-1) */
/*          On entry, the (n-1) subdiagonal elements of the tridiagonal */
/*          matrix. */
/*          On exit, E has been destroyed. */

/*  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N) */
/*          On entry, if  COMPZ = 'V', then Z contains the orthogonal */
/*          matrix used in the reduction to tridiagonal form. */
/*          On exit, if  COMPZ = 'V', Z contains the orthonormal */
/*          eigenvectors of the original symmetric matrix, and if */
/*          COMPZ = 'I', Z contains the orthonormal eigenvectors of */
/*          the symmetric tridiagonal matrix.  If an error exit is */
/*          made, Z contains the eigenvectors associated with the */
/*          stored eigenvalues. */
/*          If COMPZ = 'N', then Z is not referenced. */

/*  LDZ     (input) INTEGER */
/*          The leading dimension of the array Z.  LDZ >= 1, and if */
/*          eigenvectors are desired, then  LDZ >= max(1,N). */

/*  WORK    (workspace) DOUBLE PRECISION array, dimension (max(1,2*N-2)) 
*/
/*          If COMPZ = 'N', then WORK is not referenced. */

/*  INFO    (output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -i, the i-th argument had an illegal value */
/*          > 0:  the algorithm has failed to find all the eigenvalues in 
*/
/*                a total of 30*N iterations; if INFO = i, then i */
/*                elements of E have not converged to zero; on exit, D */
/*                and E contain the elements of a symmetric tridiagonal */
/*                matrix which is orthogonally similar to the original */
/*                matrix. */

/*  ===================================================================== 
*/

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    --work;
    z_dim1 = *ldz;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    --e;
    --d;

    /* Function Body */
    *info = 0;

    if (lsame_(compz, "N", 1L, 1L)) {
	icompz = 0;
    } else if (lsame_(compz, "V", 1L, 1L)) {
	icompz = 1;
    } else if (lsame_(compz, "I", 1L, 1L)) {
	icompz = 2;
    } else {
	icompz = -1;
    }
    if (icompz < 0) {
	*info = -1;
    } else if (*n < 0) {
	*info = -2;
    } else if (*ldz < 1 || icompz > 0 && *ldz < max(1,*n)) {
	*info = -6;
    }
    if (*info != 0) {
	i__1 = -(*info);
	xerbla_("DSTEQR", &i__1, 6L);
	return 0;
    }

/*     Quick return if possible */

    if (*n == 0) {
	return 0;
    }

    if (*n == 1) {
	if (icompz > 0) {
	    z[z_dim1 + 1] = 1.;
	}
	return 0;
    }

/*     Determine the unit roundoff for this environment. */

    eps = dlamch_("E", 1L);

/*     Compute the eigenvalues and eigenvectors of the tridiagonal */
/*     matrix. */

    if (icompz == 2) {
	dlazro_(n, n, &c_b7, &c_b8, &z[z_offset], ldz);
    }

    nmaxit = *n * 30;
    jtot = 0;

/*     Determine where the matrix splits and choose QL or QR iteration */
/*     for each block, according to whether top or bottom diagonal */
/*     element is smaller. */

    l1 = 1;
    nm1 = *n - 1;

L10:
    if (l1 > *n) {
	goto L160;
    }
    if (l1 > 1) {
	e[l1 - 1] = 0.;
    }
    if (l1 <= nm1) {
	i__1 = nm1;
	for (m = l1; m <= i__1; ++m) {
	    tst = (d__1 = e[m], abs(d__1));
	    if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m + 1], 
		    abs(d__2)))) {
		goto L30;
	    }
/* L20: */
	}
    }
    m = *n;

L30:
    l = l1;
    lend = m;
    if ((d__1 = d[lend], abs(d__1)) < (d__2 = d[l], abs(d__2))) {
	l = lend;
	lend = l1;
    }
    l1 = m + 1;

    if (lend >= l) {

/*        QL Iteration */

/*        Look for small subdiagonal element. */

L40:
	if (l != lend) {
	    lendm1 = lend - 1;
	    i__1 = lendm1;
	    for (m = l; m <= i__1; ++m) {
		tst = (d__1 = e[m], abs(d__1));
		if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m + 1],
			 abs(d__2)))) {
		    goto L60;
		}
/* L50: */
	    }
	}

	m = lend;

L60:
	if (m < lend) {
	    e[m] = 0.;
	}
	p = d[l];
	if (m == l) {
	    goto L80;
	}

/*        If remaining matrix is 2-by-2, use DLAE2 or DLAEV2 */
/*        to compute its eigensystem. */

	if (m == l + 1) {
	    if (icompz > 0) {
		dlaev2_(&d[l], &e[l], &d[l + 1], &rt1, &rt2, &c, &s);
		work[l] = c;
		work[*n - 1 + l] = s;
		dlasr_("R", "V", "B", n, &c__2, &work[l], &work[*n - 1 + l], &
			z[l * z_dim1 + 1], ldz, 1L, 1L, 1L);
	    } else {
		dlae2_(&d[l], &e[l], &d[l + 1], &rt1, &rt2);
	    }
	    d[l] = rt1;
	    d[l + 1] = rt2;
	    e[l] = 0.;
	    l += 2;
	    if (l <= lend) {
		goto L40;
	    }
	    goto L10;
	}

	if (jtot == nmaxit) {
	    goto L140;
	}
	++jtot;

/*        Form shift. */

	g = (d[l + 1] - p) / (e[l] * 2.);
	r = dlapy2_(&g, &c_b8);
	g = d[m] - p + e[l] / (g + d_sign(&r, &g));

	s = 1.;
	c = 1.;
	p = 0.;

/*        Inner loop */

	mm1 = m - 1;
	i__1 = l;
	for (i = mm1; i >= i__1; --i) {
	    f = s * e[i];
	    b = c * e[i];
	    dlartg_(&g, &f, &c, &s, &r);
	    if (i != m - 1) {
		e[i + 1] = r;
	    }
	    g = d[i + 1] - p;
	    r = (d[i] - g) * s + c * 2. * b;
	    p = s * r;
	    d[i + 1] = g + p;
	    g = c * r - b;

/*           If eigenvectors are desired, then save rotations. */

	    if (icompz > 0) {
		work[i] = c;
		work[*n - 1 + i] = -s;
	    }

/* L70: */
	}

/*        If eigenvectors are desired, then apply saved rotations. */

	if (icompz > 0) {
	    mm = m - l + 1;
	    dlasr_("R", "V", "B", n, &mm, &work[l], &work[*n - 1 + l], &z[l * 
		    z_dim1 + 1], ldz, 1L, 1L, 1L);
	}

	d[l] -= p;
	e[l] = g;
	goto L40;

/*        Eigenvalue found. */

L80:
	d[l] = p;

	++l;
	if (l <= lend) {
	    goto L40;
	}
	goto L10;

    } else {

/*        QR Iteration */

/*        Look for small superdiagonal element. */

L90:
	if (l != lend) {
	    lendp1 = lend + 1;
	    i__1 = lendp1;
	    for (m = l; m >= i__1; --m) {
		tst = (d__1 = e[m - 1], abs(d__1));
		if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m - 1],
			 abs(d__2)))) {
		    goto L110;
		}
/* L100: */
	    }
	}

	m = lend;

L110:
	if (m > lend) {
	    e[m - 1] = 0.;
	}
	p = d[l];
	if (m == l) {
	    goto L130;
	}

/*        If remaining matrix is 2-by-2, use DLAE2 or DLAEV2 */
/*        to compute its eigensystem. */

	if (m == l - 1) {
	    if (icompz > 0) {
		dlaev2_(&d[l - 1], &e[l - 1], &d[l], &rt1, &rt2, &c, &s);
		work[m] = c;
		work[*n - 1 + m] = s;
		dlasr_("R", "V", "F", n, &c__2, &work[m], &work[*n - 1 + m], &
			z[(l - 1) * z_dim1 + 1], ldz, 1L, 1L, 1L);
	    } else {
		dlae2_(&d[l - 1], &e[l - 1], &d[l], &rt1, &rt2);
	    }
	    d[l - 1] = rt1;
	    d[l] = rt2;
	    e[l - 1] = 0.;
	    l += -2;
	    if (l >= lend) {
		goto L90;
	    }
	    goto L10;
	}

	if (jtot == nmaxit) {
	    goto L140;
	}
	++jtot;

/*        Form shift. */

	g = (d[l - 1] - p) / (e[l - 1] * 2.);
	r = dlapy2_(&g, &c_b8);
	g = d[m] - p + e[l - 1] / (g + d_sign(&r, &g));

	s = 1.;
	c = 1.;
	p = 0.;

/*        Inner loop */

	lm1 = l - 1;
	i__1 = lm1;
	for (i = m; i <= i__1; ++i) {
	    f = s * e[i];
	    b = c * e[i];
	    dlartg_(&g, &f, &c, &s, &r);
	    if (i != m) {
		e[i - 1] = r;
	    }
	    g = d[i] - p;
	    r = (d[i + 1] - g) * s + c * 2. * b;
	    p = s * r;
	    d[i] = g + p;
	    g = c * r - b;

/*           If eigenvectors are desired, then save rotations. */

	    if (icompz > 0) {
		work[i] = c;
		work[*n - 1 + i] = s;
	    }

/* L120: */
	}

/*        If eigenvectors are desired, then apply saved rotations. */

	if (icompz > 0) {
	    mm = l - m + 1;
	    dlasr_("R", "V", "F", n, &mm, &work[m], &work[*n - 1 + m], &z[m * 
		    z_dim1 + 1], ldz, 1L, 1L, 1L);
	}

	d[l] -= p;
	e[lm1] = g;
	goto L90;

/*        Eigenvalue found. */

L130:
	d[l] = p;

	--l;
	if (l >= lend) {
	    goto L90;
	}
	goto L10;

    }

/*     Set error -- no convergence to an eigenvalue after a total */
/*     of N*MAXIT iterations. */

L140:
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
	if (e[i] != 0.) {
	    ++(*info);
	}
/* L150: */
    }
    return 0;

/*     Order eigenvalues and eigenvectors. */

L160:
    i__1 = *n;
    for (ii = 2; ii <= i__1; ++ii) {
	i = ii - 1;
	k = i;
	p = d[i];
	i__2 = *n;
	for (j = ii; j <= i__2; ++j) {
	    if (d[j] < p) {
		k = j;
		p = d[j];
	    }
/* L170: */
	}
	if (k != i) {
	    d[k] = d[i];
	    d[i] = p;
	    if (icompz > 0) {
		dswap_(n, &z[i * z_dim1 + 1], &c__1, &z[k * z_dim1 + 1], &
			c__1);
	    }
	}
/* L180: */
    }

    return 0;

/*     End of DSTEQR */

} /* dsteqr_ */

