/* sgamma.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

real sgamma_(a)
real *a;
{
    /* Initialized data */

    static real q1 = (float).04166669;
    static real a3 = (float).2000062;
    static real a4 = (float)-.1662921;
    static real a5 = (float).1423657;
    static real a6 = (float)-.1367177;
    static real a7 = (float).1233795;
    static real e1 = (float)1.;
    static real e2 = (float).4999897;
    static real e3 = (float).166829;
    static real e4 = (float).0407753;
    static real e5 = (float).010293;
    static real q2 = (float).02083148;
    static real aa = (float)0.;
    static real aaa = (float)0.;
    static real sqrt32 = (float)5.656854;
    static real q3 = (float).00801191;
    static real q4 = (float).00144121;
    static real q5 = (float)-7.388e-5;
    static real q6 = (float)2.4511e-4;
    static real q7 = (float)2.424e-4;
    static real a1 = (float).3333333;
    static real a2 = (float)-.250003;

    /* System generated locals */
    real ret_val, r__1;

    /* Builtin functions */
    double sqrt(), log(), r_sign(), exp();

    /* Local variables */
    extern real ranf_();
    static real b, c, d, e, p, q, r, s, t, u, v, w, x;
    extern real snorm_(), sexpo_();
    static real q0, s2, si;

/* **********************************************************************C
 */
/*                                                                      C 
*/
/*                                                                      C 
*/
/*     (STANDARD-)  G A M M A  DISTRIBUTION                             C 
*/
/*                                                                      C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*               PARAMETER  A >= 1.0  !                                 C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*     FOR DETAILS SEE:                                                 C 
*/
/*                                                                      C 
*/
/*               AHRENS, J.H. AND DIETER, U.                            C 
*/
/*               GENERATING GAMMA VARIATES BY A                         C 
*/
/*               MODIFIED REJECTION TECHNIQUE.                          C 
*/
/*               COMM. ACM, 25,1 (JAN. 1982), 47 - 54.                  C 
*/
/*                                                                      C 
*/
/*     STEP NUMBERS CORRESPOND TO ALGORITHM 'GD' IN THE ABOVE PAPER     C 
*/
/*                                 (STRAIGHTFORWARD IMPLEMENTATION)     C 
*/
/*                                                                      C 
*/
/*     Modified by Barry W. Brown, Feb 3, 1988 to use RANF instead of   C 
*/
/*     SUNIF.  The argument IR thus goes away.                          C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*               PARAMETER  0.0 < A < 1.0  !                            C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*     FOR DETAILS SEE:                                                 C 
*/
/*                                                                      C 
*/
/*               AHRENS, J.H. AND DIETER, U.                            C 
*/
/*               COMPUTER METHODS FOR SAMPLING FROM GAMMA,              C 
*/
/*               BETA, POISSON AND BINOMIAL DISTRIBUTIONS.              C 
*/
/*               COMPUTING, 12 (1974), 223 - 246.                       C 
*/
/*                                                                      C 
*/
/*     (ADAPTED IMPLEMENTATION OF ALGORITHM 'GS' IN THE ABOVE PAPER)    C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */


/*     INPUT: A =PARAMETER (MEAN) OF THE STANDARD GAMMA DISTRIBUTION */
/*     OUTPUT: SGAMMA = SAMPLE FROM THE GAMMA-(A)-DISTRIBUTION */

/*     COEFFICIENTS Q(K) - FOR Q0 = SUM(Q(K)*A**(-K)) */
/*     COEFFICIENTS A(K) - FOR Q = Q0+(T*T/2)*SUM(A(K)*V**K) */
/*     COEFFICIENTS E(K) - FOR EXP(Q)-1 = SUM(E(K)*Q**K) */


/*     PREVIOUS A PRE-SET TO ZERO - AA IS A', AAA IS A" */
/*     SQRT32 IS THE SQUAREROOT OF 32 = 5.656854249492380 */


    if (*a == aa) {
	goto L10;
    }
    if (*a < (float)1.) {
	goto L120;
    }

/*     STEP  1:  RECALCULATIONS OF S2,S,D IF A HAS CHANGED */

    aa = *a;
    s2 = *a - (float).5;
    s = sqrt(s2);
    d = sqrt32 - s * (float)12.;

/*     STEP  2:  T=STANDARD NORMAL DEVIATE, */
/*               X=(S,1/2)-NORMAL DEVIATE. */
/*               IMMEDIATE ACCEPTANCE (I) */

L10:
    t = snorm_();
    x = s + t * (float).5;
    ret_val = x * x;
    if (t >= (float)0.) {
	return ret_val;
    }

/*     STEP  3:  U= 0,1 -UNIFORM SAMPLE. SQUEEZE ACCEPTANCE (S) */

    u = ranf_();
    if (d * u <= t * t * t) {
	return ret_val;
    }

/*     STEP  4:  RECALCULATIONS OF Q0,B,SI,C IF NECESSARY */

    if (*a == aaa) {
	goto L40;
    }
    aaa = *a;
    r = (float)1. / *a;
    q0 = ((((((q7 * r + q6) * r + q5) * r + q4) * r + q3) * r + q2) * r + q1) 
	    * r;

/*               APPROXIMATION DEPENDING ON SIZE OF PARAMETER A */
/*               THE CONSTANTS IN THE EXPRESSIONS FOR B, SI AND */
/*               C WERE ESTABLISHED BY NUMERICAL EXPERIMENTS */

    if (*a <= (float)3.686) {
	goto L30;
    }
    if (*a <= (float)13.022) {
	goto L20;
    }

/*               CASE 3:  A .GT. 13.022 */

    b = (float)1.77;
    si = (float).75;
    c = (float).1515 / s;
    goto L40;

/*               CASE 2:  3.686 .LT. A .LE. 13.022 */

L20:
    b = s2 * (float).0076 + (float)1.654;
    si = (float)1.68 / s + (float).275;
    c = (float).062 / s + (float).024;
    goto L40;

/*               CASE 1:  A .LE. 3.686 */

L30:
    b = s + (float).463 - s2 * (float).178;
    si = (float)1.235;
    c = (float).195 / s - (float).079 + s * (float).016;

/*     STEP  5:  NO QUOTIENT TEST IF X NOT POSITIVE */

L40:
    if (x <= (float)0.) {
	goto L70;
    }

/*     STEP  6:  CALCULATION OF V AND QUOTIENT Q */

    v = t / (s + s);
    if (abs(v) <= (float).25) {
	goto L50;
    }
    q = q0 - s * t + t * (float).25 * t + (s2 + s2) * log(v + (float)1.);
    goto L60;
L50:
    q = q0 + t * (float).5 * t * ((((((a7 * v + a6) * v + a5) * v + a4) * v + 
	    a3) * v + a2) * v + a1) * v;

/*     STEP  7:  QUOTIENT ACCEPTANCE (Q) */

L60:
    if (log((float)1. - u) <= q) {
	return ret_val;
    }

/*     STEP  8:  E=STANDARD EXPONENTIAL DEVIATE */
/*               U= 0,1 -UNIFORM DEVIATE */
/*               T=(B,SI)-DOUBLE EXPONENTIAL (LAPLACE) SAMPLE */

L70:
    e = sexpo_();
    u = ranf_();
    u = u + u - (float)1.;
    r__1 = si * e;
    t = b + r_sign(&r__1, &u);

/*     STEP  9:  REJECTION IF T .LT. TAU(1) = -.71874483771719 */

    if (t < (float)-.7187449) {
	goto L70;
    }

/*     STEP 10:  CALCULATION OF V AND QUOTIENT Q */

    v = t / (s + s);
    if (abs(v) <= (float).25) {
	goto L80;
    }
    q = q0 - s * t + t * (float).25 * t + (s2 + s2) * log(v + (float)1.);
    goto L90;
L80:
    q = q0 + t * (float).5 * t * ((((((a7 * v + a6) * v + a5) * v + a4) * v + 
	    a3) * v + a2) * v + a1) * v;

/*     STEP 11:  HAT ACCEPTANCE (H) (IF Q NOT POSITIVE GO TO STEP 8) */

L90:
    if (q <= (float)0.) {
	goto L70;
    }
    if (q <= (float).5) {
	goto L100;
    }
    w = exp(q) - (float)1.;
    goto L110;
L100:
    w = ((((e5 * q + e4) * q + e3) * q + e2) * q + e1) * q;

/*               IF T IS REJECTED, SAMPLE AGAIN AT STEP 8 */

L110:
    if (c * abs(u) > w * exp(e - t * (float).5 * t)) {
	goto L70;
    }
    x = s + t * (float).5;
    ret_val = x * x;
    return ret_val;

/*     ALTERNATE METHOD FOR PARAMETERS A BELOW 1  (.3678794=EXP(-1.)) */

L120:
    aa = (float)0.;
    b = *a * (float).3678794 + (float)1.;
L130:
    p = b * ranf_();
    if (p >= (float)1.) {
	goto L140;
    }
    ret_val = exp(log(p) / *a);
    if (sexpo_() < ret_val) {
	goto L130;
    }
    return ret_val;
L140:
    ret_val = -log((b - p) / *a);
    if (sexpo_() < ((float)1. - *a) * log(ret_val)) {
	goto L130;
    }
    return ret_val;
} /* sgamma_ */

