#ifndef __LINUX_VMALLOC_H
#define __LINUX_VMALLOC_H

#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/pgtable.h>

struct vm_struct {
	unsigned long flags;
	void * addr;
	unsigned long size;
	struct vm_struct * next;
};

#ifndef CONFIG_MEMLEAK
struct vm_struct * get_vm_area(unsigned long size);
#endif
void vfree(void * addr);
#ifndef CONFIG_MEMLEAK
void * vmalloc(unsigned long size);
#endif
long vread(char *buf, char *addr, unsigned long count);
void vmfree_area_pages(unsigned long address, unsigned long size);
#ifndef CONFIG_MEMLEAK
int vmalloc_area_pages(unsigned long address, unsigned long size);
#else /* CONFIG_MEMLEAK */
extern void * vmalloc_wrap(unsigned long size, struct alloc_struct *id);
extern struct vm_struct * get_vm_area_wrap(unsigned long size, struct alloc_struct *id);
extern int vmalloc_area_pages_wrap(unsigned long address, unsigned long size, struct alloc_struct *id);

#define vmalloc(size) MEMLEAK_WRAP(vmalloc,size)
#define get_vm_area(size) MEMLEAK_WRAP(get_vm_area,size)
#define vmalloc_area_pages(address, size) MEMLEAK_WRAP(vmalloc_area_pages,address,size)
#endif /* CONFIG_MEMLEAK */

extern inline void * vmalloc_32(unsigned long size)
{
	return vmalloc(size);
}
#endif

