---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# X-Backend-Server header exposes server information

## Description

The target website returns the `X-Backend-Server` header which includes potentially internal/hidden IP addresses
or hostnames. By exposing these values, attackers may attempt to circumvent security proxies and access these
hosts directly.

## Remediation

Consult your proxy/load balancer documentation or provider on how to disable revealing the
`X-Backend-Server` header value.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.4 | true | 16 | Passive | Info |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
