# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import ContentFieldType, DocumentFigureKind, KnowledgeSourceKind, MediaContentKind

if TYPE_CHECKING:
    from .. import models as _models


class AnalyzeInput(_Model):
    """Additional input to analyze.

    :ivar url: The URL of the input to analyze.  Only one of url or data should be specified.
    :vartype url: str
    :ivar data: Raw image bytes. Provide bytes-like object; do not base64-encode. Only one of url
     or data should be specified.
    :vartype data: bytes
    :ivar name: Name of the input.
    :vartype name: str
    :ivar mime_type: The MIME type of the input content.  Ex. application/pdf, image/jpeg, etc.
    :vartype mime_type: str
    :ivar input_range: Range of the input to analyze (ex. ``1-3,5,9-``).  Document content uses
     1-based page numbers, while audio visual content uses integer milliseconds.
    :vartype input_range: str
    """

    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the input to analyze.  Only one of url or data should be specified."""
    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64")
    """Raw image bytes. Provide bytes-like object; do not base64-encode. Only one of url or data
     should be specified."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the input."""
    mime_type: Optional[str] = rest_field(name="mimeType", visibility=["read", "create", "update", "delete", "query"])
    """The MIME type of the input content.  Ex. application/pdf, image/jpeg, etc."""
    input_range: Optional[str] = rest_field(name="range", visibility=["read", "create", "update", "delete", "query"])
    """Range of the input to analyze (ex. ``1-3,5,9-``).  Document content uses 1-based page numbers,
     while audio visual content uses integer milliseconds."""

    @overload
    def __init__(
        self,
        *,
        url: Optional[str] = None,
        data: Optional[bytes] = None,
        name: Optional[str] = None,
        mime_type: Optional[str] = None,
        input_range: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeResult(_Model):
    """Analyze operation result.

    :ivar analyzer_id: The unique identifier of the analyzer.
    :vartype analyzer_id: str
    :ivar api_version: The version of the API used to analyze the document.
    :vartype api_version: str
    :ivar created_at: The date and time when the result was created.
    :vartype created_at: ~datetime.datetime
    :ivar warnings: Warnings encountered while analyzing the document.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar string_encoding:   The string encoding format for content spans in the response.
       Possible values are 'codePoint', 'utf16', and ``utf8``.  Default is ``codePoint``.").
    :vartype string_encoding: str
    :ivar contents: The extracted content. Required.
    :vartype contents: list[~azure.ai.contentunderstanding.models.MediaContent]
    """

    analyzer_id: Optional[str] = rest_field(
        name="analyzerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The unique identifier of the analyzer."""
    api_version: Optional[str] = rest_field(
        name="apiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the API used to analyze the document."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time when the result was created."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while analyzing the document."""
    string_encoding: Optional[str] = rest_field(
        name="stringEncoding", visibility=["read", "create", "update", "delete", "query"]
    )
    """  The string encoding format for content spans in the response.
       Possible values are 'codePoint', 'utf16', and ``utf8``.  Default is ``codePoint``.\")."""
    contents: list["_models.MediaContent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The extracted content. Required."""

    @overload
    def __init__(
        self,
        *,
        contents: list["_models.MediaContent"],
        analyzer_id: Optional[str] = None,
        api_version: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        string_encoding: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentField(_Model):
    """Field extracted from the content.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ArrayField, BooleanField, DateField, IntegerField, JsonField, NumberField, ObjectField,
    StringField, TimeField

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    spans: Optional[list["_models.ContentSpan"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Span(s) associated with the field value in the markdown content."""
    confidence: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence of predicting the field value."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the field value in the content."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ArrayField(ContentField, discriminator="array"):
    """Array field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. List of subfields of the
     same type.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.ARRAY
    :ivar value_array: Array field value.
    :vartype value_array: list[~azure.ai.contentunderstanding.models.ContentField]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.ARRAY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. List of subfields of the same type."""
    value_array: Optional[list["_models.ContentField"]] = rest_field(
        name="valueArray", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_array: Optional[list["_models.ContentField"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.ARRAY  # type: ignore


class MediaContent(_Model):
    """Media content base class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioVisualContent, DocumentContent

    :ivar kind: Content kind. Required. Known values are: "document" and "audioVisual".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.MediaContentKind
    :ivar mime_type: Detected MIME type of the content.  Ex. application/pdf, image/jpeg, etc.
     Required.
    :vartype mime_type: str
    :ivar analyzer_id: The analyzer that generated this content.
    :vartype analyzer_id: str
    :ivar category: Classified content category.
    :vartype category: str
    :ivar path: The path of the content in the input.
    :vartype path: str
    :ivar markdown: Markdown representation of the content.
    :vartype markdown: str
    :ivar fields: Extracted fields from the content.
    :vartype fields: dict[str, ~azure.ai.contentunderstanding.models.ContentField]
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Content kind. Required. Known values are: \"document\" and \"audioVisual\"."""
    mime_type: str = rest_field(name="mimeType", visibility=["read", "create", "update", "delete", "query"])
    """Detected MIME type of the content.  Ex. application/pdf, image/jpeg, etc. Required."""
    analyzer_id: Optional[str] = rest_field(
        name="analyzerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The analyzer that generated this content."""
    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Classified content category."""
    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The path of the content in the input."""
    markdown: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Markdown representation of the content."""
    fields: Optional[dict[str, "_models.ContentField"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Extracted fields from the content."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        mime_type: str,
        analyzer_id: Optional[str] = None,
        category: Optional[str] = None,
        path: Optional[str] = None,
        markdown: Optional[str] = None,
        fields: Optional[dict[str, "_models.ContentField"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AudioVisualContent(MediaContent, discriminator="audioVisual"):
    """Audio visual content.  Ex. audio/wav, video/mp4.

    :ivar mime_type: Detected MIME type of the content.  Ex. application/pdf, image/jpeg, etc.
     Required.
    :vartype mime_type: str
    :ivar analyzer_id: The analyzer that generated this content.
    :vartype analyzer_id: str
    :ivar category: Classified content category.
    :vartype category: str
    :ivar path: The path of the content in the input.
    :vartype path: str
    :ivar markdown: Markdown representation of the content.
    :vartype markdown: str
    :ivar fields: Extracted fields from the content.
    :vartype fields: dict[str, ~azure.ai.contentunderstanding.models.ContentField]
    :ivar kind: Content kind. Required. Audio visual content, such as mp3, mp4, etc.
    :vartype kind: str or ~azure.ai.contentunderstanding.models.AUDIO_VISUAL
    :ivar start_time_ms: Start time of the content in milliseconds. Required.
    :vartype start_time_ms: int
    :ivar end_time_ms: End time of the content in milliseconds. Required.
    :vartype end_time_ms: int
    :ivar width: Width of each video frame in pixels, if applicable.
    :vartype width: int
    :ivar height: Height of each video frame in pixels, if applicable.
    :vartype height: int
    :ivar camera_shot_times_ms: List of camera shot changes in the video, represented by its
     timestamp in milliseconds.  Only if returnDetails is true.
    :vartype camera_shot_times_ms: list[int]
    :ivar key_frame_times_ms: List of key frames in the video, represented by its timestamp in
     milliseconds.  Only if returnDetails is true.
    :vartype key_frame_times_ms: list[int]
    :ivar transcript_phrases: List of transcript phrases.  Only if returnDetails is true.
    :vartype transcript_phrases: list[~azure.ai.contentunderstanding.models.TranscriptPhrase]
    :ivar segments: List of detected content segments.  Only if enableSegment is true.
    :vartype segments: list[~azure.ai.contentunderstanding.models.AudioVisualContentSegment]
    """

    kind: Literal[MediaContentKind.AUDIO_VISUAL] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Content kind. Required. Audio visual content, such as mp3, mp4, etc."""
    start_time_ms: int = rest_field(name="startTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """Start time of the content in milliseconds. Required."""
    end_time_ms: int = rest_field(name="endTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """End time of the content in milliseconds. Required."""
    width: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Width of each video frame in pixels, if applicable."""
    height: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height of each video frame in pixels, if applicable."""
    camera_shot_times_ms: Optional[list[int]] = rest_field(
        name="cameraShotTimesMs", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of camera shot changes in the video, represented by its timestamp in milliseconds.  Only
     if returnDetails is true."""
    key_frame_times_ms: Optional[list[int]] = rest_field(
        name="keyFrameTimesMs", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of key frames in the video, represented by its timestamp in milliseconds.  Only if
     returnDetails is true."""
    transcript_phrases: Optional[list["_models.TranscriptPhrase"]] = rest_field(
        name="transcriptPhrases", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of transcript phrases.  Only if returnDetails is true."""
    segments: Optional[list["_models.AudioVisualContentSegment"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of detected content segments.  Only if enableSegment is true."""

    @overload
    def __init__(
        self,
        *,
        mime_type: str,
        start_time_ms: int,
        end_time_ms: int,
        analyzer_id: Optional[str] = None,
        category: Optional[str] = None,
        path: Optional[str] = None,
        markdown: Optional[str] = None,
        fields: Optional[dict[str, "_models.ContentField"]] = None,
        width: Optional[int] = None,
        height: Optional[int] = None,
        camera_shot_times_ms: Optional[list[int]] = None,
        key_frame_times_ms: Optional[list[int]] = None,
        transcript_phrases: Optional[list["_models.TranscriptPhrase"]] = None,
        segments: Optional[list["_models.AudioVisualContentSegment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MediaContentKind.AUDIO_VISUAL  # type: ignore


class AudioVisualContentSegment(_Model):
    """Detected audio/visual content segment.

    :ivar segment_id: Segment identifier. Required.
    :vartype segment_id: str
    :ivar category: Classified content category. Required.
    :vartype category: str
    :ivar span: Span of the segment in the markdown content. Required.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar start_time_ms: Start time of the segment in milliseconds. Required.
    :vartype start_time_ms: int
    :ivar end_time_ms: End time of the segment in milliseconds. Required.
    :vartype end_time_ms: int
    """

    segment_id: str = rest_field(name="segmentId", visibility=["read", "create", "update", "delete", "query"])
    """Segment identifier. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Classified content category. Required."""
    span: "_models.ContentSpan" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the segment in the markdown content. Required."""
    start_time_ms: int = rest_field(name="startTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """Start time of the segment in milliseconds. Required."""
    end_time_ms: int = rest_field(name="endTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """End time of the segment in milliseconds. Required."""

    @overload
    def __init__(
        self,
        *,
        segment_id: str,
        category: str,
        span: "_models.ContentSpan",
        start_time_ms: int,
        end_time_ms: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BooleanField(ContentField, discriminator="boolean"):
    """Boolean field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Boolean value.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.BOOLEAN
    :ivar value_boolean: Boolean field value.
    :vartype value_boolean: bool
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.BOOLEAN] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Boolean value."""
    value_boolean: Optional[bool] = rest_field(
        name="valueBoolean", visibility=["read", "create", "update", "delete", "query"]
    )
    """Boolean field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_boolean: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.BOOLEAN  # type: ignore


class ContentAnalyzer(_Model):
    """Analyzer that extracts content and fields from multimodal documents.

    :ivar analyzer_id: The unique identifier of the analyzer. Required.
    :vartype analyzer_id: str
    :ivar description: A description of the analyzer.
    :vartype description: str
    :ivar tags: Tags associated with the analyzer.
    :vartype tags: dict[str, str]
    :ivar status: The status of the analyzer. Required. Known values are: "creating", "ready",
     "deleting", and "failed".
    :vartype status: str or ~azure.ai.contentunderstanding.models.ContentAnalyzerStatus
    :ivar created_at: The date and time when the analyzer was created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: The date and time when the analyzer was last modified. Required.
    :vartype last_modified_at: ~datetime.datetime
    :ivar warnings: Warnings encountered while creating the analyzer.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar base_analyzer_id: The analyzer to incrementally train from.
    :vartype base_analyzer_id: str
    :ivar config: Analyzer configuration settings.
    :vartype config: ~azure.ai.contentunderstanding.models.ContentAnalyzerConfig
    :ivar field_schema: The schema of fields to extracted.
    :vartype field_schema: ~azure.ai.contentunderstanding.models.ContentFieldSchema
    :ivar dynamic_field_schema: Indicates whether the result may contain additional fields outside
     of the defined schema.
    :vartype dynamic_field_schema: bool
    :ivar processing_location: The location where the data may be processed.  Defaults to global.
     Known values are: "geography", "dataZone", and "global".
    :vartype processing_location: str or ~azure.ai.contentunderstanding.models.ProcessingLocation
    :ivar knowledge_sources: Additional knowledge sources used to enhance the analyzer.
    :vartype knowledge_sources: list[~azure.ai.contentunderstanding.models.KnowledgeSource]
    :ivar models: Mapping of model roles to specific model names.
     Ex. { "completion": "gpt-4.1", "embedding": "text-embedding-3-large" }.
    :vartype models: dict[str, str]
    :ivar supported_models: Chat completion and embedding models supported by the analyzer.
    :vartype supported_models: ~azure.ai.contentunderstanding.models.SupportedModels
    """

    analyzer_id: str = rest_field(name="analyzerId", visibility=["read"])
    """The unique identifier of the analyzer. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of the analyzer."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tags associated with the analyzer."""
    status: Union[str, "_models.ContentAnalyzerStatus"] = rest_field(visibility=["read"])
    """The status of the analyzer. Required. Known values are: \"creating\", \"ready\", \"deleting\",
     and \"failed\"."""
    created_at: datetime.datetime = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """The date and time when the analyzer was created. Required."""
    last_modified_at: datetime.datetime = rest_field(name="lastModifiedAt", visibility=["read"], format="rfc3339")
    """The date and time when the analyzer was last modified. Required."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read"])
    """Warnings encountered while creating the analyzer."""
    base_analyzer_id: Optional[str] = rest_field(name="baseAnalyzerId", visibility=["read", "create"])
    """The analyzer to incrementally train from."""
    config: Optional["_models.ContentAnalyzerConfig"] = rest_field(visibility=["read", "create"])
    """Analyzer configuration settings."""
    field_schema: Optional["_models.ContentFieldSchema"] = rest_field(name="fieldSchema", visibility=["read", "create"])
    """The schema of fields to extracted."""
    dynamic_field_schema: Optional[bool] = rest_field(name="dynamicFieldSchema", visibility=["read", "create"])
    """Indicates whether the result may contain additional fields outside of the defined schema."""
    processing_location: Optional[Union[str, "_models.ProcessingLocation"]] = rest_field(
        name="processingLocation", visibility=["read", "create"]
    )
    """The location where the data may be processed.  Defaults to global. Known values are:
     \"geography\", \"dataZone\", and \"global\"."""
    knowledge_sources: Optional[list["_models.KnowledgeSource"]] = rest_field(
        name="knowledgeSources", visibility=["read", "create"]
    )
    """Additional knowledge sources used to enhance the analyzer."""
    models: Optional[dict[str, str]] = rest_field(visibility=["read", "create"])
    """Mapping of model roles to specific model names.
     Ex. { \"completion\": \"gpt-4.1\", \"embedding\": \"text-embedding-3-large\" }."""
    supported_models: Optional["_models.SupportedModels"] = rest_field(name="supportedModels", visibility=["read"])
    """Chat completion and embedding models supported by the analyzer."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        base_analyzer_id: Optional[str] = None,
        config: Optional["_models.ContentAnalyzerConfig"] = None,
        field_schema: Optional["_models.ContentFieldSchema"] = None,
        dynamic_field_schema: Optional[bool] = None,
        processing_location: Optional[Union[str, "_models.ProcessingLocation"]] = None,
        knowledge_sources: Optional[list["_models.KnowledgeSource"]] = None,
        models: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentAnalyzerAnalyzeOperationStatus(_Model):
    """Provides status details for analyze operations.

    :ivar id: The unique ID of the operation. Required.
    :vartype id: str
    :ivar status: The status of the operation. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.ai.contentunderstanding.models.OperationState
    :ivar error: Error object that describes the error when status is "Failed".
    :vartype error: ~azure.core.ODataV4Format
    :ivar result: The result of the operation.
    :vartype result: ~azure.ai.contentunderstanding.models.AnalyzeResult
    :ivar usage: Usage details of the analyze operation.
    :vartype usage: ~azure.ai.contentunderstanding.models.UsageDetails
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the operation. Required."""
    status: Union[str, "_models.OperationState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    error: Optional[ODataV4Format] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error object that describes the error when status is \"Failed\"."""
    result: Optional["_models.AnalyzeResult"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The result of the operation."""
    usage: Optional["_models.UsageDetails"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage details of the analyze operation."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Union[str, "_models.OperationState"],
        error: Optional[ODataV4Format] = None,
        result: Optional["_models.AnalyzeResult"] = None,
        usage: Optional["_models.UsageDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentAnalyzerConfig(_Model):
    """Configuration settings for an analyzer.

    :ivar return_details: Return all content details.
    :vartype return_details: bool
    :ivar locales: List of locale hints for speech transcription.
    :vartype locales: list[str]
    :ivar enable_ocr: Enable optical character recognition (OCR).
    :vartype enable_ocr: bool
    :ivar enable_layout: Enable layout analysis.
    :vartype enable_layout: bool
    :ivar enable_figure_description: Enable generation of figure description.
    :vartype enable_figure_description: bool
    :ivar enable_figure_analysis: Enable analysis of figures, such as charts and diagrams.
    :vartype enable_figure_analysis: bool
    :ivar enable_formula: Enable mathematical formula detection.
    :vartype enable_formula: bool
    :ivar table_format: Representation format of tables in analyze result markdown. Known values
     are: "html" and "markdown".
    :vartype table_format: str or ~azure.ai.contentunderstanding.models.TableFormat
    :ivar chart_format: Representation format of charts in analyze result markdown. Known values
     are: "chartJs" and "markdown".
    :vartype chart_format: str or ~azure.ai.contentunderstanding.models.ChartFormat
    :ivar annotation_format: Representation format of annotations in analyze result markdown. Known
     values are: "none" and "markdown".
    :vartype annotation_format: str or ~azure.ai.contentunderstanding.models.AnnotationFormat
    :ivar disable_face_blurring: Disable the default blurring of faces for privacy while processing
     the content.
    :vartype disable_face_blurring: bool
    :ivar estimate_field_source_and_confidence: Return field grounding source and confidence.
    :vartype estimate_field_source_and_confidence: bool
    :ivar content_categories: Map of categories to classify the input content(s) against.
    :vartype content_categories: dict[str,
     ~azure.ai.contentunderstanding.models.ContentCategoryDefinition]
    :ivar enable_segment: Enable segmentation of the input by contentCategories.
    :vartype enable_segment: bool
    :ivar segment_per_page: Force segmentation of document content by page.
    :vartype segment_per_page: bool
    :ivar omit_content: Omit the content for this analyzer from analyze result.
     Only return content(s) from additional analyzers specified in contentCategories, if any.
    :vartype omit_content: bool
    """

    return_details: Optional[bool] = rest_field(
        name="returnDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Return all content details."""
    locales: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of locale hints for speech transcription."""
    enable_ocr: Optional[bool] = rest_field(
        name="enableOcr", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable optical character recognition (OCR)."""
    enable_layout: Optional[bool] = rest_field(
        name="enableLayout", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable layout analysis."""
    enable_figure_description: Optional[bool] = rest_field(
        name="enableFigureDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable generation of figure description."""
    enable_figure_analysis: Optional[bool] = rest_field(
        name="enableFigureAnalysis", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable analysis of figures, such as charts and diagrams."""
    enable_formula: Optional[bool] = rest_field(
        name="enableFormula", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable mathematical formula detection."""
    table_format: Optional[Union[str, "_models.TableFormat"]] = rest_field(
        name="tableFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Representation format of tables in analyze result markdown. Known values are: \"html\" and
     \"markdown\"."""
    chart_format: Optional[Union[str, "_models.ChartFormat"]] = rest_field(
        name="chartFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Representation format of charts in analyze result markdown. Known values are: \"chartJs\" and
     \"markdown\"."""
    annotation_format: Optional[Union[str, "_models.AnnotationFormat"]] = rest_field(
        name="annotationFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Representation format of annotations in analyze result markdown. Known values are: \"none\" and
     \"markdown\"."""
    disable_face_blurring: Optional[bool] = rest_field(
        name="disableFaceBlurring", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disable the default blurring of faces for privacy while processing the content."""
    estimate_field_source_and_confidence: Optional[bool] = rest_field(
        name="estimateFieldSourceAndConfidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """Return field grounding source and confidence."""
    content_categories: Optional[dict[str, "_models.ContentCategoryDefinition"]] = rest_field(
        name="contentCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """Map of categories to classify the input content(s) against."""
    enable_segment: Optional[bool] = rest_field(
        name="enableSegment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable segmentation of the input by contentCategories."""
    segment_per_page: Optional[bool] = rest_field(
        name="segmentPerPage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Force segmentation of document content by page."""
    omit_content: Optional[bool] = rest_field(
        name="omitContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Omit the content for this analyzer from analyze result.
     Only return content(s) from additional analyzers specified in contentCategories, if any."""

    @overload
    def __init__(
        self,
        *,
        return_details: Optional[bool] = None,
        locales: Optional[list[str]] = None,
        enable_ocr: Optional[bool] = None,
        enable_layout: Optional[bool] = None,
        enable_figure_description: Optional[bool] = None,
        enable_figure_analysis: Optional[bool] = None,
        enable_formula: Optional[bool] = None,
        table_format: Optional[Union[str, "_models.TableFormat"]] = None,
        chart_format: Optional[Union[str, "_models.ChartFormat"]] = None,
        annotation_format: Optional[Union[str, "_models.AnnotationFormat"]] = None,
        disable_face_blurring: Optional[bool] = None,
        estimate_field_source_and_confidence: Optional[bool] = None,
        content_categories: Optional[dict[str, "_models.ContentCategoryDefinition"]] = None,
        enable_segment: Optional[bool] = None,
        segment_per_page: Optional[bool] = None,
        omit_content: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentAnalyzerOperationStatus(_Model):
    """Provides status details for analyzer creation operations.

    :ivar id: The unique ID of the operation. Required.
    :vartype id: str
    :ivar status: The status of the operation. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.ai.contentunderstanding.models.OperationState
    :ivar error: Error object that describes the error when status is "Failed".
    :vartype error: ~azure.core.ODataV4Format
    :ivar result: The result of the operation.
    :vartype result: ~azure.ai.contentunderstanding.models.ContentAnalyzer
    :ivar usage: Usage details of the analyzer creation operation.
    :vartype usage: ~azure.ai.contentunderstanding.models.UsageDetails
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the operation. Required."""
    status: Union[str, "_models.OperationState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    error: Optional[ODataV4Format] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error object that describes the error when status is \"Failed\"."""
    result: Optional["_models.ContentAnalyzer"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The result of the operation."""
    usage: Optional["_models.UsageDetails"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage details of the analyzer creation operation."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Union[str, "_models.OperationState"],
        error: Optional[ODataV4Format] = None,
        result: Optional["_models.ContentAnalyzer"] = None,
        usage: Optional["_models.UsageDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentCategoryDefinition(_Model):
    """Content category definition.

    :ivar description: The description of the category.
    :vartype description: str
    :ivar analyzer_id: Optional analyzer used to process the content.
    :vartype analyzer_id: str
    :ivar analyzer: Optional inline definition of analyzer used to process the content.
    :vartype analyzer: ~azure.ai.contentunderstanding.models.ContentAnalyzer
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the category."""
    analyzer_id: Optional[str] = rest_field(
        name="analyzerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional analyzer used to process the content."""
    analyzer: Optional["_models.ContentAnalyzer"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional inline definition of analyzer used to process the content."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        analyzer_id: Optional[str] = None,
        analyzer: Optional["_models.ContentAnalyzer"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentFieldDefinition(_Model):
    """Definition of the field using a JSON Schema like syntax.

    :ivar method: Generation method. Known values are: "generate", "extract", and "classify".
    :vartype method: str or ~azure.ai.contentunderstanding.models.GenerationMethod
    :ivar type: Semantic data type of the field value. Known values are: "string", "date", "time",
     "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar description: Field description.
    :vartype description: str
    :ivar item_definition: Field type schema of each array element, if type is array.
    :vartype item_definition: ~azure.ai.contentunderstanding.models.ContentFieldDefinition
    :ivar properties: Named sub-fields, if type is object.
    :vartype properties: dict[str, ~azure.ai.contentunderstanding.models.ContentFieldDefinition]
    :ivar examples: Examples of field values.
    :vartype examples: list[str]
    :ivar enum: Enumeration of possible field values.
    :vartype enum: list[str]
    :ivar enum_descriptions: Descriptions for each enumeration value.
    :vartype enum_descriptions: dict[str, str]
    :ivar ref: Reference to another field definition.
    :vartype ref: str
    :ivar estimate_source_and_confidence: Return grounding source and confidence.
    :vartype estimate_source_and_confidence: bool
    """

    method: Optional[Union[str, "_models.GenerationMethod"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Generation method. Known values are: \"generate\", \"extract\", and \"classify\"."""
    type: Optional[Union[str, "_models.ContentFieldType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Semantic data type of the field value. Known values are: \"string\", \"date\", \"time\",
     \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Field description."""
    item_definition: Optional["_models.ContentFieldDefinition"] = rest_field(
        name="items", visibility=["read", "create", "update", "delete", "query"]
    )
    """Field type schema of each array element, if type is array."""
    properties: Optional[dict[str, "_models.ContentFieldDefinition"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Named sub-fields, if type is object."""
    examples: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Examples of field values."""
    enum: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Enumeration of possible field values."""
    enum_descriptions: Optional[dict[str, str]] = rest_field(
        name="enumDescriptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptions for each enumeration value."""
    ref: Optional[str] = rest_field(name="$ref", visibility=["read", "create", "update", "delete", "query"])
    """Reference to another field definition."""
    estimate_source_and_confidence: Optional[bool] = rest_field(
        name="estimateSourceAndConfidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """Return grounding source and confidence."""

    @overload
    def __init__(
        self,
        *,
        method: Optional[Union[str, "_models.GenerationMethod"]] = None,
        type: Optional[Union[str, "_models.ContentFieldType"]] = None,
        description: Optional[str] = None,
        item_definition: Optional["_models.ContentFieldDefinition"] = None,
        properties: Optional[dict[str, "_models.ContentFieldDefinition"]] = None,
        examples: Optional[list[str]] = None,
        enum: Optional[list[str]] = None,
        enum_descriptions: Optional[dict[str, str]] = None,
        ref: Optional[str] = None,
        estimate_source_and_confidence: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentFieldSchema(_Model):
    """Schema of fields to be extracted from documents.

    :ivar name: The name of the field schema.
    :vartype name: str
    :ivar description: A description of the field schema.
    :vartype description: str
    :ivar fields: The fields defined in the schema. Required.
    :vartype fields: dict[str, ~azure.ai.contentunderstanding.models.ContentFieldDefinition]
    :ivar definitions: Additional definitions referenced by the fields in the schema.
    :vartype definitions: dict[str, ~azure.ai.contentunderstanding.models.ContentFieldDefinition]
    """

    name: Optional[str] = rest_field(visibility=["read", "create"])
    """The name of the field schema."""
    description: Optional[str] = rest_field(visibility=["read", "create"])
    """A description of the field schema."""
    fields: dict[str, "_models.ContentFieldDefinition"] = rest_field(visibility=["read", "create"])
    """The fields defined in the schema. Required."""
    definitions: Optional[dict[str, "_models.ContentFieldDefinition"]] = rest_field(visibility=["read", "create"])
    """Additional definitions referenced by the fields in the schema."""

    @overload
    def __init__(
        self,
        *,
        fields: dict[str, "_models.ContentFieldDefinition"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        definitions: Optional[dict[str, "_models.ContentFieldDefinition"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentSpan(_Model):
    """Position of the element in markdown, specified as a character offset and length.

    :ivar offset: Starting position (0-indexed) of the element in markdown, specified in
     characters. Required.
    :vartype offset: int
    :ivar length: Length of the element in markdown, specified in characters. Required.
    :vartype length: int
    """

    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Starting position (0-indexed) of the element in markdown, specified in characters. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length of the element in markdown, specified in characters. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContentUnderstandingDefaults(_Model):
    """default settings for this Content Understanding resource.

    :ivar model_deployments: Mapping of model names to deployments.
     Ex. { "gpt-4.1": "myGpt41Deployment", "text-embedding-3-large":
     "myTextEmbedding3LargeDeployment" }. Required.
    :vartype model_deployments: dict[str, str]
    """

    model_deployments: dict[str, str] = rest_field(name="modelDeployments", visibility=["read", "create", "update"])
    """Mapping of model names to deployments.
     Ex. { \"gpt-4.1\": \"myGpt41Deployment\", \"text-embedding-3-large\":
     \"myTextEmbedding3LargeDeployment\" }. Required."""

    @overload
    def __init__(
        self,
        *,
        model_deployments: dict[str, str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CopyAuthorization(_Model):
    """Copy authorization details for cross-resource copy.

    :ivar source: Full path of the source analyzer. Required.
    :vartype source: str
    :ivar target_azure_resource_id: Azure resource ID of the target location to copy to. Required.
    :vartype target_azure_resource_id: str
    :ivar expires_at: Date/time when the copy authorization expires. Required.
    :vartype expires_at: ~datetime.datetime
    """

    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Full path of the source analyzer. Required."""
    target_azure_resource_id: str = rest_field(
        name="targetAzureResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the target location to copy to. Required."""
    expires_at: datetime.datetime = rest_field(
        name="expiresAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date/time when the copy authorization expires. Required."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        target_azure_resource_id: str,
        expires_at: datetime.datetime,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DateField(ContentField, discriminator="date"):
    """Date field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Date, normalized to ISO 8601
     (YYYY-MM-DD) format.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.DATE
    :ivar value_date: Date field value, in ISO 8601 (YYYY-MM-DD) format.
    :vartype value_date: ~datetime.date
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.DATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Date, normalized to ISO 8601 (YYYY-MM-DD)
     format."""
    value_date: Optional[datetime.date] = rest_field(
        name="valueDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Date field value, in ISO 8601 (YYYY-MM-DD) format."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_date: Optional[datetime.date] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.DATE  # type: ignore


class DocumentAnnotation(_Model):
    """Annotation in a document, such as a strikethrough or a comment.

    :ivar id: Annotation identifier. Required.
    :vartype id: str
    :ivar kind: Annotation kind. Required. Known values are: "highlight", "strikethrough",
     "underline", "italic", "bold", "circle", and "note".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DocumentAnnotationKind
    :ivar spans: Spans of the content associated with the annotation.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar source: Position of the annotation.
    :vartype source: str
    :ivar comments: Comments associated with the annotation.
    :vartype comments: list[~azure.ai.contentunderstanding.models.DocumentAnnotationComment]
    :ivar author: Annotation author.
    :vartype author: str
    :ivar created_at: Date and time when the annotation was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Date and time when the annotation was last modified.
    :vartype last_modified_at: ~datetime.datetime
    :ivar tags: Tags associated with the annotation.
    :vartype tags: list[str]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Annotation identifier. Required."""
    kind: Union[str, "_models.DocumentAnnotationKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Annotation kind. Required. Known values are: \"highlight\", \"strikethrough\", \"underline\",
     \"italic\", \"bold\", \"circle\", and \"note\"."""
    spans: Optional[list["_models.ContentSpan"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Spans of the content associated with the annotation."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Position of the annotation."""
    comments: Optional[list["_models.DocumentAnnotationComment"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Comments associated with the annotation."""
    author: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Annotation author."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time when the annotation was created."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time when the annotation was last modified."""
    tags: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tags associated with the annotation."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        kind: Union[str, "_models.DocumentAnnotationKind"],
        spans: Optional[list["_models.ContentSpan"]] = None,
        source: Optional[str] = None,
        comments: Optional[list["_models.DocumentAnnotationComment"]] = None,
        author: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        tags: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentAnnotationComment(_Model):
    """Comment associated with a document annotation.

    :ivar message: Comment message in Markdown. Required.
    :vartype message: str
    :ivar author: Author of the comment.
    :vartype author: str
    :ivar created_at: Date and time when the comment was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Date and time when the comment was last modified.
    :vartype last_modified_at: ~datetime.datetime
    :ivar tags: Tags associated with the comment.
    :vartype tags: list[str]
    """

    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Comment message in Markdown. Required."""
    author: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Author of the comment."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time when the comment was created."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time when the comment was last modified."""
    tags: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tags associated with the comment."""

    @overload
    def __init__(
        self,
        *,
        message: str,
        author: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        tags: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentBarcode(_Model):
    """Barcode in a document.

    :ivar kind: Barcode kind. Required. Known values are: "QRCode", "PDF417", "UPCA", "UPCE",
     "Code39", "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar", "DataBarExpanded", "ITF",
     "MicroQRCode", "Aztec", "DataMatrix", and "MaxiCode".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DocumentBarcodeKind
    :ivar value: Barcode value. Required.
    :vartype value: str
    :ivar source: Encoded source that identifies the position of the barcode in the content.
    :vartype source: str
    :ivar span: Span of the barcode in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar confidence: Confidence of predicting the barcode.
    :vartype confidence: float
    """

    kind: Union[str, "_models.DocumentBarcodeKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Barcode kind. Required. Known values are: \"QRCode\", \"PDF417\", \"UPCA\", \"UPCE\",
     \"Code39\", \"Code128\", \"EAN8\", \"EAN13\", \"DataBar\", \"Code93\", \"Codabar\",
     \"DataBarExpanded\", \"ITF\", \"MicroQRCode\", \"Aztec\", \"DataMatrix\", and \"MaxiCode\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Barcode value. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the barcode in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the barcode in the markdown content."""
    confidence: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence of predicting the barcode."""

    @overload
    def __init__(
        self,
        *,
        kind: Union[str, "_models.DocumentBarcodeKind"],
        value: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        confidence: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentCaption(_Model):
    """Caption of a table or figure.

    :ivar content: Content of the caption. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the caption in the content.
    :vartype source: str
    :ivar span: Span of the caption in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the caption.
    :vartype elements: list[str]
    """

    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Content of the caption. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the caption in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the caption in the markdown content."""
    elements: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Child elements of the caption."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentFigure(_Model):
    """Figure in a document.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DocumentChartFigure, DocumentMermaidFigure

    :ivar kind: Figure kind. Required. Known values are: "unknown", "chart", and "mermaid".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DocumentFigureKind
    :ivar id: Figure identifier. Required.
    :vartype id: str
    :ivar source: Encoded source that identifies the position of the figure in the content.
    :vartype source: str
    :ivar span: Span of the figure in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the figure, excluding any caption or footnotes.
    :vartype elements: list[str]
    :ivar caption: Figure caption.
    :vartype caption: ~azure.ai.contentunderstanding.models.DocumentCaption
    :ivar footnotes: List of figure footnotes.
    :vartype footnotes: list[~azure.ai.contentunderstanding.models.DocumentFootnote]
    :ivar description: Description of the figure.
    :vartype description: str
    :ivar role: Semantic role of the figure. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", and "formulaBlock".
    :vartype role: str or ~azure.ai.contentunderstanding.models.SemanticRole
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Figure kind. Required. Known values are: \"unknown\", \"chart\", and \"mermaid\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Figure identifier. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the figure in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the figure in the markdown content."""
    elements: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Child elements of the figure, excluding any caption or footnotes."""
    caption: Optional["_models.DocumentCaption"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Figure caption."""
    footnotes: Optional[list["_models.DocumentFootnote"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of figure footnotes."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the figure."""
    role: Optional[Union[str, "_models.SemanticRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Semantic role of the figure. Known values are: \"pageHeader\", \"pageFooter\", \"pageNumber\",
     \"title\", \"sectionHeading\", \"footnote\", and \"formulaBlock\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        id: str,  # pylint: disable=redefined-builtin
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
        caption: Optional["_models.DocumentCaption"] = None,
        footnotes: Optional[list["_models.DocumentFootnote"]] = None,
        description: Optional[str] = None,
        role: Optional[Union[str, "_models.SemanticRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentChartFigure(DocumentFigure, discriminator="chart"):
    """Figure containing a chart, such as a bar chart, line chart, or pie chart.

    :ivar id: Figure identifier. Required.
    :vartype id: str
    :ivar source: Encoded source that identifies the position of the figure in the content.
    :vartype source: str
    :ivar span: Span of the figure in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the figure, excluding any caption or footnotes.
    :vartype elements: list[str]
    :ivar caption: Figure caption.
    :vartype caption: ~azure.ai.contentunderstanding.models.DocumentCaption
    :ivar footnotes: List of figure footnotes.
    :vartype footnotes: list[~azure.ai.contentunderstanding.models.DocumentFootnote]
    :ivar description: Description of the figure.
    :vartype description: str
    :ivar role: Semantic role of the figure. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", and "formulaBlock".
    :vartype role: str or ~azure.ai.contentunderstanding.models.SemanticRole
    :ivar kind: Figure kind. Required. Figure containing a chart, such as a bar chart, line chart,
     or pie chart.
    :vartype kind: str or ~azure.ai.contentunderstanding.models.CHART
    :ivar content: Chart content represented using `Chart.js config
     <https://www.chartjs.org/docs/latest/configuration/>`_. Required.
    :vartype content: dict[str, any]
    """

    kind: Literal[DocumentFigureKind.CHART] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Figure kind. Required. Figure containing a chart, such as a bar chart, line chart, or pie
     chart."""
    content: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Chart content represented using `Chart.js config
     <https://www.chartjs.org/docs/latest/configuration/>`_. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        content: dict[str, Any],
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
        caption: Optional["_models.DocumentCaption"] = None,
        footnotes: Optional[list["_models.DocumentFootnote"]] = None,
        description: Optional[str] = None,
        role: Optional[Union[str, "_models.SemanticRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = DocumentFigureKind.CHART  # type: ignore


class DocumentContent(MediaContent, discriminator="document"):
    """Document content.  Ex. text/plain, application/pdf, image/jpeg.

    :ivar mime_type: Detected MIME type of the content.  Ex. application/pdf, image/jpeg, etc.
     Required.
    :vartype mime_type: str
    :ivar analyzer_id: The analyzer that generated this content.
    :vartype analyzer_id: str
    :ivar category: Classified content category.
    :vartype category: str
    :ivar path: The path of the content in the input.
    :vartype path: str
    :ivar markdown: Markdown representation of the content.
    :vartype markdown: str
    :ivar fields: Extracted fields from the content.
    :vartype fields: dict[str, ~azure.ai.contentunderstanding.models.ContentField]
    :ivar kind: Content kind. Required. Document content, such as pdf, image, txt, etc.
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DOCUMENT
    :ivar start_page_number: Start page number (1-indexed) of the content. Required.
    :vartype start_page_number: int
    :ivar end_page_number: End page number (1-indexed) of the content. Required.
    :vartype end_page_number: int
    :ivar unit: Length unit used by the width, height, and source properties.
     For images/tiff, the default unit is pixel.  For PDF, the default unit is inch. Known values
     are: "pixel" and "inch".
    :vartype unit: str or ~azure.ai.contentunderstanding.models.LengthUnit
    :ivar pages: List of pages in the document.
    :vartype pages: list[~azure.ai.contentunderstanding.models.DocumentPage]
    :ivar paragraphs: List of paragraphs in the document.  Only if enableOcr and returnDetails are
     true.
    :vartype paragraphs: list[~azure.ai.contentunderstanding.models.DocumentParagraph]
    :ivar sections: List of sections in the document.  Only if enableLayout and returnDetails are
     true.
    :vartype sections: list[~azure.ai.contentunderstanding.models.DocumentSection]
    :ivar tables: List of tables in the document.  Only if enableLayout and returnDetails are true.
    :vartype tables: list[~azure.ai.contentunderstanding.models.DocumentTable]
    :ivar figures: List of figures in the document.  Only if enableLayout and returnDetails are
     true.
    :vartype figures: list[~azure.ai.contentunderstanding.models.DocumentFigure]
    :ivar annotations: List of annotations in the document.  Only if enableAnnotations and
     returnDetails are true.
    :vartype annotations: list[~azure.ai.contentunderstanding.models.DocumentAnnotation]
    :ivar hyperlinks: List of hyperlinks in the document.  Only if returnDetails are true.
    :vartype hyperlinks: list[~azure.ai.contentunderstanding.models.DocumentHyperlink]
    :ivar segments: List of detected content segments.  Only if enableSegment is true.
    :vartype segments: list[~azure.ai.contentunderstanding.models.DocumentContentSegment]
    """

    kind: Literal[MediaContentKind.DOCUMENT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Content kind. Required. Document content, such as pdf, image, txt, etc."""
    start_page_number: int = rest_field(
        name="startPageNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start page number (1-indexed) of the content. Required."""
    end_page_number: int = rest_field(name="endPageNumber", visibility=["read", "create", "update", "delete", "query"])
    """End page number (1-indexed) of the content. Required."""
    unit: Optional[Union[str, "_models.LengthUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Length unit used by the width, height, and source properties.
     For images/tiff, the default unit is pixel.  For PDF, the default unit is inch. Known values
     are: \"pixel\" and \"inch\"."""
    pages: Optional[list["_models.DocumentPage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of pages in the document."""
    paragraphs: Optional[list["_models.DocumentParagraph"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of paragraphs in the document.  Only if enableOcr and returnDetails are true."""
    sections: Optional[list["_models.DocumentSection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of sections in the document.  Only if enableLayout and returnDetails are true."""
    tables: Optional[list["_models.DocumentTable"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of tables in the document.  Only if enableLayout and returnDetails are true."""
    figures: Optional[list["_models.DocumentFigure"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of figures in the document.  Only if enableLayout and returnDetails are true."""
    annotations: Optional[list["_models.DocumentAnnotation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of annotations in the document.  Only if enableAnnotations and returnDetails are true."""
    hyperlinks: Optional[list["_models.DocumentHyperlink"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of hyperlinks in the document.  Only if returnDetails are true."""
    segments: Optional[list["_models.DocumentContentSegment"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of detected content segments.  Only if enableSegment is true."""

    @overload
    def __init__(
        self,
        *,
        mime_type: str,
        start_page_number: int,
        end_page_number: int,
        analyzer_id: Optional[str] = None,
        category: Optional[str] = None,
        path: Optional[str] = None,
        markdown: Optional[str] = None,
        fields: Optional[dict[str, "_models.ContentField"]] = None,
        unit: Optional[Union[str, "_models.LengthUnit"]] = None,
        pages: Optional[list["_models.DocumentPage"]] = None,
        paragraphs: Optional[list["_models.DocumentParagraph"]] = None,
        sections: Optional[list["_models.DocumentSection"]] = None,
        tables: Optional[list["_models.DocumentTable"]] = None,
        figures: Optional[list["_models.DocumentFigure"]] = None,
        annotations: Optional[list["_models.DocumentAnnotation"]] = None,
        hyperlinks: Optional[list["_models.DocumentHyperlink"]] = None,
        segments: Optional[list["_models.DocumentContentSegment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MediaContentKind.DOCUMENT  # type: ignore


class DocumentContentSegment(_Model):
    """Detected document content segment.

    :ivar segment_id: Segment identifier. Required.
    :vartype segment_id: str
    :ivar category: Classified content category. Required.
    :vartype category: str
    :ivar span: Span of the segment in the markdown content. Required.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar start_page_number: Start page number (1-indexed) of the segment. Required.
    :vartype start_page_number: int
    :ivar end_page_number: End page number (1-indexed) of the segment. Required.
    :vartype end_page_number: int
    """

    segment_id: str = rest_field(name="segmentId", visibility=["read", "create", "update", "delete", "query"])
    """Segment identifier. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Classified content category. Required."""
    span: "_models.ContentSpan" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the segment in the markdown content. Required."""
    start_page_number: int = rest_field(
        name="startPageNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start page number (1-indexed) of the segment. Required."""
    end_page_number: int = rest_field(name="endPageNumber", visibility=["read", "create", "update", "delete", "query"])
    """End page number (1-indexed) of the segment. Required."""

    @overload
    def __init__(
        self,
        *,
        segment_id: str,
        category: str,
        span: "_models.ContentSpan",
        start_page_number: int,
        end_page_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentFootnote(_Model):
    """Footnote of a table or figure.

    :ivar content: Content of the footnote. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the footnote in the content.
    :vartype source: str
    :ivar span: Span of the footnote in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the footnote.
    :vartype elements: list[str]
    """

    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Content of the footnote. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the footnote in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the footnote in the markdown content."""
    elements: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Child elements of the footnote."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentFormula(_Model):
    """Mathematical formula in a document.

    :ivar kind: Formula kind. Required. Known values are: "inline" and "display".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DocumentFormulaKind
    :ivar value: LaTex expression describing the formula. Required.
    :vartype value: str
    :ivar source: Encoded source that identifies the position of the formula in the content.
    :vartype source: str
    :ivar span: Span of the formula in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar confidence: Confidence of predicting the formula.
    :vartype confidence: float
    """

    kind: Union[str, "_models.DocumentFormulaKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Formula kind. Required. Known values are: \"inline\" and \"display\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """LaTex expression describing the formula. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the formula in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the formula in the markdown content."""
    confidence: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence of predicting the formula."""

    @overload
    def __init__(
        self,
        *,
        kind: Union[str, "_models.DocumentFormulaKind"],
        value: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        confidence: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentHyperlink(_Model):
    """Hyperlink in a document, such as a link to a web page or an email address.

    :ivar content: Hyperlinked content. Required.
    :vartype content: str
    :ivar url: URL of the hyperlink. Required.
    :vartype url: str
    :ivar span: Span of the hyperlink in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar source: Position of the hyperlink.
    :vartype source: str
    """

    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Hyperlinked content. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL of the hyperlink. Required."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the hyperlink in the markdown content."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Position of the hyperlink."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        url: str,
        span: Optional["_models.ContentSpan"] = None,
        source: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentLine(_Model):
    """Line in a document, consisting of an contiguous sequence of words.

    :ivar content: Line text. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the line in the content.
    :vartype source: str
    :ivar span: Span of the line in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    """

    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Line text. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the line in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the line in the markdown content."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentMermaidFigure(DocumentFigure, discriminator="mermaid"):
    """Figure containing a diagram, such as a flowchart or network diagram.

    :ivar id: Figure identifier. Required.
    :vartype id: str
    :ivar source: Encoded source that identifies the position of the figure in the content.
    :vartype source: str
    :ivar span: Span of the figure in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the figure, excluding any caption or footnotes.
    :vartype elements: list[str]
    :ivar caption: Figure caption.
    :vartype caption: ~azure.ai.contentunderstanding.models.DocumentCaption
    :ivar footnotes: List of figure footnotes.
    :vartype footnotes: list[~azure.ai.contentunderstanding.models.DocumentFootnote]
    :ivar description: Description of the figure.
    :vartype description: str
    :ivar role: Semantic role of the figure. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", and "formulaBlock".
    :vartype role: str or ~azure.ai.contentunderstanding.models.SemanticRole
    :ivar kind: Figure kind. Required. Figure containing a diagram, such as a flowchart or network
     diagram.
    :vartype kind: str or ~azure.ai.contentunderstanding.models.MERMAID
    :ivar content: Diagram content represented using `Mermaid syntax
     <https://mermaid.js.org/intro/>`_. Required.
    :vartype content: str
    """

    kind: Literal[DocumentFigureKind.MERMAID] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Figure kind. Required. Figure containing a diagram, such as a flowchart or network diagram."""
    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Diagram content represented using `Mermaid syntax <https://mermaid.js.org/intro/>`_. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        content: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
        caption: Optional["_models.DocumentCaption"] = None,
        footnotes: Optional[list["_models.DocumentFootnote"]] = None,
        description: Optional[str] = None,
        role: Optional[Union[str, "_models.SemanticRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = DocumentFigureKind.MERMAID  # type: ignore


class DocumentPage(_Model):
    """Content from a document page.

    :ivar page_number: Page number (1-based). Required.
    :vartype page_number: int
    :ivar width: Width of the page.
    :vartype width: float
    :ivar height: Height of the page.
    :vartype height: float
    :ivar spans: Span(s) associated with the page in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar angle: The general orientation of the content in clockwise direction,
     measured in degrees between (-180, 180].
     Only if enableOcr is true.
    :vartype angle: float
    :ivar words: List of words in the page.  Only if enableOcr and returnDetails are true.
    :vartype words: list[~azure.ai.contentunderstanding.models.DocumentWord]
    :ivar lines: List of lines in the page.  Only if enableOcr and returnDetails are true.
    :vartype lines: list[~azure.ai.contentunderstanding.models.DocumentLine]
    :ivar barcodes: List of barcodes in the page.  Only if enableBarcode and returnDetails are
     true.
    :vartype barcodes: list[~azure.ai.contentunderstanding.models.DocumentBarcode]
    :ivar formulas: List of mathematical formulas in the page.  Only if enableFormula and
     returnDetails are true.
    :vartype formulas: list[~azure.ai.contentunderstanding.models.DocumentFormula]
    """

    page_number: int = rest_field(name="pageNumber", visibility=["read", "create", "update", "delete", "query"])
    """Page number (1-based). Required."""
    width: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Width of the page."""
    height: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height of the page."""
    spans: Optional[list["_models.ContentSpan"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Span(s) associated with the page in the markdown content."""
    angle: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The general orientation of the content in clockwise direction,
     measured in degrees between (-180, 180].
     Only if enableOcr is true."""
    words: Optional[list["_models.DocumentWord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of words in the page.  Only if enableOcr and returnDetails are true."""
    lines: Optional[list["_models.DocumentLine"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of lines in the page.  Only if enableOcr and returnDetails are true."""
    barcodes: Optional[list["_models.DocumentBarcode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of barcodes in the page.  Only if enableBarcode and returnDetails are true."""
    formulas: Optional[list["_models.DocumentFormula"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of mathematical formulas in the page.  Only if enableFormula and returnDetails are true."""

    @overload
    def __init__(
        self,
        *,
        page_number: int,
        width: Optional[float] = None,
        height: Optional[float] = None,
        spans: Optional[list["_models.ContentSpan"]] = None,
        angle: Optional[float] = None,
        words: Optional[list["_models.DocumentWord"]] = None,
        lines: Optional[list["_models.DocumentLine"]] = None,
        barcodes: Optional[list["_models.DocumentBarcode"]] = None,
        formulas: Optional[list["_models.DocumentFormula"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentParagraph(_Model):
    """Paragraph in a document, generally consisting of an contiguous sequence of lines
    with common alignment and spacing.

    :ivar role: Semantic role of the paragraph. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", and "formulaBlock".
    :vartype role: str or ~azure.ai.contentunderstanding.models.SemanticRole
    :ivar content: Paragraph text. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the paragraph in the content.
    :vartype source: str
    :ivar span: Span of the paragraph in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    """

    role: Optional[Union[str, "_models.SemanticRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Semantic role of the paragraph. Known values are: \"pageHeader\", \"pageFooter\",
     \"pageNumber\", \"title\", \"sectionHeading\", \"footnote\", and \"formulaBlock\"."""
    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Paragraph text. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the paragraph in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the paragraph in the markdown content."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        role: Optional[Union[str, "_models.SemanticRole"]] = None,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentSection(_Model):
    """Section in a document.

    :ivar span: Span of the section in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the section.
    :vartype elements: list[str]
    """

    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the section in the markdown content."""
    elements: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Child elements of the section."""

    @overload
    def __init__(
        self,
        *,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTable(_Model):
    """Table in a document, consisting table cells arranged in a rectangular layout.

    :ivar row_count: Number of rows in the table. Required.
    :vartype row_count: int
    :ivar column_count: Number of columns in the table. Required.
    :vartype column_count: int
    :ivar cells: Cells contained within the table. Required.
    :vartype cells: list[~azure.ai.contentunderstanding.models.DocumentTableCell]
    :ivar source: Encoded source that identifies the position of the table in the content.
    :vartype source: str
    :ivar span: Span of the table in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar caption: Table caption.
    :vartype caption: ~azure.ai.contentunderstanding.models.DocumentCaption
    :ivar footnotes: List of table footnotes.
    :vartype footnotes: list[~azure.ai.contentunderstanding.models.DocumentFootnote]
    :ivar role: Semantic role of the table. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", and "formulaBlock".
    :vartype role: str or ~azure.ai.contentunderstanding.models.SemanticRole
    """

    row_count: int = rest_field(name="rowCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of rows in the table. Required."""
    column_count: int = rest_field(name="columnCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of columns in the table. Required."""
    cells: list["_models.DocumentTableCell"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Cells contained within the table. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the table in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the table in the markdown content."""
    caption: Optional["_models.DocumentCaption"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Table caption."""
    footnotes: Optional[list["_models.DocumentFootnote"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of table footnotes."""
    role: Optional[Union[str, "_models.SemanticRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Semantic role of the table. Known values are: \"pageHeader\", \"pageFooter\", \"pageNumber\",
     \"title\", \"sectionHeading\", \"footnote\", and \"formulaBlock\"."""

    @overload
    def __init__(
        self,
        *,
        row_count: int,
        column_count: int,
        cells: list["_models.DocumentTableCell"],
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        caption: Optional["_models.DocumentCaption"] = None,
        footnotes: Optional[list["_models.DocumentFootnote"]] = None,
        role: Optional[Union[str, "_models.SemanticRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTableCell(_Model):
    """Table cell in a document table.

    :ivar kind: Table cell kind. Known values are: "content", "rowHeader", "columnHeader",
     "stubHead", and "description".
    :vartype kind: str or ~azure.ai.contentunderstanding.models.DocumentTableCellKind
    :ivar row_index: Row index of the cell. Required.
    :vartype row_index: int
    :ivar column_index: Column index of the cell. Required.
    :vartype column_index: int
    :ivar row_span: Number of rows spanned by this cell.
    :vartype row_span: int
    :ivar column_span: Number of columns spanned by this cell.
    :vartype column_span: int
    :ivar content: Content of the table cell. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the table cell in the content.
    :vartype source: str
    :ivar span: Span of the table cell in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar elements: Child elements of the table cell.
    :vartype elements: list[str]
    """

    kind: Optional[Union[str, "_models.DocumentTableCellKind"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Table cell kind. Known values are: \"content\", \"rowHeader\", \"columnHeader\", \"stubHead\",
     and \"description\"."""
    row_index: int = rest_field(name="rowIndex", visibility=["read", "create", "update", "delete", "query"])
    """Row index of the cell. Required."""
    column_index: int = rest_field(name="columnIndex", visibility=["read", "create", "update", "delete", "query"])
    """Column index of the cell. Required."""
    row_span: Optional[int] = rest_field(name="rowSpan", visibility=["read", "create", "update", "delete", "query"])
    """Number of rows spanned by this cell."""
    column_span: Optional[int] = rest_field(
        name="columnSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of columns spanned by this cell."""
    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Content of the table cell. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the table cell in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the table cell in the markdown content."""
    elements: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Child elements of the table cell."""

    @overload
    def __init__(
        self,
        *,
        row_index: int,
        column_index: int,
        content: str,
        kind: Optional[Union[str, "_models.DocumentTableCellKind"]] = None,
        row_span: Optional[int] = None,
        column_span: Optional[int] = None,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        elements: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentWord(_Model):
    """Word in a document, consisting of a contiguous sequence of characters.
    For non-space delimited languages, such as Chinese, Japanese, and Korean,
    each character is represented as its own word.

    :ivar content: Word text. Required.
    :vartype content: str
    :ivar source: Encoded source that identifies the position of the word in the content.
    :vartype source: str
    :ivar span: Span of the word in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar confidence: Confidence of predicting the word.
    :vartype confidence: float
    """

    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Word text. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoded source that identifies the position of the word in the content."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the word in the markdown content."""
    confidence: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence of predicting the word."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        source: Optional[str] = None,
        span: Optional["_models.ContentSpan"] = None,
        confidence: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IntegerField(ContentField, discriminator="integer"):
    """Integer field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Integer as 64-bit signed
     integer.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.INTEGER
    :ivar value_integer: Integer field value.
    :vartype value_integer: int
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.INTEGER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Integer as 64-bit signed integer."""
    value_integer: Optional[int] = rest_field(
        name="valueInteger", visibility=["read", "create", "update", "delete", "query"]
    )
    """Integer field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_integer: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.INTEGER  # type: ignore


class JsonField(ContentField, discriminator="json"):
    """JSON field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. JSON object.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.JSON
    :ivar value_json: JSON field value.
    :vartype value_json: any
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.JSON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. JSON object."""
    value_json: Optional[Any] = rest_field(name="valueJson", visibility=["read", "create", "update", "delete", "query"])
    """JSON field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_json: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.JSON  # type: ignore


class KnowledgeSource(_Model):
    """Knowledge source.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LabeledDataKnowledgeSource

    :ivar kind: The kind of knowledge source. Required. "labeledData"
    :vartype kind: str or ~azure.ai.contentunderstanding.models.KnowledgeSourceKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of knowledge source. Required. \"labeledData\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LabeledDataKnowledgeSource(KnowledgeSource, discriminator="labeledData"):
    """Labeled data knowledge source.

    :ivar kind: A blob container containing labeled data. Required. A labeled data knowledge
     source.
    :vartype kind: str or ~azure.ai.contentunderstanding.models.LABELED_DATA
    :ivar container_url: The URL of the blob container containing labeled data. Required.
    :vartype container_url: str
    :ivar prefix: An optional prefix to filter blobs within the container.
    :vartype prefix: str
    :ivar file_list_path: An optional path to a file listing specific blobs to include. Required.
    :vartype file_list_path: str
    """

    kind: Literal[KnowledgeSourceKind.LABELED_DATA] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A blob container containing labeled data. Required. A labeled data knowledge source."""
    container_url: str = rest_field(name="containerUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the blob container containing labeled data. Required."""
    prefix: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional prefix to filter blobs within the container."""
    file_list_path: str = rest_field(name="fileListPath", visibility=["read", "create", "update", "delete", "query"])
    """An optional path to a file listing specific blobs to include. Required."""

    @overload
    def __init__(
        self,
        *,
        container_url: str,
        file_list_path: str,
        prefix: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.LABELED_DATA  # type: ignore


class NumberField(ContentField, discriminator="number"):
    """Number field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Number as double precision
     floating point.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.NUMBER
    :ivar value_number: Number field value.
    :vartype value_number: float
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.NUMBER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Number as double precision floating point."""
    value_number: Optional[float] = rest_field(
        name="valueNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_number: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.NUMBER  # type: ignore


class ObjectField(ContentField, discriminator="object"):
    """Object field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Named list of subfields.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.OBJECT
    :ivar value_object: Object field value.
    :vartype value_object: dict[str, ~azure.ai.contentunderstanding.models.ContentField]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.OBJECT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Named list of subfields."""
    value_object: Optional[dict[str, "_models.ContentField"]] = rest_field(
        name="valueObject", visibility=["read", "create", "update", "delete", "query"]
    )
    """Object field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_object: Optional[dict[str, "_models.ContentField"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.OBJECT  # type: ignore


class RecordMergePatchUpdate(_Model):
    """RecordMergePatchUpdate."""


class StringField(ContentField, discriminator="string"):
    """String field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Plain text.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.STRING
    :ivar value_string: String field value.
    :vartype value_string: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.STRING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Plain text."""
    value_string: Optional[str] = rest_field(
        name="valueString", visibility=["read", "create", "update", "delete", "query"]
    )
    """String field value."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_string: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.STRING  # type: ignore


class SupportedModels(_Model):
    """Chat completion and embedding models supported by the analyzer.

    :ivar completion: Chat completion models supported by the analyzer.
    :vartype completion: list[str]
    :ivar embedding: Embedding models supported by the analyzer.
    :vartype embedding: list[str]
    """

    completion: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Chat completion models supported by the analyzer."""
    embedding: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Embedding models supported by the analyzer."""

    @overload
    def __init__(
        self,
        *,
        completion: Optional[list[str]] = None,
        embedding: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TimeField(ContentField, discriminator="time"):
    """Time field extracted from the content.

    :ivar type: Semantic data type of the field value. Required. Known values are: "string",
     "date", "time", "number", "integer", "boolean", "array", "object", and "json".
    :vartype type: str or ~azure.ai.contentunderstanding.models.ContentFieldType
    :ivar spans: Span(s) associated with the field value in the markdown content.
    :vartype spans: list[~azure.ai.contentunderstanding.models.ContentSpan]
    :ivar confidence: Confidence of predicting the field value.
    :vartype confidence: float
    :ivar source: Encoded source that identifies the position of the field value in the content.
    :vartype source: str
    :ivar field_type: Semantic data type of the field value. Required. Time, normalized to ISO 8601
     (hh:mm:ss) format.
    :vartype field_type: str or ~azure.ai.contentunderstanding.models.TIME
    :ivar value_time: Time field value, in ISO 8601 (hh:mm:ss) format.
    :vartype value_time: ~datetime.time
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Semantic data type of the field value. Required. Known values are: \"string\", \"date\",
     \"time\", \"number\", \"integer\", \"boolean\", \"array\", \"object\", and \"json\"."""
    field_type: Literal[ContentFieldType.TIME] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Semantic data type of the field value. Required. Time, normalized to ISO 8601 (hh:mm:ss)
     format."""
    value_time: Optional[datetime.time] = rest_field(
        name="valueTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Time field value, in ISO 8601 (hh:mm:ss) format."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        spans: Optional[list["_models.ContentSpan"]] = None,
        confidence: Optional[float] = None,
        source: Optional[str] = None,
        value_time: Optional[datetime.time] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.field_type = ContentFieldType.TIME  # type: ignore


class TranscriptPhrase(_Model):
    """Transcript phrase.

    :ivar speaker: Speaker index or name.
    :vartype speaker: str
    :ivar start_time_ms: Start time of the phrase in milliseconds. Required.
    :vartype start_time_ms: int
    :ivar end_time_ms: End time of the phrase in milliseconds. Required.
    :vartype end_time_ms: int
    :ivar locale: Detected locale of the phrase.  Ex. en-US.
    :vartype locale: str
    :ivar text: Transcript text. Required.
    :vartype text: str
    :ivar confidence: Confidence of predicting the phrase.
    :vartype confidence: float
    :ivar span: Span of the phrase in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    :ivar words: List of words in the phrase. Required.
    :vartype words: list[~azure.ai.contentunderstanding.models.TranscriptWord]
    """

    speaker: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Speaker index or name."""
    start_time_ms: int = rest_field(name="startTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """Start time of the phrase in milliseconds. Required."""
    end_time_ms: int = rest_field(name="endTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """End time of the phrase in milliseconds. Required."""
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detected locale of the phrase.  Ex. en-US."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Transcript text. Required."""
    confidence: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence of predicting the phrase."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the phrase in the markdown content."""
    words: list["_models.TranscriptWord"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of words in the phrase. Required."""

    @overload
    def __init__(
        self,
        *,
        start_time_ms: int,
        end_time_ms: int,
        text: str,
        words: list["_models.TranscriptWord"],
        speaker: Optional[str] = None,
        locale: Optional[str] = None,
        confidence: Optional[float] = None,
        span: Optional["_models.ContentSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranscriptWord(_Model):
    """Transcript word.

    :ivar start_time_ms: Start time of the word in milliseconds. Required.
    :vartype start_time_ms: int
    :ivar end_time_ms: End time of the word in milliseconds. Required.
    :vartype end_time_ms: int
    :ivar text: Transcript text. Required.
    :vartype text: str
    :ivar span: Span of the word in the markdown content.
    :vartype span: ~azure.ai.contentunderstanding.models.ContentSpan
    """

    start_time_ms: int = rest_field(name="startTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """Start time of the word in milliseconds. Required."""
    end_time_ms: int = rest_field(name="endTimeMs", visibility=["read", "create", "update", "delete", "query"])
    """End time of the word in milliseconds. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Transcript text. Required."""
    span: Optional["_models.ContentSpan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Span of the word in the markdown content."""

    @overload
    def __init__(
        self,
        *,
        start_time_ms: int,
        end_time_ms: int,
        text: str,
        span: Optional["_models.ContentSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UsageDetails(_Model):
    """Usage details.

    :ivar document_pages_minimal: The number of document pages processed at the minimal level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page.
    :vartype document_pages_minimal: int
    :ivar document_pages_basic: The number of document pages processed at the basic level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page.
    :vartype document_pages_basic: int
    :ivar document_pages_standard: The number of document pages processed at the standard level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page.
    :vartype document_pages_standard: int
    :ivar audio_hours: The hours of audio processed.
    :vartype audio_hours: float
    :ivar video_hours: The hours of video processed.
    :vartype video_hours: float
    :ivar contextualization_tokens: The number of contextualization tokens consumed for preparing
     context, generating confidence scores, source grounding, and output formatting.
    :vartype contextualization_tokens: int
    :ivar tokens: The number of LLM and embedding tokens consumed, grouped by model (ex. GTP 4.1)
     and type (ex. input, cached input, output).
    :vartype tokens: dict[str, int]
    """

    document_pages_minimal: Optional[int] = rest_field(
        name="documentPagesMinimal", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of document pages processed at the minimal level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page."""
    document_pages_basic: Optional[int] = rest_field(
        name="documentPagesBasic", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of document pages processed at the basic level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page."""
    document_pages_standard: Optional[int] = rest_field(
        name="documentPagesStandard", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of document pages processed at the standard level.
     For documents without explicit pages (ex. txt, html), every 3000 UTF-16 characters is counted
     as one page."""
    audio_hours: Optional[float] = rest_field(
        name="audioHours", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hours of audio processed."""
    video_hours: Optional[float] = rest_field(
        name="videoHours", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hours of video processed."""
    contextualization_tokens: Optional[int] = rest_field(
        name="contextualizationTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of contextualization tokens consumed for preparing context, generating confidence
     scores, source grounding, and output formatting."""
    tokens: Optional[dict[str, int]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of LLM and embedding tokens consumed, grouped by model (ex. GTP 4.1) and type (ex.
     input, cached input, output)."""

    @overload
    def __init__(
        self,
        *,
        document_pages_minimal: Optional[int] = None,
        document_pages_basic: Optional[int] = None,
        document_pages_standard: Optional[int] = None,
        audio_hours: Optional[float] = None,
        video_hours: Optional[float] = None,
        contextualization_tokens: Optional[int] = None,
        tokens: Optional[dict[str, int]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
