
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_BoundedCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Line.hxx>
#include <gp_Lin.hxx>
#include <gp_Circ.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <gp_Ax3.hxx>
#include <Geom_Surface.hxx>
#include <Geom_SurfaceOfRevolution.hxx>
#include <Geom_Circle.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>

// module includes
#include <GeomConvert.hxx>
#include <GeomConvert_ApproxCurve.hxx>
#include <GeomConvert_ApproxSurface.hxx>
#include <GeomConvert_BSplineCurveKnotSplitting.hxx>
#include <GeomConvert_BSplineCurveToBezierCurve.hxx>
#include <GeomConvert_BSplineSurfaceKnotSplitting.hxx>
#include <GeomConvert_BSplineSurfaceToBezierSurface.hxx>
#include <GeomConvert_CompBezierSurfacesToBSplineSurface.hxx>
#include <GeomConvert_CompCurveToBSplineCurve.hxx>
#include <GeomConvert_ConvType.hxx>
#include <GeomConvert_CurveToAnaCurve.hxx>
#include <GeomConvert_FuncConeLSDist.hxx>
#include <GeomConvert_FuncCylinderLSDist.hxx>
#include <GeomConvert_FuncSphereLSDist.hxx>
#include <GeomConvert_SurfToAnaSurf.hxx>
#include <GeomConvert_Units.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_GeomConvert(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("GeomConvert"));
py::object klass;

//Python trampoline classes

// classes

    // Class GeomConvert from ./opencascade/GeomConvert.hxx
    klass = m.attr("GeomConvert");

    // default constructor
    register_default_constructor<GeomConvert , shared_ptr<GeomConvert>>(m,"GeomConvert");

    // nested enums

    static_cast<py::class_<GeomConvert , shared_ptr<GeomConvert>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("SplitBSplineCurve_s",
                    (handle<Geom_BSplineCurve> (*)(  const handle<Geom_BSplineCurve> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineCurve> (*)(  const handle<Geom_BSplineCurve> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineCurve),
                    R"#(Convert a curve from Geom by an approximation method)#"  , py::arg("C"),  py::arg("FromK1"),  py::arg("ToK2"),  py::arg("SameOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("SplitBSplineCurve_s",
                    (handle<Geom_BSplineCurve> (*)(  const handle<Geom_BSplineCurve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineCurve> (*)(  const handle<Geom_BSplineCurve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineCurve),
                    R"#(This function computes the segment of B-spline curve between the parametric values FromU1, ToU2. If C is periodic the arc has the same orientation as C if SameOrientation = True. If C is not periodic SameOrientation is not used for the computation and C is oriented fromU1 toU2. If U1 and U2 and two parametric values we consider that U1 = U2 if Abs (U1 - U2) <= ParametricTolerance and ParametricTolerance must be greater or equal to Resolution from package gp.)#"  , py::arg("C"),  py::arg("FromU1"),  py::arg("ToU2"),  py::arg("ParametricTolerance"),  py::arg("SameOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("SplitBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineSurface),
                    R"#(Computes the B-spline surface patche between the knots values FromUK1, ToUK2, FromVK1, ToVK2. If S is periodic in one direction the patche has the same orientation as S in this direction if the flag is true in this direction (SameUOrientation, SameVOrientation). If S is not periodic SameUOrientation and SameVOrientation are not used for the computation and S is oriented FromUK1 ToUK2 and FromVK1 ToVK2. Raised if FromUK1 = ToUK2 or FromVK1 = ToVK2 FromUK1 or ToUK2 are out of the bounds [FirstUKnotIndex, LastUKnotIndex] FromVK1 or ToVK2 are out of the bounds [FirstVKnotIndex, LastVKnotIndex])#"  , py::arg("S"),  py::arg("FromUK1"),  py::arg("ToUK2"),  py::arg("FromVK1"),  py::arg("ToVK2"),  py::arg("SameUOrientation")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("SameVOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("SplitBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineSurface),
                    R"#(This method splits a B-spline surface patche between the knots values FromK1, ToK2 in one direction. If USplit = True then the splitting direction is the U parametric direction else it is the V parametric direction. If S is periodic in the considered direction the patche has the same orientation as S in this direction if SameOrientation is True If S is not periodic in this direction SameOrientation is not used for the computation and S is oriented FromK1 ToK2. Raised if FromK1 = ToK2 or if FromK1 or ToK2 are out of the bounds [FirstUKnotIndex, LastUKnotIndex] in the considered parametric direction.)#"  , py::arg("S"),  py::arg("FromK1"),  py::arg("ToK2"),  py::arg("USplit"),  py::arg("SameOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("SplitBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineSurface),
                    R"#(This method computes the B-spline surface patche between the parametric values FromU1, ToU2, FromV1, ToV2. If S is periodic in one direction the patche has the same orientation as S in this direction if the flag is True in this direction (SameUOrientation, SameVOrientation). If S is not periodic SameUOrientation and SameVOrientation are not used for the computation and S is oriented FromU1 ToU2 and FromV1 ToV2. If U1 and U2 and two parametric values we consider that U1 = U2 if Abs (U1 - U2) <= ParametricTolerance and ParametricTolerance must be greater or equal to Resolution from package gp.)#"  , py::arg("S"),  py::arg("FromU1"),  py::arg("ToU2"),  py::arg("FromV1"),  py::arg("ToV2"),  py::arg("ParametricTolerance"),  py::arg("SameUOrientation")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("SameVOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("SplitBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Geom_BSplineSurface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Real ,   const Standard_Boolean  ) >(&GeomConvert::SplitBSplineSurface),
                    R"#(This method splits the B-spline surface S in one direction between the parametric values FromParam1, ToParam2. If USplit = True then the Splitting direction is the U parametric direction else it is the V parametric direction. If S is periodic in the considered direction the patche has the same orientation as S in this direction if SameOrientation is true. If S is not periodic in the considered direction SameOrientation is not used for the computation and S is oriented FromParam1 ToParam2. If U1 and U2 and two parametric values we consider that U1 = U2 if Abs (U1 - U2) <= ParametricTolerance and ParametricTolerance must be greater or equal to Resolution from package gp.)#"  , py::arg("S"),  py::arg("FromParam1"),  py::arg("ToParam2"),  py::arg("USplit"),  py::arg("ParametricTolerance"),  py::arg("SameOrientation")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("CurveToBSplineCurve_s",
                    (handle<Geom_BSplineCurve> (*)(  const handle<Geom_Curve> & ,   const Convert_ParameterisationType  ) ) static_cast<handle<Geom_BSplineCurve> (*)(  const handle<Geom_Curve> & ,   const Convert_ParameterisationType  ) >(&GeomConvert::CurveToBSplineCurve),
                    R"#(This function converts a non infinite curve from Geom into a B-spline curve. C must be an ellipse or a circle or a trimmed conic or a trimmed line or a Bezier curve or a trimmed Bezier curve or a BSpline curve or a trimmed BSpline curve or an OffsetCurve. The returned B-spline is not periodic except if C is a Circle or an Ellipse. If the Parameterisation is QuasiAngular than the returned curve is NOT periodic in case a periodic Geom_Circle or Geom_Ellipse. For TgtThetaOver2_1 and TgtThetaOver2_2 the method raises an exception in case of a periodic Geom_Circle or a Geom_Ellipse ParameterisationType applies only if the curve is a Circle or an ellipse : TgtThetaOver2, -- TgtThetaOver2_1, -- TgtThetaOver2_2, -- TgtThetaOver2_3, -- TgtThetaOver2_4,)#"  , py::arg("C"),  py::arg("Parameterisation")=static_cast< const Convert_ParameterisationType>(Convert_TgtThetaOver2)
          )
        .def_static("SurfaceToBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Geom_Surface> &  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Geom_Surface> &  ) >(&GeomConvert::SurfaceToBSplineSurface),
                    R"#(This algorithm converts a non infinite surface from Geom into a B-spline surface. S must be a trimmed plane or a trimmed cylinder or a trimmed cone or a trimmed sphere or a trimmed torus or a sphere or a torus or a Bezier surface of a trimmed Bezier surface or a trimmed swept surface with a corresponding basis curve which can be turned into a B-spline curve (see the method CurveToBSplineCurve). Raises DomainError if the type of the surface is not previously defined.)#"  , py::arg("S")
          )
    // static methods using call by reference i.s.o. return
        .def_static("ConcatG1_s",
            [](TColGeom_Array1OfBSplineCurve & ArrayOfCurves, const TColStd_Array1OfReal & ArrayOfToler,TColGeom_HArray1OfBSplineCurve& ArrayOfConcatenated, const Standard_Real ClosedTolerance ){
                Standard_Boolean  ClosedFlag;
                handle<TColGeom_HArray1OfBSplineCurve>  ArrayOfConcatenated_ptr; ArrayOfConcatenated_ptr = &ArrayOfConcatenated;

                GeomConvert::ConcatG1(ArrayOfCurves,ArrayOfToler,ArrayOfConcatenated_ptr,ClosedFlag,ClosedTolerance);
                if ( ArrayOfConcatenated_ptr.get() != &ArrayOfConcatenated ) copy_if_copy_constructible(ArrayOfConcatenated, *ArrayOfConcatenated_ptr);

return std::make_tuple(ClosedFlag); },
            R"#(This Method concatenates G1 the ArrayOfCurves as far as it is possible. ArrayOfCurves[0..N-1] ArrayOfToler contains the biggest tolerance of the two points shared by two consecutives curves. Its dimension: [0..N-2] ClosedFlag indicates if the ArrayOfCurves is closed. In this case ClosedTolerance contains the biggest tolerance of the two points which are at the closure. Otherwise its value is 0.0 ClosedFlag becomes False on the output if it is impossible to build closed curve.)#"  , py::arg("ArrayOfCurves"),  py::arg("ArrayOfToler"),  py::arg("ArrayOfConcatenated"),  py::arg("ClosedTolerance")
          )
        .def_static("ConcatC1_s",
            [](TColGeom_Array1OfBSplineCurve & ArrayOfCurves, const TColStd_Array1OfReal & ArrayOfToler,TColStd_HArray1OfInteger& ArrayOfIndices,TColGeom_HArray1OfBSplineCurve& ArrayOfConcatenated, const Standard_Real ClosedTolerance ){
                Standard_Boolean  ClosedFlag;
                handle<TColStd_HArray1OfInteger>  ArrayOfIndices_ptr; ArrayOfIndices_ptr = &ArrayOfIndices;
                handle<TColGeom_HArray1OfBSplineCurve>  ArrayOfConcatenated_ptr; ArrayOfConcatenated_ptr = &ArrayOfConcatenated;

                GeomConvert::ConcatC1(ArrayOfCurves,ArrayOfToler,ArrayOfIndices_ptr,ArrayOfConcatenated_ptr,ClosedFlag,ClosedTolerance);
                if ( ArrayOfIndices_ptr.get() != &ArrayOfIndices ) copy_if_copy_constructible(ArrayOfIndices, *ArrayOfIndices_ptr);
                if ( ArrayOfConcatenated_ptr.get() != &ArrayOfConcatenated ) copy_if_copy_constructible(ArrayOfConcatenated, *ArrayOfConcatenated_ptr);

return std::make_tuple(ClosedFlag); },
            R"#(This Method concatenates C1 the ArrayOfCurves as far as it is possible. ArrayOfCurves[0..N-1] ArrayOfToler contains the biggest tolerance of the two points shared by two consecutives curves. Its dimension: [0..N-2] ClosedFlag indicates if the ArrayOfCurves is closed. In this case ClosedTolerance contains the biggest tolerance of the two points which are at the closure. Otherwise its value is 0.0 ClosedFlag becomes False on the output if it is impossible to build closed curve.)#"  , py::arg("ArrayOfCurves"),  py::arg("ArrayOfToler"),  py::arg("ArrayOfIndices"),  py::arg("ArrayOfConcatenated"),  py::arg("ClosedTolerance")
          )
        .def_static("ConcatC1_s",
            [](TColGeom_Array1OfBSplineCurve & ArrayOfCurves, const TColStd_Array1OfReal & ArrayOfToler,TColStd_HArray1OfInteger& ArrayOfIndices,TColGeom_HArray1OfBSplineCurve& ArrayOfConcatenated, const Standard_Real ClosedTolerance, const Standard_Real AngularTolerance ){
                Standard_Boolean  ClosedFlag;
                handle<TColStd_HArray1OfInteger>  ArrayOfIndices_ptr; ArrayOfIndices_ptr = &ArrayOfIndices;
                handle<TColGeom_HArray1OfBSplineCurve>  ArrayOfConcatenated_ptr; ArrayOfConcatenated_ptr = &ArrayOfConcatenated;

                GeomConvert::ConcatC1(ArrayOfCurves,ArrayOfToler,ArrayOfIndices_ptr,ArrayOfConcatenated_ptr,ClosedFlag,ClosedTolerance,AngularTolerance);
                if ( ArrayOfIndices_ptr.get() != &ArrayOfIndices ) copy_if_copy_constructible(ArrayOfIndices, *ArrayOfIndices_ptr);
                if ( ArrayOfConcatenated_ptr.get() != &ArrayOfConcatenated ) copy_if_copy_constructible(ArrayOfConcatenated, *ArrayOfConcatenated_ptr);

return std::make_tuple(ClosedFlag); },
            R"#(This Method concatenates C1 the ArrayOfCurves as far as it is possible. ArrayOfCurves[0..N-1] ArrayOfToler contains the biggest tolerance of the two points shared by two consecutives curves. Its dimension: [0..N-2] ClosedFlag indicates if the ArrayOfCurves is closed. In this case ClosedTolerance contains the biggest tolerance of the two points which are at the closure. Otherwise its value is 0.0 ClosedFlag becomes False on the output if it is impossible to build closed curve.)#"  , py::arg("ArrayOfCurves"),  py::arg("ArrayOfToler"),  py::arg("ArrayOfIndices"),  py::arg("ArrayOfConcatenated"),  py::arg("ClosedTolerance"),  py::arg("AngularTolerance")
          )
        .def_static("C0BSplineToC1BSplineCurve_s",
            [](Geom_BSplineCurve& BS, const Standard_Real tolerance, const Standard_Real AngularTolerance ){
                handle<Geom_BSplineCurve>  BS_ptr; BS_ptr = &BS;

                GeomConvert::C0BSplineToC1BSplineCurve(BS_ptr,tolerance,AngularTolerance);
                if ( BS_ptr.get() != &BS ) copy_if_copy_constructible(BS, *BS_ptr);

 },
            R"#(This Method reduces as far as it is possible the multiplicities of the knots of the BSpline BS.(keeping the geometry). It returns a new BSpline which could still be C0. tolerance is a geometrical tolerance. The Angular toleranceis in radians and measures the angle of the tangents on the left and on the right to decide if the curve is G1 or not at a given point)#"  , py::arg("BS"),  py::arg("tolerance"),  py::arg("AngularTolerance")=static_cast< const Standard_Real>(1.0e-7)
          )
        .def_static("C0BSplineToArrayOfC1BSplineCurve_s",
            []( const handle<Geom_BSplineCurve> & BS,TColGeom_HArray1OfBSplineCurve& tabBS, const Standard_Real tolerance ){
                handle<TColGeom_HArray1OfBSplineCurve>  tabBS_ptr; tabBS_ptr = &tabBS;

                GeomConvert::C0BSplineToArrayOfC1BSplineCurve(BS,tabBS_ptr,tolerance);
                if ( tabBS_ptr.get() != &tabBS ) copy_if_copy_constructible(tabBS, *tabBS_ptr);

 },
            R"#(This Method reduces as far as it is possible the multiplicities of the knots of the BSpline BS.(keeping the geometry). It returns an array of BSpline C1. tolerance is a geometrical tolerance.)#"  , py::arg("BS"),  py::arg("tabBS"),  py::arg("tolerance")
          )
        .def_static("C0BSplineToArrayOfC1BSplineCurve_s",
            []( const handle<Geom_BSplineCurve> & BS,TColGeom_HArray1OfBSplineCurve& tabBS, const Standard_Real AngularTolerance, const Standard_Real tolerance ){
                handle<TColGeom_HArray1OfBSplineCurve>  tabBS_ptr; tabBS_ptr = &tabBS;

                GeomConvert::C0BSplineToArrayOfC1BSplineCurve(BS,tabBS_ptr,AngularTolerance,tolerance);
                if ( tabBS_ptr.get() != &tabBS ) copy_if_copy_constructible(tabBS, *tabBS_ptr);

 },
            R"#(This Method reduces as far as it is possible the multiplicities of the knots of the BSpline BS.(keeping the geometry). It returns an array of BSpline C1. tolerance is a geometrical tolerance : it allows for the maximum deformation The Angular tolerance is in radians and measures the angle of the tangents on the left and on the right to decide if the curve is C1 or not at a given point)#"  , py::arg("BS"),  py::arg("tabBS"),  py::arg("AngularTolerance"),  py::arg("tolerance")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_ApproxCurve from ./opencascade/GeomConvert_ApproxCurve.hxx
    klass = m.attr("GeomConvert_ApproxCurve");


    // nested enums

    static_cast<py::class_<GeomConvert_ApproxCurve , shared_ptr<GeomConvert_ApproxCurve>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_Curve> &, const Standard_Real, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer >()  , py::arg("Curve"),  py::arg("Tol3d"),  py::arg("Order"),  py::arg("MaxSegments"),  py::arg("MaxDegree") )
        .def(py::init<  const handle<Adaptor3d_Curve> &, const Standard_Real, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer >()  , py::arg("Curve"),  py::arg("Tol3d"),  py::arg("Order"),  py::arg("MaxSegments"),  py::arg("MaxDegree") )
    // custom constructors
    // methods
        .def("Curve",
             (handle<Geom_BSplineCurve> (GeomConvert_ApproxCurve::*)() const) static_cast<handle<Geom_BSplineCurve> (GeomConvert_ApproxCurve::*)() const>(&GeomConvert_ApproxCurve::Curve),
             R"#(Returns the BSpline curve resulting from the approximation algorithm.)#" 
          )
        .def("IsDone",
             (Standard_Boolean (GeomConvert_ApproxCurve::*)() const) static_cast<Standard_Boolean (GeomConvert_ApproxCurve::*)() const>(&GeomConvert_ApproxCurve::IsDone),
             R"#(returns Standard_True if the approximation has been done within required tolerance)#" 
          )
        .def("HasResult",
             (Standard_Boolean (GeomConvert_ApproxCurve::*)() const) static_cast<Standard_Boolean (GeomConvert_ApproxCurve::*)() const>(&GeomConvert_ApproxCurve::HasResult),
             R"#(Returns Standard_True if the approximation did come out with a result that is not NECESSARELY within the required tolerance)#" 
          )
        .def("MaxError",
             (Standard_Real (GeomConvert_ApproxCurve::*)() const) static_cast<Standard_Real (GeomConvert_ApproxCurve::*)() const>(&GeomConvert_ApproxCurve::MaxError),
             R"#(Returns the greatest distance between a point on the source conic and the BSpline curve resulting from the approximation. (>0 when an approximation has been done, 0 if no approximation))#" 
          )
        .def("Dump",
             (void (GeomConvert_ApproxCurve::*)( Standard_OStream &  ) const) static_cast<void (GeomConvert_ApproxCurve::*)( Standard_OStream &  ) const>(&GeomConvert_ApproxCurve::Dump),
             R"#(Print on the stream o information about the object)#"  , py::arg("o")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_ApproxSurface from ./opencascade/GeomConvert_ApproxSurface.hxx
    klass = m.attr("GeomConvert_ApproxSurface");


    // nested enums

    static_cast<py::class_<GeomConvert_ApproxSurface , shared_ptr<GeomConvert_ApproxSurface>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_Surface> &, const Standard_Real, const GeomAbs_Shape, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer >()  , py::arg("Surf"),  py::arg("Tol3d"),  py::arg("UContinuity"),  py::arg("VContinuity"),  py::arg("MaxDegU"),  py::arg("MaxDegV"),  py::arg("MaxSegments"),  py::arg("PrecisCode") )
        .def(py::init<  const handle<Adaptor3d_Surface> &, const Standard_Real, const GeomAbs_Shape, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer >()  , py::arg("Surf"),  py::arg("Tol3d"),  py::arg("UContinuity"),  py::arg("VContinuity"),  py::arg("MaxDegU"),  py::arg("MaxDegV"),  py::arg("MaxSegments"),  py::arg("PrecisCode") )
    // custom constructors
    // methods
        .def("Surface",
             (handle<Geom_BSplineSurface> (GeomConvert_ApproxSurface::*)() const) static_cast<handle<Geom_BSplineSurface> (GeomConvert_ApproxSurface::*)() const>(&GeomConvert_ApproxSurface::Surface),
             R"#(Returns the BSpline surface resulting from the approximation algorithm.)#" 
          )
        .def("IsDone",
             (Standard_Boolean (GeomConvert_ApproxSurface::*)() const) static_cast<Standard_Boolean (GeomConvert_ApproxSurface::*)() const>(&GeomConvert_ApproxSurface::IsDone),
             R"#(Returns Standard_True if the approximation has be done)#" 
          )
        .def("HasResult",
             (Standard_Boolean (GeomConvert_ApproxSurface::*)() const) static_cast<Standard_Boolean (GeomConvert_ApproxSurface::*)() const>(&GeomConvert_ApproxSurface::HasResult),
             R"#(Returns true if the approximation did come out with a result that is not NECESSARILY within the required tolerance or a result that is not recognized with the wished continuities.)#" 
          )
        .def("MaxError",
             (Standard_Real (GeomConvert_ApproxSurface::*)() const) static_cast<Standard_Real (GeomConvert_ApproxSurface::*)() const>(&GeomConvert_ApproxSurface::MaxError),
             R"#(Returns the greatest distance between a point on the source conic surface and the BSpline surface resulting from the approximation (>0 when an approximation has been done, 0 if no approximation ))#" 
          )
        .def("Dump",
             (void (GeomConvert_ApproxSurface::*)( Standard_OStream &  ) const) static_cast<void (GeomConvert_ApproxSurface::*)( Standard_OStream &  ) const>(&GeomConvert_ApproxSurface::Dump),
             R"#(Prints on the stream o information on the current state of the object.)#"  , py::arg("o")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_BSplineCurveKnotSplitting from ./opencascade/GeomConvert_BSplineCurveKnotSplitting.hxx
    klass = m.attr("GeomConvert_BSplineCurveKnotSplitting");


    // nested enums

    static_cast<py::class_<GeomConvert_BSplineCurveKnotSplitting , shared_ptr<GeomConvert_BSplineCurveKnotSplitting>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_BSplineCurve> &, const Standard_Integer >()  , py::arg("BasisCurve"),  py::arg("ContinuityRange") )
    // custom constructors
    // methods
        .def("NbSplits",
             (Standard_Integer (GeomConvert_BSplineCurveKnotSplitting::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineCurveKnotSplitting::*)() const>(&GeomConvert_BSplineCurveKnotSplitting::NbSplits),
             R"#(Returns the number of points at which the analyzed BSpline curve should be split, in order to obtain arcs with the continuity required by this framework. All these points correspond to knot values. Note that the first and last points of the curve, which bound the first and last arcs, are counted among these splitting points.)#" 
          )
        .def("Splitting",
             (void (GeomConvert_BSplineCurveKnotSplitting::*)( TColStd_Array1OfInteger &  ) const) static_cast<void (GeomConvert_BSplineCurveKnotSplitting::*)( TColStd_Array1OfInteger &  ) const>(&GeomConvert_BSplineCurveKnotSplitting::Splitting),
             R"#(Loads the SplitValues table with the split knots values computed in this framework. Each value in the table is an index in the knots table of the BSpline curve analyzed by this algorithm. The values in SplitValues are given in ascending order and comprise the indices of the knots which give the first and last points of the curve. Use two consecutive values from the table as arguments of the global function SplitBSplineCurve (provided by the package GeomConvert) to split the curve. Exceptions Standard_DimensionError if the array SplitValues was not created with the following bounds: - 1, and - the number of split points computed in this framework (as given by the function NbSplits).)#"  , py::arg("SplitValues")
          )
        .def("SplitValue",
             (Standard_Integer (GeomConvert_BSplineCurveKnotSplitting::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (GeomConvert_BSplineCurveKnotSplitting::*)(  const Standard_Integer  ) const>(&GeomConvert_BSplineCurveKnotSplitting::SplitValue),
             R"#(Returns the split knot of index Index to the split knots table computed in this framework. The returned value is an index in the knots table of the BSpline curve analyzed by this algorithm. Notes: - If Index is equal to 1, the corresponding knot gives the first point of the curve. - If Index is equal to the number of split knots computed in this framework, the corresponding point is the last point of the curve. Exceptions Standard_RangeError if Index is less than 1 or greater than the number of split knots computed in this framework.)#"  , py::arg("Index")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_BSplineCurveToBezierCurve from ./opencascade/GeomConvert_BSplineCurveToBezierCurve.hxx
    klass = m.attr("GeomConvert_BSplineCurveToBezierCurve");


    // nested enums

    static_cast<py::class_<GeomConvert_BSplineCurveToBezierCurve , shared_ptr<GeomConvert_BSplineCurveToBezierCurve>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_BSplineCurve> & >()  , py::arg("BasisCurve") )
        .def(py::init<  const handle<Geom_BSplineCurve> &, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("BasisCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("ParametricTolerance") )
    // custom constructors
    // methods
        .def("Arc",
             (handle<Geom_BezierCurve> (GeomConvert_BSplineCurveToBezierCurve::*)(  const Standard_Integer  ) ) static_cast<handle<Geom_BezierCurve> (GeomConvert_BSplineCurveToBezierCurve::*)(  const Standard_Integer  ) >(&GeomConvert_BSplineCurveToBezierCurve::Arc),
             R"#(Constructs and returns the Bezier curve of index Index to the table of adjacent Bezier arcs computed by this algorithm. This Bezier curve has the same orientation as the BSpline curve analyzed in this framework. Exceptions Standard_OutOfRange if Index is less than 1 or greater than the number of adjacent Bezier arcs computed by this algorithm.)#"  , py::arg("Index")
          )
        .def("Arcs",
             (void (GeomConvert_BSplineCurveToBezierCurve::*)( TColGeom_Array1OfBezierCurve &  ) ) static_cast<void (GeomConvert_BSplineCurveToBezierCurve::*)( TColGeom_Array1OfBezierCurve &  ) >(&GeomConvert_BSplineCurveToBezierCurve::Arcs),
             R"#(Constructs all the Bezier curves whose data is computed by this algorithm and loads these curves into the Curves table. The Bezier curves have the same orientation as the BSpline curve analyzed in this framework. Exceptions Standard_DimensionError if the Curves array was not created with the following bounds: - 1 , and - the number of adjacent Bezier arcs computed by this algorithm (as given by the function NbArcs).)#"  , py::arg("Curves")
          )
        .def("Knots",
             (void (GeomConvert_BSplineCurveToBezierCurve::*)( TColStd_Array1OfReal &  ) const) static_cast<void (GeomConvert_BSplineCurveToBezierCurve::*)( TColStd_Array1OfReal &  ) const>(&GeomConvert_BSplineCurveToBezierCurve::Knots),
             R"#(This methode returns the bspline's knots associated to the converted arcs Raised if the length of Curves is not equal to NbArcs + 1.)#"  , py::arg("TKnots")
          )
        .def("NbArcs",
             (Standard_Integer (GeomConvert_BSplineCurveToBezierCurve::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineCurveToBezierCurve::*)() const>(&GeomConvert_BSplineCurveToBezierCurve::NbArcs),
             R"#(Returns the number of BezierCurve arcs. If at the creation time you have decomposed the basis curve between the parametric values UFirst, ULast the number of BezierCurve arcs depends on the number of knots included inside the interval [UFirst, ULast]. If you have decomposed the whole basis B-spline curve the number of BezierCurve arcs NbArcs is equal to the number of knots less one.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_BSplineSurfaceKnotSplitting from ./opencascade/GeomConvert_BSplineSurfaceKnotSplitting.hxx
    klass = m.attr("GeomConvert_BSplineSurfaceKnotSplitting");


    // nested enums

    static_cast<py::class_<GeomConvert_BSplineSurfaceKnotSplitting , shared_ptr<GeomConvert_BSplineSurfaceKnotSplitting>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_BSplineSurface> &, const Standard_Integer, const Standard_Integer >()  , py::arg("BasisSurface"),  py::arg("UContinuityRange"),  py::arg("VContinuityRange") )
    // custom constructors
    // methods
        .def("NbUSplits",
             (Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)() const>(&GeomConvert_BSplineSurfaceKnotSplitting::NbUSplits),
             R"#(Returns the number of u-isoparametric curves along which the analysed BSpline surface should be split in order to obtain patches with the continuity required by this framework. The parameters which define these curves are knot values in the corresponding parametric direction. Note that the four curves which bound the surface are counted among these splitting curves.)#" 
          )
        .def("NbVSplits",
             (Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)() const>(&GeomConvert_BSplineSurfaceKnotSplitting::NbVSplits),
             R"#(Returns the number of v-isoparametric curves along which the analysed BSpline surface should be split in order to obtain patches with the continuity required by this framework. The parameters which define these curves are knot values in the corresponding parametric direction. Note that the four curves which bound the surface are counted among these splitting curves.)#" 
          )
        .def("Splitting",
             (void (GeomConvert_BSplineSurfaceKnotSplitting::*)( TColStd_Array1OfInteger & ,  TColStd_Array1OfInteger &  ) const) static_cast<void (GeomConvert_BSplineSurfaceKnotSplitting::*)( TColStd_Array1OfInteger & ,  TColStd_Array1OfInteger &  ) const>(&GeomConvert_BSplineSurfaceKnotSplitting::Splitting),
             R"#(Loads the USplit and VSplit tables with the split knots values computed in this framework. Each value in these tables is an index in the knots table corresponding to the u or v parametric direction of the BSpline surface analysed by this algorithm. The USplit and VSplit values are given in ascending order and comprise the indices of the knots which give the first and last isoparametric curves of the surface in the corresponding parametric direction. Use two consecutive values from the USplit table and two consecutive values from the VSplit table as arguments of the global function SplitBSplineSurface (provided by the package GeomConvert) to split the surface. Exceptions Standard_DimensionError if: - the array USplit was not created with the following bounds: - 1 , and - the number of split knots in the u parametric direction computed in this framework (as given by the function NbUSplits); or - the array VSplit was not created with the following bounds: - 1 , and - the number of split knots in the v parametric direction computed in this framework (as given by the function NbVSplits).)#"  , py::arg("USplit"),  py::arg("VSplit")
          )
        .def("USplitValue",
             (Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)(  const Standard_Integer  ) const>(&GeomConvert_BSplineSurfaceKnotSplitting::USplitValue),
             R"#(Returns the split knot of index UIndex to the split knots table for the u parametric direction computed in this framework. The returned value is an index in the knots table relative to the u parametric direction of the BSpline surface analysed by this algorithm. Note: If UIndex is equal to 1, or to the number of split knots for the u parametric direction computed in this framework, the corresponding knot gives the parameter of one of the bounding curves of the surface. Exceptions Standard_RangeError if UIndex is less than 1 or greater than the number of split knots for the u parametric direction computed in this framework.)#"  , py::arg("UIndex")
          )
        .def("VSplitValue",
             (Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceKnotSplitting::*)(  const Standard_Integer  ) const>(&GeomConvert_BSplineSurfaceKnotSplitting::VSplitValue),
             R"#(Returns the split knot of index VIndex to the split knots table for the v parametric direction computed in this framework. The returned value is an index in the knots table relative to the v parametric direction of the BSpline surface analysed by this algorithm. Note: If UIndex is equal to 1, or to the number of split knots for the v parametric direction computed in this framework, the corresponding knot gives the parameter of one of the bounding curves of the surface. Exceptions Standard_RangeError if VIndex is less than 1 or greater than the number of split knots for the v parametric direction computed in this framework.)#"  , py::arg("VIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_BSplineSurfaceToBezierSurface from ./opencascade/GeomConvert_BSplineSurfaceToBezierSurface.hxx
    klass = m.attr("GeomConvert_BSplineSurfaceToBezierSurface");


    // nested enums

    static_cast<py::class_<GeomConvert_BSplineSurfaceToBezierSurface , shared_ptr<GeomConvert_BSplineSurfaceToBezierSurface>  >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_BSplineSurface> & >()  , py::arg("BasisSurface") )
        .def(py::init<  const handle<Geom_BSplineSurface> &, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("BasisSurface"),  py::arg("U1"),  py::arg("U2"),  py::arg("V1"),  py::arg("V2"),  py::arg("ParametricTolerance") )
    // custom constructors
    // methods
        .def("Patch",
             (handle<Geom_BezierSurface> (GeomConvert_BSplineSurfaceToBezierSurface::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<handle<Geom_BezierSurface> (GeomConvert_BSplineSurfaceToBezierSurface::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&GeomConvert_BSplineSurfaceToBezierSurface::Patch),
             R"#(Constructs and returns the Bezier surface of indices (UIndex, VIndex) to the patch grid computed on the BSpline surface analyzed by this algorithm. This Bezier surface has the same orientation as the BSpline surface analyzed in this framework. UIndex is an index common to a row in the patch grid. A row in the grid corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves of the surface. VIndex is an index common to a column in the patch grid. A column in the grid corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves of the surface. Exceptions Standard_OutOfRange if: - UIndex is less than 1 or greater than the number of rows in the patch grid computed on the BSpline surface analyzed by this algorithm (as returned by the function NbUPatches); or if - VIndex is less than 1 or greater than the number of columns in the patch grid computed on the BSpline surface analyzed by this algorithm (as returned by the function NbVPatches).)#"  , py::arg("UIndex"),  py::arg("VIndex")
          )
        .def("Patches",
             (void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColGeom_Array2OfBezierSurface &  ) ) static_cast<void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColGeom_Array2OfBezierSurface &  ) >(&GeomConvert_BSplineSurfaceToBezierSurface::Patches),
             R"#(Constructs all the Bezier surfaces whose data is computed by this algorithm, and loads them into the Surfaces table. These Bezier surfaces have the same orientation as the BSpline surface analyzed in this framework. The Surfaces array is organised in the same way as the patch grid computed on the BSpline surface analyzed by this algorithm. A row in the array corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves of the surface. A column in the array corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves of the surface. Exceptions Standard_DimensionError if the Surfaces array was not created with the following bounds: - 1, and the number of adjacent patch series in the u parametric direction of the patch grid computed on the BSpline surface, analyzed by this algorithm (as given by the function NbUPatches) as row bounds, - 1, and the number of adjacent patch series in the v parametric direction of the patch grid computed on the BSpline surface, analyzed by this algorithm (as given by the function NbVPatches) as column bounds.)#"  , py::arg("Surfaces")
          )
        .def("UKnots",
             (void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColStd_Array1OfReal &  ) const) static_cast<void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColStd_Array1OfReal &  ) const>(&GeomConvert_BSplineSurfaceToBezierSurface::UKnots),
             R"#(This methode returns the bspline's u-knots associated to the converted Patches Raised if the length of Curves is not equal to NbUPatches + 1.)#"  , py::arg("TKnots")
          )
        .def("VKnots",
             (void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColStd_Array1OfReal &  ) const) static_cast<void (GeomConvert_BSplineSurfaceToBezierSurface::*)( TColStd_Array1OfReal &  ) const>(&GeomConvert_BSplineSurfaceToBezierSurface::VKnots),
             R"#(This methode returns the bspline's v-knots associated to the converted Patches Raised if the length of Curves is not equal to NbVPatches + 1.)#"  , py::arg("TKnots")
          )
        .def("NbUPatches",
             (Standard_Integer (GeomConvert_BSplineSurfaceToBezierSurface::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceToBezierSurface::*)() const>(&GeomConvert_BSplineSurfaceToBezierSurface::NbUPatches),
             R"#(Returns the number of Bezier surfaces in the U direction. If at the creation time you have decomposed the basis Surface between the parametric values UFirst, ULast the number of Bezier surfaces in the U direction depends on the number of knots included inside the interval [UFirst, ULast]. If you have decomposed the whole basis B-spline surface the number of Bezier surfaces NbUPatches is equal to the number of UKnots less one.)#" 
          )
        .def("NbVPatches",
             (Standard_Integer (GeomConvert_BSplineSurfaceToBezierSurface::*)() const) static_cast<Standard_Integer (GeomConvert_BSplineSurfaceToBezierSurface::*)() const>(&GeomConvert_BSplineSurfaceToBezierSurface::NbVPatches),
             R"#(Returns the number of Bezier surfaces in the V direction. If at the creation time you have decomposed the basis surface between the parametric values VFirst, VLast the number of Bezier surfaces in the V direction depends on the number of knots included inside the interval [VFirst, VLast]. If you have decomposed the whole basis B-spline surface the number of Bezier surfaces NbVPatches is equal to the number of VKnots less one.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_CompBezierSurfacesToBSplineSurface from ./opencascade/GeomConvert_CompBezierSurfacesToBSplineSurface.hxx
    klass = m.attr("GeomConvert_CompBezierSurfacesToBSplineSurface");


    // nested enums

    static_cast<py::class_<GeomConvert_CompBezierSurfacesToBSplineSurface , shared_ptr<GeomConvert_CompBezierSurfacesToBSplineSurface>  >>(klass)
    // constructors
        .def(py::init<  const TColGeom_Array2OfBezierSurface & >()  , py::arg("Beziers") )
        .def(py::init<  const TColGeom_Array2OfBezierSurface &, const Standard_Real, const Standard_Boolean >()  , py::arg("Beziers"),  py::arg("Tolerance"),  py::arg("RemoveKnots")=static_cast< const Standard_Boolean>(Standard_True) )
        .def(py::init<  const TColGeom_Array2OfBezierSurface &, const TColStd_Array1OfReal &, const TColStd_Array1OfReal &, const GeomAbs_Shape, const GeomAbs_Shape, const Standard_Real >()  , py::arg("Beziers"),  py::arg("UKnots"),  py::arg("VKnots"),  py::arg("UContinuity")=static_cast< const GeomAbs_Shape>(GeomAbs_C0),  py::arg("VContinuity")=static_cast< const GeomAbs_Shape>(GeomAbs_C0),  py::arg("Tolerance")=static_cast< const Standard_Real>(1.0e-4) )
    // custom constructors
    // methods
        .def("NbUKnots",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbUKnots),
             R"#(Returns the number of knots in the U direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbUPoles",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbUPoles),
             R"#(Returns number of poles in the U direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbVKnots",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbVKnots),
             R"#(Returns the number of knots in the V direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbVPoles",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbVPoles),
             R"#(Returns the number of poles in the V direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("UDegree",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UDegree),
             R"#(Returns the degree for the u parametric direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("VDegree",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VDegree),
             R"#(Returns the degree for the v parametric direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("IsDone",
             (Standard_Boolean (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Boolean (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::IsDone),
             R"#(Returns true if the conversion was successful. Unless an exception was raised at the time of construction, the conversion of the Bezier surface grid assigned to this algorithm is always carried out. IsDone returns false if the constraints defined at the time of construction cannot be respected. This occurs when there is an incompatibility between a required degree of continuity on the BSpline surface, and the maximum tolerance accepted for local deformations of the surface. In such a case the computed data does not satisfy all the initial constraints.)#" 
          )
        .def("NbUKnots",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbUKnots),
             R"#(Returns the number of knots in the U direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbUPoles",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbUPoles),
             R"#(Returns number of poles in the U direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbVKnots",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbVKnots),
             R"#(Returns the number of knots in the V direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("NbVPoles",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::NbVPoles),
             R"#(Returns the number of poles in the V direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("UDegree",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UDegree),
             R"#(Returns the degree for the u parametric direction of the BSpline surface whose data is computed in this framework.)#" 
          )
        .def("VDegree",
             (Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast<Standard_Integer (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VDegree),
             R"#(Returns the degree for the v parametric direction of the BSpline surface whose data is computed in this framework.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Poles",
             ( const handle<TColgp_HArray2OfPnt> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColgp_HArray2OfPnt> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::Poles),
             R"#(Returns the table of poles of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("UKnots",
             ( const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UKnots),
             R"#(Returns the knots table for the u parametric direction of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("VKnots",
             ( const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VKnots),
             R"#(Returns the knots table for the v parametric direction of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("UMultiplicities",
             ( const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UMultiplicities),
             R"#(Returns the multiplicities table for the u parametric direction of the knots of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("VMultiplicities",
             ( const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VMultiplicities),
             R"#(-- Returns the multiplicities table for the v parametric direction of the knots of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Poles",
             ( const handle<TColgp_HArray2OfPnt> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColgp_HArray2OfPnt> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::Poles),
             R"#(Returns the table of poles of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("UKnots",
             ( const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UKnots),
             R"#(Returns the knots table for the u parametric direction of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("VKnots",
             ( const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfReal> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VKnots),
             R"#(Returns the knots table for the v parametric direction of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("UMultiplicities",
             ( const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::UMultiplicities),
             R"#(Returns the multiplicities table for the u parametric direction of the knots of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("VMultiplicities",
             ( const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const) static_cast< const handle<TColStd_HArray1OfInteger> & (GeomConvert_CompBezierSurfacesToBSplineSurface::*)() const>(&GeomConvert_CompBezierSurfacesToBSplineSurface::VMultiplicities),
             R"#(-- Returns the multiplicities table for the v parametric direction of the knots of the BSpline surface whose data is computed in this framework.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class GeomConvert_CompCurveToBSplineCurve from ./opencascade/GeomConvert_CompCurveToBSplineCurve.hxx
    klass = m.attr("GeomConvert_CompCurveToBSplineCurve");


    // nested enums

    static_cast<py::class_<GeomConvert_CompCurveToBSplineCurve , shared_ptr<GeomConvert_CompCurveToBSplineCurve>  >>(klass)
    // constructors
        .def(py::init<  const Convert_ParameterisationType >()  , py::arg("Parameterisation")=static_cast< const Convert_ParameterisationType>(Convert_TgtThetaOver2) )
        .def(py::init<  const handle<Geom_BoundedCurve> &, const Convert_ParameterisationType >()  , py::arg("BasisCurve"),  py::arg("Parameterisation")=static_cast< const Convert_ParameterisationType>(Convert_TgtThetaOver2) )
    // custom constructors
    // methods
        .def("Add",
             (Standard_Boolean (GeomConvert_CompCurveToBSplineCurve::*)(  const handle<Geom_BoundedCurve> & ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean ,   const Standard_Integer  ) ) static_cast<Standard_Boolean (GeomConvert_CompCurveToBSplineCurve::*)(  const handle<Geom_BoundedCurve> & ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean ,   const Standard_Integer  ) >(&GeomConvert_CompCurveToBSplineCurve::Add),
             R"#(Append a curve in the BSpline Return False if the curve is not G0 with the BSplineCurve. Tolerance is used to check continuity and decrease Multiplicity at the common Knot until MinM if MinM = 0, the common Knot can be removed)#"  , py::arg("NewCurve"),  py::arg("Tolerance"),  py::arg("After")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("WithRatio")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("MinM")=static_cast< const Standard_Integer>(0)
          )
        .def("BSplineCurve",
             (handle<Geom_BSplineCurve> (GeomConvert_CompCurveToBSplineCurve::*)() const) static_cast<handle<Geom_BSplineCurve> (GeomConvert_CompCurveToBSplineCurve::*)() const>(&GeomConvert_CompCurveToBSplineCurve::BSplineCurve),
             R"#()#" 
          )
        .def("Clear",
             (void (GeomConvert_CompCurveToBSplineCurve::*)() ) static_cast<void (GeomConvert_CompCurveToBSplineCurve::*)() >(&GeomConvert_CompCurveToBSplineCurve::Clear),
             R"#(Clear a result curve)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_CurveToAnaCurve from ./opencascade/GeomConvert_CurveToAnaCurve.hxx
    klass = m.attr("GeomConvert_CurveToAnaCurve");


    // nested enums

    static_cast<py::class_<GeomConvert_CurveToAnaCurve , shared_ptr<GeomConvert_CurveToAnaCurve>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Geom_Curve> & >()  , py::arg("C") )
    // custom constructors
    // methods
        .def("Init",
             (void (GeomConvert_CurveToAnaCurve::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (GeomConvert_CurveToAnaCurve::*)(  const handle<Geom_Curve> &  ) >(&GeomConvert_CurveToAnaCurve::Init),
             R"#()#"  , py::arg("C")
          )
        .def("ConvertToAnalytical",
             (Standard_Boolean (GeomConvert_CurveToAnaCurve::*)(  const Standard_Real ,  handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (GeomConvert_CurveToAnaCurve::*)(  const Standard_Real ,  handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::ConvertToAnalytical),
             R"#(Converts me to analytical if possible with given tolerance. The new first and last parameters are returned to newF, newL)#"  , py::arg("theTol"),  py::arg("theResultCurve"),  py::arg("F"),  py::arg("L"),  py::arg("newF"),  py::arg("newL")
          )
        .def("Gap",
             (Standard_Real (GeomConvert_CurveToAnaCurve::*)() const) static_cast<Standard_Real (GeomConvert_CurveToAnaCurve::*)() const>(&GeomConvert_CurveToAnaCurve::Gap),
             R"#(Returns maximal deviation of converted surface from the original one computed by last call to ConvertToAnalytical)#" 
          )
        .def("GetConvType",
             (GeomConvert_ConvType (GeomConvert_CurveToAnaCurve::*)() const) static_cast<GeomConvert_ConvType (GeomConvert_CurveToAnaCurve::*)() const>(&GeomConvert_CurveToAnaCurve::GetConvType),
             R"#(Returns conversion type)#" 
          )
        .def("SetConvType",
             (void (GeomConvert_CurveToAnaCurve::*)(  const GeomConvert_ConvType  ) ) static_cast<void (GeomConvert_CurveToAnaCurve::*)(  const GeomConvert_ConvType  ) >(&GeomConvert_CurveToAnaCurve::SetConvType),
             R"#(Sets type of conversion)#"  , py::arg("theConvType")
          )
        .def("GetTarget",
             (GeomAbs_CurveType (GeomConvert_CurveToAnaCurve::*)() const) static_cast<GeomAbs_CurveType (GeomConvert_CurveToAnaCurve::*)() const>(&GeomConvert_CurveToAnaCurve::GetTarget),
             R"#(Returns target curve type)#" 
          )
        .def("SetTarget",
             (void (GeomConvert_CurveToAnaCurve::*)(  const GeomAbs_CurveType  ) ) static_cast<void (GeomConvert_CurveToAnaCurve::*)(  const GeomAbs_CurveType  ) >(&GeomConvert_CurveToAnaCurve::SetTarget),
             R"#(Sets target curve type)#"  , py::arg("theTarget")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ComputeCurve_s",
                    (handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real & ,   const GeomConvert_ConvType ,   const GeomAbs_CurveType  ) ) static_cast<handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real & ,   const GeomConvert_ConvType ,   const GeomAbs_CurveType  ) >(&GeomConvert_CurveToAnaCurve::ComputeCurve),
                    R"#()#"  , py::arg("curve"),  py::arg("tolerance"),  py::arg("c1"),  py::arg("c2"),  py::arg("cf"),  py::arg("cl"),  py::arg("theGap"),  py::arg("theCurvType")=static_cast< const GeomConvert_ConvType>(GeomConvert_MinGap),  py::arg("theTarget")=static_cast< const GeomAbs_CurveType>(GeomAbs_Line)
          )
        .def_static("ComputeCircle_s",
                    (handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::ComputeCircle),
                    R"#(Tries to convert the given curve to circle with given tolerance. Returns NULL curve if conversion is not possible.)#"  , py::arg("curve"),  py::arg("tolerance"),  py::arg("c1"),  py::arg("c2"),  py::arg("cf"),  py::arg("cl"),  py::arg("Deviation")
          )
        .def_static("ComputeEllipse_s",
                    (handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<handle<Geom_Curve> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::ComputeEllipse),
                    R"#(Tries to convert the given curve to ellipse with given tolerance. Returns NULL curve if conversion is not possible.)#"  , py::arg("curve"),  py::arg("tolerance"),  py::arg("c1"),  py::arg("c2"),  py::arg("cf"),  py::arg("cl"),  py::arg("Deviation")
          )
        .def_static("ComputeLine_s",
                    (handle<Geom_Line> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<handle<Geom_Line> (*)(  const handle<Geom_Curve> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::ComputeLine),
                    R"#(Tries to convert the given curve to line with given tolerance. Returns NULL curve if conversion is not possible.)#"  , py::arg("curve"),  py::arg("tolerance"),  py::arg("c1"),  py::arg("c2"),  py::arg("cf"),  py::arg("cl"),  py::arg("Deviation")
          )
        .def_static("IsLinear_s",
                    (Standard_Boolean (*)(  const TColgp_Array1OfPnt & ,   const Standard_Real ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)(  const TColgp_Array1OfPnt & ,   const Standard_Real ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::IsLinear),
                    R"#(Returns true if the set of points is linear with given tolerance)#"  , py::arg("aPoints"),  py::arg("tolerance"),  py::arg("Deviation")
          )
        .def_static("GetLine_s",
                    (gp_Lin (*)(  const gp_Pnt & ,   const gp_Pnt & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<gp_Lin (*)(  const gp_Pnt & ,   const gp_Pnt & ,  Standard_Real & ,  Standard_Real &  ) >(&GeomConvert_CurveToAnaCurve::GetLine),
                    R"#(Creates line on two points. Resulting parameters returned)#"  , py::arg("P1"),  py::arg("P2"),  py::arg("cf"),  py::arg("cl")
          )
        .def_static("GetCircle_s",
                    (Standard_Boolean (*)( gp_Circ & ,   const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt &  ) ) static_cast<Standard_Boolean (*)( gp_Circ & ,   const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt &  ) >(&GeomConvert_CurveToAnaCurve::GetCircle),
                    R"#(Creates circle on points. Returns true if OK.)#"  , py::arg("Circ"),  py::arg("P0"),  py::arg("P1"),  py::arg("P2")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_FuncConeLSDist from ./opencascade/GeomConvert_FuncConeLSDist.hxx
    klass = m.attr("GeomConvert_FuncConeLSDist");


    // nested enums

    static_cast<py::class_<GeomConvert_FuncConeLSDist , shared_ptr<GeomConvert_FuncConeLSDist>  , math_MultipleVarFunction >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<TColgp_HArray1OfXYZ> &, const gp_Dir & >()  , py::arg("thePoints"),  py::arg("theDir") )
    // custom constructors
    // methods
        .def("SetPoints",
             (void (GeomConvert_FuncConeLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) ) static_cast<void (GeomConvert_FuncConeLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) >(&GeomConvert_FuncConeLSDist::SetPoints),
             R"#()#"  , py::arg("thePoints")
          )
        .def("SetDir",
             (void (GeomConvert_FuncConeLSDist::*)(  const gp_Dir &  ) ) static_cast<void (GeomConvert_FuncConeLSDist::*)(  const gp_Dir &  ) >(&GeomConvert_FuncConeLSDist::SetDir),
             R"#()#"  , py::arg("theDir")
          )
        .def("NbVariables",
             (Standard_Integer (GeomConvert_FuncConeLSDist::*)() const) static_cast<Standard_Integer (GeomConvert_FuncConeLSDist::*)() const>(&GeomConvert_FuncConeLSDist::NbVariables),
             R"#(Number of variables.)#" 
          )
        .def("Value",
             (Standard_Boolean (GeomConvert_FuncConeLSDist::*)(  const math_Vector & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncConeLSDist::*)(  const math_Vector & ,  Standard_Real &  ) >(&GeomConvert_FuncConeLSDist::Value),
             R"#(Value.)#"  , py::arg("X"),  py::arg("F")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_FuncCylinderLSDist from ./opencascade/GeomConvert_FuncCylinderLSDist.hxx
    klass = m.attr("GeomConvert_FuncCylinderLSDist");


    // nested enums

    static_cast<py::class_<GeomConvert_FuncCylinderLSDist , shared_ptr<GeomConvert_FuncCylinderLSDist>  , math_MultipleVarFunctionWithGradient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<TColgp_HArray1OfXYZ> &, const gp_Dir & >()  , py::arg("thePoints"),  py::arg("theDir") )
    // custom constructors
    // methods
        .def("SetPoints",
             (void (GeomConvert_FuncCylinderLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) ) static_cast<void (GeomConvert_FuncCylinderLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) >(&GeomConvert_FuncCylinderLSDist::SetPoints),
             R"#()#"  , py::arg("thePoints")
          )
        .def("SetDir",
             (void (GeomConvert_FuncCylinderLSDist::*)(  const gp_Dir &  ) ) static_cast<void (GeomConvert_FuncCylinderLSDist::*)(  const gp_Dir &  ) >(&GeomConvert_FuncCylinderLSDist::SetDir),
             R"#()#"  , py::arg("theDir")
          )
        .def("NbVariables",
             (Standard_Integer (GeomConvert_FuncCylinderLSDist::*)() const) static_cast<Standard_Integer (GeomConvert_FuncCylinderLSDist::*)() const>(&GeomConvert_FuncCylinderLSDist::NbVariables),
             R"#(Number of variables.)#" 
          )
        .def("Value",
             (Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  Standard_Real &  ) >(&GeomConvert_FuncCylinderLSDist::Value),
             R"#(Value.)#"  , py::arg("X"),  py::arg("F")
          )
        .def("Gradient",
             (Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  math_Vector &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  math_Vector &  ) >(&GeomConvert_FuncCylinderLSDist::Gradient),
             R"#(Gradient.)#"  , py::arg("X"),  py::arg("G")
          )
        .def("Values",
             (Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  Standard_Real & ,  math_Vector &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncCylinderLSDist::*)(  const math_Vector & ,  Standard_Real & ,  math_Vector &  ) >(&GeomConvert_FuncCylinderLSDist::Values),
             R"#(Value and gradient.)#"  , py::arg("X"),  py::arg("F"),  py::arg("G")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_FuncSphereLSDist from ./opencascade/GeomConvert_FuncSphereLSDist.hxx
    klass = m.attr("GeomConvert_FuncSphereLSDist");


    // nested enums

    static_cast<py::class_<GeomConvert_FuncSphereLSDist , shared_ptr<GeomConvert_FuncSphereLSDist>  , math_MultipleVarFunctionWithGradient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<TColgp_HArray1OfXYZ> & >()  , py::arg("thePoints") )
    // custom constructors
    // methods
        .def("SetPoints",
             (void (GeomConvert_FuncSphereLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) ) static_cast<void (GeomConvert_FuncSphereLSDist::*)(  const handle<TColgp_HArray1OfXYZ> &  ) >(&GeomConvert_FuncSphereLSDist::SetPoints),
             R"#()#"  , py::arg("thePoints")
          )
        .def("NbVariables",
             (Standard_Integer (GeomConvert_FuncSphereLSDist::*)() const) static_cast<Standard_Integer (GeomConvert_FuncSphereLSDist::*)() const>(&GeomConvert_FuncSphereLSDist::NbVariables),
             R"#(Number of variables.)#" 
          )
        .def("Value",
             (Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  Standard_Real &  ) >(&GeomConvert_FuncSphereLSDist::Value),
             R"#(Value.)#"  , py::arg("X"),  py::arg("F")
          )
        .def("Gradient",
             (Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  math_Vector &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  math_Vector &  ) >(&GeomConvert_FuncSphereLSDist::Gradient),
             R"#(Gradient.)#"  , py::arg("X"),  py::arg("G")
          )
        .def("Values",
             (Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  Standard_Real & ,  math_Vector &  ) ) static_cast<Standard_Boolean (GeomConvert_FuncSphereLSDist::*)(  const math_Vector & ,  Standard_Real & ,  math_Vector &  ) >(&GeomConvert_FuncSphereLSDist::Values),
             R"#(Value and gradient.)#"  , py::arg("X"),  py::arg("F"),  py::arg("G")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_SurfToAnaSurf from ./opencascade/GeomConvert_SurfToAnaSurf.hxx
    klass = m.attr("GeomConvert_SurfToAnaSurf");


    // nested enums

    static_cast<py::class_<GeomConvert_SurfToAnaSurf , shared_ptr<GeomConvert_SurfToAnaSurf>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Geom_Surface> & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (GeomConvert_SurfToAnaSurf::*)(  const handle<Geom_Surface> &  ) ) static_cast<void (GeomConvert_SurfToAnaSurf::*)(  const handle<Geom_Surface> &  ) >(&GeomConvert_SurfToAnaSurf::Init),
             R"#()#"  , py::arg("S")
          )
        .def("SetConvType",
             (void (GeomConvert_SurfToAnaSurf::*)(  const GeomConvert_ConvType  ) ) static_cast<void (GeomConvert_SurfToAnaSurf::*)(  const GeomConvert_ConvType  ) >(&GeomConvert_SurfToAnaSurf::SetConvType),
             R"#()#"  , py::arg("theConvType")=static_cast< const GeomConvert_ConvType>(GeomConvert_Simplest)
          )
        .def("SetTarget",
             (void (GeomConvert_SurfToAnaSurf::*)(  const GeomAbs_SurfaceType  ) ) static_cast<void (GeomConvert_SurfToAnaSurf::*)(  const GeomAbs_SurfaceType  ) >(&GeomConvert_SurfToAnaSurf::SetTarget),
             R"#()#"  , py::arg("theSurfType")=static_cast< const GeomAbs_SurfaceType>(GeomAbs_Plane)
          )
        .def("Gap",
             (Standard_Real (GeomConvert_SurfToAnaSurf::*)() const) static_cast<Standard_Real (GeomConvert_SurfToAnaSurf::*)() const>(&GeomConvert_SurfToAnaSurf::Gap),
             R"#(Returns maximal deviation of converted surface from the original one computed by last call to ConvertToAnalytical)#" 
          )
        .def("ConvertToAnalytical",
             (handle<Geom_Surface> (GeomConvert_SurfToAnaSurf::*)(  const Standard_Real  ) ) static_cast<handle<Geom_Surface> (GeomConvert_SurfToAnaSurf::*)(  const Standard_Real  ) >(&GeomConvert_SurfToAnaSurf::ConvertToAnalytical),
             R"#(Tries to convert the Surface to an Analytic form Returns the result In case of failure, returns a Null Handle)#"  , py::arg("InitialToler")
          )
        .def("ConvertToAnalytical",
             (handle<Geom_Surface> (GeomConvert_SurfToAnaSurf::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<handle<Geom_Surface> (GeomConvert_SurfToAnaSurf::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&GeomConvert_SurfToAnaSurf::ConvertToAnalytical),
             R"#()#"  , py::arg("InitialToler"),  py::arg("Umin"),  py::arg("Umax"),  py::arg("Vmin"),  py::arg("Vmax")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsSame_s",
                    (Standard_Boolean (*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const Standard_Real  ) >(&GeomConvert_SurfToAnaSurf::IsSame),
                    R"#(Returns true if surfaces is same with the given tolerance)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("tol")
          )
        .def_static("IsCanonical_s",
                    (Standard_Boolean (*)(  const handle<Geom_Surface> &  ) ) static_cast<Standard_Boolean (*)(  const handle<Geom_Surface> &  ) >(&GeomConvert_SurfToAnaSurf::IsCanonical),
                    R"#(Returns true, if surface is canonical)#"  , py::arg("S")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomConvert_Units from ./opencascade/GeomConvert_Units.hxx
    klass = m.attr("GeomConvert_Units");

    // default constructor
    register_default_constructor<GeomConvert_Units , shared_ptr<GeomConvert_Units>>(m,"GeomConvert_Units");

    // nested enums

    static_cast<py::class_<GeomConvert_Units , shared_ptr<GeomConvert_Units>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("RadianToDegree_s",
                    (handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const Standard_Real ,   const Standard_Real  ) >(&GeomConvert_Units::RadianToDegree),
                    R"#(Convert 2d curve for change angle unit from radian to degree)#"  , py::arg("theCurve"),  py::arg("theSurface"),  py::arg("theLengthFactor"),  py::arg("theFactorRadianDegree")
          )
        .def_static("DegreeToRadian_s",
                    (handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const Standard_Real ,   const Standard_Real  ) >(&GeomConvert_Units::DegreeToRadian),
                    R"#(Convert 2d curve for change angle unit from degree to radian)#"  , py::arg("theCurve"),  py::arg("theSurface"),  py::arg("theLengthFactor"),  py::arg("theFactorRadianDegree")
          )
        .def_static("MirrorPCurve_s",
                    (handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> &  ) ) static_cast<handle<Geom2d_Curve> (*)(  const handle<Geom2d_Curve> &  ) >(&GeomConvert_Units::MirrorPCurve),
                    R"#(return 2d curve as 'mirror' for given)#"  , py::arg("theCurve")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/GeomConvert.hxx
// ./opencascade/GeomConvert_ApproxCurve.hxx
// ./opencascade/GeomConvert_ApproxSurface.hxx
// ./opencascade/GeomConvert_BSplineCurveKnotSplitting.hxx
// ./opencascade/GeomConvert_BSplineCurveToBezierCurve.hxx
// ./opencascade/GeomConvert_BSplineSurfaceKnotSplitting.hxx
// ./opencascade/GeomConvert_BSplineSurfaceToBezierSurface.hxx
// ./opencascade/GeomConvert_CompBezierSurfacesToBSplineSurface.hxx
// ./opencascade/GeomConvert_CompCurveToBSplineCurve.hxx
// ./opencascade/GeomConvert_ConvType.hxx
// ./opencascade/GeomConvert_CurveToAnaCurve.hxx
// ./opencascade/GeomConvert_FuncConeLSDist.hxx
// ./opencascade/GeomConvert_FuncCylinderLSDist.hxx
// ./opencascade/GeomConvert_FuncSphereLSDist.hxx
// ./opencascade/GeomConvert_SurfToAnaSurf.hxx
// ./opencascade/GeomConvert_Units.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
