# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class DefaultsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the DefaultsList

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsList
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsList
        """
        super(DefaultsList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }

    def get(self):
        """
        Constructs a DefaultsContext

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        """
        return DefaultsContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __call__(self):
        """
        Constructs a DefaultsContext

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        """
        return DefaultsContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.DefaultsList>'


class DefaultsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the DefaultsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsPage
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsPage
        """
        super(DefaultsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DefaultsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        return DefaultsInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.DefaultsPage>'


class DefaultsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the DefaultsContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the resource to fetch

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        """
        super(DefaultsContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }
        self._uri = '/Assistants/{assistant_sid}/Defaults'.format(**self._solution)

    def fetch(self):
        """
        Fetch the DefaultsInstance

        :returns: The fetched DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DefaultsInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def update(self, defaults=values.unset):
        """
        Update the DefaultsInstance

        :param dict defaults: A JSON string that describes the default task links.

        :returns: The updated DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        data = values.of({'Defaults': serialize.object(defaults), })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return DefaultsInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.DefaultsContext {}>'.format(context)


class DefaultsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid):
        """
        Initialize the DefaultsInstance

        :returns: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        super(DefaultsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'url': payload.get('url'),
            'data': payload.get('data'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DefaultsContext for this DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsContext
        """
        if self._context is None:
            self._context = DefaultsContext(self._version, assistant_sid=self._solution['assistant_sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The SID of the Assistant that is the parent of the resource
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Defaults resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data(self):
        """
        :returns: The JSON string that describes the default task links
        :rtype: dict
        """
        return self._properties['data']

    def fetch(self):
        """
        Fetch the DefaultsInstance

        :returns: The fetched DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        return self._proxy.fetch()

    def update(self, defaults=values.unset):
        """
        Update the DefaultsInstance

        :param dict defaults: A JSON string that describes the default task links.

        :returns: The updated DefaultsInstance
        :rtype: twilio.rest.autopilot.v1.assistant.defaults.DefaultsInstance
        """
        return self._proxy.update(defaults=defaults, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.DefaultsInstance {}>'.format(context)
