/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jd.xml.util.XmlUtil;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xpath.model.NodeName;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.XString;
import jd.xml.xpath.parser.XPathParseContext;
import jd.xml.xslt.expr.StaticExprContext;
import jd.xml.xslt.expr.SystemProperty;
import jd.xml.xslt.expr.XsltFunctionLibrary;
import jd.xml.xslt.parser.AttributeSetInfo;
import jd.xml.xslt.parser.ExcludedUris;
import jd.xml.xslt.parser.ExtensionUris;
import jd.xml.xslt.parser.GlobalVariableNames;
import jd.xml.xslt.parser.LocalVariableNames;
import jd.xml.xslt.parser.StylesheetData;
import jd.xml.xslt.parser.VariableSorter;
import jd.xml.xslt.parser.WhitespaceTest;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.pattern.Key;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.template.AttributeSet;
import jd.xml.xslt.template.CallTemplate;
import jd.xml.xslt.template.OutputFormatTemplate;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.Variable;
import jd.xml.xslt.util.XsltSortable;

public class XsltParseContext
extends XPathParseContext
implements StaticExprContext,
Cloneable {
    private boolean fcpMode_;
    private int importPrecedence_;
    private State currentState_;
    private String documentBaseUri_;
    private XsltParseContext backup_;
    private Vector templateNames_;
    private Hashtable attributeSetInfos_;
    private Vector whitespaceTests_;
    private int maxLocalParameterCount_;
    private int maxLocalVariableCount_;
    private LocalVariableNames localVariableNames_;
    private GlobalVariableNames globalVariableNames_;
    private Vector globalVariables_;
    private Vector callTemplateLocations_;
    private int nextTemplateRuleIndex_;
    private String currentParsedTemplateName_;
    private TemplateRuleList currentTemplateRuleList_;
    private TemplateRuleList defaultTemplateRuleList_;
    private Vector templateRuleLists_;
    private Hashtable namedTemplateRules_;
    private NodeName xsltNamePattern_;
    private Hashtable keys_;
    private NodeNamePool inputNamePool_;
    private NodeNamePool stylesheetNamePool_;

    public XsltParseContext() {
        super(XsltFunctionLibrary.INSTANCE);
        this.reset();
    }

    public boolean isStylesheetNode(XPathNode xPathNode) {
        return xPathNode.hasNamespaceUri(this.xsltNamePattern_);
    }

    public void initXsltNamePattern(NodeNamePool nodeNamePool) {
        this.xsltNamePattern_ = nodeNamePool.getNamePattern("http://www.w3.org/1999/XSL/Transform");
    }

    public String getBaseUri() {
        return this.currentState_.element.getBaseUri();
    }

    public void setDocumentBaseUri(String string) throws XsltParseException {
        if (string == null) {
            throw this.createException("base uri is null");
        }
        this.documentBaseUri_ = string;
    }

    public String getDocumentBaseUri() {
        return this.documentBaseUri_;
    }

    public void setVersion(String string) {
        double d = XString.toNumberValue(string);
        this.setProcessingMode(!SystemProperty.isSupportedVersion(d));
    }

    public void setProcessingMode(boolean bl) {
        this.fcpMode_ = bl;
    }

    public boolean processForwardsCompatible() {
        return this.fcpMode_;
    }

    public int getImportPrecedence() {
        return this.importPrecedence_;
    }

    public void increaseImportPrecedence() {
        ++this.importPrecedence_;
    }

    public AttributeSet getAttributeSet(String string) {
        return this.getAttributeSetInfo((String)string).attributeSet;
    }

    public AttributeSetInfo getAttributeSetInfo(String string) {
        AttributeSetInfo attributeSetInfo = null;
        if (this.attributeSetInfos_ == null) {
            this.attributeSetInfos_ = new Hashtable(10);
        } else {
            attributeSetInfo = (AttributeSetInfo)this.attributeSetInfos_.get(string);
        }
        if (attributeSetInfo == null) {
            attributeSetInfo = new AttributeSetInfo(string, this.currentState_.element);
            this.attributeSetInfos_.put(string, attributeSetInfo);
        }
        return attributeSetInfo;
    }

    private void mergeAttributeSets() throws XsltParseException {
        Object object;
        int n = this.attributeSetInfos_.size();
        AttributeSetInfo[] attributeSetInfoArray = new AttributeSetInfo[n];
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = this.attributeSetInfos_.elements();
        while (enumeration.hasMoreElements()) {
            int n4 = n3++;
            AttributeSetInfo attributeSetInfo = (AttributeSetInfo)enumeration.nextElement();
            attributeSetInfoArray[n4] = attributeSetInfo;
            object = attributeSetInfo;
            if (!((AttributeSetInfo)object).hasDefinition) {
                this.reportUndefinedAttributeSet(((AttributeSetInfo)object).expandedName, ((AttributeSetInfo)object).element);
            }
            if (((AttributeSetInfo)object).usesSets == null) continue;
            ++n2;
        }
        while (n2 > 0) {
            boolean bl = false;
            for (n3 = 0; n3 < n; ++n3) {
                object = attributeSetInfoArray[n3];
                if (((AttributeSetInfo)object).usesSets == null) continue;
                int n5 = 0;
                while (n5 < ((AttributeSetInfo)object).usesSets.size()) {
                    String string = (String)((AttributeSetInfo)object).usesSets.elementAt(n5);
                    AttributeSetInfo attributeSetInfo = (AttributeSetInfo)this.attributeSetInfos_.get(string);
                    if (attributeSetInfo == null) {
                        this.reportUndefinedAttributeSet(string, ((AttributeSetInfo)object).element);
                    }
                    if (attributeSetInfo.usesSets == null) {
                        ((AttributeSetInfo)object).attributeSet.add(attributeSetInfo.attributeSet);
                        bl = true;
                        ((AttributeSetInfo)object).usesSets.removeElementAt(n5);
                        continue;
                    }
                    ++n5;
                }
                if (((AttributeSetInfo)object).usesSets.size() != 0) continue;
                ((AttributeSetInfo)object).usesSets = null;
                --n2;
            }
            if (bl) continue;
            object = new StringBuffer();
            for (n3 = 0; n3 < n; ++n3) {
                if (attributeSetInfoArray[n3].usesSets == null) continue;
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append('\'');
                ((StringBuffer)object).append(attributeSetInfoArray[n3].expandedName);
                ((StringBuffer)object).append('\'');
            }
            throw this.createException("the attribute-sets " + object + " have circular dependency", (XPathNode)null);
        }
    }

    private void reportUndefinedAttributeSet(String string, XPathNode xPathNode) throws XsltParseException {
        throw this.createException("attribute-set '" + string + "' is not defined", xPathNode);
    }

    public void setCurrentElement(XPathNode xPathNode) throws XsltParseException {
        Object object;
        if (xPathNode == null) {
            this.currentState_.element = null;
            this.currentState_.attribute = null;
            return;
        }
        if (this.currentState_.element != null) {
            if (xPathNode.getParent() == this.currentState_.element) {
                this.currentState_ = new State(this.currentState_);
            } else {
                object = this.currentState_.getStateForElement(xPathNode);
                if (object == null) {
                    throw this.createException("cannot find element state");
                }
                this.currentState_ = xPathNode.equalsNode(((State)object).element) ? object : new State((State)object);
            }
        }
        object = xPathNode.getName();
        object = null;
        this.currentState_.element = xPathNode;
        this.currentState_.attribute = null;
        this.currentState_.sourceNsContext = xPathNode.getNamespaceContext();
        int n = xPathNode.getLocalId();
        for (NamespaceContext namespaceContext = xPathNode.getNamespaceContext(); namespaceContext != null && namespaceContext.getDeclarationId() == n; namespaceContext = namespaceContext.next()) {
            if (this.currentState_.excludedUris.isExcluded(namespaceContext.getUri())) continue;
            this.currentState_.resultNsContext = NamespaceContext.add(namespaceContext.getPrefix(), namespaceContext.getUri(), this.currentState_.resultNsContext);
        }
    }

    public XPathNode getCurrentElement() {
        return this.currentState_.element;
    }

    public void setCurrentAttribute(XPathNode xPathNode) {
        this.currentState_.attribute = xPathNode;
    }

    private void applyNamespaceTests(StylesheetData stylesheetData) {
        Object[] objectArray = null;
        if (this.whitespaceTests_ != null) {
            objectArray = new WhitespaceTest[this.whitespaceTests_.size()];
            this.whitespaceTests_.copyInto(objectArray);
            XsltSortable.sort((XsltSortable[])objectArray, objectArray.length);
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Object object = objectArray[i];
                this.inputNamePool_.setPreserveSpace(((WhitespaceTest)object).namespaceUri, ((WhitespaceTest)object).localName, ((WhitespaceTest)object).preserve);
            }
        }
        stylesheetData.setWhitespaceTests((WhitespaceTest[])objectArray);
    }

    public void addWhitespaceTest(WhitespaceTest whitespaceTest) {
        if (this.whitespaceTests_ == null) {
            this.whitespaceTests_ = new Vector();
        }
        this.whitespaceTests_.addElement(whitespaceTest);
    }

    public void templateParametersParsed(Variable[] variableArray) {
        if (variableArray.length > this.maxLocalParameterCount_) {
            this.maxLocalParameterCount_ = variableArray.length;
        }
    }

    public void addNamedTemplateRule(String string, TemplateRule templateRule) throws XsltParseException {
        TemplateRule templateRule2;
        if (this.namedTemplateRules_ == null) {
            this.namedTemplateRules_ = new Hashtable(10);
        }
        if ((templateRule2 = this.namedTemplateRules_.put(string, templateRule)) != null && templateRule2.getImportPrecedence() == templateRule.getImportPrecedence()) {
            throw this.createException("template with name '" + string + "' already defined");
        }
    }

    public int getNextTemplateRuleIndex() {
        return this.nextTemplateRuleIndex_++;
    }

    public void startParseTemplate(String string, int n) {
        this.currentParsedTemplateName_ = string;
        this.localVariableNames_.begin(n);
    }

    public void endParseTemplate() {
        if (this.localVariableNames_.size() > this.maxLocalVariableCount_) {
            this.maxLocalVariableCount_ = this.localVariableNames_.size();
        }
        this.localVariableNames_.end();
        this.currentParsedTemplateName_ = null;
    }

    public void startParseTemplateLevel() {
        this.localVariableNames_.beginLevel();
    }

    public void endParseTemplateLevel() {
        this.localVariableNames_.endLevel();
    }

    public boolean isParsingTemplate() {
        return this.localVariableNames_.level() > 0;
    }

    public void addCallTemplate(CallTemplate callTemplate, XPathNode xPathNode) {
        this.callTemplateLocations_.addElement(new Location(callTemplate, xPathNode));
    }

    public String getCurrentParsedTemplateName() {
        return this.currentParsedTemplateName_;
    }

    public TemplateRuleList getRuleList(String string) throws XsltParseException {
        if (string == null) {
            return this.defaultTemplateRuleList_;
        }
        int n = this.templateRuleLists_.size();
        for (int i = 1; i < n; ++i) {
            TemplateRuleList templateRuleList = (TemplateRuleList)this.templateRuleLists_.elementAt(i);
            if (!string.equals(templateRuleList.getMode())) continue;
            return templateRuleList;
        }
        TemplateRuleList templateRuleList = new TemplateRuleList(string);
        this.templateRuleLists_.addElement(templateRuleList);
        return templateRuleList;
    }

    public TemplateRuleList getCurrentTemplateRules() {
        return this.currentTemplateRuleList_;
    }

    public TemplateRuleList setCurrentTemplateRules(TemplateRuleList templateRuleList) {
        TemplateRuleList templateRuleList2 = this.currentTemplateRuleList_;
        this.currentTemplateRuleList_ = templateRuleList;
        return templateRuleList2;
    }

    public void setDefaultCurrentTemplateRules() {
        this.currentTemplateRuleList_ = this.defaultTemplateRuleList_;
    }

    private void setupTemplates() throws XsltParseException {
        int n;
        int n2 = this.inputNamePool_.size();
        for (n = 0; n < this.templateRuleLists_.size(); ++n) {
            ((TemplateRuleList)this.templateRuleLists_.elementAt(n)).setup(n2);
        }
        for (n = this.callTemplateLocations_.size() - 1; n >= 0; --n) {
            Location location = (Location)this.callTemplateLocations_.elementAt(n);
            CallTemplate callTemplate = (CallTemplate)location.data;
            String string = callTemplate.getTemplateName();
            TemplateRule templateRule = this.namedTemplateRules_ == null ? null : this.namedTemplateRules_.get(string);
            if (templateRule == null) {
                throw this.createException("template with name '" + string + "' does not exist", location.element);
            }
            callTemplate.setTemplateRule(templateRule);
        }
    }

    public VariableName getVariableName(String string) throws XsltParseException {
        String string2 = this.getExpandedName(string);
        VariableName variableName = null;
        if (this.isParsingTemplate()) {
            variableName = this.localVariableNames_.getName(string2);
        }
        if (variableName == null) {
            variableName = this.globalVariableNames_.getName(string2, this.currentState_.element);
        }
        return variableName;
    }

    public VariableName addVariableName(String string, int n) throws XsltParseException {
        String string2 = this.getExpandedName(string);
        VariableName variableName = n == 2 ? new VariableName(string2, -1, false) : (this.isParsingTemplate() ? this.localVariableNames_.addName(string2, n == 1) : this.globalVariableNames_.addName(string2, this.importPrecedence_));
        if (variableName == null) {
            throw this.createException("variable '" + string + "' already defined");
        }
        return variableName;
    }

    public void addGlobalVariable(Variable variable) throws XsltParseException {
        int n;
        if (this.globalVariables_ == null) {
            this.globalVariables_ = new Vector();
        }
        if ((n = variable.getVariableName().getIndex()) >= this.globalVariables_.size()) {
            this.globalVariables_.setSize(n + 1);
        }
        this.globalVariables_.setElementAt(variable, n);
    }

    private Variable[] getGlobalVariables() throws XsltParseException {
        this.globalVariableNames_.checkPreliminariesResolved();
        if (this.globalVariables_ == null) {
            return Variable.EMPTY_LIST;
        }
        Object[] objectArray = new Variable[this.globalVariables_.size()];
        this.globalVariables_.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasLocalVariables() {
        return this.localVariableNames_.size() > 0;
    }

    public NodeNamePool getNodeNamePool() {
        return this.inputNamePool_;
    }

    void setStylesheetNamePool(NodeNamePool nodeNamePool) {
        this.stylesheetNamePool_ = nodeNamePool;
    }

    public String setExcludedNamespace(String string) throws XsltParseException {
        String string2;
        String string3 = string2 = string.length() == 0 ? this.getNamespaceUri(string) : this.getCheckedNamespaceUri(string);
        if (string2 != null) {
            this.currentState_.resultNsContext = NamespaceContext.remove(string, this.currentState_.resultNsContext);
            this.currentState_.excludedUris = ExcludedUris.add(string2, this.currentState_.excludedUris);
        }
        return string2;
    }

    public void setExtensionNamespace(String string) throws XsltParseException {
        String string2 = this.setExcludedNamespace(string);
        if (string2 != null) {
            this.currentState_.extensionUris = ExtensionUris.add(string2, this.currentState_.extensionUris);
        }
    }

    public boolean isExtensionNamespaceUri(String string) {
        return this.currentState_.extensionUris != null && this.currentState_.extensionUris.contains(string);
    }

    public void checkLiteralNamespace(String string, String string2) {
        if (this.currentState_.excludedUris.isExcluded(string2)) {
            ExcludedUris.remove(string2, this.currentState_.excludedUris);
            if (string == null) {
                string = "";
            }
            this.currentState_.resultNsContext = NamespaceContext.add(string, string2, this.currentState_.resultNsContext);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this.currentState_.sourceNsContext;
    }

    public NamespaceContext getResultNamespaceContext() {
        return this.currentState_.resultNsContext;
    }

    public String getExpandedName(String string) throws XsltParseException {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        String string2 = this.getNamespaceUri(string.substring(0, n));
        return string2 + ':' + string.substring(n + 1);
    }

    public String getNamespaceUri(String string) {
        String string2;
        String string3 = string2 = this.currentState_.sourceNsContext == null ? null : this.currentState_.sourceNsContext.getUri(string);
        if (string2 == null && string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return string2;
    }

    public String getCheckedNamespaceUri(String string) throws XsltParseException {
        String string2 = this.getNamespaceUri(string);
        if (string2 == null) {
            throw this.createException("no namespace defined for prefix '" + string + "'");
        }
        return string2;
    }

    public void addKey(String string, Pattern pattern, Expression expression) {
        Key key;
        if (this.keys_ == null) {
            this.keys_ = new Hashtable(5);
        }
        if ((key = (Key)this.keys_.get(string)) != null) {
            key.addNext(new Key(pattern, expression, key.getIndex()));
        } else {
            Key key2 = new Key(pattern, expression, this.keys_.size());
            this.keys_.put(string, key2);
        }
    }

    public void addCDataSectionElements(String string, OutputFormatTemplate outputFormatTemplate) throws XsltParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = XmlUtil.getPrefix(string2);
            String string4 = string3 != null ? this.getCheckedNamespaceUri(string3) : this.getNamespaceUri("");
            String string5 = string4 != null ? XmlUtil.getLocalPart(string2) : string2;
            outputFormatTemplate.addCDataSectionElement(string4, string5);
            this.inputNamePool_.setCDataSectionName(string4, string5, string2);
            this.stylesheetNamePool_.setCDataSectionName(string4, string5, string2);
        }
    }

    private XPathNode getContextNode() {
        if (this.currentState_.attribute != null) {
            return this.currentState_.attribute;
        }
        if (this.currentState_.element != null) {
            return this.currentState_.element;
        }
        return null;
    }

    public XsltParseException createException(String string) {
        return this.createException(string, this.getContextNode(), null);
    }

    public XsltParseException createException(String string, Exception exception) {
        return this.createException(string, this.getContextNode(), exception);
    }

    public XsltParseException createException(String string, XPathNode xPathNode) {
        return this.createException(string, xPathNode, null);
    }

    public XsltParseException createException(String string, XPathNode xPathNode, Exception exception) {
        return xPathNode == null ? new XsltParseException(string, this.documentBaseUri_, exception) : new XsltParseException(string, xPathNode, exception);
    }

    public void beginInclude(String string) throws XsltParseException {
        if (string != null) {
            XsltParseContext xsltParseContext = this;
            while (xsltParseContext != null) {
                if (string.equals(xsltParseContext.documentBaseUri_)) {
                    throw this.createException("'" + string + "' includes directly or indirectly itself");
                }
                xsltParseContext = xsltParseContext.backup_;
            }
        }
        this.backup_ = (XsltParseContext)this.clone();
        this.currentState_ = new State();
        this.templateNames_ = null;
        this.setDocumentBaseUri(string);
    }

    public void endInclude() {
        if (this.backup_ == null) {
            throw new IllegalStateException("context backup stack is empty");
        }
        this.currentState_ = this.backup_.currentState_;
        this.documentBaseUri_ = this.backup_.documentBaseUri_;
        this.fcpMode_ = this.backup_.fcpMode_;
        this.templateNames_ = this.backup_.templateNames_;
        this.backup_ = this.backup_.backup_;
    }

    public void reset() {
        this.documentBaseUri_ = null;
        this.fcpMode_ = false;
        this.backup_ = null;
        this.importPrecedence_ = 0;
        this.templateNames_ = null;
        this.attributeSetInfos_ = null;
        this.currentState_ = new State();
        this.inputNamePool_ = new NodeNamePool();
        this.localVariableNames_ = new LocalVariableNames();
        this.globalVariableNames_ = new GlobalVariableNames();
        this.maxLocalVariableCount_ = 0;
        this.maxLocalParameterCount_ = 0;
        this.callTemplateLocations_ = new Vector();
        this.nextTemplateRuleIndex_ = 0;
        this.namedTemplateRules_ = null;
        this.templateRuleLists_ = new Vector();
        this.currentTemplateRuleList_ = this.defaultTemplateRuleList_ = new TemplateRuleList(null);
        this.keys_ = null;
        this.templateRuleLists_.addElement(this.defaultTemplateRuleList_);
    }

    public void finish(StylesheetData stylesheetData) throws XsltParseException {
        stylesheetData.setMaxLocalVariableCount(this.maxLocalVariableCount_);
        stylesheetData.setMaxLocalParameterCount(this.maxLocalParameterCount_);
        VariableSorter variableSorter = new VariableSorter();
        variableSorter.sort(this, this.getGlobalVariables());
        stylesheetData.setGlobalVariables(variableSorter.getSortedVariables(), variableSorter.firstUnClassifiedGlobalVar());
        this.applyNamespaceTests(stylesheetData);
        this.inputNamePool_.seal();
        stylesheetData.setNodeNamePool(this.inputNamePool_);
        this.setupTemplates();
        stylesheetData.setTemplateRules(this.templateRuleLists_, this.namedTemplateRules_);
        if (this.attributeSetInfos_ != null) {
            this.mergeAttributeSets();
        }
        stylesheetData.setKeys(this.keys_);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static class Location {
        XPathNode element;
        Object data;

        public Location(Object object, XPathNode xPathNode) {
            this.element = xPathNode;
            this.data = object;
        }
    }

    private static class State {
        XPathNode element;
        XPathNode attribute;
        NamespaceContext sourceNsContext;
        NamespaceContext resultNsContext;
        ExcludedUris excludedUris;
        ExtensionUris extensionUris;
        State next_;

        public State() {
            this.excludedUris = ExcludedUris.add("http://www.w3.org/1999/XSL/Transform", null);
        }

        public State(State state) {
            this.next_ = state;
            this.sourceNsContext = state.sourceNsContext;
            this.resultNsContext = state.resultNsContext;
            this.excludedUris = state.excludedUris;
            this.extensionUris = state.extensionUris;
        }

        public State getStateForElement(XPathNode xPathNode) {
            XPathNode xPathNode2 = xPathNode;
            while (xPathNode2.getType() != 3) {
                State state = this;
                do {
                    if (!xPathNode2.equalsNode(state.element)) continue;
                    return state;
                } while ((state = state.next_) != null);
                xPathNode2 = xPathNode2.getParent();
            }
            return null;
        }
    }
}

