/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.plugins.cache;

/**
 * Default cache factory - legacy mock.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class DefaultCacheFactory implements CacheFactory
{
   public String createFqn(Object owner)
   {
      // no need for fqn
      return null;
   }

   public <K, V> Cache<K, V> createCache(Class<K> keyClass, Class<V> valueClass, String rootFqn)
   {
      return new ConcurrentHashMapCache<K,V>();
   }

   public <V> CacheItem<V> createCacheItem(Class<V> valueClass, String rootFqn)
   {
      return new InMemoryCacheItem<V>();
   }

   /**
    * Simple in memory item.
    */
   private class InMemoryCacheItem<V> implements CacheItem<V>
   {
      private V value;

      public V put(V value)
      {
         V oldValue = this.value;
         this.value = value;
         return oldValue;
      }

      public V get()
      {
         return value;
      }

      public void clear()
      {
         value = null;
      }
   }
}
