# Boost.Scope

Boost.Scope provides a number of scope guard utilities and a `unique_resource` wrapper, similar to those described in
[C++ Extensions for Library Fundamentals, Version 3](https://github.com/cplusplus/fundamentals-ts/releases/tag/n4908),
Section 3.3 Scope guard support \[scopeguard\]. The implementation also provides a few non-standard extensions.

### Directories

* **doc** - QuickBook documentation sources
* **include** - Interface headers of Boost.Scope
* **test** - Boost.Scope unit tests

### More information

* Read the [documentation](https://www.boost.org/libs/scope/).
* [Report bugs](https://github.com/boostorg/scope/issues/new). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as [pull requests](https://github.com/boostorg/scope/compare) against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Build status

Branch          | GitHub Actions | AppVeyor | Test Matrix | Dependencies |
:-------------: | -------------- | -------- | ----------- | ------------ |
[`master`](https://github.com/boostorg/scope/tree/master) | [![GitHub Actions](https://github.com/boostorg/scope/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/scope/actions?query=branch%3Amaster) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/7dr1fo39o27subn1/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/scope/branch/master) | [![Tests](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://regression.boost.io/master/developer/scope.html) | [![Dependencies](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/scope.html)
[`develop`](https://github.com/boostorg/scope/tree/develop) | [![GitHub Actions](https://github.com/boostorg/scope/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/scope/actions?query=branch%3Adevelop) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/7dr1fo39o27subn1/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/scope/branch/develop) | [![Tests](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://regression.boost.io/develop/developer/scope.html) | [![Dependencies](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/scope.html)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
