<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: google/protobuf/duration.proto

namespace Google\Protobuf;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * A Duration represents a signed, fixed-length span of time represented
 * as a count of seconds and fractions of seconds at nanosecond
 * resolution. It is independent of any calendar and concepts like "day"
 * or "month". It is related to Timestamp in that the difference between
 * two Timestamp values is a Duration and it can be added or subtracted
 * from a Timestamp. Range is approximately +-10,000 years.
 * # Examples
 * Example 1: Compute Duration from two Timestamps in pseudo code.
 *     Timestamp start = ...;
 *     Timestamp end = ...;
 *     Duration duration = ...;
 *     duration.seconds = end.seconds - start.seconds;
 *     duration.nanos = end.nanos - start.nanos;
 *     if (duration.seconds < 0 && duration.nanos > 0) {
 *       duration.seconds += 1;
 *       duration.nanos -= 1000000000;
 *     } else if (duration.seconds > 0 && duration.nanos < 0) {
 *       duration.seconds -= 1;
 *       duration.nanos += 1000000000;
 *     }
 * Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.
 *     Timestamp start = ...;
 *     Duration duration = ...;
 *     Timestamp end = ...;
 *     end.seconds = start.seconds + duration.seconds;
 *     end.nanos = start.nanos + duration.nanos;
 *     if (end.nanos < 0) {
 *       end.seconds -= 1;
 *       end.nanos += 1000000000;
 *     } else if (end.nanos >= 1000000000) {
 *       end.seconds += 1;
 *       end.nanos -= 1000000000;
 *     }
 * Example 3: Compute Duration from datetime.timedelta in Python.
 *     td = datetime.timedelta(days=3, minutes=10)
 *     duration = Duration()
 *     duration.FromTimedelta(td)
 * # JSON Mapping
 * In JSON format, the Duration type is encoded as a string rather than an
 * object, where the string ends in the suffix "s" (indicating seconds) and
 * is preceded by the number of seconds, with nanoseconds expressed as
 * fractional seconds. For example, 3 seconds with 0 nanoseconds should be
 * encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
 * be expressed in JSON format as "3.000000001s", and 3 seconds and 1
 * microsecond should be expressed in JSON format as "3.000001s".
 *
 * Generated from protobuf message <code>google.protobuf.Duration</code>
 */
class Duration extends \Google\Protobuf\Internal\Message
{
    /**
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Generated from protobuf field <code>int64 seconds = 1;</code>
     */
    protected $seconds = 0;
    /**
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     *
     * Generated from protobuf field <code>int32 nanos = 2;</code>
     */
    protected $nanos = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $seconds
     *           Signed seconds of the span of time. Must be from -315,576,000,000
     *           to +315,576,000,000 inclusive. Note: these bounds are computed from:
     *           60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *     @type int $nanos
     *           Signed fractions of a second at nanosecond resolution of the span
     *           of time. Durations less than one second are represented with a 0
     *           `seconds` field and a positive or negative `nanos` field. For durations
     *           of one second or more, a non-zero value for the `nanos` field must be
     *           of the same sign as the `seconds` field. Must be from -999,999,999
     *           to +999,999,999 inclusive.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Protobuf\Duration::initOnce();
        parent::__construct($data);
    }

    /**
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Generated from protobuf field <code>int64 seconds = 1;</code>
     * @return int|string
     */
    public function getSeconds()
    {
        return $this->seconds;
    }

    /**
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Generated from protobuf field <code>int64 seconds = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSeconds(int|string $var)
    {
        GPBUtil::checkInt64($var);
        $this->seconds = $var;

        return $this;
    }

    /**
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     *
     * Generated from protobuf field <code>int32 nanos = 2;</code>
     * @return int
     */
    public function getNanos()
    {
        return $this->nanos;
    }

    /**
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     *
     * Generated from protobuf field <code>int32 nanos = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setNanos(int $var)
    {
        GPBUtil::checkInt32($var);
        $this->nanos = $var;

        return $this;
    }

}

