// Copyright 2015-2025 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_STRUCTS_HPP
#define VULKAN_STRUCTS_HPP

// include-what-you-use: make sure, vulkan.hpp is used by code-completers
// IWYU pragma: private; include "vulkan.hpp"

#include <cstring>  // strcmp

namespace VULKAN_HPP_NAMESPACE
{

  //===============
  //=== STRUCTS ===
  //===============

  struct AabbPositionsKHR
  {
    using NativeType = VkAabbPositionsKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AabbPositionsKHR( float minX_ = {}, float minY_ = {}, float minZ_ = {}, float maxX_ = {}, float maxY_ = {}, float maxZ_ = {} ) VULKAN_HPP_NOEXCEPT
      : minX{ minX_ }
      , minY{ minY_ }
      , minZ{ minZ_ }
      , maxX{ maxX_ }
      , maxY{ maxY_ }
      , maxZ{ maxZ_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AabbPositionsKHR( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT : AabbPositionsKHR( *reinterpret_cast<AabbPositionsKHR const *>( &rhs ) ) {}

    AabbPositionsKHR & operator=( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AabbPositionsKHR & operator=( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AabbPositionsKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinX( float minX_ ) VULKAN_HPP_NOEXCEPT
    {
      minX = minX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinY( float minY_ ) VULKAN_HPP_NOEXCEPT
    {
      minY = minY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinZ( float minZ_ ) VULKAN_HPP_NOEXCEPT
    {
      minZ = minZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxX( float maxX_ ) VULKAN_HPP_NOEXCEPT
    {
      maxX = maxX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxY( float maxY_ ) VULKAN_HPP_NOEXCEPT
    {
      maxY = maxY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxZ( float maxZ_ ) VULKAN_HPP_NOEXCEPT
    {
      maxZ = maxZ_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAabbPositionsKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAabbPositionsKHR *>( this );
    }

    operator VkAabbPositionsKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAabbPositionsKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( minX, minY, minZ, maxX, maxY, maxZ );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AabbPositionsKHR const & ) const = default;
#else
    bool operator==( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( minX == rhs.minX ) && ( minY == rhs.minY ) && ( minZ == rhs.minZ ) && ( maxX == rhs.maxX ) && ( maxY == rhs.maxY ) && ( maxZ == rhs.maxZ );
#  endif
    }

    bool operator!=( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float minX = {};
    float minY = {};
    float minZ = {};
    float maxX = {};
    float maxY = {};
    float maxZ = {};
  };

  using AabbPositionsNV = AabbPositionsKHR;

  union DeviceOrHostAddressConstKHR
  {
    using NativeType = VkDeviceOrHostAddressConstKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( const void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setHostAddress( const void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkDeviceOrHostAddressConstKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressConstKHR *>( this );
    }

    operator VkDeviceOrHostAddressConstKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressConstKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    const void *                        hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    const void *                                    hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryTrianglesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryTrianglesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryTrianglesDataKHR( VULKAN_HPP_NAMESPACE::Format                      vertexFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_   = {},
                                                     VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride_ = {},
                                                     uint32_t                                          maxVertex_    = {},
                                                     VULKAN_HPP_NAMESPACE::IndexType                   indexType_    = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData_    = {},
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData_ = {},
                                                     const void *                                      pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , maxVertex{ maxVertex_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , transformData{ transformData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryTrianglesDataKHR( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryTrianglesDataKHR( *reinterpret_cast<AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryTrianglesDataKHR & operator=( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryTrianglesDataKHR & operator=( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setMaxVertex( uint32_t maxVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      maxVertex = maxVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setIndexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setTransformData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryTrianglesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryTrianglesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexFormat, vertexData, vertexStride, maxVertex, indexType, indexData, transformData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType         = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;
    const void *                                      pNext         = {};
    VULKAN_HPP_NAMESPACE::Format                      vertexFormat  = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride  = {};
    uint32_t                                          maxVertex     = {};
    VULKAN_HPP_NAMESPACE::IndexType                   indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData     = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryTrianglesDataKHR>
  {
    using Type = AccelerationStructureGeometryTrianglesDataKHR;
  };

  struct AccelerationStructureGeometryAabbsDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryAabbsDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_   = {},
                                                                       VULKAN_HPP_NAMESPACE::DeviceSize                  stride_ = {},
                                                                       const void *                                      pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , data{ data_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryAabbsDataKHR( *reinterpret_cast<AccelerationStructureGeometryAabbsDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryAabbsDataKHR & operator=( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryAabbsDataKHR & operator=( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR &
      setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setStride( VULKAN_HPP_NAMESPACE::DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryAabbsDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryAabbsDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, data, stride );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;
    const void *                                      pNext  = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  stride = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryAabbsDataKHR>
  {
    using Type = AccelerationStructureGeometryAabbsDataKHR;
  };

  struct AccelerationStructureGeometryInstancesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryInstancesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryInstancesDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR( VULKAN_HPP_NAMESPACE::Bool32                      arrayOfPointers_ = {},
                                                                           VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_            = {},
                                                                           const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , arrayOfPointers{ arrayOfPointers_ }
      , data{ data_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryInstancesDataKHR( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryInstancesDataKHR( *reinterpret_cast<AccelerationStructureGeometryInstancesDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryInstancesDataKHR & operator=( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryInstancesDataKHR & operator=( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
      setArrayOfPointers( VULKAN_HPP_NAMESPACE::Bool32 arrayOfPointers_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayOfPointers = arrayOfPointers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
      setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryInstancesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryInstancesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, arrayOfPointers, data );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType           = StructureType::eAccelerationStructureGeometryInstancesDataKHR;
    const void *                                      pNext           = {};
    VULKAN_HPP_NAMESPACE::Bool32                      arrayOfPointers = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data            = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryInstancesDataKHR>
  {
    using Type = AccelerationStructureGeometryInstancesDataKHR;
  };

  union AccelerationStructureGeometryDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryDataKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles_ = {} )
      : triangles( triangles_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR aabbs_ ) : aabbs( aabbs_ ) {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances_ )
      : instances( instances_ )
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setTriangles( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setAabbs( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setInstances( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const & instances_ ) VULKAN_HPP_NOEXCEPT
    {
      instances = instances_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryDataKHR const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryDataKHR &()
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryDataKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR     aabbs;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances;
#else
    VkAccelerationStructureGeometryTrianglesDataKHR triangles;
    VkAccelerationStructureGeometryAabbsDataKHR     aabbs;
    VkAccelerationStructureGeometryInstancesDataKHR instances;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryKHR
  {
    using NativeType = VkAccelerationStructureGeometryKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryKHR( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
                                        VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry_ = {},
                                        VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags_    = {},
                                        const void *                                               pNext_    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , geometryType{ geometryType_ }
      , geometry{ geometry_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryKHR( *reinterpret_cast<AccelerationStructureGeometryKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryKHR & operator=( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryKHR & operator=( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR &
      setGeometry( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryKHR *>( this );
    }

    operator VkAccelerationStructureGeometryKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::GeometryTypeKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR const &,
               VULKAN_HPP_NAMESPACE::GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType        = StructureType::eAccelerationStructureGeometryKHR;
    const void *                                               pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR                      geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry     = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryKHR>
  {
    using Type = AccelerationStructureGeometryKHR;
  };

  union DeviceOrHostAddressKHR
  {
    using NativeType = VkDeviceOrHostAddressKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setHostAddress( void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkDeviceOrHostAddressKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressKHR *>( this );
    }

    operator VkDeviceOrHostAddressKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    void *                              hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    void *                                          hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureBuildGeometryInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildGeometryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildGeometryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                     type_  = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR               flags_ = {},
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                mode_  = VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure_ = {},
      uint32_t                                                               geometryCount_            = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries_              = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_             = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData_              = {},
      const void *                                                           pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , flags{ flags_ }
      , mode{ mode_ }
      , srcAccelerationStructure{ srcAccelerationStructure_ }
      , dstAccelerationStructure{ dstAccelerationStructure_ }
      , geometryCount{ geometryCount_ }
      , pGeometries{ pGeometries_ }
      , ppGeometries{ ppGeometries_ }
      , scratchData{ scratchData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildGeometryInfoKHR( *reinterpret_cast<AccelerationStructureBuildGeometryInfoKHR const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                                                                          type_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR                                                                    flags_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                                                                     mode_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                                                                              srcAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                                                                              dstAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const &         geometries_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                                                                                scratchData_ = {},
      const void *                                                                                                                pNext_       = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( static_cast<uint32_t>( !geometries_.empty() ? geometries_.size() : pGeometries_.size() ) )
      , pGeometries( geometries_.data() )
      , ppGeometries( pGeometries_.data() )
      , scratchData( scratchData_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !geometries_.empty() + !pGeometries_.empty() ) <= 1 );
#    else
      if ( 1 < ( !geometries_.empty() + !pGeometries_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureBuildGeometryInfoKHR::AccelerationStructureBuildGeometryInfoKHR: 1 < ( !geometries_.empty() + !pGeometries_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureBuildGeometryInfoKHR & operator=( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildGeometryInfoKHR & operator=( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setMode( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setSrcAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setDstAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dstAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructure = dstAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR & setGeometries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setPpGeometries( const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      ppGeometries = ppGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ )
        VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( pGeometries_.size() );
      ppGeometries  = pGeometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setScratchData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureBuildGeometryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildGeometryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const &,
               const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, type, flags, mode, srcAccelerationStructure, dstAccelerationStructure, geometryCount, pGeometries, ppGeometries, scratchData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                    sType = StructureType::eAccelerationStructureBuildGeometryInfoKHR;
    const void *                                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                     type  = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR               flags = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                mode  = VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild;
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure = {};
    uint32_t                                                               geometryCount            = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries              = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries             = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData              = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildGeometryInfoKHR>
  {
    using Type = AccelerationStructureBuildGeometryInfoKHR;
  };

  struct AccelerationStructureBuildRangeInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildRangeInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( uint32_t primitiveCount_  = {},
                                                                 uint32_t primitiveOffset_ = {},
                                                                 uint32_t firstVertex_     = {},
                                                                 uint32_t transformOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : primitiveCount{ primitiveCount_ }
      , primitiveOffset{ primitiveOffset_ }
      , firstVertex{ firstVertex_ }
      , transformOffset{ transformOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildRangeInfoKHR( *reinterpret_cast<AccelerationStructureBuildRangeInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureBuildRangeInfoKHR & operator=( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildRangeInfoKHR & operator=( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveCount( uint32_t primitiveCount_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveCount = primitiveCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveOffset( uint32_t primitiveOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveOffset = primitiveOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setFirstVertex( uint32_t firstVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstVertex = firstVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setTransformOffset( uint32_t transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureBuildRangeInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildRangeInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( primitiveCount, primitiveOffset, firstVertex, transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildRangeInfoKHR const & ) const = default;
#else
    bool                                            operator==( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( primitiveCount == rhs.primitiveCount ) && ( primitiveOffset == rhs.primitiveOffset ) && ( firstVertex == rhs.firstVertex ) &&
             ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t primitiveCount  = {};
    uint32_t primitiveOffset = {};
    uint32_t firstVertex     = {};
    uint32_t transformOffset = {};
  };

  struct AccelerationStructureBuildSizesInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildSizesInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildSizesInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( VULKAN_HPP_NAMESPACE::DeviceSize accelerationStructureSize_ = {},
                                                                 VULKAN_HPP_NAMESPACE::DeviceSize updateScratchSize_         = {},
                                                                 VULKAN_HPP_NAMESPACE::DeviceSize buildScratchSize_          = {},
                                                                 const void *                     pNext_                     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructureSize{ accelerationStructureSize_ }
      , updateScratchSize{ updateScratchSize_ }
      , buildScratchSize{ buildScratchSize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildSizesInfoKHR( *reinterpret_cast<AccelerationStructureBuildSizesInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureBuildSizesInfoKHR & operator=( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildSizesInfoKHR & operator=( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR const *>( &rhs );
      return *this;
    }

    operator VkAccelerationStructureBuildSizesInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildSizesInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructureSize, updateScratchSize, buildScratchSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildSizesInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructureSize == rhs.accelerationStructureSize ) &&
             ( updateScratchSize == rhs.updateScratchSize ) && ( buildScratchSize == rhs.buildScratchSize );
#  endif
    }

    bool operator!=( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                     = StructureType::eAccelerationStructureBuildSizesInfoKHR;
    const void *                        pNext                     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    accelerationStructureSize = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    updateScratchSize         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    buildScratchSize          = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildSizesInfoKHR>
  {
    using Type = AccelerationStructureBuildSizesInfoKHR;
  };

  struct AccelerationStructureCaptureDescriptorDataInfoEXT
  {
    using NativeType = VkAccelerationStructureCaptureDescriptorDataInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCaptureDescriptorDataInfoEXT( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_   = {},
                                                                            VULKAN_HPP_NAMESPACE::AccelerationStructureNV  accelerationStructureNV_ = {},
                                                                            const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
      , accelerationStructureNV{ accelerationStructureNV_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureCaptureDescriptorDataInfoEXT( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCaptureDescriptorDataInfoEXT( VkAccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCaptureDescriptorDataInfoEXT( *reinterpret_cast<AccelerationStructureCaptureDescriptorDataInfoEXT const *>( &rhs ) )
    {
    }

    AccelerationStructureCaptureDescriptorDataInfoEXT &
      operator=( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCaptureDescriptorDataInfoEXT & operator=( VkAccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCaptureDescriptorDataInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT &
      setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT &
      setAccelerationStructureNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructureNV_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureNV = accelerationStructureNV_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure, accelerationStructureNV );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCaptureDescriptorDataInfoEXT const & ) const = default;
#else
    bool operator==( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure ) &&
             ( accelerationStructureNV == rhs.accelerationStructureNV );
#  endif
    }

    bool operator!=( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                   = StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT;
    const void *                                   pNext                   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV  accelerationStructureNV = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT>
  {
    using Type = AccelerationStructureCaptureDescriptorDataInfoEXT;
  };

  struct AccelerationStructureCreateInfoKHR
  {
    using NativeType = VkAccelerationStructureCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_   = {},
      VULKAN_HPP_NAMESPACE::Buffer                              buffer_        = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          offset_        = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          size_          = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type_          = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
      VULKAN_HPP_NAMESPACE::DeviceAddress                       deviceAddress_ = {},
      const void *                                              pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , createFlags{ createFlags_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
      , type{ type_ }
      , deviceAddress{ deviceAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoKHR( *reinterpret_cast<AccelerationStructureCreateInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureCreateInfoKHR & operator=( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCreateInfoKHR & operator=( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
      setCreateFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      createFlags = createFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoKHR *>( this );
    }

    operator VkAccelerationStructureCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createFlags, buffer, offset, size, type, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createFlags == rhs.createFlags ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) &&
             ( size == rhs.size ) && ( type == rhs.type ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                       sType         = StructureType::eAccelerationStructureCreateInfoKHR;
    const void *                                              pNext         = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags   = {};
    VULKAN_HPP_NAMESPACE::Buffer                              buffer        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          offset        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          size          = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type          = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::DeviceAddress                       deviceAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoKHR>
  {
    using Type = AccelerationStructureCreateInfoKHR;
  };

  struct GeometryTrianglesNV
  {
    using NativeType = VkGeometryTrianglesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryTrianglesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( VULKAN_HPP_NAMESPACE::Buffer     vertexData_      = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_    = {},
                                              uint32_t                         vertexCount_     = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_    = {},
                                              VULKAN_HPP_NAMESPACE::Format     vertexFormat_    = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                              VULKAN_HPP_NAMESPACE::Buffer     indexData_       = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_     = {},
                                              uint32_t                         indexCount_      = {},
                                              VULKAN_HPP_NAMESPACE::IndexType  indexType_       = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                              VULKAN_HPP_NAMESPACE::Buffer     transformData_   = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ = {},
                                              const void *                     pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexData{ vertexData_ }
      , vertexOffset{ vertexOffset_ }
      , vertexCount{ vertexCount_ }
      , vertexStride{ vertexStride_ }
      , vertexFormat{ vertexFormat_ }
      , indexData{ indexData_ }
      , indexOffset{ indexOffset_ }
      , indexCount{ indexCount_ }
      , indexType{ indexType_ }
      , transformData{ transformData_ }
      , transformOffset{ transformOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryTrianglesNV( *reinterpret_cast<GeometryTrianglesNV const *>( &rhs ) )
    {
    }

    GeometryTrianglesNV & operator=( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryTrianglesNV & operator=( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexData( VULKAN_HPP_NAMESPACE::Buffer vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexOffset( VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexOffset = vertexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexData( VULKAN_HPP_NAMESPACE::Buffer indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexOffset( VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      indexOffset = indexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexCount( uint32_t indexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      indexCount = indexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformData( VULKAN_HPP_NAMESPACE::Buffer transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformOffset( VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryTrianglesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryTrianglesNV *>( this );
    }

    operator VkGeometryTrianglesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryTrianglesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexData,
                       vertexOffset,
                       vertexCount,
                       vertexStride,
                       vertexFormat,
                       indexData,
                       indexOffset,
                       indexCount,
                       indexType,
                       transformData,
                       transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryTrianglesNV const & ) const = default;
#else
    bool operator==( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexData == rhs.vertexData ) && ( vertexOffset == rhs.vertexOffset ) &&
             ( vertexCount == rhs.vertexCount ) && ( vertexStride == rhs.vertexStride ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( indexData == rhs.indexData ) && ( indexOffset == rhs.indexOffset ) && ( indexCount == rhs.indexCount ) && ( indexType == rhs.indexType ) &&
             ( transformData == rhs.transformData ) && ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eGeometryTrianglesNV;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::Buffer        vertexData      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexOffset    = {};
    uint32_t                            vertexCount     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexStride    = {};
    VULKAN_HPP_NAMESPACE::Format        vertexFormat    = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer        indexData       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    indexOffset     = {};
    uint32_t                            indexCount      = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType       = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::Buffer        transformData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    transformOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryTrianglesNV>
  {
    using Type = GeometryTrianglesNV;
  };

  struct GeometryAABBNV
  {
    using NativeType = VkGeometryAABBNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryAabbNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryAABBNV( VULKAN_HPP_NAMESPACE::Buffer     aabbData_ = {},
                                         uint32_t                         numAABBs_ = {},
                                         uint32_t                         stride_   = {},
                                         VULKAN_HPP_NAMESPACE::DeviceSize offset_   = {},
                                         const void *                     pNext_    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , aabbData{ aabbData_ }
      , numAABBs{ numAABBs_ }
      , stride{ stride_ }
      , offset{ offset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryAABBNV( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryAABBNV( *reinterpret_cast<GeometryAABBNV const *>( &rhs ) ) {}

    GeometryAABBNV & operator=( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryAABBNV & operator=( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryAABBNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setAabbData( VULKAN_HPP_NAMESPACE::Buffer aabbData_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbData = aabbData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setNumAABBs( uint32_t numAABBs_ ) VULKAN_HPP_NOEXCEPT
    {
      numAABBs = numAABBs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryAABBNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryAABBNV *>( this );
    }

    operator VkGeometryAABBNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryAABBNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, aabbData, numAABBs, stride, offset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryAABBNV const & ) const = default;
#else
    bool operator==( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( aabbData == rhs.aabbData ) && ( numAABBs == rhs.numAABBs ) && ( stride == rhs.stride ) &&
             ( offset == rhs.offset );
#  endif
    }

    bool operator!=( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eGeometryAabbNV;
    const void *                        pNext    = {};
    VULKAN_HPP_NAMESPACE::Buffer        aabbData = {};
    uint32_t                            numAABBs = {};
    uint32_t                            stride   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryAabbNV>
  {
    using Type = GeometryAABBNV;
  };

  struct GeometryDataNV
  {
    using NativeType = VkGeometryDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryDataNV( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles_ = {},
                                         VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs_     = {} ) VULKAN_HPP_NOEXCEPT
      : triangles{ triangles_ }
      , aabbs{ aabbs_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryDataNV( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryDataNV( *reinterpret_cast<GeometryDataNV const *>( &rhs ) ) {}

    GeometryDataNV & operator=( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryDataNV & operator=( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setTriangles( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setAabbs( VULKAN_HPP_NAMESPACE::GeometryAABBNV const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryDataNV *>( this );
    }

    operator VkGeometryDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const &, VULKAN_HPP_NAMESPACE::GeometryAABBNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( triangles, aabbs );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryDataNV const & ) const = default;
#else
    bool operator==( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( triangles == rhs.triangles ) && ( aabbs == rhs.aabbs );
#  endif
    }

    bool operator!=( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles = {};
    VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs     = {};
  };

  struct GeometryNV
  {
    using NativeType = VkGeometryNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryNV( VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
                                     VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry_     = {},
                                     VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_        = {},
                                     const void *                           pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , geometryType{ geometryType_ }
      , geometry{ geometry_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryNV( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryNV( *reinterpret_cast<GeometryNV const *>( &rhs ) ) {}

    GeometryNV & operator=( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryNV & operator=( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometry( VULKAN_HPP_NAMESPACE::GeometryDataNV const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryNV *>( this );
    }

    operator VkGeometryNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::GeometryTypeKHR const &,
               VULKAN_HPP_NAMESPACE::GeometryDataNV const &,
               VULKAN_HPP_NAMESPACE::GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryNV const & ) const = default;
#else
    bool operator==( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( geometryType == rhs.geometryType ) && ( geometry == rhs.geometry ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType        = StructureType::eGeometryNV;
    const void *                           pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry     = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryNV>
  {
    using Type = GeometryNV;
  };

  struct AccelerationStructureInfoNV
  {
    using NativeType = VkAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type_          = {},
                                                      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_         = {},
                                                      uint32_t                                                instanceCount_ = {},
                                                      uint32_t                                                geometryCount_ = {},
                                                      const VULKAN_HPP_NAMESPACE::GeometryNV *                pGeometries_   = {},
                                                      const void *                                            pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , flags{ flags_ }
      , instanceCount{ instanceCount_ }
      , geometryCount{ geometryCount_ }
      , pGeometries{ pGeometries_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInfoNV( *reinterpret_cast<AccelerationStructureInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV                                             type_,
                                 VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV                                       flags_,
                                 uint32_t                                                                                      instanceCount_,
                                 VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_,
                                 const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( static_cast<uint32_t>( geometries_.size() ) )
      , pGeometries( geometries_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureInfoNV & operator=( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureInfoNV & operator=( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPGeometries( const VULKAN_HPP_NAMESPACE::GeometryNV * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV &
      setGeometries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInfoNV *>( this );
    }

    operator VkAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::GeometryNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, flags, instanceCount, geometryCount, pGeometries );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( flags == rhs.flags ) && ( instanceCount == rhs.instanceCount ) &&
             ( geometryCount == rhs.geometryCount ) && ( pGeometries == rhs.pGeometries );
#  endif
    }

    bool operator!=( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType         = StructureType::eAccelerationStructureInfoNV;
    const void *                                            pNext         = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type          = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags         = {};
    uint32_t                                                instanceCount = {};
    uint32_t                                                geometryCount = {};
    const VULKAN_HPP_NAMESPACE::GeometryNV *                pGeometries   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureInfoNV>
  {
    using Type = AccelerationStructureInfoNV;
  };

  struct AccelerationStructureCreateInfoNV
  {
    using NativeType = VkAccelerationStructureCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize_ = {},
                                                            VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info_          = {},
                                                            const void *                                      pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , compactedSize{ compactedSize_ }
      , info{ info_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoNV( *reinterpret_cast<AccelerationStructureCreateInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureCreateInfoNV & operator=( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCreateInfoNV & operator=( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setCompactedSize( VULKAN_HPP_NAMESPACE::DeviceSize compactedSize_ ) VULKAN_HPP_NOEXCEPT
    {
      compactedSize = compactedSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setInfo( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const & info_ ) VULKAN_HPP_NOEXCEPT
    {
      info = info_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoNV *>( this );
    }

    operator VkAccelerationStructureCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, compactedSize, info );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( compactedSize == rhs.compactedSize ) && ( info == rhs.info );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType         = StructureType::eAccelerationStructureCreateInfoNV;
    const void *                                      pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info          = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoNV>
  {
    using Type = AccelerationStructureCreateInfoNV;
  };

  struct AccelerationStructureDeviceAddressInfoKHR
  {
    using NativeType = VkAccelerationStructureDeviceAddressInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureDeviceAddressInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ = {},
                                                                    const void *                                   pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureDeviceAddressInfoKHR( *reinterpret_cast<AccelerationStructureDeviceAddressInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureDeviceAddressInfoKHR & operator=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureDeviceAddressInfoKHR & operator=( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR &
      setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureDeviceAddressInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    operator VkAccelerationStructureDeviceAddressInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureDeviceAddressInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                 = StructureType::eAccelerationStructureDeviceAddressInfoKHR;
    const void *                                   pNext                 = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureDeviceAddressInfoKHR>
  {
    using Type = AccelerationStructureDeviceAddressInfoKHR;
  };

  struct AccelerationStructureGeometryLinearSweptSpheresDataNV
  {
    using NativeType = VkAccelerationStructureGeometryLinearSweptSpheresDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV(
      VULKAN_HPP_NAMESPACE::Format                              vertexFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         vertexData_   = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          vertexStride_ = {},
      VULKAN_HPP_NAMESPACE::Format                              radiusFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         radiusData_   = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          radiusStride_ = {},
      VULKAN_HPP_NAMESPACE::IndexType                           indexType_    = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         indexData_    = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          indexStride_  = {},
      VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV         indexingMode_ = VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV::eList,
      VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV endCapsMode_  = VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV::eNone,
      const void *                                              pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , radiusFormat{ radiusFormat_ }
      , radiusData{ radiusData_ }
      , radiusStride{ radiusStride_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , indexStride{ indexStride_ }
      , indexingMode{ indexingMode_ }
      , endCapsMode{ endCapsMode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryLinearSweptSpheresDataNV( AccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryLinearSweptSpheresDataNV( VkAccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryLinearSweptSpheresDataNV( *reinterpret_cast<AccelerationStructureGeometryLinearSweptSpheresDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryLinearSweptSpheresDataNV &
      operator=( AccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryLinearSweptSpheresDataNV & operator=( VkAccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryLinearSweptSpheresDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setRadiusFormat( VULKAN_HPP_NAMESPACE::Format radiusFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusFormat = radiusFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setRadiusData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & radiusData_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusData = radiusData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setRadiusStride( VULKAN_HPP_NAMESPACE::DeviceSize radiusStride_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusStride = radiusStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexStride( VULKAN_HPP_NAMESPACE::DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexingMode( VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV indexingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      indexingMode = indexingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setEndCapsMode( VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV endCapsMode_ ) VULKAN_HPP_NOEXCEPT
    {
      endCapsMode = endCapsMode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV const &,
               VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexFormat,
                       vertexData,
                       vertexStride,
                       radiusFormat,
                       radiusData,
                       radiusStride,
                       indexType,
                       indexData,
                       indexStride,
                       indexingMode,
                       endCapsMode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                       sType        = StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV;
    const void *                                              pNext        = {};
    VULKAN_HPP_NAMESPACE::Format                              vertexFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         vertexData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          vertexStride = {};
    VULKAN_HPP_NAMESPACE::Format                              radiusFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         radiusData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          radiusStride = {};
    VULKAN_HPP_NAMESPACE::IndexType                           indexType    = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR         indexData    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          indexStride  = {};
    VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV         indexingMode = VULKAN_HPP_NAMESPACE::RayTracingLssIndexingModeNV::eList;
    VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV endCapsMode  = VULKAN_HPP_NAMESPACE::RayTracingLssPrimitiveEndCapsModeNV::eNone;
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV>
  {
    using Type = AccelerationStructureGeometryLinearSweptSpheresDataNV;
  };

  struct AccelerationStructureGeometryMotionTrianglesDataNV
  {
    using NativeType = VkAccelerationStructureGeometryMotionTrianglesDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_ = {},
                                                                                const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexData{ vertexData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryMotionTrianglesDataNV( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryMotionTrianglesDataNV( *reinterpret_cast<AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryMotionTrianglesDataNV &
      operator=( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryMotionTrianglesDataNV & operator=( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType      = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;
    const void *                                      pNext      = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV>
  {
    using Type = AccelerationStructureGeometryMotionTrianglesDataNV;
  };

  struct AccelerationStructureGeometrySpheresDataNV
  {
    using NativeType = VkAccelerationStructureGeometrySpheresDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometrySpheresDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV( VULKAN_HPP_NAMESPACE::Format vertexFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                                        VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_   = {},
                                                                        VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride_ = {},
                                                                        VULKAN_HPP_NAMESPACE::Format radiusFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                                        VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR radiusData_   = {},
                                                                        VULKAN_HPP_NAMESPACE::DeviceSize                  radiusStride_ = {},
                                                                        VULKAN_HPP_NAMESPACE::IndexType indexType_ = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                                                        VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData_   = {},
                                                                        VULKAN_HPP_NAMESPACE::DeviceSize                  indexStride_ = {},
                                                                        const void *                                      pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , radiusFormat{ radiusFormat_ }
      , radiusData{ radiusData_ }
      , radiusStride{ radiusStride_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , indexStride{ indexStride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV( AccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometrySpheresDataNV( VkAccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometrySpheresDataNV( *reinterpret_cast<AccelerationStructureGeometrySpheresDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometrySpheresDataNV & operator=( AccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometrySpheresDataNV & operator=( VkAccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometrySpheresDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setRadiusFormat( VULKAN_HPP_NAMESPACE::Format radiusFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusFormat = radiusFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV &
      setRadiusData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & radiusData_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusData = radiusData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setRadiusStride( VULKAN_HPP_NAMESPACE::DeviceSize radiusStride_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusStride = radiusStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV &
      setIndexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setIndexStride( VULKAN_HPP_NAMESPACE::DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometrySpheresDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometrySpheresDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexFormat, vertexData, vertexStride, radiusFormat, radiusData, radiusStride, indexType, indexData, indexStride );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType        = StructureType::eAccelerationStructureGeometrySpheresDataNV;
    const void *                                      pNext        = {};
    VULKAN_HPP_NAMESPACE::Format                      vertexFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride = {};
    VULKAN_HPP_NAMESPACE::Format                      radiusFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR radiusData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  radiusStride = {};
    VULKAN_HPP_NAMESPACE::IndexType                   indexType    = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  indexStride  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometrySpheresDataNV>
  {
    using Type = AccelerationStructureGeometrySpheresDataNV;
  };

  struct TransformMatrixKHR
  {
    using NativeType = VkTransformMatrixKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( std::array<std::array<float, 4>, 3> const & matrix_ = {} ) VULKAN_HPP_NOEXCEPT : matrix{ matrix_ } {}

    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT : TransformMatrixKHR( *reinterpret_cast<TransformMatrixKHR const *>( &rhs ) ) {}

    TransformMatrixKHR & operator=( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    TransformMatrixKHR & operator=( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR & setMatrix( std::array<std::array<float, 4>, 3> matrix_ ) VULKAN_HPP_NOEXCEPT
    {
      matrix = matrix_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkTransformMatrixKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkTransformMatrixKHR *>( this );
    }

    operator VkTransformMatrixKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkTransformMatrixKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ArrayWrapper2D<float, 3, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( matrix );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( TransformMatrixKHR const & ) const = default;
#else
    bool operator==( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( matrix == rhs.matrix );
#  endif
    }

    bool operator!=( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ArrayWrapper2D<float, 3, 4> matrix = {};
  };

  using TransformMatrixNV = TransformMatrixKHR;

  struct AccelerationStructureInstanceKHR
  {
    using NativeType = VkAccelerationStructureInstanceKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( VULKAN_HPP_NAMESPACE::TransformMatrixKHR       transform_                              = {},
                                                              uint32_t                                       instanceCustomIndex_                    = {},
                                                              uint32_t                                       mask_                                   = {},
                                                              uint32_t                                       instanceShaderBindingTableRecordOffset_ = {},
                                                              VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                                  = {},
                                                              uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transform{ transform_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInstanceKHR( *reinterpret_cast<AccelerationStructureInstanceKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureInstanceKHR & operator=( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureInstanceKHR & operator=( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setTransform( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureInstanceKHR & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureInstanceKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInstanceKHR *>( this );
    }

    operator VkAccelerationStructureInstanceKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInstanceKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transform, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInstanceKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transform == rhs.transform ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) && ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transform = {};
    uint32_t                                 instanceCustomIndex                    : 24;
    uint32_t                                 mask                                   : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags                                  : 8;
    uint64_t                                 accelerationStructureReference = {};
  };

  using AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;

  struct AccelerationStructureMatrixMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMatrixMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV( VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0_                            = {},
                                                                         VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1_                            = {},
                                                                         uint32_t                                 instanceCustomIndex_                    = {},
                                                                         uint32_t                                 mask_                                   = {},
                                                                         uint32_t                                 instanceShaderBindingTableRecordOffset_ = {},
                                                                         VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                            = {},
                                                                         uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0{ transformT0_ }
      , transformT1{ transformT1_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureMatrixMotionInstanceNV( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMatrixMotionInstanceNV( *reinterpret_cast<AccelerationStructureMatrixMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMatrixMotionInstanceNV & operator=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMatrixMotionInstanceNV & operator=( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setTransformT0( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setTransformT1( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureMatrixMotionInstanceNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMatrixMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMatrixMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMatrixMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0 = {};
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1 = {};
    uint32_t                                 instanceCustomIndex                    : 24;
    uint32_t                                 mask                                   : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags                                  : 8;
    uint64_t                                 accelerationStructureReference = {};
  };

  struct AccelerationStructureMemoryRequirementsInfoNV
  {
    using NativeType = VkAccelerationStructureMemoryRequirementsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMemoryRequirementsInfoNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ = VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject,
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV                       accelerationStructure_ = {},
      const void *                                                        pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , accelerationStructure{ accelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureMemoryRequirementsInfoNV( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMemoryRequirementsInfoNV( *reinterpret_cast<AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMemoryRequirementsInfoNV & operator=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMemoryRequirementsInfoNV & operator=( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
      setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
      setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMemoryRequirementsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    operator VkAccelerationStructureMemoryRequirementsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMemoryRequirementsInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                 sType = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;
    const void *                                                        pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type  = VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject;
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV                       accelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMemoryRequirementsInfoNV>
  {
    using Type = AccelerationStructureMemoryRequirementsInfoNV;
  };

  struct AccelerationStructureMotionInfoNV
  {
    using NativeType = VkAccelerationStructureMotionInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMotionInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( uint32_t                                                     maxInstances_ = {},
                                                            VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_        = {},
                                                            const void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxInstances{ maxInstances_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInfoNV( *reinterpret_cast<AccelerationStructureMotionInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMotionInfoNV & operator=( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMotionInfoNV & operator=( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setMaxInstances( uint32_t maxInstances_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstances = maxInstances_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV &
      setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInfoNV *>( this );
    }

    operator VkAccelerationStructureMotionInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxInstances, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMotionInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInstances == rhs.maxInstances ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType        = StructureType::eAccelerationStructureMotionInfoNV;
    const void *                                                 pNext        = {};
    uint32_t                                                     maxInstances = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMotionInfoNV>
  {
    using Type = AccelerationStructureMotionInfoNV;
  };

  struct SRTDataNV
  {
    using NativeType = VkSRTDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SRTDataNV( float sx_  = {},
                                    float a_   = {},
                                    float b_   = {},
                                    float pvx_ = {},
                                    float sy_  = {},
                                    float c_   = {},
                                    float pvy_ = {},
                                    float sz_  = {},
                                    float pvz_ = {},
                                    float qx_  = {},
                                    float qy_  = {},
                                    float qz_  = {},
                                    float qw_  = {},
                                    float tx_  = {},
                                    float ty_  = {},
                                    float tz_  = {} ) VULKAN_HPP_NOEXCEPT
      : sx{ sx_ }
      , a{ a_ }
      , b{ b_ }
      , pvx{ pvx_ }
      , sy{ sy_ }
      , c{ c_ }
      , pvy{ pvy_ }
      , sz{ sz_ }
      , pvz{ pvz_ }
      , qx{ qx_ }
      , qy{ qy_ }
      , qz{ qz_ }
      , qw{ qw_ }
      , tx{ tx_ }
      , ty{ ty_ }
      , tz{ tz_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SRTDataNV( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : SRTDataNV( *reinterpret_cast<SRTDataNV const *>( &rhs ) ) {}

    SRTDataNV & operator=( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SRTDataNV & operator=( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SRTDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSx( float sx_ ) VULKAN_HPP_NOEXCEPT
    {
      sx = sx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setA( float a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setB( float b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvx( float pvx_ ) VULKAN_HPP_NOEXCEPT
    {
      pvx = pvx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSy( float sy_ ) VULKAN_HPP_NOEXCEPT
    {
      sy = sy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setC( float c_ ) VULKAN_HPP_NOEXCEPT
    {
      c = c_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvy( float pvy_ ) VULKAN_HPP_NOEXCEPT
    {
      pvy = pvy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSz( float sz_ ) VULKAN_HPP_NOEXCEPT
    {
      sz = sz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvz( float pvz_ ) VULKAN_HPP_NOEXCEPT
    {
      pvz = pvz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQx( float qx_ ) VULKAN_HPP_NOEXCEPT
    {
      qx = qx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQy( float qy_ ) VULKAN_HPP_NOEXCEPT
    {
      qy = qy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQz( float qz_ ) VULKAN_HPP_NOEXCEPT
    {
      qz = qz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQw( float qw_ ) VULKAN_HPP_NOEXCEPT
    {
      qw = qw_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTx( float tx_ ) VULKAN_HPP_NOEXCEPT
    {
      tx = tx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTy( float ty_ ) VULKAN_HPP_NOEXCEPT
    {
      ty = ty_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTz( float tz_ ) VULKAN_HPP_NOEXCEPT
    {
      tz = tz_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSRTDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSRTDataNV *>( this );
    }

    operator VkSRTDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSRTDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sx, a, b, pvx, sy, c, pvy, sz, pvz, qx, qy, qz, qw, tx, ty, tz );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SRTDataNV const & ) const = default;
#else
    bool operator==( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sx == rhs.sx ) && ( a == rhs.a ) && ( b == rhs.b ) && ( pvx == rhs.pvx ) && ( sy == rhs.sy ) && ( c == rhs.c ) && ( pvy == rhs.pvy ) &&
             ( sz == rhs.sz ) && ( pvz == rhs.pvz ) && ( qx == rhs.qx ) && ( qy == rhs.qy ) && ( qz == rhs.qz ) && ( qw == rhs.qw ) && ( tx == rhs.tx ) &&
             ( ty == rhs.ty ) && ( tz == rhs.tz );
#  endif
    }

    bool operator!=( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float sx  = {};
    float a   = {};
    float b   = {};
    float pvx = {};
    float sy  = {};
    float c   = {};
    float pvy = {};
    float sz  = {};
    float pvz = {};
    float qx  = {};
    float qy  = {};
    float qz  = {};
    float qw  = {};
    float tx  = {};
    float ty  = {};
    float tz  = {};
  };

  struct AccelerationStructureSRTMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureSRTMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( VULKAN_HPP_NAMESPACE::SRTDataNV                transformT0_                            = {},
                                                                   VULKAN_HPP_NAMESPACE::SRTDataNV                transformT1_                            = {},
                                                                   uint32_t                                       instanceCustomIndex_                    = {},
                                                                   uint32_t                                       mask_                                   = {},
                                                                   uint32_t                                       instanceShaderBindingTableRecordOffset_ = {},
                                                                   VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                                  = {},
                                                                   uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0{ transformT0_ }
      , transformT1{ transformT1_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureSRTMotionInstanceNV( *reinterpret_cast<AccelerationStructureSRTMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureSRTMotionInstanceNV & operator=( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureSRTMotionInstanceNV & operator=( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setTransformT0( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setTransformT1( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureSRTMotionInstanceNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureSRTMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureSRTMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::SRTDataNV const &,
               VULKAN_HPP_NAMESPACE::SRTDataNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureSRTMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT0 = {};
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT1 = {};
    uint32_t                        instanceCustomIndex                    : 24;
    uint32_t                        mask                                   : 8;
    uint32_t                        instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR      flags                                  : 8;
    uint64_t                        accelerationStructureReference = {};
  };

  union AccelerationStructureMotionInstanceDataNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceDataNV;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR staticInstance_ = {} )
      : staticInstance( staticInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance_ )
      : matrixMotionInstance( matrixMotionInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV srtMotionInstance_ )
      : srtMotionInstance( srtMotionInstance_ )
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setStaticInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const & staticInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      staticInstance = staticInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setMatrixMotionInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const & matrixMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      matrixMotionInstance = matrixMotionInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setSrtMotionInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const & srtMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      srtMotionInstance = srtMotionInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInstanceDataNV const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceDataNV &()
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR            staticInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#else
    VkAccelerationStructureInstanceKHR            staticInstance;
    VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VkAccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV  type_  = VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic,
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data_  = {} ) VULKAN_HPP_NOEXCEPT
      : type{ type_ }
      , flags{ flags_ }
      , data{ data_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInstanceNV( *reinterpret_cast<AccelerationStructureMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMotionInstanceNV & operator=( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMotionInstanceNV & operator=( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setData( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( type, flags, data );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV  type  = VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data  = {};
  };

  struct MicromapUsageEXT
  {
    using NativeType = VkMicromapUsageEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MicromapUsageEXT( uint32_t count_ = {}, uint32_t subdivisionLevel_ = {}, uint32_t format_ = {} ) VULKAN_HPP_NOEXCEPT
      : count{ count_ }
      , subdivisionLevel{ subdivisionLevel_ }
      , format{ format_ }
    {
    }

    VULKAN_HPP_CONSTEXPR MicromapUsageEXT( MicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MicromapUsageEXT( VkMicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT : MicromapUsageEXT( *reinterpret_cast<MicromapUsageEXT const *>( &rhs ) ) {}

    MicromapUsageEXT & operator=( MicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    MicromapUsageEXT & operator=( VkMicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::MicromapUsageEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setCount( uint32_t count_ ) VULKAN_HPP_NOEXCEPT
    {
      count = count_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setSubdivisionLevel( uint32_t subdivisionLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      subdivisionLevel = subdivisionLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setFormat( uint32_t format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkMicromapUsageEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMicromapUsageEXT *>( this );
    }

    operator VkMicromapUsageEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMicromapUsageEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( count, subdivisionLevel, format );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MicromapUsageEXT const & ) const = default;
#else
    bool                                          operator==( MicromapUsageEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( count == rhs.count ) && ( subdivisionLevel == rhs.subdivisionLevel ) && ( format == rhs.format );
#  endif
    }

    bool operator!=( MicromapUsageEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t count            = {};
    uint32_t subdivisionLevel = {};
    uint32_t format           = {};
  };

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  struct AccelerationStructureTrianglesDisplacementMicromapNV
  {
    using NativeType = VkAccelerationStructureTrianglesDisplacementMicromapNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV(
      VULKAN_HPP_NAMESPACE::Format                           displacementBiasAndScaleFormat_        = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::Format                           displacementVectorFormat_              = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacementBiasAndScaleBuffer_        = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                       displacementBiasAndScaleStride_        = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacementVectorBuffer_              = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                       displacementVectorStride_              = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacedMicromapPrimitiveFlags_       = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                       displacedMicromapPrimitiveFlagsStride_ = {},
      VULKAN_HPP_NAMESPACE::IndexType                        indexType_                             = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      indexBuffer_                           = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                       indexStride_                           = {},
      uint32_t                                               baseTriangle_                          = {},
      uint32_t                                               usageCountsCount_                      = {},
      const VULKAN_HPP_NAMESPACE::MicromapUsageEXT *         pUsageCounts_                          = {},
      const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts_                         = {},
      VULKAN_HPP_NAMESPACE::MicromapEXT                      micromap_                              = {},
      void *                                                 pNext_                                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displacementBiasAndScaleFormat{ displacementBiasAndScaleFormat_ }
      , displacementVectorFormat{ displacementVectorFormat_ }
      , displacementBiasAndScaleBuffer{ displacementBiasAndScaleBuffer_ }
      , displacementBiasAndScaleStride{ displacementBiasAndScaleStride_ }
      , displacementVectorBuffer{ displacementVectorBuffer_ }
      , displacementVectorStride{ displacementVectorStride_ }
      , displacedMicromapPrimitiveFlags{ displacedMicromapPrimitiveFlags_ }
      , displacedMicromapPrimitiveFlagsStride{ displacedMicromapPrimitiveFlagsStride_ }
      , indexType{ indexType_ }
      , indexBuffer{ indexBuffer_ }
      , indexStride{ indexStride_ }
      , baseTriangle{ baseTriangle_ }
      , usageCountsCount{ usageCountsCount_ }
      , pUsageCounts{ pUsageCounts_ }
      , ppUsageCounts{ ppUsageCounts_ }
      , micromap{ micromap_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureTrianglesDisplacementMicromapNV( AccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureTrianglesDisplacementMicromapNV( VkAccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureTrianglesDisplacementMicromapNV( *reinterpret_cast<AccelerationStructureTrianglesDisplacementMicromapNV const *>( &rhs ) )
    {
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV(
      VULKAN_HPP_NAMESPACE::Format                                                                                displacementBiasAndScaleFormat_,
      VULKAN_HPP_NAMESPACE::Format                                                                                displacementVectorFormat_,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR                                                           displacementBiasAndScaleBuffer_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                                                            displacementBiasAndScaleStride_,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR                                                           displacementVectorBuffer_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                                                            displacementVectorStride_,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR                                                           displacedMicromapPrimitiveFlags_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                                                            displacedMicromapPrimitiveFlagsStride_,
      VULKAN_HPP_NAMESPACE::IndexType                                                                             indexType_,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR                                                           indexBuffer_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                                                            indexStride_,
      uint32_t                                                                                                    baseTriangle_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT> const &         usageCounts_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const> const & pUsageCounts_ = {},
      VULKAN_HPP_NAMESPACE::MicromapEXT                                                                           micromap_     = {},
      void *                                                                                                      pNext_        = nullptr )
      : pNext( pNext_ )
      , displacementBiasAndScaleFormat( displacementBiasAndScaleFormat_ )
      , displacementVectorFormat( displacementVectorFormat_ )
      , displacementBiasAndScaleBuffer( displacementBiasAndScaleBuffer_ )
      , displacementBiasAndScaleStride( displacementBiasAndScaleStride_ )
      , displacementVectorBuffer( displacementVectorBuffer_ )
      , displacementVectorStride( displacementVectorStride_ )
      , displacedMicromapPrimitiveFlags( displacedMicromapPrimitiveFlags_ )
      , displacedMicromapPrimitiveFlagsStride( displacedMicromapPrimitiveFlagsStride_ )
      , indexType( indexType_ )
      , indexBuffer( indexBuffer_ )
      , indexStride( indexStride_ )
      , baseTriangle( baseTriangle_ )
      , usageCountsCount( static_cast<uint32_t>( usageCounts_.size() ) )
      , pUsageCounts( usageCounts_.data() )
      , ppUsageCounts( pUsageCounts_.data() )
      , micromap( micromap_ )
    {
#      ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( usageCounts_.empty() || pUsageCounts_.empty() || ( usageCounts_.size() == pUsageCounts_.size() ) );
#      else
      if ( !usageCounts_.empty() && !pUsageCounts_.empty() && ( usageCounts_.size() != pUsageCounts_.size() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureTrianglesDisplacementMicromapNV::AccelerationStructureTrianglesDisplacementMicromapNV: !usageCounts_.empty() && !pUsageCounts_.empty() && ( usageCounts_.size() != pUsageCounts_.size() )" );
      }
#      endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureTrianglesDisplacementMicromapNV &
      operator=( AccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureTrianglesDisplacementMicromapNV & operator=( VkAccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureTrianglesDisplacementMicromapNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleFormat( VULKAN_HPP_NAMESPACE::Format displacementBiasAndScaleFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleFormat = displacementBiasAndScaleFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorFormat( VULKAN_HPP_NAMESPACE::Format displacementVectorFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorFormat = displacementVectorFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleBuffer( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & displacementBiasAndScaleBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleBuffer = displacementBiasAndScaleBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleStride( VULKAN_HPP_NAMESPACE::DeviceSize displacementBiasAndScaleStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleStride = displacementBiasAndScaleStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorBuffer( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & displacementVectorBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorBuffer = displacementVectorBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorStride( VULKAN_HPP_NAMESPACE::DeviceSize displacementVectorStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorStride = displacementVectorStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacedMicromapPrimitiveFlags( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & displacedMicromapPrimitiveFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      displacedMicromapPrimitiveFlags = displacedMicromapPrimitiveFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacedMicromapPrimitiveFlagsStride( VULKAN_HPP_NAMESPACE::DeviceSize displacedMicromapPrimitiveFlagsStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacedMicromapPrimitiveFlagsStride = displacedMicromapPrimitiveFlagsStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setIndexStride( VULKAN_HPP_NAMESPACE::DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setBaseTriangle( uint32_t baseTriangle_ ) VULKAN_HPP_NOEXCEPT
    {
      baseTriangle = baseTriangle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setUsageCountsCount( uint32_t usageCountsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = usageCountsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setPUsageCounts( const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pUsageCounts = pUsageCounts_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV &
      setUsageCounts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT> const & usageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( usageCounts_.size() );
      pUsageCounts     = usageCounts_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setPpUsageCounts( const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      ppUsageCounts = ppUsageCounts_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV & setPUsageCounts(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const> const & pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( pUsageCounts_.size() );
      ppUsageCounts    = pUsageCounts_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setMicromap( VULKAN_HPP_NAMESPACE::MicromapEXT micromap_ ) VULKAN_HPP_NOEXCEPT
    {
      micromap = micromap_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const &,
               const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       displacementBiasAndScaleFormat,
                       displacementVectorFormat,
                       displacementBiasAndScaleBuffer,
                       displacementBiasAndScaleStride,
                       displacementVectorBuffer,
                       displacementVectorStride,
                       displacedMicromapPrimitiveFlags,
                       displacedMicromapPrimitiveFlagsStride,
                       indexType,
                       indexBuffer,
                       indexStride,
                       baseTriangle,
                       usageCountsCount,
                       pUsageCounts,
                       ppUsageCounts,
                       micromap );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV;
    void *                                                 pNext = {};
    VULKAN_HPP_NAMESPACE::Format                           displacementBiasAndScaleFormat        = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Format                           displacementVectorFormat              = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacementBiasAndScaleBuffer        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                       displacementBiasAndScaleStride        = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacementVectorBuffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                       displacementVectorStride              = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      displacedMicromapPrimitiveFlags       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                       displacedMicromapPrimitiveFlagsStride = {};
    VULKAN_HPP_NAMESPACE::IndexType                        indexType                             = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      indexBuffer                           = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                       indexStride                           = {};
    uint32_t                                               baseTriangle                          = {};
    uint32_t                                               usageCountsCount                      = {};
    const VULKAN_HPP_NAMESPACE::MicromapUsageEXT *         pUsageCounts                          = {};
    const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts                         = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT                      micromap                              = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV>
  {
    using Type = AccelerationStructureTrianglesDisplacementMicromapNV;
  };
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  struct AccelerationStructureTrianglesOpacityMicromapEXT
  {
    using NativeType = VkAccelerationStructureTrianglesOpacityMicromapEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureTrianglesOpacityMicromapEXT( VULKAN_HPP_NAMESPACE::IndexType                   indexType_ = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                                        VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexBuffer_        = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceSize                  indexStride_        = {},
                                                        uint32_t                                          baseTriangle_       = {},
                                                        uint32_t                                          usageCountsCount_   = {},
                                                        const VULKAN_HPP_NAMESPACE::MicromapUsageEXT *    pUsageCounts_       = {},
                                                        const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts_ = {},
                                                        VULKAN_HPP_NAMESPACE::MicromapEXT                      micromap_      = {},
                                                        void *                                                 pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , indexType{ indexType_ }
      , indexBuffer{ indexBuffer_ }
      , indexStride{ indexStride_ }
      , baseTriangle{ baseTriangle_ }
      , usageCountsCount{ usageCountsCount_ }
      , pUsageCounts{ pUsageCounts_ }
      , ppUsageCounts{ ppUsageCounts_ }
      , micromap{ micromap_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureTrianglesOpacityMicromapEXT( AccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureTrianglesOpacityMicromapEXT( VkAccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureTrianglesOpacityMicromapEXT( *reinterpret_cast<AccelerationStructureTrianglesOpacityMicromapEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT(
      VULKAN_HPP_NAMESPACE::IndexType                                                                             indexType_,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR                                                           indexBuffer_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                                                            indexStride_,
      uint32_t                                                                                                    baseTriangle_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT> const &         usageCounts_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const> const & pUsageCounts_ = {},
      VULKAN_HPP_NAMESPACE::MicromapEXT                                                                           micromap_     = {},
      void *                                                                                                      pNext_        = nullptr )
      : pNext( pNext_ )
      , indexType( indexType_ )
      , indexBuffer( indexBuffer_ )
      , indexStride( indexStride_ )
      , baseTriangle( baseTriangle_ )
      , usageCountsCount( static_cast<uint32_t>( !usageCounts_.empty() ? usageCounts_.size() : pUsageCounts_.size() ) )
      , pUsageCounts( usageCounts_.data() )
      , ppUsageCounts( pUsageCounts_.data() )
      , micromap( micromap_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !usageCounts_.empty() + !pUsageCounts_.empty() ) <= 1 );
#    else
      if ( 1 < ( !usageCounts_.empty() + !pUsageCounts_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureTrianglesOpacityMicromapEXT::AccelerationStructureTrianglesOpacityMicromapEXT: 1 < ( !usageCounts_.empty() + !pUsageCounts_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureTrianglesOpacityMicromapEXT & operator=( AccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureTrianglesOpacityMicromapEXT & operator=( VkAccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureTrianglesOpacityMicromapEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setIndexStride( VULKAN_HPP_NAMESPACE::DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setBaseTriangle( uint32_t baseTriangle_ ) VULKAN_HPP_NOEXCEPT
    {
      baseTriangle = baseTriangle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setUsageCountsCount( uint32_t usageCountsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = usageCountsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setPUsageCounts( const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pUsageCounts = pUsageCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT &
      setUsageCounts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT> const & usageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( usageCounts_.size() );
      pUsageCounts     = usageCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setPpUsageCounts( const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      ppUsageCounts = ppUsageCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT & setPUsageCounts(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const> const & pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( pUsageCounts_.size() );
      ppUsageCounts    = pUsageCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setMicromap( VULKAN_HPP_NAMESPACE::MicromapEXT micromap_ ) VULKAN_HPP_NOEXCEPT
    {
      micromap = micromap_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const &,
               const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, indexType, indexBuffer, indexStride, baseTriangle, usageCountsCount, pUsageCounts, ppUsageCounts, micromap );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType            = StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT;
    void *                                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::IndexType                        indexType        = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      indexBuffer      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                       indexStride      = {};
    uint32_t                                               baseTriangle     = {};
    uint32_t                                               usageCountsCount = {};
    const VULKAN_HPP_NAMESPACE::MicromapUsageEXT *         pUsageCounts     = {};
    const VULKAN_HPP_NAMESPACE::MicromapUsageEXT * const * ppUsageCounts    = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT                      micromap         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT>
  {
    using Type = AccelerationStructureTrianglesOpacityMicromapEXT;
  };

  struct AccelerationStructureVersionInfoKHR
  {
    using NativeType = VkAccelerationStructureVersionInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureVersionInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( const uint8_t * pVersionData_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pVersionData{ pVersionData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureVersionInfoKHR( *reinterpret_cast<AccelerationStructureVersionInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureVersionInfoKHR & operator=( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureVersionInfoKHR & operator=( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPVersionData( const uint8_t * pVersionData_ ) VULKAN_HPP_NOEXCEPT
    {
      pVersionData = pVersionData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureVersionInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureVersionInfoKHR *>( this );
    }

    operator VkAccelerationStructureVersionInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureVersionInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const uint8_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pVersionData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureVersionInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pVersionData == rhs.pVersionData );
#  endif
    }

    bool operator!=( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eAccelerationStructureVersionInfoKHR;
    const void *                        pNext        = {};
    const uint8_t *                     pVersionData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureVersionInfoKHR>
  {
    using Type = AccelerationStructureVersionInfoKHR;
  };

  struct AcquireNextImageInfoKHR
  {
    using NativeType = VkAcquireNextImageInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireNextImageInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                  uint64_t                           timeout_    = {},
                                                  VULKAN_HPP_NAMESPACE::Semaphore    semaphore_  = {},
                                                  VULKAN_HPP_NAMESPACE::Fence        fence_      = {},
                                                  uint32_t                           deviceMask_ = {},
                                                  const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , timeout{ timeout_ }
      , semaphore{ semaphore_ }
      , fence{ fence_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireNextImageInfoKHR( *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs ) )
    {
    }

    AcquireNextImageInfoKHR & operator=( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AcquireNextImageInfoKHR & operator=( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSemaphore( VULKAN_HPP_NAMESPACE::Semaphore semaphore_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphore = semaphore_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAcquireNextImageInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SwapchainKHR const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::Semaphore const &,
               VULKAN_HPP_NAMESPACE::Fence const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, timeout, semaphore, fence, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireNextImageInfoKHR const & ) const = default;
#else
    bool operator==( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( timeout == rhs.timeout ) &&
             ( semaphore == rhs.semaphore ) && ( fence == rhs.fence ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eAcquireNextImageInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint64_t                            timeout    = {};
    VULKAN_HPP_NAMESPACE::Semaphore     semaphore  = {};
    VULKAN_HPP_NAMESPACE::Fence         fence      = {};
    uint32_t                            deviceMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireNextImageInfoKHR>
  {
    using Type = AcquireNextImageInfoKHR;
  };

  struct AcquireProfilingLockInfoKHR
  {
    using NativeType = VkAcquireProfilingLockInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireProfilingLockInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_   = {},
                                                      uint64_t                                           timeout_ = {},
                                                      const void *                                       pNext_   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , timeout{ timeout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireProfilingLockInfoKHR( *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs ) )
    {
    }

    AcquireProfilingLockInfoKHR & operator=( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AcquireProfilingLockInfoKHR & operator=( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAcquireProfilingLockInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, timeout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireProfilingLockInfoKHR const & ) const = default;
#else
    bool operator==( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( timeout == rhs.timeout );
#  endif
    }

    bool operator!=( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType   = StructureType::eAcquireProfilingLockInfoKHR;
    const void *                                       pNext   = {};
    VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags   = {};
    uint64_t                                           timeout = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireProfilingLockInfoKHR>
  {
    using Type = AcquireProfilingLockInfoKHR;
  };

  typedef void *( VKAPI_PTR * PFN_AllocationFunction )( void *                                      pUserData,
                                                        size_t                                      size,
                                                        size_t                                      alignment,
                                                        VULKAN_HPP_NAMESPACE::SystemAllocationScope allocationScope );

  typedef void *( VKAPI_PTR * PFN_ReallocationFunction )(
    void * pUserData, void * pOriginal, size_t size, size_t alignment, VULKAN_HPP_NAMESPACE::SystemAllocationScope allocationScope );

  typedef void( VKAPI_PTR * PFN_FreeFunction )( void * pUserData, void * pMemory );

  typedef void( VKAPI_PTR * PFN_InternalAllocationNotification )( void *                                       pUserData,
                                                                  size_t                                       size,
                                                                  VULKAN_HPP_NAMESPACE::InternalAllocationType allocationType,
                                                                  VULKAN_HPP_NAMESPACE::SystemAllocationScope  allocationScope );

  typedef void( VKAPI_PTR * PFN_InternalFreeNotification )( void *                                       pUserData,
                                                            size_t                                       size,
                                                            VULKAN_HPP_NAMESPACE::InternalAllocationType allocationType,
                                                            VULKAN_HPP_NAMESPACE::SystemAllocationScope  allocationScope );

  struct AllocationCallbacks
  {
    using NativeType = VkAllocationCallbacks;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AllocationCallbacks( void *                                                   pUserData_             = {},
                                              VULKAN_HPP_NAMESPACE::PFN_AllocationFunction             pfnAllocation_         = {},
                                              VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction           pfnReallocation_       = {},
                                              VULKAN_HPP_NAMESPACE::PFN_FreeFunction                   pfnFree_               = {},
                                              VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification pfnInternalAllocation_ = {},
                                              VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : pUserData{ pUserData_ }
      , pfnAllocation{ pfnAllocation_ }
      , pfnReallocation{ pfnReallocation_ }
      , pfnFree{ pfnFree_ }
      , pfnInternalAllocation{ pfnInternalAllocation_ }
      , pfnInternalFree{ pfnInternalFree_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AllocationCallbacks( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT : AllocationCallbacks( *reinterpret_cast<AllocationCallbacks const *>( &rhs ) )
    {
    }

#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic push
#    if defined( __clang__ )
#      pragma clang diagnostic ignored "-Wunknown-warning-option"
#    endif
#    pragma GCC diagnostic ignored "-Wcast-function-type"
#  endif
    VULKAN_HPP_DEPRECATED( "This constructor is deprecated. Use the one taking function pointer types from the vk-namespace instead." )

    AllocationCallbacks( void *                               pUserData_,
                         PFN_vkAllocationFunction             pfnAllocation_,
                         PFN_vkReallocationFunction           pfnReallocation_       = {},
                         PFN_vkFreeFunction                   pfnFree_               = {},
                         PFN_vkInternalAllocationNotification pfnInternalAllocation_ = {},
                         PFN_vkInternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : AllocationCallbacks( pUserData_,
                             reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_AllocationFunction>( pfnAllocation_ ),
                             reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction>( pfnReallocation_ ),
                             reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_FreeFunction>( pfnFree_ ),
                             reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification>( pfnInternalAllocation_ ),
                             reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification>( pfnInternalFree_ ) )
    {
    }
#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic pop
#  endif

    AllocationCallbacks & operator=( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AllocationCallbacks & operator=( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AllocationCallbacks const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnAllocation( VULKAN_HPP_NAMESPACE::PFN_AllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnAllocation = pfnAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnReallocation( VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnReallocation = pfnReallocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnFree( VULKAN_HPP_NAMESPACE::PFN_FreeFunction pfnFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFree = pfnFree_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks &
      setPfnInternalAllocation( VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalAllocation = pfnInternalAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalFree( VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalFree = pfnInternalFree_;
      return *this;
    }

#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic push
#    if defined( __clang__ )
#      pragma clang diagnostic ignored "-Wunknown-warning-option"
#    endif
#    pragma GCC diagnostic ignored "-Wcast-function-type"
#  endif
    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnAllocation( PFN_vkAllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnAllocation( reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_AllocationFunction>( pfnAllocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnReallocation( PFN_vkReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnReallocation( reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction>( pfnReallocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnInternalAllocation( PFN_vkInternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnInternalAllocation( reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification>( pfnInternalAllocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnInternalFree( PFN_vkInternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnInternalFree( reinterpret_cast<VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification>( pfnInternalFree_ ) );
    }
#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic pop
#  endif
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAllocationCallbacks const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAllocationCallbacks *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<void * const &,
               VULKAN_HPP_NAMESPACE::PFN_AllocationFunction const &,
               VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction const &,
               VULKAN_HPP_NAMESPACE::PFN_FreeFunction const &,
               VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification const &,
               VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pUserData, pfnAllocation, pfnReallocation, pfnFree, pfnInternalAllocation, pfnInternalFree );
    }
#endif

    bool operator==( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#else
      return ( pUserData == rhs.pUserData ) && ( pfnAllocation == rhs.pfnAllocation ) && ( pfnReallocation == rhs.pfnReallocation ) &&
             ( pfnFree == rhs.pfnFree ) && ( pfnInternalAllocation == rhs.pfnInternalAllocation ) && ( pfnInternalFree == rhs.pfnInternalFree );
#endif
    }

    bool operator!=( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    void *                                                   pUserData             = {};
    VULKAN_HPP_NAMESPACE::PFN_AllocationFunction             pfnAllocation         = {};
    VULKAN_HPP_NAMESPACE::PFN_ReallocationFunction           pfnReallocation       = {};
    VULKAN_HPP_NAMESPACE::PFN_FreeFunction                   pfnFree               = {};
    VULKAN_HPP_NAMESPACE::PFN_InternalAllocationNotification pfnInternalAllocation = {};
    VULKAN_HPP_NAMESPACE::PFN_InternalFreeNotification       pfnInternalFree       = {};
  };

  struct AmigoProfilingSubmitInfoSEC
  {
    using NativeType = VkAmigoProfilingSubmitInfoSEC;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAmigoProfilingSubmitInfoSEC;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AmigoProfilingSubmitInfoSEC( uint64_t firstDrawTimestamp_ = {}, uint64_t swapBufferTimestamp_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , firstDrawTimestamp{ firstDrawTimestamp_ }
      , swapBufferTimestamp{ swapBufferTimestamp_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AmigoProfilingSubmitInfoSEC( AmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AmigoProfilingSubmitInfoSEC( VkAmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT
      : AmigoProfilingSubmitInfoSEC( *reinterpret_cast<AmigoProfilingSubmitInfoSEC const *>( &rhs ) )
    {
    }

    AmigoProfilingSubmitInfoSEC & operator=( AmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AmigoProfilingSubmitInfoSEC & operator=( VkAmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AmigoProfilingSubmitInfoSEC const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setFirstDrawTimestamp( uint64_t firstDrawTimestamp_ ) VULKAN_HPP_NOEXCEPT
    {
      firstDrawTimestamp = firstDrawTimestamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setSwapBufferTimestamp( uint64_t swapBufferTimestamp_ ) VULKAN_HPP_NOEXCEPT
    {
      swapBufferTimestamp = swapBufferTimestamp_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAmigoProfilingSubmitInfoSEC const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAmigoProfilingSubmitInfoSEC *>( this );
    }

    operator VkAmigoProfilingSubmitInfoSEC &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAmigoProfilingSubmitInfoSEC *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint64_t const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, firstDrawTimestamp, swapBufferTimestamp );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AmigoProfilingSubmitInfoSEC const & ) const = default;
#else
    bool operator==( AmigoProfilingSubmitInfoSEC const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( firstDrawTimestamp == rhs.firstDrawTimestamp ) &&
             ( swapBufferTimestamp == rhs.swapBufferTimestamp );
#  endif
    }

    bool operator!=( AmigoProfilingSubmitInfoSEC const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eAmigoProfilingSubmitInfoSEC;
    const void *                        pNext               = {};
    uint64_t                            firstDrawTimestamp  = {};
    uint64_t                            swapBufferTimestamp = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAmigoProfilingSubmitInfoSEC>
  {
    using Type = AmigoProfilingSubmitInfoSEC;
  };

  struct ComponentMapping
  {
    using NativeType = VkComponentMapping;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComponentMapping( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity ) VULKAN_HPP_NOEXCEPT
      : r{ r_ }
      , g{ g_ }
      , b{ b_ }
      , a{ a_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT : ComponentMapping( *reinterpret_cast<ComponentMapping const *>( &rhs ) ) {}

    ComponentMapping & operator=( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComponentMapping & operator=( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComponentMapping const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setR( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ ) VULKAN_HPP_NOEXCEPT
    {
      r = r_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setG( VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ ) VULKAN_HPP_NOEXCEPT
    {
      g = g_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setB( VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setA( VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComponentMapping const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComponentMapping *>( this );
    }

    operator VkComponentMapping &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComponentMapping *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( r, g, b, a );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComponentMapping const & ) const = default;
#else
    bool operator==( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( r == rhs.r ) && ( g == rhs.g ) && ( b == rhs.b ) && ( a == rhs.a );
#  endif
    }

    bool operator!=( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ComponentSwizzle r = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle g = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle b = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle a = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
  };

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatProperties2ANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatProperties2ANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatProperties2ANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_                           = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_                   = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags2         formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , format{ format_ }
      , externalFormat{ externalFormat_ }
      , formatFeatures{ formatFeatures_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatProperties2ANDROID( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatProperties2ANDROID( *reinterpret_cast<AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatProperties2ANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;
    void *                                            pNext                            = {};
    VULKAN_HPP_NAMESPACE::Format                      format                           = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                          externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2         formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatProperties2ANDROID>
  {
    using Type = AndroidHardwareBufferFormatProperties2ANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_                           = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_                   = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , format{ format_ }
      , externalFormat{ externalFormat_ }
      , formatFeatures{ formatFeatures_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;
    void *                                            pNext                            = {};
    VULKAN_HPP_NAMESPACE::Format                      format                           = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                          externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatResolvePropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatResolvePropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatResolvePropertiesANDROID( VULKAN_HPP_NAMESPACE::Format colorAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                           void *                       pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorAttachmentFormat{ colorAttachmentFormat_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatResolvePropertiesANDROID( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatResolvePropertiesANDROID( VkAndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatResolvePropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferFormatResolvePropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatResolvePropertiesANDROID &
      operator=( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatResolvePropertiesANDROID & operator=( VkAndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatResolvePropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::Format const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorAttachmentFormat );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatResolvePropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentFormat == rhs.colorAttachmentFormat );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                 = StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID;
    void *                              pNext                 = {};
    VULKAN_HPP_NAMESPACE::Format        colorAttachmentFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatResolvePropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( VULKAN_HPP_NAMESPACE::DeviceSize allocationSize_ = {},
                                                                 uint32_t                         memoryTypeBits_ = {},
                                                                 void *                           pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , allocationSize{ allocationSize_ }
      , memoryTypeBits{ memoryTypeBits_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferPropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferPropertiesANDROID & operator=( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferPropertiesANDROID & operator=( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, allocationSize, memoryTypeBits );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( allocationSize == rhs.allocationSize ) && ( memoryTypeBits == rhs.memoryTypeBits );
#    endif
    }

    bool operator!=( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eAndroidHardwareBufferPropertiesANDROID;
    void *                              pNext          = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    allocationSize = {};
    uint32_t                            memoryTypeBits = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferUsageANDROID
  {
    using NativeType = VkAndroidHardwareBufferUsageANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferUsageANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( uint64_t androidHardwareBufferUsage_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , androidHardwareBufferUsage{ androidHardwareBufferUsage_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferUsageANDROID( *reinterpret_cast<AndroidHardwareBufferUsageANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferUsageANDROID & operator=( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferUsageANDROID & operator=( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferUsageANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    operator VkAndroidHardwareBufferUsageANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferUsageANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint64_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, androidHardwareBufferUsage );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferUsageANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( androidHardwareBufferUsage == rhs.androidHardwareBufferUsage );
#    endif
    }

    bool operator!=( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eAndroidHardwareBufferUsageANDROID;
    void *                              pNext                      = {};
    uint64_t                            androidHardwareBufferUsage = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferUsageANDROID>
  {
    using Type = AndroidHardwareBufferUsageANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidSurfaceCreateInfoKHR
  {
    using NativeType = VkAndroidSurfaceCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidSurfaceCreateInfoKHR;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_  = {},
                                                      struct ANativeWindow *                             window_ = {},
                                                      const void *                                       pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , window{ window_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidSurfaceCreateInfoKHR( *reinterpret_cast<AndroidSurfaceCreateInfoKHR const *>( &rhs ) )
    {
    }

    AndroidSurfaceCreateInfoKHR & operator=( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidSurfaceCreateInfoKHR & operator=( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setWindow( struct ANativeWindow * window_ ) VULKAN_HPP_NOEXCEPT
    {
      window = window_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAndroidSurfaceCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    operator VkAndroidSurfaceCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidSurfaceCreateInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR const &,
               struct ANativeWindow * const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, window );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidSurfaceCreateInfoKHR const & ) const = default;
#  else
    bool operator==( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( window == rhs.window );
#    endif
    }

    bool operator!=( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eAndroidSurfaceCreateInfoKHR;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags  = {};
    struct ANativeWindow *                             window = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidSurfaceCreateInfoKHR>
  {
    using Type = AndroidSurfaceCreateInfoKHR;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

  struct AntiLagPresentationInfoAMD
  {
    using NativeType = VkAntiLagPresentationInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAntiLagPresentationInfoAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AntiLagPresentationInfoAMD( VULKAN_HPP_NAMESPACE::AntiLagStageAMD stage_      = VULKAN_HPP_NAMESPACE::AntiLagStageAMD::eInput,
                                                     uint64_t                              frameIndex_ = {},
                                                     void *                                pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , frameIndex{ frameIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AntiLagPresentationInfoAMD( AntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AntiLagPresentationInfoAMD( VkAntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AntiLagPresentationInfoAMD( *reinterpret_cast<AntiLagPresentationInfoAMD const *>( &rhs ) )
    {
    }

    AntiLagPresentationInfoAMD & operator=( AntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AntiLagPresentationInfoAMD & operator=( VkAntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AntiLagPresentationInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setStage( VULKAN_HPP_NAMESPACE::AntiLagStageAMD stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setFrameIndex( uint64_t frameIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      frameIndex = frameIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAntiLagPresentationInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAntiLagPresentationInfoAMD *>( this );
    }

    operator VkAntiLagPresentationInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAntiLagPresentationInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::AntiLagStageAMD const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, frameIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AntiLagPresentationInfoAMD const & ) const = default;
#else
    bool operator==( AntiLagPresentationInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( frameIndex == rhs.frameIndex );
#  endif
    }

    bool operator!=( AntiLagPresentationInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType   sType      = StructureType::eAntiLagPresentationInfoAMD;
    void *                                pNext      = {};
    VULKAN_HPP_NAMESPACE::AntiLagStageAMD stage      = VULKAN_HPP_NAMESPACE::AntiLagStageAMD::eInput;
    uint64_t                              frameIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAntiLagPresentationInfoAMD>
  {
    using Type = AntiLagPresentationInfoAMD;
  };

  struct AntiLagDataAMD
  {
    using NativeType = VkAntiLagDataAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAntiLagDataAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AntiLagDataAMD( VULKAN_HPP_NAMESPACE::AntiLagModeAMD                     mode_ = VULKAN_HPP_NAMESPACE::AntiLagModeAMD::eDriverControl,
                                         uint32_t                                                 maxFPS_            = {},
                                         const VULKAN_HPP_NAMESPACE::AntiLagPresentationInfoAMD * pPresentationInfo_ = {},
                                         const void *                                             pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , mode{ mode_ }
      , maxFPS{ maxFPS_ }
      , pPresentationInfo{ pPresentationInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AntiLagDataAMD( AntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AntiLagDataAMD( VkAntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT : AntiLagDataAMD( *reinterpret_cast<AntiLagDataAMD const *>( &rhs ) ) {}

    AntiLagDataAMD & operator=( AntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AntiLagDataAMD & operator=( VkAntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AntiLagDataAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setMode( VULKAN_HPP_NAMESPACE::AntiLagModeAMD mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setMaxFPS( uint32_t maxFPS_ ) VULKAN_HPP_NOEXCEPT
    {
      maxFPS = maxFPS_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD &
      setPPresentationInfo( const VULKAN_HPP_NAMESPACE::AntiLagPresentationInfoAMD * pPresentationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pPresentationInfo = pPresentationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAntiLagDataAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAntiLagDataAMD *>( this );
    }

    operator VkAntiLagDataAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAntiLagDataAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AntiLagModeAMD const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::AntiLagPresentationInfoAMD * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, mode, maxFPS, pPresentationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AntiLagDataAMD const & ) const = default;
#else
    bool operator==( AntiLagDataAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( mode == rhs.mode ) && ( maxFPS == rhs.maxFPS ) &&
             ( pPresentationInfo == rhs.pPresentationInfo );
#  endif
    }

    bool operator!=( AntiLagDataAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType             = StructureType::eAntiLagDataAMD;
    const void *                                             pNext             = {};
    VULKAN_HPP_NAMESPACE::AntiLagModeAMD                     mode              = VULKAN_HPP_NAMESPACE::AntiLagModeAMD::eDriverControl;
    uint32_t                                                 maxFPS            = {};
    const VULKAN_HPP_NAMESPACE::AntiLagPresentationInfoAMD * pPresentationInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAntiLagDataAMD>
  {
    using Type = AntiLagDataAMD;
  };

  struct ApplicationInfo
  {
    using NativeType = VkApplicationInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationInfo( const char * pApplicationName_   = {},
                                          uint32_t     applicationVersion_ = {},
                                          const char * pEngineName_        = {},
                                          uint32_t     engineVersion_      = {},
                                          uint32_t     apiVersion_         = {},
                                          const void * pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pApplicationName{ pApplicationName_ }
      , applicationVersion{ applicationVersion_ }
      , pEngineName{ pEngineName_ }
      , engineVersion{ engineVersion_ }
      , apiVersion{ apiVersion_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ApplicationInfo( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : ApplicationInfo( *reinterpret_cast<ApplicationInfo const *>( &rhs ) ) {}

    ApplicationInfo & operator=( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ApplicationInfo & operator=( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ApplicationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPApplicationName( const char * pApplicationName_ ) VULKAN_HPP_NOEXCEPT
    {
      pApplicationName = pApplicationName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApplicationVersion( uint32_t applicationVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      applicationVersion = applicationVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPEngineName( const char * pEngineName_ ) VULKAN_HPP_NOEXCEPT
    {
      pEngineName = pEngineName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setEngineVersion( uint32_t engineVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      engineVersion = engineVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApiVersion( uint32_t apiVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      apiVersion = apiVersion_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkApplicationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const char * const &,
               uint32_t const &,
               const char * const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pApplicationName, applicationVersion, pEngineName, engineVersion, apiVersion );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pApplicationName != rhs.pApplicationName )
        if ( auto cmp = strcmp( pApplicationName, rhs.pApplicationName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = applicationVersion <=> rhs.applicationVersion; cmp != 0 )
        return cmp;
      if ( pEngineName != rhs.pEngineName )
        if ( auto cmp = strcmp( pEngineName, rhs.pEngineName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = engineVersion <=> rhs.engineVersion; cmp != 0 )
        return cmp;
      if ( auto cmp = apiVersion <=> rhs.apiVersion; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( ( pApplicationName == rhs.pApplicationName ) || ( strcmp( pApplicationName, rhs.pApplicationName ) == 0 ) ) &&
             ( applicationVersion == rhs.applicationVersion ) && ( ( pEngineName == rhs.pEngineName ) || ( strcmp( pEngineName, rhs.pEngineName ) == 0 ) ) &&
             ( engineVersion == rhs.engineVersion ) && ( apiVersion == rhs.apiVersion );
    }

    bool operator!=( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eApplicationInfo;
    const void *                        pNext              = {};
    const char *                        pApplicationName   = {};
    uint32_t                            applicationVersion = {};
    const char *                        pEngineName        = {};
    uint32_t                            engineVersion      = {};
    uint32_t                            apiVersion         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eApplicationInfo>
  {
    using Type = ApplicationInfo;
  };

  struct AttachmentDescription
  {
    using NativeType = VkAttachmentDescription;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescription( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_          = {},
                             VULKAN_HPP_NAMESPACE::Format                     format_         = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout_  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                             VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription( *reinterpret_cast<AttachmentDescription const *>( &rhs ) )
    {
    }

    AttachmentDescription & operator=( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescription & operator=( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription const & ) const = default;
#else
    bool operator==( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) && ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) &&
             ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) && ( initialLayout == rhs.initialLayout ) &&
             ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  struct AttachmentDescription2
  {
    using NativeType = VkAttachmentDescription2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescription2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription2( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_   = {},
                                                 VULKAN_HPP_NAMESPACE::Format                     format_  = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp  stencilLoadOp_    = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_   = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       initialLayout_    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       finalLayout_      = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 const void *                            pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription2( *reinterpret_cast<AttachmentDescription2 const *>( &rhs ) )
    {
    }

    AttachmentDescription2 & operator=( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescription2 & operator=( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescription2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription2 const & ) const = default;
#else
    bool operator==( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) &&
             ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) && ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) &&
             ( initialLayout == rhs.initialLayout ) && ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType          = StructureType::eAttachmentDescription2;
    const void *                                     pNext          = {};
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescription2>
  {
    using Type = AttachmentDescription2;
  };

  using AttachmentDescription2KHR = AttachmentDescription2;

  struct AttachmentDescriptionStencilLayout
  {
    using NativeType = VkAttachmentDescriptionStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescriptionStencilLayout;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescriptionStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          void *                            pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilInitialLayout{ stencilInitialLayout_ }
      , stencilFinalLayout{ stencilFinalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescriptionStencilLayout( *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentDescriptionStencilLayout & operator=( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescriptionStencilLayout & operator=( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilInitialLayout = stencilInitialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilFinalLayout = stencilFinalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescriptionStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilInitialLayout, stencilFinalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescriptionStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilInitialLayout == rhs.stencilInitialLayout ) &&
             ( stencilFinalLayout == rhs.stencilFinalLayout );
#  endif
    }

    bool operator!=( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eAttachmentDescriptionStencilLayout;
    void *                              pNext                = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilInitialLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilFinalLayout   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescriptionStencilLayout>
  {
    using Type = AttachmentDescriptionStencilLayout;
  };

  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

  struct AttachmentReference
  {
    using NativeType = VkAttachmentReference;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference( uint32_t                          attachment_ = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout layout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : attachment{ attachment_ }
      , layout{ layout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT : AttachmentReference( *reinterpret_cast<AttachmentReference const *>( &rhs ) )
    {
    }

    AttachmentReference & operator=( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReference & operator=( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReference const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachment, layout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference const & ) const = default;
#else
    bool operator==( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachment == rhs.attachment ) && ( layout == rhs.layout );
#  endif
    }

    bool operator!=( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                          attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  struct AttachmentReference2
  {
    using NativeType = VkAttachmentReference2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReference2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference2( uint32_t                               attachment_ = {},
                                               VULKAN_HPP_NAMESPACE::ImageLayout      layout_     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                               VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {},
                                               const void *                           pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , attachment{ attachment_ }
      , layout{ layout_ }
      , aspectMask{ aspectMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference2( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference2( *reinterpret_cast<AttachmentReference2 const *>( &rhs ) )
    {
    }

    AttachmentReference2 & operator=( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReference2 & operator=( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReference2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageAspectFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, attachment, layout, aspectMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference2 const & ) const = default;
#else
    bool operator==( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachment == rhs.attachment ) && ( layout == rhs.layout ) &&
             ( aspectMask == rhs.aspectMask );
#  endif
    }

    bool operator!=( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType      = StructureType::eAttachmentReference2;
    const void *                           pNext      = {};
    uint32_t                               attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout      layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReference2>
  {
    using Type = AttachmentReference2;
  };

  using AttachmentReference2KHR = AttachmentReference2;

  struct AttachmentReferenceStencilLayout
  {
    using NativeType = VkAttachmentReferenceStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReferenceStencilLayout;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                           void *                            pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilLayout{ stencilLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReferenceStencilLayout( *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentReferenceStencilLayout & operator=( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReferenceStencilLayout & operator=( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLayout = stencilLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReferenceStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReferenceStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilLayout == rhs.stencilLayout );
#  endif
    }

    bool operator!=( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eAttachmentReferenceStencilLayout;
    void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReferenceStencilLayout>
  {
    using Type = AttachmentReferenceStencilLayout;
  };

  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

  struct AttachmentSampleCountInfoAMD
  {
    using NativeType = VkAttachmentSampleCountInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentSampleCountInfoAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentSampleCountInfoAMD( uint32_t                                          colorAttachmentCount_    = {},
                                    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ = {},
                                    VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_   = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                    const void *                              pNext_                           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorAttachmentCount{ colorAttachmentCount_ }
      , pColorAttachmentSamples{ pColorAttachmentSamples_ }
      , depthStencilAttachmentSamples{ depthStencilAttachmentSamples_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleCountInfoAMD( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleCountInfoAMD( *reinterpret_cast<AttachmentSampleCountInfoAMD const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const & colorAttachmentSamples_,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
      const void *                              pNext_                         = nullptr )
      : pNext( pNext_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentSamples_.size() ) )
      , pColorAttachmentSamples( colorAttachmentSamples_.data() )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AttachmentSampleCountInfoAMD & operator=( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentSampleCountInfoAMD & operator=( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
      setPColorAttachmentSamples( const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentSamples = pColorAttachmentSamples_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD & setColorAttachmentSamples(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const & colorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentSamples_.size() );
      pColorAttachmentSamples = colorAttachmentSamples_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
      setDepthStencilAttachmentSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencilAttachmentSamples = depthStencilAttachmentSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentSampleCountInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleCountInfoAMD *>( this );
    }

    operator VkAttachmentSampleCountInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleCountInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorAttachmentCount, pColorAttachmentSamples, depthStencilAttachmentSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleCountInfoAMD const & ) const = default;
#else
    bool operator==( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentCount == rhs.colorAttachmentCount ) &&
             ( pColorAttachmentSamples == rhs.pColorAttachmentSamples ) && ( depthStencilAttachmentSamples == rhs.depthStencilAttachmentSamples );
#  endif
    }

    bool operator!=( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                         = StructureType::eAttachmentSampleCountInfoAMD;
    const void *                                      pNext                         = {};
    uint32_t                                          colorAttachmentCount          = {};
    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples       = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits         depthStencilAttachmentSamples = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentSampleCountInfoAMD>
  {
    using Type = AttachmentSampleCountInfoAMD;
  };

  using AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

  struct Extent2D
  {
    using NativeType = VkExtent2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent2D( uint32_t width_ = {}, uint32_t height_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent2D( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent2D( *reinterpret_cast<Extent2D const *>( &rhs ) ) {}

    Extent2D & operator=( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Extent2D & operator=( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent2D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent2D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkExtent2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent2D *>( this );
    }

    operator VkExtent2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent2D const & ) const = default;
#else
    bool operator==( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height );
#  endif
    }

    bool operator!=( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
  };

  struct SampleLocationEXT
  {
    using NativeType = VkSampleLocationEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationEXT( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT : SampleLocationEXT( *reinterpret_cast<SampleLocationEXT const *>( &rhs ) ) {}

    SampleLocationEXT & operator=( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SampleLocationEXT & operator=( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSampleLocationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationEXT const & ) const = default;
#else
    bool operator==( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };

  struct SampleLocationsInfoEXT
  {
    using NativeType = VkSampleLocationsInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSampleLocationsInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                              VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize_  = {},
                              uint32_t                                        sampleLocationsCount_    = {},
                              const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_        = {},
                              const void *                                    pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , sampleLocationsPerPixel{ sampleLocationsPerPixel_ }
      , sampleLocationGridSize{ sampleLocationGridSize_ }
      , sampleLocationsCount{ sampleLocationsCount_ }
      , pSampleLocations{ pSampleLocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationsInfoEXT( *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits                                                            sampleLocationsPerPixel_,
                            VULKAN_HPP_NAMESPACE::Extent2D                                                                       sampleLocationGridSize_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_,
                            const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SampleLocationsInfoEXT & operator=( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SampleLocationsInfoEXT & operator=( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setSampleLocationsPerPixel( VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsPerPixel = sampleLocationsPerPixel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setSampleLocationGridSize( VULKAN_HPP_NAMESPACE::Extent2D const & sampleLocationGridSize_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationGridSize = sampleLocationGridSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsCount( uint32_t sampleLocationsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = sampleLocationsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setPSampleLocations( const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations     = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSampleLocationsInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SampleLocationEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, sampleLocationsPerPixel, sampleLocationGridSize, sampleLocationsCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationsInfoEXT const & ) const = default;
#else
    bool operator==( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( sampleLocationsPerPixel == rhs.sampleLocationsPerPixel ) &&
             ( sampleLocationGridSize == rhs.sampleLocationGridSize ) && ( sampleLocationsCount == rhs.sampleLocationsCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType                   = StructureType::eSampleLocationsInfoEXT;
    const void *                                    pNext                   = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize  = {};
    uint32_t                                        sampleLocationsCount    = {};
    const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eSampleLocationsInfoEXT>
  {
    using Type = SampleLocationsInfoEXT;
  };

  struct AttachmentSampleLocationsEXT
  {
    using NativeType = VkAttachmentSampleLocationsEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( uint32_t                                     attachmentIndex_     = {},
                                                       VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachmentIndex{ attachmentIndex_ }
      , sampleLocationsInfo{ sampleLocationsInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleLocationsEXT( *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs ) )
    {
    }

    AttachmentSampleLocationsEXT & operator=( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentSampleLocationsEXT & operator=( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setAttachmentIndex( uint32_t attachmentIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentIndex = attachmentIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT &
      setSampleLocationsInfo( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const & sampleLocationsInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsInfo = sampleLocationsInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentSampleLocationsEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachmentIndex, sampleLocationsInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleLocationsEXT const & ) const = default;
#else
    bool operator==( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachmentIndex == rhs.attachmentIndex ) && ( sampleLocationsInfo == rhs.sampleLocationsInfo );
#  endif
    }

    bool operator!=( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                     attachmentIndex     = {};
    VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo = {};
  };

  struct BaseInStructure
  {
    using NativeType = VkBaseInStructure;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseInStructure( VULKAN_HPP_NAMESPACE::StructureType                  sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                     const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseInStructure( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseInStructure( *reinterpret_cast<BaseInStructure const *>( &rhs ) ) {}

    BaseInStructure & operator=( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BaseInStructure & operator=( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseInStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseInStructure & setPNext( const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBaseInStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseInStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const struct VULKAN_HPP_NAMESPACE::BaseInStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseInStructure const & ) const = default;
#else
    bool operator==( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext = {};
  };

  struct BaseOutStructure
  {
    using NativeType = VkBaseOutStructure;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseOutStructure( VULKAN_HPP_NAMESPACE::StructureType             sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                      struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseOutStructure( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseOutStructure( *reinterpret_cast<BaseOutStructure const *>( &rhs ) ) {}

    BaseOutStructure & operator=( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BaseOutStructure & operator=( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseOutStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseOutStructure & setPNext( struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBaseOutStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseOutStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, struct VULKAN_HPP_NAMESPACE::BaseOutStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseOutStructure const & ) const = default;
#else
    bool operator==( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext = {};
  };

  struct BindAccelerationStructureMemoryInfoNV
  {
    using NativeType = VkBindAccelerationStructureMemoryInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindAccelerationStructureMemoryInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ = {},
                                                                VULKAN_HPP_NAMESPACE::DeviceMemory            memory_                = {},
                                                                VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset_          = {},
                                                                uint32_t                                      deviceIndexCount_      = {},
                                                                const uint32_t *                              pDeviceIndices_        = {},
                                                                const void *                                  pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindAccelerationStructureMemoryInfoNV( *reinterpret_cast<BindAccelerationStructureMemoryInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV                         accelerationStructure_,
                                           VULKAN_HPP_NAMESPACE::DeviceMemory                                    memory_,
                                           VULKAN_HPP_NAMESPACE::DeviceSize                                      memoryOffset_,
                                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_,
                                           const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ )
      , accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindAccelerationStructureMemoryInfoNV & operator=( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindAccelerationStructureMemoryInfoNV & operator=( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
      setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindAccelerationStructureMemoryInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    operator VkBindAccelerationStructureMemoryInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureNV const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure, memory, memoryOffset, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindAccelerationStructureMemoryInfoNV const & ) const = default;
#else
    bool operator==( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType                 = StructureType::eBindAccelerationStructureMemoryInfoNV;
    const void *                                  pNext                 = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory            memory                = {};
    VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset          = {};
    uint32_t                                      deviceIndexCount      = {};
    const uint32_t *                              pDeviceIndices        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindAccelerationStructureMemoryInfoNV>
  {
    using Type = BindAccelerationStructureMemoryInfoNV;
  };

  struct BindBufferMemoryDeviceGroupInfo
  {
    using NativeType = VkBindBufferMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_ = {},
                                                          const uint32_t * pDeviceIndices_   = {},
                                                          const void *     pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryDeviceGroupInfo( *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) ), pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindBufferMemoryDeviceGroupInfo & operator=( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindBufferMemoryDeviceGroupInfo & operator=( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindBufferMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eBindBufferMemoryDeviceGroupInfo;
    const void *                        pNext            = {};
    uint32_t                            deviceIndexCount = {};
    const uint32_t *                    pDeviceIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryDeviceGroupInfo>
  {
    using Type = BindBufferMemoryDeviceGroupInfo;
  };

  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

  struct BindBufferMemoryInfo
  {
    using NativeType = VkBindBufferMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( VULKAN_HPP_NAMESPACE::Buffer       buffer_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                               const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryInfo( *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs ) )
    {
    }

    BindBufferMemoryInfo & operator=( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindBufferMemoryInfo & operator=( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindBufferMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindBufferMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryInfo>
  {
    using Type = BindBufferMemoryInfo;
  };

  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

  struct BindDescriptorBufferEmbeddedSamplersInfoEXT
  {
    using NativeType = VkBindDescriptorBufferEmbeddedSamplersInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindDescriptorBufferEmbeddedSamplersInfoEXT( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ = {},
                                                                      VULKAN_HPP_NAMESPACE::PipelineLayout   layout_     = {},
                                                                      uint32_t                               set_        = {},
                                                                      const void *                           pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stageFlags{ stageFlags_ }
      , layout{ layout_ }
      , set{ set_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindDescriptorBufferEmbeddedSamplersInfoEXT( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindDescriptorBufferEmbeddedSamplersInfoEXT( VkBindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindDescriptorBufferEmbeddedSamplersInfoEXT( *reinterpret_cast<BindDescriptorBufferEmbeddedSamplersInfoEXT const *>( &rhs ) )
    {
    }

    BindDescriptorBufferEmbeddedSamplersInfoEXT & operator=( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindDescriptorBufferEmbeddedSamplersInfoEXT & operator=( VkBindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindDescriptorBufferEmbeddedSamplersInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT &
      setStageFlags( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setSet( uint32_t set_ ) VULKAN_HPP_NOEXCEPT
    {
      set = set_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlags const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stageFlags, layout, set );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindDescriptorBufferEmbeddedSamplersInfoEXT const & ) const = default;
#else
    bool operator==( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stageFlags == rhs.stageFlags ) && ( layout == rhs.layout ) && ( set == rhs.set );
#  endif
    }

    bool operator!=( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType      = StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT;
    const void *                           pNext      = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout   layout     = {};
    uint32_t                               set        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT>
  {
    using Type = BindDescriptorBufferEmbeddedSamplersInfoEXT;
  };

  struct BindDescriptorSetsInfo
  {
    using NativeType = VkBindDescriptorSetsInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindDescriptorSetsInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindDescriptorSetsInfo( VULKAN_HPP_NAMESPACE::ShaderStageFlags      stageFlags_         = {},
                                                 VULKAN_HPP_NAMESPACE::PipelineLayout        layout_             = {},
                                                 uint32_t                                    firstSet_           = {},
                                                 uint32_t                                    descriptorSetCount_ = {},
                                                 const VULKAN_HPP_NAMESPACE::DescriptorSet * pDescriptorSets_    = {},
                                                 uint32_t                                    dynamicOffsetCount_ = {},
                                                 const uint32_t *                            pDynamicOffsets_    = {},
                                                 const void *                                pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stageFlags{ stageFlags_ }
      , layout{ layout_ }
      , firstSet{ firstSet_ }
      , descriptorSetCount{ descriptorSetCount_ }
      , pDescriptorSets{ pDescriptorSets_ }
      , dynamicOffsetCount{ dynamicOffsetCount_ }
      , pDynamicOffsets{ pDynamicOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindDescriptorSetsInfo( BindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindDescriptorSetsInfo( VkBindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindDescriptorSetsInfo( *reinterpret_cast<BindDescriptorSetsInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo( VULKAN_HPP_NAMESPACE::ShaderStageFlags                                                           stageFlags_,
                            VULKAN_HPP_NAMESPACE::PipelineLayout                                                             layout_,
                            uint32_t                                                                                         firstSet_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSet> const & descriptorSets_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const &                            dynamicOffsets_ = {},
                            const void *                                                                                     pNext_          = nullptr )
      : pNext( pNext_ )
      , stageFlags( stageFlags_ )
      , layout( layout_ )
      , firstSet( firstSet_ )
      , descriptorSetCount( static_cast<uint32_t>( descriptorSets_.size() ) )
      , pDescriptorSets( descriptorSets_.data() )
      , dynamicOffsetCount( static_cast<uint32_t>( dynamicOffsets_.size() ) )
      , pDynamicOffsets( dynamicOffsets_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindDescriptorSetsInfo & operator=( BindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindDescriptorSetsInfo & operator=( VkBindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindDescriptorSetsInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setStageFlags( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setFirstSet( uint32_t firstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      firstSet = firstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPDescriptorSets( const VULKAN_HPP_NAMESPACE::DescriptorSet * pDescriptorSets_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorSets = pDescriptorSets_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo &
      setDescriptorSets( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSet> const & descriptorSets_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( descriptorSets_.size() );
      pDescriptorSets    = descriptorSets_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setDynamicOffsetCount( uint32_t dynamicOffsetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicOffsetCount = dynamicOffsetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPDynamicOffsets( const uint32_t * pDynamicOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      pDynamicOffsets = pDynamicOffsets_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo & setDynamicOffsets( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & dynamicOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicOffsetCount = static_cast<uint32_t>( dynamicOffsets_.size() );
      pDynamicOffsets    = dynamicOffsets_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindDescriptorSetsInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindDescriptorSetsInfo *>( this );
    }

    operator VkBindDescriptorSetsInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindDescriptorSetsInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlags const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorSet * const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stageFlags, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindDescriptorSetsInfo const & ) const = default;
#else
    bool operator==( BindDescriptorSetsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stageFlags == rhs.stageFlags ) && ( layout == rhs.layout ) && ( firstSet == rhs.firstSet ) &&
             ( descriptorSetCount == rhs.descriptorSetCount ) && ( pDescriptorSets == rhs.pDescriptorSets ) &&
             ( dynamicOffsetCount == rhs.dynamicOffsetCount ) && ( pDynamicOffsets == rhs.pDynamicOffsets );
#  endif
    }

    bool operator!=( BindDescriptorSetsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType              = StructureType::eBindDescriptorSetsInfo;
    const void *                                pNext              = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlags      stageFlags         = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout        layout             = {};
    uint32_t                                    firstSet           = {};
    uint32_t                                    descriptorSetCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSet * pDescriptorSets    = {};
    uint32_t                                    dynamicOffsetCount = {};
    const uint32_t *                            pDynamicOffsets    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindDescriptorSetsInfo>
  {
    using Type = BindDescriptorSetsInfo;
  };

  using BindDescriptorSetsInfoKHR = BindDescriptorSetsInfo;

  struct Offset2D
  {
    using NativeType = VkOffset2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset2D( int32_t x_ = {}, int32_t y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset2D( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset2D( *reinterpret_cast<Offset2D const *>( &rhs ) ) {}

    Offset2D & operator=( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Offset2D & operator=( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset2D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset2D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkOffset2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset2D *>( this );
    }

    operator VkOffset2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset2D const & ) const = default;
#else
    bool operator==( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
  };

  struct Rect2D
  {
    using NativeType = VkRect2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Rect2D( VULKAN_HPP_NAMESPACE::Offset2D offset_ = {}, VULKAN_HPP_NAMESPACE::Extent2D extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset{ offset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Rect2D( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT : Rect2D( *reinterpret_cast<Rect2D const *>( &rhs ) ) {}

    Rect2D & operator=( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Rect2D & operator=( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Rect2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Rect2D & setOffset( VULKAN_HPP_NAMESPACE::Offset2D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Rect2D & setExtent( VULKAN_HPP_NAMESPACE::Extent2D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkRect2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkRect2D *>( this );
    }

    operator VkRect2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkRect2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Offset2D const &, VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( offset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Rect2D const & ) const = default;
#else
    bool operator==( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( offset == rhs.offset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Offset2D offset = {};
    VULKAN_HPP_NAMESPACE::Extent2D extent = {};
  };

  struct BindImageMemoryDeviceGroupInfo
  {
    using NativeType = VkBindImageMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( uint32_t                             deviceIndexCount_             = {},
                                                         const uint32_t *                     pDeviceIndices_               = {},
                                                         uint32_t                             splitInstanceBindRegionCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_    = {},
                                                         const void *                         pNext_                        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
      , splitInstanceBindRegionCount{ splitInstanceBindRegionCount_ }
      , pSplitInstanceBindRegions{ pSplitInstanceBindRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryDeviceGroupInfo( *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const &                     deviceIndices_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ = {},
                                    const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
      , splitInstanceBindRegionCount( static_cast<uint32_t>( splitInstanceBindRegions_.size() ) )
      , pSplitInstanceBindRegions( splitInstanceBindRegions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindImageMemoryDeviceGroupInfo & operator=( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemoryDeviceGroupInfo & operator=( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegionCount( uint32_t splitInstanceBindRegionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = splitInstanceBindRegionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
      setPSplitInstanceBindRegions( const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pSplitInstanceBindRegions = pSplitInstanceBindRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = static_cast<uint32_t>( splitInstanceBindRegions_.size() );
      pSplitInstanceBindRegions    = splitInstanceBindRegions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint32_t * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices, splitInstanceBindRegionCount, pSplitInstanceBindRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices ) &&
             ( splitInstanceBindRegionCount == rhs.splitInstanceBindRegionCount ) && ( pSplitInstanceBindRegions == rhs.pSplitInstanceBindRegions );
#  endif
    }

    bool operator!=( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType                        = StructureType::eBindImageMemoryDeviceGroupInfo;
    const void *                         pNext                        = {};
    uint32_t                             deviceIndexCount             = {};
    const uint32_t *                     pDeviceIndices               = {};
    uint32_t                             splitInstanceBindRegionCount = {};
    const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryDeviceGroupInfo>
  {
    using Type = BindImageMemoryDeviceGroupInfo;
  };

  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

  struct BindImageMemoryInfo
  {
    using NativeType = VkBindImageMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( VULKAN_HPP_NAMESPACE::Image        image_        = {},
                                              VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                              const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , image{ image_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindImageMemoryInfo( *reinterpret_cast<BindImageMemoryInfo const *>( &rhs ) )
    {
    }

    BindImageMemoryInfo & operator=( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemoryInfo & operator=( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindImageMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Image         image        = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryInfo>
  {
    using Type = BindImageMemoryInfo;
  };

  using BindImageMemoryInfoKHR = BindImageMemoryInfo;

  struct BindImageMemorySwapchainInfoKHR
  {
    using NativeType = VkBindImageMemorySwapchainInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemorySwapchainInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                          uint32_t                           imageIndex_ = {},
                                                          const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , imageIndex{ imageIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemorySwapchainInfoKHR( *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs ) )
    {
    }

    BindImageMemorySwapchainInfoKHR & operator=( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemorySwapchainInfoKHR & operator=( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setImageIndex( uint32_t imageIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      imageIndex = imageIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemorySwapchainInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::SwapchainKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, imageIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemorySwapchainInfoKHR const & ) const = default;
#else
    bool operator==( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( imageIndex == rhs.imageIndex );
#  endif
    }

    bool operator!=( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eBindImageMemorySwapchainInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint32_t                            imageIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemorySwapchainInfoKHR>
  {
    using Type = BindImageMemorySwapchainInfoKHR;
  };

  struct BindImagePlaneMemoryInfo
  {
    using NativeType = VkBindImagePlaneMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImagePlaneMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor,
                                                   const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , planeAspect{ planeAspect_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImagePlaneMemoryInfo( *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs ) )
    {
    }

    BindImagePlaneMemoryInfo & operator=( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImagePlaneMemoryInfo & operator=( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImagePlaneMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImagePlaneMemoryInfo const & ) const = default;
#else
    bool operator==( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eBindImagePlaneMemoryInfo;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImagePlaneMemoryInfo>
  {
    using Type = BindImagePlaneMemoryInfo;
  };

  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

  struct BindIndexBufferIndirectCommandEXT
  {
    using NativeType = VkBindIndexBufferIndirectCommandEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandEXT( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                         uint32_t                            size_          = {},
                                         VULKAN_HPP_NAMESPACE::IndexType     indexType_     = VULKAN_HPP_NAMESPACE::IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , indexType{ indexType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandEXT( BindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandEXT( VkBindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandEXT( *reinterpret_cast<BindIndexBufferIndirectCommandEXT const *>( &rhs ) )
    {
    }

    BindIndexBufferIndirectCommandEXT & operator=( BindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandEXT & operator=( VkBindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindIndexBufferIndirectCommandEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindIndexBufferIndirectCommandEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, VULKAN_HPP_NAMESPACE::IndexType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, indexType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandEXT const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
#  endif
    }

    bool operator!=( BindIndexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
  };

  struct BindIndexBufferIndirectCommandNV
  {
    using NativeType = VkBindIndexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                        uint32_t                            size_          = {},
                                        VULKAN_HPP_NAMESPACE::IndexType     indexType_     = VULKAN_HPP_NAMESPACE::IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , indexType{ indexType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandNV( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandNV( *reinterpret_cast<BindIndexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindIndexBufferIndirectCommandNV & operator=( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandNV & operator=( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindIndexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandNV *>( this );
    }

    operator VkBindIndexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, VULKAN_HPP_NAMESPACE::IndexType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, indexType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
#  endif
    }

    bool operator!=( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
  };

  struct BindMemoryStatus
  {
    using NativeType = VkBindMemoryStatus;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindMemoryStatus;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindMemoryStatus( VULKAN_HPP_NAMESPACE::Result * pResult_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pResult{ pResult_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindMemoryStatus( BindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindMemoryStatus( VkBindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT : BindMemoryStatus( *reinterpret_cast<BindMemoryStatus const *>( &rhs ) ) {}

    BindMemoryStatus & operator=( BindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindMemoryStatus & operator=( VkBindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindMemoryStatus const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindMemoryStatus & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindMemoryStatus & setPResult( VULKAN_HPP_NAMESPACE::Result * pResult_ ) VULKAN_HPP_NOEXCEPT
    {
      pResult = pResult_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindMemoryStatus const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindMemoryStatus *>( this );
    }

    operator VkBindMemoryStatus &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindMemoryStatus *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Result * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pResult );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindMemoryStatus const & ) const = default;
#else
    bool operator==( BindMemoryStatus const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pResult == rhs.pResult );
#  endif
    }

    bool operator!=( BindMemoryStatus const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType   = StructureType::eBindMemoryStatus;
    const void *                        pNext   = {};
    VULKAN_HPP_NAMESPACE::Result *      pResult = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindMemoryStatus>
  {
    using Type = BindMemoryStatus;
  };

  using BindMemoryStatusKHR = BindMemoryStatus;

  struct BindPipelineIndirectCommandNV
  {
    using NativeType = VkBindPipelineIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindPipelineIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress pipelineAddress_ = {} ) VULKAN_HPP_NOEXCEPT
      : pipelineAddress{ pipelineAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindPipelineIndirectCommandNV( BindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindPipelineIndirectCommandNV( VkBindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindPipelineIndirectCommandNV( *reinterpret_cast<BindPipelineIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindPipelineIndirectCommandNV & operator=( BindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindPipelineIndirectCommandNV & operator=( VkBindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindPipelineIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindPipelineIndirectCommandNV & setPipelineAddress( VULKAN_HPP_NAMESPACE::DeviceAddress pipelineAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineAddress = pipelineAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindPipelineIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindPipelineIndirectCommandNV *>( this );
    }

    operator VkBindPipelineIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindPipelineIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pipelineAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindPipelineIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindPipelineIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pipelineAddress == rhs.pipelineAddress );
#  endif
    }

    bool operator!=( BindPipelineIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress pipelineAddress = {};
  };

  struct BindShaderGroupIndirectCommandNV
  {
    using NativeType = VkBindShaderGroupIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( uint32_t groupIndex_ = {} ) VULKAN_HPP_NOEXCEPT : groupIndex{ groupIndex_ } {}

    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindShaderGroupIndirectCommandNV( *reinterpret_cast<BindShaderGroupIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindShaderGroupIndirectCommandNV & operator=( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindShaderGroupIndirectCommandNV & operator=( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindShaderGroupIndirectCommandNV & setGroupIndex( uint32_t groupIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      groupIndex = groupIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindShaderGroupIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindShaderGroupIndirectCommandNV *>( this );
    }

    operator VkBindShaderGroupIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindShaderGroupIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( groupIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindShaderGroupIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( groupIndex == rhs.groupIndex );
#  endif
    }

    bool operator!=( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t groupIndex = {};
  };

  struct SparseMemoryBind
  {
    using NativeType = VkSparseMemoryBind;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseMemoryBind( VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset_ = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            size_           = {},
                                           VULKAN_HPP_NAMESPACE::DeviceMemory          memory_         = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_   = {},
                                           VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_          = {} ) VULKAN_HPP_NOEXCEPT
      : resourceOffset{ resourceOffset_ }
      , size{ size_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseMemoryBind( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT : SparseMemoryBind( *reinterpret_cast<SparseMemoryBind const *>( &rhs ) ) {}

    SparseMemoryBind & operator=( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseMemoryBind & operator=( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setResourceOffset( VULKAN_HPP_NAMESPACE::DeviceSize resourceOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      resourceOffset = resourceOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseMemoryBind *>( this );
    }

    operator VkSparseMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( resourceOffset, size, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseMemoryBind const & ) const = default;
#else
    bool operator==( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( resourceOffset == rhs.resourceOffset ) && ( size == rhs.size ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset ) &&
             ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            size           = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset   = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags          = {};
  };

  struct SparseBufferMemoryBindInfo
  {
    using NativeType = VkSparseBufferMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( VULKAN_HPP_NAMESPACE::Buffer                   buffer_    = {},
                                                     uint32_t                                       bindCount_ = {},
                                                     const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : buffer{ buffer_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseBufferMemoryBindInfo( *reinterpret_cast<SparseBufferMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo( VULKAN_HPP_NAMESPACE::Buffer                                                                        buffer_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : buffer( buffer_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseBufferMemoryBindInfo & operator=( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseBufferMemoryBindInfo & operator=( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseBufferMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseBufferMemoryBindInfo *>( this );
    }

    operator VkSparseBufferMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseBufferMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Buffer const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( buffer, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseBufferMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( buffer == rhs.buffer ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer                   buffer    = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };

  struct SparseImageOpaqueMemoryBindInfo
  {
    using NativeType = VkSparseImageOpaqueMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageOpaqueMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                    image_     = {},
                                                          uint32_t                                       bindCount_ = {},
                                                          const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : image{ image_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageOpaqueMemoryBindInfo( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageOpaqueMemoryBindInfo( *reinterpret_cast<SparseImageOpaqueMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                                                                         image_,
                                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseImageOpaqueMemoryBindInfo & operator=( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageOpaqueMemoryBindInfo & operator=( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageOpaqueMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    operator VkSparseImageOpaqueMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Image const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageOpaqueMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                    image     = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };

  struct ImageSubresource
  {
    using NativeType = VkImageSubresource;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ImageSubresource( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {}, uint32_t mipLevel_ = {}, uint32_t arrayLayer_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , mipLevel{ mipLevel_ }
      , arrayLayer{ arrayLayer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresource( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT : ImageSubresource( *reinterpret_cast<ImageSubresource const *>( &rhs ) ) {}

    ImageSubresource & operator=( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageSubresource & operator=( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresource const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setArrayLayer( uint32_t arrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayLayer = arrayLayer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageSubresource const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresource *>( this );
    }

    operator VkImageSubresource &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresource *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, arrayLayer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresource const & ) const = default;
#else
    bool operator==( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( arrayLayer == rhs.arrayLayer );
#  endif
    }

    bool operator!=( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
    uint32_t                               mipLevel   = {};
    uint32_t                               arrayLayer = {};
  };

  struct Offset3D
  {
    using NativeType = VkOffset3D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset3D( int32_t x_ = {}, int32_t y_ = {}, int32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , z{ z_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset3D( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset3D( *reinterpret_cast<Offset3D const *>( &rhs ) ) {}

    explicit Offset3D( Offset2D const & offset2D, int32_t z_ = {} ) : x( offset2D.x ), y( offset2D.y ), z( z_ ) {}

    Offset3D & operator=( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Offset3D & operator=( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset3D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setZ( int32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkOffset3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset3D *>( this );
    }

    operator VkOffset3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, z );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset3D const & ) const = default;
#else
    bool operator==( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
#  endif
    }

    bool operator!=( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
    int32_t z = {};
  };

  struct Extent3D
  {
    using NativeType = VkExtent3D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent3D( uint32_t width_ = {}, uint32_t height_ = {}, uint32_t depth_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
      , depth{ depth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent3D( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent3D( *reinterpret_cast<Extent3D const *>( &rhs ) ) {}

    explicit Extent3D( Extent2D const & extent2D, uint32_t depth_ = {} ) : width( extent2D.width ), height( extent2D.height ), depth( depth_ ) {}

    Extent3D & operator=( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Extent3D & operator=( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent3D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setDepth( uint32_t depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkExtent3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent3D *>( this );
    }

    operator VkExtent3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height, depth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent3D const & ) const = default;
#else
    bool operator==( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height ) && ( depth == rhs.depth );
#  endif
    }

    bool operator!=( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
    uint32_t depth  = {};
  };

  struct SparseImageMemoryBind
  {
    using NativeType = VkSparseImageMemoryBind;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( VULKAN_HPP_NAMESPACE::ImageSubresource      subresource_  = {},
                                                VULKAN_HPP_NAMESPACE::Offset3D              offset_       = {},
                                                VULKAN_HPP_NAMESPACE::Extent3D              extent_       = {},
                                                VULKAN_HPP_NAMESPACE::DeviceMemory          memory_       = {},
                                                VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_ = {},
                                                VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : subresource{ subresource_ }
      , offset{ offset_ }
      , extent{ extent_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBind( *reinterpret_cast<SparseImageMemoryBind const *>( &rhs ) )
    {
    }

    SparseImageMemoryBind & operator=( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageMemoryBind & operator=( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setSubresource( VULKAN_HPP_NAMESPACE::ImageSubresource const & subresource_ ) VULKAN_HPP_NOEXCEPT
    {
      subresource = subresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setOffset( VULKAN_HPP_NAMESPACE::Offset3D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBind *>( this );
    }

    operator VkSparseImageMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageSubresource const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( subresource, offset, extent, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBind const & ) const = default;
#else
    bool operator==( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( subresource == rhs.subresource ) && ( offset == rhs.offset ) && ( extent == rhs.extent ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresource      subresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D              offset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D              extent       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags        = {};
  };

  struct SparseImageMemoryBindInfo
  {
    using NativeType = VkSparseImageMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                         image_     = {},
                                                    uint32_t                                            bindCount_ = {},
                                                    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : image{ image_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBindInfo( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBindInfo( *reinterpret_cast<SparseImageMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                                                                              image_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseImageMemoryBindInfo & operator=( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageMemoryBindInfo & operator=( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBindInfo *>( this );
    }

    operator VkSparseImageMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Image const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                         image     = {};
    uint32_t                                            bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds    = {};
  };

  struct BindSparseInfo
  {
    using NativeType = VkBindSparseInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindSparseInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindSparseInfo( uint32_t                                                      waitSemaphoreCount_   = {},
                                         const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores_      = {},
                                         uint32_t                                                      bufferBindCount_      = {},
                                         const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds_         = {},
                                         uint32_t                                                      imageOpaqueBindCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_    = {},
                                         uint32_t                                                      imageBindCount_       = {},
                                         const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds_          = {},
                                         uint32_t                                                      signalSemaphoreCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::Semaphore *                       pSignalSemaphores_    = {},
                                         const void *                                                  pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , waitSemaphoreCount{ waitSemaphoreCount_ }
      , pWaitSemaphores{ pWaitSemaphores_ }
      , bufferBindCount{ bufferBindCount_ }
      , pBufferBinds{ pBufferBinds_ }
      , imageOpaqueBindCount{ imageOpaqueBindCount_ }
      , pImageOpaqueBinds{ pImageOpaqueBinds_ }
      , imageBindCount{ imageBindCount_ }
      , pImageBinds{ pImageBinds_ }
      , signalSemaphoreCount{ signalSemaphoreCount_ }
      , pSignalSemaphores{ pSignalSemaphores_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindSparseInfo( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindSparseInfo( *reinterpret_cast<BindSparseInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const &                       waitSemaphores_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const &      bufferBinds_      = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const &       imageBinds_       = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const &                       signalSemaphores_ = {},
                    const void *                                                                                                       pNext_ = nullptr )
      : pNext( pNext_ )
      , waitSemaphoreCount( static_cast<uint32_t>( waitSemaphores_.size() ) )
      , pWaitSemaphores( waitSemaphores_.data() )
      , bufferBindCount( static_cast<uint32_t>( bufferBinds_.size() ) )
      , pBufferBinds( bufferBinds_.data() )
      , imageOpaqueBindCount( static_cast<uint32_t>( imageOpaqueBinds_.size() ) )
      , pImageOpaqueBinds( imageOpaqueBinds_.data() )
      , imageBindCount( static_cast<uint32_t>( imageBinds_.size() ) )
      , pImageBinds( imageBinds_.data() )
      , signalSemaphoreCount( static_cast<uint32_t>( signalSemaphores_.size() ) )
      , pSignalSemaphores( signalSemaphores_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindSparseInfo & operator=( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindSparseInfo & operator=( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindSparseInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setWaitSemaphoreCount( uint32_t waitSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = waitSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPWaitSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pWaitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphores = pWaitSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo &
      setWaitSemaphores( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & waitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = static_cast<uint32_t>( waitSemaphores_.size() );
      pWaitSemaphores    = waitSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setBufferBindCount( uint32_t bufferBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = bufferBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPBufferBinds( const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo * pBufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferBinds = pBufferBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setBufferBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const & bufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = static_cast<uint32_t>( bufferBinds_.size() );
      pBufferBinds    = bufferBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageOpaqueBindCount( uint32_t imageOpaqueBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = imageOpaqueBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
      setPImageOpaqueBinds( const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageOpaqueBinds = pImageOpaqueBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageOpaqueBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = static_cast<uint32_t>( imageOpaqueBinds_.size() );
      pImageOpaqueBinds    = imageOpaqueBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageBindCount( uint32_t imageBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = imageBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPImageBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo * pImageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageBinds = pImageBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const & imageBinds_ )
      VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = static_cast<uint32_t>( imageBinds_.size() );
      pImageBinds    = imageBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setSignalSemaphoreCount( uint32_t signalSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = signalSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPSignalSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pSignalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphores = pSignalSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo &
      setSignalSemaphores( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & signalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = static_cast<uint32_t>( signalSemaphores_.size() );
      pSignalSemaphores    = signalSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindSparseInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindSparseInfo *>( this );
    }

    operator VkBindSparseInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindSparseInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Semaphore * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Semaphore * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       waitSemaphoreCount,
                       pWaitSemaphores,
                       bufferBindCount,
                       pBufferBinds,
                       imageOpaqueBindCount,
                       pImageOpaqueBinds,
                       imageBindCount,
                       pImageBinds,
                       signalSemaphoreCount,
                       pSignalSemaphores );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindSparseInfo const & ) const = default;
#else
    bool operator==( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreCount == rhs.waitSemaphoreCount ) &&
             ( pWaitSemaphores == rhs.pWaitSemaphores ) && ( bufferBindCount == rhs.bufferBindCount ) && ( pBufferBinds == rhs.pBufferBinds ) &&
             ( imageOpaqueBindCount == rhs.imageOpaqueBindCount ) && ( pImageOpaqueBinds == rhs.pImageOpaqueBinds ) &&
             ( imageBindCount == rhs.imageBindCount ) && ( pImageBinds == rhs.pImageBinds ) && ( signalSemaphoreCount == rhs.signalSemaphoreCount ) &&
             ( pSignalSemaphores == rhs.pSignalSemaphores );
#  endif
    }

    bool operator!=( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType                = StructureType::eBindSparseInfo;
    const void *                                                  pNext                = {};
    uint32_t                                                      waitSemaphoreCount   = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores      = {};
    uint32_t                                                      bufferBindCount      = {};
    const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds         = {};
    uint32_t                                                      imageOpaqueBindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds    = {};
    uint32_t                                                      imageBindCount       = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds          = {};
    uint32_t                                                      signalSemaphoreCount = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pSignalSemaphores    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindSparseInfo>
  {
    using Type = BindSparseInfo;
  };

  struct BindVertexBufferIndirectCommandEXT
  {
    using NativeType = VkBindVertexBufferIndirectCommandEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandEXT( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                                             uint32_t                            size_          = {},
                                                             uint32_t                            stride_        = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandEXT( BindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandEXT( VkBindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandEXT( *reinterpret_cast<BindVertexBufferIndirectCommandEXT const *>( &rhs ) )
    {
    }

    BindVertexBufferIndirectCommandEXT & operator=( BindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandEXT & operator=( VkBindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVertexBufferIndirectCommandEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindVertexBufferIndirectCommandEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandEXT const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( BindVertexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    uint32_t                            stride        = {};
  };

  struct BindVertexBufferIndirectCommandNV
  {
    using NativeType = VkBindVertexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                                            uint32_t                            size_          = {},
                                                            uint32_t                            stride_        = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandNV( *reinterpret_cast<BindVertexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindVertexBufferIndirectCommandNV & operator=( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandNV & operator=( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVertexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandNV *>( this );
    }

    operator VkBindVertexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    uint32_t                            stride        = {};
  };

  struct BindVideoSessionMemoryInfoKHR
  {
    using NativeType = VkBindVideoSessionMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindVideoSessionMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVideoSessionMemoryInfoKHR( uint32_t                           memoryBindIndex_ = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceMemory memory_          = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_    = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceSize   memorySize_      = {},
                                                        const void *                       pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , memoryBindIndex{ memoryBindIndex_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , memorySize{ memorySize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVideoSessionMemoryInfoKHR( BindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVideoSessionMemoryInfoKHR( VkBindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVideoSessionMemoryInfoKHR( *reinterpret_cast<BindVideoSessionMemoryInfoKHR const *>( &rhs ) )
    {
    }

    BindVideoSessionMemoryInfoKHR & operator=( BindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVideoSessionMemoryInfoKHR & operator=( VkBindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindVideoSessionMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemoryBindIndex( uint32_t memoryBindIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBindIndex = memoryBindIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemorySize( VULKAN_HPP_NAMESPACE::DeviceSize memorySize_ ) VULKAN_HPP_NOEXCEPT
    {
      memorySize = memorySize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVideoSessionMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVideoSessionMemoryInfoKHR *>( this );
    }

    operator VkBindVideoSessionMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVideoSessionMemoryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, memoryBindIndex, memory, memoryOffset, memorySize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVideoSessionMemoryInfoKHR const & ) const = default;
#else
    bool operator==( BindVideoSessionMemoryInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryBindIndex == rhs.memoryBindIndex ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( memorySize == rhs.memorySize );
#  endif
    }

    bool operator!=( BindVideoSessionMemoryInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eBindVideoSessionMemoryInfoKHR;
    const void *                        pNext           = {};
    uint32_t                            memoryBindIndex = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory          = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memorySize      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindVideoSessionMemoryInfoKHR>
  {
    using Type = BindVideoSessionMemoryInfoKHR;
  };

  struct BlitImageCubicWeightsInfoQCOM
  {
    using NativeType = VkBlitImageCubicWeightsInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageCubicWeightsInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BlitImageCubicWeightsInfoQCOM( VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM cubicWeights_ = VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM::eCatmullRom,
                                     const void *                                 pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , cubicWeights{ cubicWeights_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BlitImageCubicWeightsInfoQCOM( BlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageCubicWeightsInfoQCOM( VkBlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : BlitImageCubicWeightsInfoQCOM( *reinterpret_cast<BlitImageCubicWeightsInfoQCOM const *>( &rhs ) )
    {
    }

    BlitImageCubicWeightsInfoQCOM & operator=( BlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BlitImageCubicWeightsInfoQCOM & operator=( VkBlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BlitImageCubicWeightsInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageCubicWeightsInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageCubicWeightsInfoQCOM & setCubicWeights( VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM cubicWeights_ ) VULKAN_HPP_NOEXCEPT
    {
      cubicWeights = cubicWeights_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBlitImageCubicWeightsInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

    operator VkBlitImageCubicWeightsInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, cubicWeights );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageCubicWeightsInfoQCOM const & ) const = default;
#else
    bool operator==( BlitImageCubicWeightsInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( cubicWeights == rhs.cubicWeights );
#  endif
    }

    bool operator!=( BlitImageCubicWeightsInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType        = StructureType::eBlitImageCubicWeightsInfoQCOM;
    const void *                                 pNext        = {};
    VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM cubicWeights = VULKAN_HPP_NAMESPACE::CubicFilterWeightsQCOM::eCatmullRom;
  };

  template <>
  struct CppType<StructureType, StructureType::eBlitImageCubicWeightsInfoQCOM>
  {
    using Type = BlitImageCubicWeightsInfoQCOM;
  };

  struct ImageSubresourceLayers
  {
    using NativeType = VkImageSubresourceLayers;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                 uint32_t                               mipLevel_       = {},
                                                 uint32_t                               baseArrayLayer_ = {},
                                                 uint32_t                               layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , mipLevel{ mipLevel_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceLayers( *reinterpret_cast<ImageSubresourceLayers const *>( &rhs ) )
    {
    }

    ImageSubresourceLayers & operator=( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageSubresourceLayers & operator=( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageSubresourceLayers const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceLayers const & ) const = default;
#else
    bool operator==( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               mipLevel       = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };

  struct ImageBlit2
  {
    using NativeType = VkImageBlit2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageBlit2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          srcSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_     = {},
                                        VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          dstSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_     = {},
                                        const void *                                          pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffsets{ srcOffsets_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffsets{ dstOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageBlit2( *reinterpret_cast<ImageBlit2 const *>( &rhs ) ) {}

    ImageBlit2 & operator=( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageBlit2 & operator=( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageBlit2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageBlit2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit2 *>( this );
    }

    operator VkImageBlit2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffsets, dstSubresource, dstOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit2 const & ) const = default;
#else
    bool operator==( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffsets == rhs.srcOffsets ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffsets == rhs.dstOffsets );
#  endif
    }

    bool operator!=( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                     sType          = StructureType::eImageBlit2;
    const void *                                                            pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            srcSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> srcOffsets     = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            dstSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> dstOffsets     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageBlit2>
  {
    using Type = ImageBlit2;
  };

  using ImageBlit2KHR = ImageBlit2;

  struct BlitImageInfo2
  {
    using NativeType = VkBlitImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            uint32_t                                 regionCount_    = {},
                                            const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_       = {},
                                            VULKAN_HPP_NAMESPACE::Filter             filter_         = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                                            const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
      , filter{ filter_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : BlitImageInfo2( *reinterpret_cast<BlitImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_,
                    VULKAN_HPP_NAMESPACE::Filter filter_ = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                    const void *                 pNext_  = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
      , filter( filter_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BlitImageInfo2 & operator=( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BlitImageInfo2 & operator=( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BlitImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setFilter( VULKAN_HPP_NAMESPACE::Filter filter_ ) VULKAN_HPP_NOEXCEPT
    {
      filter = filter_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBlitImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageInfo2 *>( this );
    }

    operator VkBlitImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageBlit2 * const &,
               VULKAN_HPP_NAMESPACE::Filter const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageInfo2 const & ) const = default;
#else
    bool operator==( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions ) &&
             ( filter == rhs.filter );
#  endif
    }

    bool operator!=( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eBlitImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions       = {};
    VULKAN_HPP_NAMESPACE::Filter             filter         = VULKAN_HPP_NAMESPACE::Filter::eNearest;
  };

  template <>
  struct CppType<StructureType, StructureType::eBlitImageInfo2>
  {
    using Type = BlitImageInfo2;
  };

  using BlitImageInfo2KHR = BlitImageInfo2;

  struct BufferCaptureDescriptorDataInfoEXT
  {
    using NativeType = VkBufferCaptureDescriptorDataInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCaptureDescriptorDataInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCaptureDescriptorDataInfoEXT( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCaptureDescriptorDataInfoEXT( BufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCaptureDescriptorDataInfoEXT( VkBufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCaptureDescriptorDataInfoEXT( *reinterpret_cast<BufferCaptureDescriptorDataInfoEXT const *>( &rhs ) )
    {
    }

    BufferCaptureDescriptorDataInfoEXT & operator=( BufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCaptureDescriptorDataInfoEXT & operator=( VkBufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCaptureDescriptorDataInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCaptureDescriptorDataInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCaptureDescriptorDataInfoEXT & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCaptureDescriptorDataInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkBufferCaptureDescriptorDataInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCaptureDescriptorDataInfoEXT const & ) const = default;
#else
    bool operator==( BufferCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferCaptureDescriptorDataInfoEXT;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCaptureDescriptorDataInfoEXT>
  {
    using Type = BufferCaptureDescriptorDataInfoEXT;
  };

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionBufferCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionBufferCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                                                  uint32_t                                      index_      = {},
                                                                  const void *                                  pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collection{ collection_ }
      , index{ index_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionBufferCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA &
      setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionBufferCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionBufferCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionBufferCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionBufferCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionBufferCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( uint32_t     minBufferCount_                  = {},
                                                                 uint32_t     maxBufferCount_                  = {},
                                                                 uint32_t     minBufferCountForCamping_        = {},
                                                                 uint32_t     minBufferCountForDedicatedSlack_ = {},
                                                                 uint32_t     minBufferCountForSharedSlack_    = {},
                                                                 const void * pNext_                           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , minBufferCount{ minBufferCount_ }
      , maxBufferCount{ maxBufferCount_ }
      , minBufferCountForCamping{ minBufferCountForCamping_ }
      , minBufferCountForDedicatedSlack{ minBufferCountForDedicatedSlack_ }
      , minBufferCountForSharedSlack{ minBufferCountForSharedSlack_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionConstraintsInfoFUCHSIA( *reinterpret_cast<BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionConstraintsInfoFUCHSIA & operator=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionConstraintsInfoFUCHSIA & operator=( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCount( uint32_t minBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCount = minBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMaxBufferCount( uint32_t maxBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxBufferCount = maxBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCountForCamping( uint32_t minBufferCountForCamping_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForCamping = minBufferCountForCamping_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForDedicatedSlack( uint32_t minBufferCountForDedicatedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForDedicatedSlack = minBufferCountForDedicatedSlack_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForSharedSlack( uint32_t minBufferCountForSharedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForSharedSlack = minBufferCountForSharedSlack_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, minBufferCount, maxBufferCount, minBufferCountForCamping, minBufferCountForDedicatedSlack, minBufferCountForSharedSlack );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( minBufferCount == rhs.minBufferCount ) && ( maxBufferCount == rhs.maxBufferCount ) &&
             ( minBufferCountForCamping == rhs.minBufferCountForCamping ) && ( minBufferCountForDedicatedSlack == rhs.minBufferCountForDedicatedSlack ) &&
             ( minBufferCountForSharedSlack == rhs.minBufferCountForSharedSlack );
#    endif
    }

    bool operator!=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                           = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;
    const void *                        pNext                           = {};
    uint32_t                            minBufferCount                  = {};
    uint32_t                            maxBufferCount                  = {};
    uint32_t                            minBufferCountForCamping        = {};
    uint32_t                            minBufferCountForDedicatedSlack = {};
    uint32_t                            minBufferCountForSharedSlack    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionConstraintsInfoFUCHSIA>
  {
    using Type = BufferCollectionConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( zx_handle_t collectionToken_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collectionToken{ collectionToken_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionCreateInfoFUCHSIA & operator=( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionCreateInfoFUCHSIA & operator=( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setCollectionToken( zx_handle_t collectionToken_ ) VULKAN_HPP_NOEXCEPT
    {
      collectionToken = collectionToken_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, zx_handle_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collectionToken );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ) == 0 );
    }

    bool operator!=( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eBufferCollectionCreateInfoFUCHSIA;
    const void *                        pNext           = {};
    zx_handle_t                         collectionToken = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionImageCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionImageCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                                                 uint32_t                                      index_      = {},
                                                                 const void *                                  pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collection{ collection_ }
      , index{ index_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionImageCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionImageCreateInfoFUCHSIA & operator=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionImageCreateInfoFUCHSIA & operator=( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA &
      setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionImageCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionImageCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionImageCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionImageCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionImageCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct SysmemColorSpaceFUCHSIA
  {
    using NativeType = VkSysmemColorSpaceFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSysmemColorSpaceFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( uint32_t colorSpace_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorSpace{ colorSpace_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : SysmemColorSpaceFUCHSIA( *reinterpret_cast<SysmemColorSpaceFUCHSIA const *>( &rhs ) )
    {
    }

    SysmemColorSpaceFUCHSIA & operator=( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SysmemColorSpaceFUCHSIA & operator=( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setColorSpace( uint32_t colorSpace_ ) VULKAN_HPP_NOEXCEPT
    {
      colorSpace = colorSpace_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSysmemColorSpaceFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSysmemColorSpaceFUCHSIA *>( this );
    }

    operator VkSysmemColorSpaceFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSysmemColorSpaceFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorSpace );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SysmemColorSpaceFUCHSIA const & ) const = default;
#  else
    bool operator==( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorSpace == rhs.colorSpace );
#    endif
    }

    bool operator!=( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eSysmemColorSpaceFUCHSIA;
    const void *                        pNext      = {};
    uint32_t                            colorSpace = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eSysmemColorSpaceFUCHSIA>
  {
    using Type = SysmemColorSpaceFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionPropertiesFUCHSIA
  {
    using NativeType = VkBufferCollectionPropertiesFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionPropertiesFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA(
      uint32_t                                          memoryTypeBits_                   = {},
      uint32_t                                          bufferCount_                      = {},
      uint32_t                                          createInfoIndex_                  = {},
      uint64_t                                          sysmemPixelFormat_                = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex_            = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , memoryTypeBits{ memoryTypeBits_ }
      , bufferCount{ bufferCount_ }
      , createInfoIndex{ createInfoIndex_ }
      , sysmemPixelFormat{ sysmemPixelFormat_ }
      , formatFeatures{ formatFeatures_ }
      , sysmemColorSpaceIndex{ sysmemColorSpaceIndex_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionPropertiesFUCHSIA( *reinterpret_cast<BufferCollectionPropertiesFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionPropertiesFUCHSIA & operator=( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionPropertiesFUCHSIA & operator=( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA const *>( &rhs );
      return *this;
    }

    operator VkBufferCollectionPropertiesFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    operator VkBufferCollectionPropertiesFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       memoryTypeBits,
                       bufferCount,
                       createInfoIndex,
                       sysmemPixelFormat,
                       formatFeatures,
                       sysmemColorSpaceIndex,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionPropertiesFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryTypeBits == rhs.memoryTypeBits ) && ( bufferCount == rhs.bufferCount ) &&
             ( createInfoIndex == rhs.createInfoIndex ) && ( sysmemPixelFormat == rhs.sysmemPixelFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( sysmemColorSpaceIndex == rhs.sysmemColorSpaceIndex ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eBufferCollectionPropertiesFUCHSIA;
    void *                                            pNext                            = {};
    uint32_t                                          memoryTypeBits                   = {};
    uint32_t                                          bufferCount                      = {};
    uint32_t                                          createInfoIndex                  = {};
    uint64_t                                          sysmemPixelFormat                = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex            = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionPropertiesFUCHSIA>
  {
    using Type = BufferCollectionPropertiesFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCreateInfo
  {
    using NativeType = VkBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_                 = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize        size_                  = {},
                                           VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage_                 = {},
                                           VULKAN_HPP_NAMESPACE::SharingMode       sharingMode_           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive,
                                           uint32_t                                queueFamilyIndexCount_ = {},
                                           const uint32_t *                        pQueueFamilyIndices_   = {},
                                           const void *                            pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , size{ size_ }
      , usage{ usage_ }
      , sharingMode{ sharingMode_ }
      , queueFamilyIndexCount{ queueFamilyIndexCount_ }
      , pQueueFamilyIndices{ pQueueFamilyIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCreateInfo( *reinterpret_cast<BufferCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags                               flags_,
                      VULKAN_HPP_NAMESPACE::DeviceSize                                      size_,
                      VULKAN_HPP_NAMESPACE::BufferUsageFlags                                usage_,
                      VULKAN_HPP_NAMESPACE::SharingMode                                     sharingMode_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_,
                      const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BufferCreateInfo & operator=( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCreateInfo & operator=( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setUsage( VULKAN_HPP_NAMESPACE::BufferUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSharingMode( VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo & setQueueFamilyIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferCreateFlags const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::BufferUsageFlags const &,
               VULKAN_HPP_NAMESPACE::SharingMode const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, size, usage, sharingMode, queueFamilyIndexCount, pQueueFamilyIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCreateInfo const & ) const = default;
#else
    bool operator==( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( size == rhs.size ) && ( usage == rhs.usage ) &&
             ( sharingMode == rhs.sharingMode ) && ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) && ( pQueueFamilyIndices == rhs.pQueueFamilyIndices );
#  endif
    }

    bool operator!=( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType     sType                 = StructureType::eBufferCreateInfo;
    const void *                            pNext                 = {};
    VULKAN_HPP_NAMESPACE::BufferCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::DeviceSize        size                  = {};
    VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage                 = {};
    VULKAN_HPP_NAMESPACE::SharingMode       sharingMode           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive;
    uint32_t                                queueFamilyIndexCount = {};
    const uint32_t *                        pQueueFamilyIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCreateInfo>
  {
    using Type = BufferCreateInfo;
  };

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo_                  = {},
                                                       VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures_      = {},
                                                       VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints_ = {},
                                                       const void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , createInfo{ createInfo_ }
      , requiredFormatFeatures{ requiredFormatFeatures_ }
      , bufferCollectionConstraints{ bufferCollectionConstraints_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferConstraintsInfoFUCHSIA( *reinterpret_cast<BufferConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferConstraintsInfoFUCHSIA & operator=( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferConstraintsInfoFUCHSIA & operator=( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateInfo const & createInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfo = createInfo_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setRequiredFormatFeatures( VULKAN_HPP_NAMESPACE::FormatFeatureFlags requiredFormatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      requiredFormatFeatures = requiredFormatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setBufferCollectionConstraints( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const & bufferCollectionConstraints_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferCollectionConstraints = bufferCollectionConstraints_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferCreateInfo const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createInfo, requiredFormatFeatures, bufferCollectionConstraints );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createInfo == rhs.createInfo ) && ( requiredFormatFeatures == rhs.requiredFormatFeatures ) &&
             ( bufferCollectionConstraints == rhs.bufferCollectionConstraints );
#    endif
    }

    bool operator!=( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType                       = StructureType::eBufferConstraintsInfoFUCHSIA;
    const void *                                                 pNext                       = {};
    VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo                  = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferConstraintsInfoFUCHSIA>
  {
    using Type = BufferConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCopy
  {
    using NativeType = VkBufferCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize size_      = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy( *reinterpret_cast<BufferCopy const *>( &rhs ) ) {}

    BufferCopy & operator=( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCopy & operator=( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy *>( this );
    }

    operator VkBufferCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy const & ) const = default;
#else
    bool operator==( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize size      = {};
  };

  struct BufferCopy2
  {
    using NativeType = VkBufferCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy2( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize size_      = {},
                                      const void *                     pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy2( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy2( *reinterpret_cast<BufferCopy2 const *>( &rhs ) ) {}

    BufferCopy2 & operator=( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCopy2 & operator=( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy2 *>( this );
    }

    operator VkBufferCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy2 const & ) const = default;
#else
    bool operator==( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eBufferCopy2;
    const void *                        pNext     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCopy2>
  {
    using Type = BufferCopy2;
  };

  using BufferCopy2KHR = BufferCopy2;

  struct BufferDeviceAddressCreateInfoEXT
  {
    using NativeType = VkBufferDeviceAddressCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {},
                                                           const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceAddress{ deviceAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressCreateInfoEXT( *reinterpret_cast<BufferDeviceAddressCreateInfoEXT const *>( &rhs ) )
    {
    }

    BufferDeviceAddressCreateInfoEXT & operator=( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferDeviceAddressCreateInfoEXT & operator=( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferDeviceAddressCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    operator VkBufferDeviceAddressCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressCreateInfoEXT const & ) const = default;
#else
    bool operator==( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eBufferDeviceAddressCreateInfoEXT;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressCreateInfoEXT>
  {
    using Type = BufferDeviceAddressCreateInfoEXT;
  };

  struct BufferDeviceAddressInfo
  {
    using NativeType = VkBufferDeviceAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressInfo( *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs ) )
    {
    }

    BufferDeviceAddressInfo & operator=( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferDeviceAddressInfo & operator=( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferDeviceAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressInfo const & ) const = default;
#else
    bool operator==( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferDeviceAddressInfo;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressInfo>
  {
    using Type = BufferDeviceAddressInfo;
  };

  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

  struct BufferImageCopy
  {
    using NativeType = VkBufferImageCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                          uint32_t                                     bufferRowLength_   = {},
                                          uint32_t                                     bufferImageHeight_ = {},
                                          VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                          VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                          VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy( *reinterpret_cast<BufferImageCopy const *>( &rhs ) ) {}

    BufferImageCopy & operator=( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferImageCopy & operator=( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy const & ) const = default;
#else
    bool operator==( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  struct BufferImageCopy2
  {
    using NativeType = VkBufferImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferImageCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy2( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                           uint32_t                                     bufferRowLength_   = {},
                                           uint32_t                                     bufferImageHeight_ = {},
                                           VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                           VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                           VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {},
                                           const void *                                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy2( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy2( *reinterpret_cast<BufferImageCopy2 const *>( &rhs ) ) {}

    BufferImageCopy2 & operator=( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferImageCopy2 & operator=( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy2 *>( this );
    }

    operator VkBufferImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy2 const & ) const = default;
#else
    bool operator==( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) &&
             ( bufferImageHeight == rhs.bufferImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eBufferImageCopy2;
    const void *                                 pNext             = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferImageCopy2>
  {
    using Type = BufferImageCopy2;
  };

  using BufferImageCopy2KHR = BufferImageCopy2;

  struct BufferMemoryBarrier
  {
    using NativeType = VkBufferMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_       = {},
                                              uint32_t                          srcQueueFamilyIndex_ = {},
                                              uint32_t                          dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Buffer      buffer_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  offset_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  size_                = {},
                                              const void *                      pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT : BufferMemoryBarrier( *reinterpret_cast<BufferMemoryBarrier const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier & operator=( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryBarrier & operator=( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcAccessMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) && ( dstAccessMask == rhs.dstAccessMask ) &&
             ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eBufferMemoryBarrier;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   dstAccessMask       = {};
    uint32_t                            srcQueueFamilyIndex = {};
    uint32_t                            dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier>
  {
    using Type = BufferMemoryBarrier;
  };

  struct BufferMemoryBarrier2
  {
    using NativeType = VkBufferMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask_       = {},
                                               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask_       = {},
                                               uint32_t                                  srcQueueFamilyIndex_ = {},
                                               uint32_t                                  dstQueueFamilyIndex_ = {},
                                               VULKAN_HPP_NAMESPACE::Buffer              buffer_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          offset_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          size_                = {},
                                               const void *                              pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcStageMask{ srcStageMask_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstStageMask{ dstStageMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier2( *reinterpret_cast<BufferMemoryBarrier2 const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier2 & operator=( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryBarrier2 & operator=( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier2 *>( this );
    }

    operator VkBufferMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier2 const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType               = StructureType::eBufferMemoryBarrier2;
    const void *                              pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask       = {};
    uint32_t                                  srcQueueFamilyIndex = {};
    uint32_t                                  dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer              buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier2>
  {
    using Type = BufferMemoryBarrier2;
  };

  using BufferMemoryBarrier2KHR = BufferMemoryBarrier2;

  struct BufferMemoryRequirementsInfo2
  {
    using NativeType = VkBufferMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryRequirementsInfo2( *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs ) )
    {
    }

    BufferMemoryRequirementsInfo2 & operator=( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryRequirementsInfo2 & operator=( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferMemoryRequirementsInfo2;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryRequirementsInfo2>
  {
    using Type = BufferMemoryRequirementsInfo2;
  };

  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

  struct BufferOpaqueCaptureAddressCreateInfo
  {
    using NativeType = VkBufferOpaqueCaptureAddressCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferOpaqueCaptureAddressCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( uint64_t opaqueCaptureAddress_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , opaqueCaptureAddress{ opaqueCaptureAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferOpaqueCaptureAddressCreateInfo( *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs ) )
    {
    }

    BufferOpaqueCaptureAddressCreateInfo & operator=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferOpaqueCaptureAddressCreateInfo & operator=( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setOpaqueCaptureAddress( uint64_t opaqueCaptureAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      opaqueCaptureAddress = opaqueCaptureAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferOpaqueCaptureAddressCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, opaqueCaptureAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferOpaqueCaptureAddressCreateInfo const & ) const = default;
#else
    bool operator==( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( opaqueCaptureAddress == rhs.opaqueCaptureAddress );
#  endif
    }

    bool operator!=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eBufferOpaqueCaptureAddressCreateInfo;
    const void *                        pNext                = {};
    uint64_t                            opaqueCaptureAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferOpaqueCaptureAddressCreateInfo>
  {
    using Type = BufferOpaqueCaptureAddressCreateInfo;
  };

  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

  struct BufferUsageFlags2CreateInfo
  {
    using NativeType = VkBufferUsageFlags2CreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferUsageFlags2CreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferUsageFlags2CreateInfo( VULKAN_HPP_NAMESPACE::BufferUsageFlags2 usage_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , usage{ usage_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferUsageFlags2CreateInfo( BufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferUsageFlags2CreateInfo( VkBufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferUsageFlags2CreateInfo( *reinterpret_cast<BufferUsageFlags2CreateInfo const *>( &rhs ) )
    {
    }

    BufferUsageFlags2CreateInfo & operator=( BufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferUsageFlags2CreateInfo & operator=( VkBufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferUsageFlags2CreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferUsageFlags2CreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferUsageFlags2CreateInfo & setUsage( VULKAN_HPP_NAMESPACE::BufferUsageFlags2 usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferUsageFlags2CreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferUsageFlags2CreateInfo *>( this );
    }

    operator VkBufferUsageFlags2CreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferUsageFlags2CreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::BufferUsageFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, usage );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferUsageFlags2CreateInfo const & ) const = default;
#else
    bool operator==( BufferUsageFlags2CreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( usage == rhs.usage );
#  endif
    }

    bool operator!=( BufferUsageFlags2CreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType     sType = StructureType::eBufferUsageFlags2CreateInfo;
    const void *                            pNext = {};
    VULKAN_HPP_NAMESPACE::BufferUsageFlags2 usage = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferUsageFlags2CreateInfo>
  {
    using Type = BufferUsageFlags2CreateInfo;
  };

  using BufferUsageFlags2CreateInfoKHR = BufferUsageFlags2CreateInfo;

  struct BufferViewCreateInfo
  {
    using NativeType = VkBufferViewCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferViewCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_  = {},
                                               VULKAN_HPP_NAMESPACE::Buffer                buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::Format                format_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                               VULKAN_HPP_NAMESPACE::DeviceSize            offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize            range_  = {},
                                               const void *                                pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , buffer{ buffer_ }
      , format{ format_ }
      , offset{ offset_ }
      , range{ range_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferViewCreateInfo( *reinterpret_cast<BufferViewCreateInfo const *>( &rhs ) )
    {
    }

    BufferViewCreateInfo & operator=( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferViewCreateInfo & operator=( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferViewCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferViewCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, buffer, format, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferViewCreateInfo const & ) const = default;
#else
    bool operator==( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( buffer == rhs.buffer ) && ( format == rhs.format ) &&
             ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType  = StructureType::eBufferViewCreateInfo;
    const void *                                pNext  = {};
    VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags  = {};
    VULKAN_HPP_NAMESPACE::Buffer                buffer = {};
    VULKAN_HPP_NAMESPACE::Format                format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceSize            offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            range  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferViewCreateInfo>
  {
    using Type = BufferViewCreateInfo;
  };

  struct StridedDeviceAddressNV
  {
    using NativeType = VkStridedDeviceAddressNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR StridedDeviceAddressNV( VULKAN_HPP_NAMESPACE::DeviceAddress startAddress_  = {},
                                                 VULKAN_HPP_NAMESPACE::DeviceSize    strideInBytes_ = {} ) VULKAN_HPP_NOEXCEPT
      : startAddress{ startAddress_ }
      , strideInBytes{ strideInBytes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR StridedDeviceAddressNV( StridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    StridedDeviceAddressNV( VkStridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : StridedDeviceAddressNV( *reinterpret_cast<StridedDeviceAddressNV const *>( &rhs ) )
    {
    }

    StridedDeviceAddressNV & operator=( StridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    StridedDeviceAddressNV & operator=( VkStridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressNV & setStartAddress( VULKAN_HPP_NAMESPACE::DeviceAddress startAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      startAddress = startAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressNV & setStrideInBytes( VULKAN_HPP_NAMESPACE::DeviceSize strideInBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      strideInBytes = strideInBytes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkStridedDeviceAddressNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkStridedDeviceAddressNV *>( this );
    }

    operator VkStridedDeviceAddressNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkStridedDeviceAddressNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( startAddress, strideInBytes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( StridedDeviceAddressNV const & ) const = default;
#else
    bool operator==( StridedDeviceAddressNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( startAddress == rhs.startAddress ) && ( strideInBytes == rhs.strideInBytes );
#  endif
    }

    bool operator!=( StridedDeviceAddressNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress startAddress  = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    strideInBytes = {};
  };

  struct BuildPartitionedAccelerationStructureIndirectCommandNV
  {
    using NativeType = VkBuildPartitionedAccelerationStructureIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureIndirectCommandNV(
      VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV opType_   = VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV::eWriteInstance,
      uint32_t                                                       argCount_ = {},
      VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV                   argData_  = {} ) VULKAN_HPP_NOEXCEPT
      : opType{ opType_ }
      , argCount{ argCount_ }
      , argData{ argData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureIndirectCommandNV( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BuildPartitionedAccelerationStructureIndirectCommandNV( VkBuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BuildPartitionedAccelerationStructureIndirectCommandNV( *reinterpret_cast<BuildPartitionedAccelerationStructureIndirectCommandNV const *>( &rhs ) )
    {
    }

    BuildPartitionedAccelerationStructureIndirectCommandNV &
      operator=( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BuildPartitionedAccelerationStructureIndirectCommandNV &
      operator=( VkBuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BuildPartitionedAccelerationStructureIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV &
      setOpType( VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV opType_ ) VULKAN_HPP_NOEXCEPT
    {
      opType = opType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV & setArgCount( uint32_t argCount_ ) VULKAN_HPP_NOEXCEPT
    {
      argCount = argCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV &
      setArgData( VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV const & argData_ ) VULKAN_HPP_NOEXCEPT
    {
      argData = argData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV const &, uint32_t const &, VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( opType, argCount, argData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BuildPartitionedAccelerationStructureIndirectCommandNV const & ) const = default;
#else
    bool operator==( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( opType == rhs.opType ) && ( argCount == rhs.argCount ) && ( argData == rhs.argData );
#  endif
    }

    bool operator!=( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV opType   = VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureOpTypeNV::eWriteInstance;
    uint32_t                                                       argCount = {};
    VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV                   argData  = {};
  };

  struct PartitionedAccelerationStructureInstancesInputNV
  {
    using NativeType = VkPartitionedAccelerationStructureInstancesInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePartitionedAccelerationStructureInstancesInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PartitionedAccelerationStructureInstancesInputNV( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_         = {},
                                                                           uint32_t                                                 instanceCount_ = {},
                                                                           uint32_t maxInstancePerPartitionCount_                                  = {},
                                                                           uint32_t partitionCount_                                                = {},
                                                                           uint32_t maxInstanceInGlobalPartitionCount_                             = {},
                                                                           void *   pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , instanceCount{ instanceCount_ }
      , maxInstancePerPartitionCount{ maxInstancePerPartitionCount_ }
      , partitionCount{ partitionCount_ }
      , maxInstanceInGlobalPartitionCount{ maxInstanceInGlobalPartitionCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      PartitionedAccelerationStructureInstancesInputNV( PartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PartitionedAccelerationStructureInstancesInputNV( VkPartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : PartitionedAccelerationStructureInstancesInputNV( *reinterpret_cast<PartitionedAccelerationStructureInstancesInputNV const *>( &rhs ) )
    {
    }

    PartitionedAccelerationStructureInstancesInputNV & operator=( PartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    PartitionedAccelerationStructureInstancesInputNV & operator=( VkPartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureInstancesInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV &
      setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV &
      setMaxInstancePerPartitionCount( uint32_t maxInstancePerPartitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstancePerPartitionCount = maxInstancePerPartitionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setPartitionCount( uint32_t partitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      partitionCount = partitionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV &
      setMaxInstanceInGlobalPartitionCount( uint32_t maxInstanceInGlobalPartitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstanceInGlobalPartitionCount = maxInstanceInGlobalPartitionCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkPartitionedAccelerationStructureInstancesInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

    operator VkPartitionedAccelerationStructureInstancesInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, instanceCount, maxInstancePerPartitionCount, partitionCount, maxInstanceInGlobalPartitionCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PartitionedAccelerationStructureInstancesInputNV const & ) const = default;
#else
    bool operator==( PartitionedAccelerationStructureInstancesInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( instanceCount == rhs.instanceCount ) &&
             ( maxInstancePerPartitionCount == rhs.maxInstancePerPartitionCount ) && ( partitionCount == rhs.partitionCount ) &&
             ( maxInstanceInGlobalPartitionCount == rhs.maxInstanceInGlobalPartitionCount );
#  endif
    }

    bool operator!=( PartitionedAccelerationStructureInstancesInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType                        = StructureType::ePartitionedAccelerationStructureInstancesInputNV;
    void *                                                   pNext                        = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags                        = {};
    uint32_t                                                 instanceCount                = {};
    uint32_t                                                 maxInstancePerPartitionCount = {};
    uint32_t                                                 partitionCount               = {};
    uint32_t                                                 maxInstanceInGlobalPartitionCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePartitionedAccelerationStructureInstancesInputNV>
  {
    using Type = PartitionedAccelerationStructureInstancesInputNV;
  };

  struct BuildPartitionedAccelerationStructureInfoNV
  {
    using NativeType = VkBuildPartitionedAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBuildPartitionedAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureInstancesInputNV input_ = {},
                                                                      VULKAN_HPP_NAMESPACE::DeviceAddress srcAccelerationStructureData_             = {},
                                                                      VULKAN_HPP_NAMESPACE::DeviceAddress dstAccelerationStructureData_             = {},
                                                                      VULKAN_HPP_NAMESPACE::DeviceAddress scratchData_                              = {},
                                                                      VULKAN_HPP_NAMESPACE::DeviceAddress srcInfos_                                 = {},
                                                                      VULKAN_HPP_NAMESPACE::DeviceAddress srcInfosCount_                            = {},
                                                                      void *                              pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , input{ input_ }
      , srcAccelerationStructureData{ srcAccelerationStructureData_ }
      , dstAccelerationStructureData{ dstAccelerationStructureData_ }
      , scratchData{ scratchData_ }
      , srcInfos{ srcInfos_ }
      , srcInfosCount{ srcInfosCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureInfoNV( BuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BuildPartitionedAccelerationStructureInfoNV( VkBuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BuildPartitionedAccelerationStructureInfoNV( *reinterpret_cast<BuildPartitionedAccelerationStructureInfoNV const *>( &rhs ) )
    {
    }

    BuildPartitionedAccelerationStructureInfoNV & operator=( BuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BuildPartitionedAccelerationStructureInfoNV & operator=( VkBuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BuildPartitionedAccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setInput( VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureInstancesInputNV const & input_ ) VULKAN_HPP_NOEXCEPT
    {
      input = input_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setSrcAccelerationStructureData( VULKAN_HPP_NAMESPACE::DeviceAddress srcAccelerationStructureData_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructureData = srcAccelerationStructureData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setDstAccelerationStructureData( VULKAN_HPP_NAMESPACE::DeviceAddress dstAccelerationStructureData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructureData = dstAccelerationStructureData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setScratchData( VULKAN_HPP_NAMESPACE::DeviceAddress scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setSrcInfos( VULKAN_HPP_NAMESPACE::DeviceAddress srcInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfos = srcInfos_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setSrcInfosCount( VULKAN_HPP_NAMESPACE::DeviceAddress srcInfosCount_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosCount = srcInfosCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBuildPartitionedAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureInstancesInputNV const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, input, srcAccelerationStructureData, dstAccelerationStructureData, scratchData, srcInfos, srcInfosCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BuildPartitionedAccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( BuildPartitionedAccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( input == rhs.input ) &&
             ( srcAccelerationStructureData == rhs.srcAccelerationStructureData ) && ( dstAccelerationStructureData == rhs.dstAccelerationStructureData ) &&
             ( scratchData == rhs.scratchData ) && ( srcInfos == rhs.srcInfos ) && ( srcInfosCount == rhs.srcInfosCount );
#  endif
    }

    bool operator!=( BuildPartitionedAccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                    sType = StructureType::eBuildPartitionedAccelerationStructureInfoNV;
    void *                                                                 pNext = {};
    VULKAN_HPP_NAMESPACE::PartitionedAccelerationStructureInstancesInputNV input = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                    srcAccelerationStructureData = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                    dstAccelerationStructureData = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                    scratchData                  = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                    srcInfos                     = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                    srcInfosCount                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBuildPartitionedAccelerationStructureInfoNV>
  {
    using Type = BuildPartitionedAccelerationStructureInfoNV;
  };

  struct CalibratedTimestampInfoKHR
  {
    using NativeType = VkCalibratedTimestampInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCalibratedTimestampInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain_ = VULKAN_HPP_NAMESPACE::TimeDomainKHR::eDevice,
                                                     const void *                        pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , timeDomain{ timeDomain_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoKHR( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CalibratedTimestampInfoKHR( *reinterpret_cast<CalibratedTimestampInfoKHR const *>( &rhs ) )
    {
    }

    CalibratedTimestampInfoKHR & operator=( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CalibratedTimestampInfoKHR & operator=( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setTimeDomain( VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain_ ) VULKAN_HPP_NOEXCEPT
    {
      timeDomain = timeDomain_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCalibratedTimestampInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCalibratedTimestampInfoKHR *>( this );
    }

    operator VkCalibratedTimestampInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCalibratedTimestampInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::TimeDomainKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, timeDomain );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CalibratedTimestampInfoKHR const & ) const = default;
#else
    bool operator==( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( timeDomain == rhs.timeDomain );
#  endif
    }

    bool operator!=( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eCalibratedTimestampInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::TimeDomainKHR timeDomain = VULKAN_HPP_NAMESPACE::TimeDomainKHR::eDevice;
  };

  template <>
  struct CppType<StructureType, StructureType::eCalibratedTimestampInfoKHR>
  {
    using Type = CalibratedTimestampInfoKHR;
  };

  using CalibratedTimestampInfoEXT = CalibratedTimestampInfoKHR;

  struct CheckpointData2NV
  {
    using NativeType = VkCheckpointData2NV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointData2NV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CheckpointData2NV( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 stage_ = {}, void * pCheckpointMarker_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , pCheckpointMarker{ pCheckpointMarker_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointData2NV( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointData2NV( *reinterpret_cast<CheckpointData2NV const *>( &rhs ) ) {}

    CheckpointData2NV & operator=( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CheckpointData2NV & operator=( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointData2NV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointData2NV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointData2NV *>( this );
    }

    operator VkCheckpointData2NV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointData2NV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointData2NV const & ) const = default;
#else
    bool operator==( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType             = StructureType::eCheckpointData2NV;
    void *                                    pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 stage             = {};
    void *                                    pCheckpointMarker = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCheckpointData2NV>
  {
    using Type = CheckpointData2NV;
  };

  struct CheckpointDataNV
  {
    using NativeType = VkCheckpointDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointDataNV( VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage_ = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe,
                                           void *                                      pCheckpointMarker_ = {},
                                           void *                                      pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , pCheckpointMarker{ pCheckpointMarker_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointDataNV( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointDataNV( *reinterpret_cast<CheckpointDataNV const *>( &rhs ) ) {}

    CheckpointDataNV & operator=( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CheckpointDataNV & operator=( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointDataNV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointDataNV *>( this );
    }

    operator VkCheckpointDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::PipelineStageFlagBits const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointDataNV const & ) const = default;
#else
    bool operator==( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType             = StructureType::eCheckpointDataNV;
    void *                                      pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage             = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe;
    void *                                      pCheckpointMarker = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCheckpointDataNV>
  {
    using Type = CheckpointDataNV;
  };

  union ClearColorValue
  {
    using NativeType = VkClearColorValue;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<float, 4> & float32_ = {} ) : float32( float32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( float float32_0, float float32_1, float float32_2, float float32_3 )
      : float32{ { { float32_0, float32_1, float32_2, float32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<int32_t, 4> & int32_ ) : int32( int32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( int32_t int32_0, int32_t int32_1, int32_t int32_2, int32_t int32_3 )
      : int32{ { { int32_0, int32_1, int32_2, int32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<uint32_t, 4> & uint32_ ) : uint32( uint32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( uint32_t uint32_0, uint32_t uint32_1, uint32_t uint32_2, uint32_t uint32_3 )
      : uint32{ { { uint32_0, uint32_1, uint32_2, uint32_3 } } }
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setFloat32( std::array<float, 4> float32_ ) VULKAN_HPP_NOEXCEPT
    {
      float32 = float32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setInt32( std::array<int32_t, 4> int32_ ) VULKAN_HPP_NOEXCEPT
    {
      int32 = int32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setUint32( std::array<uint32_t, 4> uint32_ ) VULKAN_HPP_NOEXCEPT
    {
      uint32 = uint32_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearColorValue const &() const
    {
      return *reinterpret_cast<const VkClearColorValue *>( this );
    }

    operator VkClearColorValue &()
    {
      return *reinterpret_cast<VkClearColorValue *>( this );
    }

    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4>    float32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<int32_t, 4>  int32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, 4> uint32;
  };

  struct ClearDepthStencilValue
  {
    using NativeType = VkClearDepthStencilValue;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( float depth_ = {}, uint32_t stencil_ = {} ) VULKAN_HPP_NOEXCEPT
      : depth{ depth_ }
      , stencil{ stencil_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearDepthStencilValue( *reinterpret_cast<ClearDepthStencilValue const *>( &rhs ) )
    {
    }

    ClearDepthStencilValue & operator=( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearDepthStencilValue & operator=( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setDepth( float depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setStencil( uint32_t stencil_ ) VULKAN_HPP_NOEXCEPT
    {
      stencil = stencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearDepthStencilValue const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( depth, stencil );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearDepthStencilValue const & ) const = default;
#else
    bool operator==( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( depth == rhs.depth ) && ( stencil == rhs.stencil );
#  endif
    }

    bool operator!=( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float    depth   = {};
    uint32_t stencil = {};
  };

  union ClearValue
  {
    using NativeType = VkClearValue;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearColorValue color_ = {} ) : color( color_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil_ ) : depthStencil( depthStencil_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearValue & setColor( VULKAN_HPP_NAMESPACE::ClearColorValue const & color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearValue & setDepthStencil( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const & depthStencil_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencil = depthStencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearValue const &() const
    {
      return *reinterpret_cast<const VkClearValue *>( this );
    }

    operator VkClearValue &()
    {
      return *reinterpret_cast<VkClearValue *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::ClearColorValue        color;
    VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil;
#else
    VkClearColorValue        color;
    VkClearDepthStencilValue depthStencil;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct ClearAttachment
  {
    using NativeType = VkClearAttachment;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_      = {},
                                             uint32_t                               colorAttachment_ = {},
                                             VULKAN_HPP_NAMESPACE::ClearValue       clearValue_      = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , colorAttachment{ colorAttachment_ }
      , clearValue{ clearValue_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT : ClearAttachment( *reinterpret_cast<ClearAttachment const *>( &rhs ) ) {}

    ClearAttachment & operator=( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearAttachment & operator=( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearAttachment const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setColorAttachment( uint32_t colorAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachment = colorAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setClearValue( VULKAN_HPP_NAMESPACE::ClearValue const & clearValue_ ) VULKAN_HPP_NOEXCEPT
    {
      clearValue = clearValue_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearAttachment const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearAttachment *>( this );
    }

    operator VkClearAttachment &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearAttachment *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, VULKAN_HPP_NAMESPACE::ClearValue const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, colorAttachment, clearValue );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask      = {};
    uint32_t                               colorAttachment = {};
    VULKAN_HPP_NAMESPACE::ClearValue       clearValue      = {};
  };

  struct ClearRect
  {
    using NativeType = VkClearRect;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearRect( VULKAN_HPP_NAMESPACE::Rect2D rect_ = {}, uint32_t baseArrayLayer_ = {}, uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : rect{ rect_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearRect( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT : ClearRect( *reinterpret_cast<ClearRect const *>( &rhs ) ) {}

    ClearRect & operator=( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearRect & operator=( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearRect const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearRect & setRect( VULKAN_HPP_NAMESPACE::Rect2D const & rect_ ) VULKAN_HPP_NOEXCEPT
    {
      rect = rect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearRect const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearRect *>( this );
    }

    operator VkClearRect &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearRect *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Rect2D const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( rect, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearRect const & ) const = default;
#else
    bool                     operator==( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( rect == rhs.rect ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Rect2D rect           = {};
    uint32_t                     baseArrayLayer = {};
    uint32_t                     layerCount     = {};
  };

  struct ClusterAccelerationStructureBuildClustersBottomLevelInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( uint32_t                            clusterReferencesCount_  = {},
                                                                  uint32_t                            clusterReferencesStride_ = {},
                                                                  VULKAN_HPP_NAMESPACE::DeviceAddress clusterReferences_       = {} ) VULKAN_HPP_NOEXCEPT
      : clusterReferencesCount{ clusterReferencesCount_ }
      , clusterReferencesStride{ clusterReferencesStride_ }
      , clusterReferences{ clusterReferences_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildClustersBottomLevelInfoNV(
          *reinterpret_cast<ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      operator=( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      operator=( VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferencesCount( uint32_t clusterReferencesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferencesCount = clusterReferencesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferencesStride( uint32_t clusterReferencesStride_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferencesStride = clusterReferencesStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferences( VULKAN_HPP_NAMESPACE::DeviceAddress clusterReferences_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferences = clusterReferences_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterReferencesCount, clusterReferencesStride, clusterReferences );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterReferencesCount == rhs.clusterReferencesCount ) && ( clusterReferencesStride == rhs.clusterReferencesStride ) &&
             ( clusterReferences == rhs.clusterReferences );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                            clusterReferencesCount  = {};
    uint32_t                            clusterReferencesStride = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress clusterReferences       = {};
  };

  struct ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV
  {
    using NativeType = VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( uint32_t geometryIndex_ = {},
                                                                                      uint32_t reserved_      = {},
                                                                                      uint32_t geometryFlags_ = {} ) VULKAN_HPP_NOEXCEPT
      : geometryIndex{ geometryIndex_ }
      , reserved{ reserved_ }
      , geometryFlags{ geometryFlags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV(
          *reinterpret_cast<ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &
      operator=( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &
      operator=( VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setGeometryIndex( uint32_t geometryIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndex = geometryIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setReserved( uint32_t reserved_ ) VULKAN_HPP_NOEXCEPT
    {
      reserved = reserved_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setGeometryFlags( uint32_t geometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryFlags = geometryFlags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( geometryIndex, reserved, geometryFlags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( geometryIndex == rhs.geometryIndex ) && ( reserved == rhs.reserved ) && ( geometryFlags == rhs.geometryFlags );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t geometryIndex : 24;
    uint32_t reserved      : 5;
    uint32_t geometryFlags : 3;
  };

  struct ClusterAccelerationStructureBuildTriangleClusterInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildTriangleClusterInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterInfoNV(
      uint32_t                                                                          clusterID_                         = {},
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV                  clusterFlags_                      = {},
      uint32_t                                                                          triangleCount_                     = {},
      uint32_t                                                                          vertexCount_                       = {},
      uint32_t                                                                          positionTruncateBitCount_          = {},
      uint32_t                                                                          indexType_                         = {},
      uint32_t                                                                          opacityMicromapIndexType_          = {},
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags_ = {},
      uint16_t                                                                          indexBufferStride_                 = {},
      uint16_t                                                                          vertexBufferStride_                = {},
      uint16_t                                                                          geometryIndexAndFlagsBufferStride_ = {},
      uint16_t                                                                          opacityMicromapIndexBufferStride_  = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               indexBuffer_                       = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               vertexBuffer_                      = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               geometryIndexAndFlagsBuffer_       = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapArray_              = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapIndexBuffer_        = {} ) VULKAN_HPP_NOEXCEPT
      : clusterID{ clusterID_ }
      , clusterFlags{ clusterFlags_ }
      , triangleCount{ triangleCount_ }
      , vertexCount{ vertexCount_ }
      , positionTruncateBitCount{ positionTruncateBitCount_ }
      , indexType{ indexType_ }
      , opacityMicromapIndexType{ opacityMicromapIndexType_ }
      , baseGeometryIndexAndGeometryFlags{ baseGeometryIndexAndGeometryFlags_ }
      , indexBufferStride{ indexBufferStride_ }
      , vertexBufferStride{ vertexBufferStride_ }
      , geometryIndexAndFlagsBufferStride{ geometryIndexAndFlagsBufferStride_ }
      , opacityMicromapIndexBufferStride{ opacityMicromapIndexBufferStride_ }
      , indexBuffer{ indexBuffer_ }
      , vertexBuffer{ vertexBuffer_ }
      , geometryIndexAndFlagsBuffer{ geometryIndexAndFlagsBuffer_ }
      , opacityMicromapArray{ opacityMicromapArray_ }
      , opacityMicromapIndexBuffer{ opacityMicromapIndexBuffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterInfoNV( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildTriangleClusterInfoNV( VkClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildTriangleClusterInfoNV( *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      operator=( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      operator=( VkClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureBuildTriangleClusterInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setClusterID( uint32_t clusterID_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterID = clusterID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setClusterFlags( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV clusterFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterFlags = clusterFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setTriangleCount( uint32_t triangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      triangleCount = triangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setPositionTruncateBitCount( uint32_t positionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      positionTruncateBitCount = positionTruncateBitCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setIndexType( uint32_t indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexType( uint32_t opacityMicromapIndexType_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexType = opacityMicromapIndexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setBaseGeometryIndexAndGeometryFlags(
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & baseGeometryIndexAndGeometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      baseGeometryIndexAndGeometryFlags = baseGeometryIndexAndGeometryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setIndexBufferStride( uint16_t indexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBufferStride = indexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setVertexBufferStride( uint16_t vertexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBufferStride = vertexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setGeometryIndexAndFlagsBufferStride( uint16_t geometryIndexAndFlagsBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBufferStride = geometryIndexAndFlagsBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexBufferStride( uint16_t opacityMicromapIndexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBufferStride = opacityMicromapIndexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setVertexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setGeometryIndexAndFlagsBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress geometryIndexAndFlagsBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBuffer = geometryIndexAndFlagsBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapArray( VULKAN_HPP_NAMESPACE::DeviceAddress opacityMicromapArray_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapArray = opacityMicromapArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress opacityMicromapIndexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBuffer = opacityMicromapIndexBuffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterID,
                       clusterFlags,
                       triangleCount,
                       vertexCount,
                       positionTruncateBitCount,
                       indexType,
                       opacityMicromapIndexType,
                       baseGeometryIndexAndGeometryFlags,
                       indexBufferStride,
                       vertexBufferStride,
                       geometryIndexAndFlagsBufferStride,
                       opacityMicromapIndexBufferStride,
                       indexBuffer,
                       vertexBuffer,
                       geometryIndexAndFlagsBuffer,
                       opacityMicromapArray,
                       opacityMicromapIndexBuffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterID == rhs.clusterID ) && ( clusterFlags == rhs.clusterFlags ) && ( triangleCount == rhs.triangleCount ) &&
             ( vertexCount == rhs.vertexCount ) && ( positionTruncateBitCount == rhs.positionTruncateBitCount ) && ( indexType == rhs.indexType ) &&
             ( opacityMicromapIndexType == rhs.opacityMicromapIndexType ) && ( baseGeometryIndexAndGeometryFlags == rhs.baseGeometryIndexAndGeometryFlags ) &&
             ( indexBufferStride == rhs.indexBufferStride ) && ( vertexBufferStride == rhs.vertexBufferStride ) &&
             ( geometryIndexAndFlagsBufferStride == rhs.geometryIndexAndFlagsBufferStride ) &&
             ( opacityMicromapIndexBufferStride == rhs.opacityMicromapIndexBufferStride ) && ( indexBuffer == rhs.indexBuffer ) &&
             ( vertexBuffer == rhs.vertexBuffer ) && ( geometryIndexAndFlagsBuffer == rhs.geometryIndexAndFlagsBuffer ) &&
             ( opacityMicromapArray == rhs.opacityMicromapArray ) && ( opacityMicromapIndexBuffer == rhs.opacityMicromapIndexBuffer );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                                                          clusterID    = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV                  clusterFlags = {};
    uint32_t                                                                          triangleCount            : 9;
    uint32_t                                                                          vertexCount              : 9;
    uint32_t                                                                          positionTruncateBitCount : 6;
    uint32_t                                                                          indexType                : 4;
    uint32_t                                                                          opacityMicromapIndexType : 4;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags = {};
    uint16_t                                                                          indexBufferStride                 = {};
    uint16_t                                                                          vertexBufferStride                = {};
    uint16_t                                                                          geometryIndexAndFlagsBufferStride = {};
    uint16_t                                                                          opacityMicromapIndexBufferStride  = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               indexBuffer                       = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               vertexBuffer                      = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               geometryIndexAndFlagsBuffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapArray              = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapIndexBuffer        = {};
  };

  struct ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      uint32_t                                                                          clusterID_                         = {},
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV                  clusterFlags_                      = {},
      uint32_t                                                                          triangleCount_                     = {},
      uint32_t                                                                          vertexCount_                       = {},
      uint32_t                                                                          positionTruncateBitCount_          = {},
      uint32_t                                                                          indexType_                         = {},
      uint32_t                                                                          opacityMicromapIndexType_          = {},
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags_ = {},
      uint16_t                                                                          indexBufferStride_                 = {},
      uint16_t                                                                          vertexBufferStride_                = {},
      uint16_t                                                                          geometryIndexAndFlagsBufferStride_ = {},
      uint16_t                                                                          opacityMicromapIndexBufferStride_  = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               indexBuffer_                       = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               vertexBuffer_                      = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               geometryIndexAndFlagsBuffer_       = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapArray_              = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapIndexBuffer_        = {},
      VULKAN_HPP_NAMESPACE::DeviceAddress                                               instantiationBoundingBoxLimit_     = {} ) VULKAN_HPP_NOEXCEPT
      : clusterID{ clusterID_ }
      , clusterFlags{ clusterFlags_ }
      , triangleCount{ triangleCount_ }
      , vertexCount{ vertexCount_ }
      , positionTruncateBitCount{ positionTruncateBitCount_ }
      , indexType{ indexType_ }
      , opacityMicromapIndexType{ opacityMicromapIndexType_ }
      , baseGeometryIndexAndGeometryFlags{ baseGeometryIndexAndGeometryFlags_ }
      , indexBufferStride{ indexBufferStride_ }
      , vertexBufferStride{ vertexBufferStride_ }
      , geometryIndexAndFlagsBufferStride{ geometryIndexAndFlagsBufferStride_ }
      , opacityMicromapIndexBufferStride{ opacityMicromapIndexBufferStride_ }
      , indexBuffer{ indexBuffer_ }
      , vertexBuffer{ vertexBuffer_ }
      , geometryIndexAndFlagsBuffer{ geometryIndexAndFlagsBuffer_ }
      , opacityMicromapArray{ opacityMicromapArray_ }
      , opacityMicromapIndexBuffer{ opacityMicromapIndexBuffer_ }
      , instantiationBoundingBoxLimit{ instantiationBoundingBoxLimit_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV( VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
          *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const *>( &rhs ) )
    {
    }

    explicit ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      ClusterAccelerationStructureBuildTriangleClusterInfoNV const & clusterAccelerationStructureBuildTriangleClusterInfoNV,
      VULKAN_HPP_NAMESPACE::DeviceAddress                            instantiationBoundingBoxLimit_ = {} )
      : clusterID( clusterAccelerationStructureBuildTriangleClusterInfoNV.clusterID )
      , clusterFlags( clusterAccelerationStructureBuildTriangleClusterInfoNV.clusterFlags )
      , triangleCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.triangleCount )
      , vertexCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexCount )
      , positionTruncateBitCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.positionTruncateBitCount )
      , indexType( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexType )
      , opacityMicromapIndexType( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexType )
      , baseGeometryIndexAndGeometryFlags( clusterAccelerationStructureBuildTriangleClusterInfoNV.baseGeometryIndexAndGeometryFlags )
      , indexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexBufferStride )
      , vertexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexBufferStride )
      , geometryIndexAndFlagsBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.geometryIndexAndFlagsBufferStride )
      , opacityMicromapIndexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexBufferStride )
      , indexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexBuffer )
      , vertexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexBuffer )
      , geometryIndexAndFlagsBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.geometryIndexAndFlagsBuffer )
      , opacityMicromapArray( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapArray )
      , opacityMicromapIndexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexBuffer )
      , instantiationBoundingBoxLimit( instantiationBoundingBoxLimit_ )
    {
    }

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      operator=( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      operator=( VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setClusterID( uint32_t clusterID_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterID = clusterID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setClusterFlags( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV clusterFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterFlags = clusterFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setTriangleCount( uint32_t triangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      triangleCount = triangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setPositionTruncateBitCount( uint32_t positionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      positionTruncateBitCount = positionTruncateBitCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setIndexType( uint32_t indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexType( uint32_t opacityMicromapIndexType_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexType = opacityMicromapIndexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setBaseGeometryIndexAndGeometryFlags(
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & baseGeometryIndexAndGeometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      baseGeometryIndexAndGeometryFlags = baseGeometryIndexAndGeometryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setIndexBufferStride( uint16_t indexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBufferStride = indexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setVertexBufferStride( uint16_t vertexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBufferStride = vertexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setGeometryIndexAndFlagsBufferStride( uint16_t geometryIndexAndFlagsBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBufferStride = geometryIndexAndFlagsBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexBufferStride( uint16_t opacityMicromapIndexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBufferStride = opacityMicromapIndexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setVertexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setGeometryIndexAndFlagsBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress geometryIndexAndFlagsBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBuffer = geometryIndexAndFlagsBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapArray( VULKAN_HPP_NAMESPACE::DeviceAddress opacityMicromapArray_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapArray = opacityMicromapArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexBuffer( VULKAN_HPP_NAMESPACE::DeviceAddress opacityMicromapIndexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBuffer = opacityMicromapIndexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setInstantiationBoundingBoxLimit( VULKAN_HPP_NAMESPACE::DeviceAddress instantiationBoundingBoxLimit_ ) VULKAN_HPP_NOEXCEPT
    {
      instantiationBoundingBoxLimit = instantiationBoundingBoxLimit_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterID,
                       clusterFlags,
                       triangleCount,
                       vertexCount,
                       positionTruncateBitCount,
                       indexType,
                       opacityMicromapIndexType,
                       baseGeometryIndexAndGeometryFlags,
                       indexBufferStride,
                       vertexBufferStride,
                       geometryIndexAndFlagsBufferStride,
                       opacityMicromapIndexBufferStride,
                       indexBuffer,
                       vertexBuffer,
                       geometryIndexAndFlagsBuffer,
                       opacityMicromapArray,
                       opacityMicromapIndexBuffer,
                       instantiationBoundingBoxLimit );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterID == rhs.clusterID ) && ( clusterFlags == rhs.clusterFlags ) && ( triangleCount == rhs.triangleCount ) &&
             ( vertexCount == rhs.vertexCount ) && ( positionTruncateBitCount == rhs.positionTruncateBitCount ) && ( indexType == rhs.indexType ) &&
             ( opacityMicromapIndexType == rhs.opacityMicromapIndexType ) && ( baseGeometryIndexAndGeometryFlags == rhs.baseGeometryIndexAndGeometryFlags ) &&
             ( indexBufferStride == rhs.indexBufferStride ) && ( vertexBufferStride == rhs.vertexBufferStride ) &&
             ( geometryIndexAndFlagsBufferStride == rhs.geometryIndexAndFlagsBufferStride ) &&
             ( opacityMicromapIndexBufferStride == rhs.opacityMicromapIndexBufferStride ) && ( indexBuffer == rhs.indexBuffer ) &&
             ( vertexBuffer == rhs.vertexBuffer ) && ( geometryIndexAndFlagsBuffer == rhs.geometryIndexAndFlagsBuffer ) &&
             ( opacityMicromapArray == rhs.opacityMicromapArray ) && ( opacityMicromapIndexBuffer == rhs.opacityMicromapIndexBuffer ) &&
             ( instantiationBoundingBoxLimit == rhs.instantiationBoundingBoxLimit );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                                                          clusterID    = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClusterFlagsNV                  clusterFlags = {};
    uint32_t                                                                          triangleCount            : 9;
    uint32_t                                                                          vertexCount              : 9;
    uint32_t                                                                          positionTruncateBitCount : 6;
    uint32_t                                                                          indexType                : 4;
    uint32_t                                                                          opacityMicromapIndexType : 4;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags = {};
    uint16_t                                                                          indexBufferStride                 = {};
    uint16_t                                                                          vertexBufferStride                = {};
    uint16_t                                                                          geometryIndexAndFlagsBufferStride = {};
    uint16_t                                                                          opacityMicromapIndexBufferStride  = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               indexBuffer                       = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               vertexBuffer                      = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               geometryIndexAndFlagsBuffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapArray              = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               opacityMicromapIndexBuffer        = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                               instantiationBoundingBoxLimit     = {};
  };

  struct ClusterAccelerationStructureClustersBottomLevelInputNV
  {
    using NativeType = VkClusterAccelerationStructureClustersBottomLevelInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureClustersBottomLevelInputNV( uint32_t maxTotalClusterCount_                    = {},
                                                                                 uint32_t maxClusterCountPerAccelerationStructure_ = {},
                                                                                 void *   pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxTotalClusterCount{ maxTotalClusterCount_ }
      , maxClusterCountPerAccelerationStructure{ maxClusterCountPerAccelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureClustersBottomLevelInputNV( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureClustersBottomLevelInputNV( VkClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureClustersBottomLevelInputNV( *reinterpret_cast<ClusterAccelerationStructureClustersBottomLevelInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureClustersBottomLevelInputNV &
      operator=( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureClustersBottomLevelInputNV &
      operator=( VkClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClustersBottomLevelInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV &
      setMaxTotalClusterCount( uint32_t maxTotalClusterCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalClusterCount = maxTotalClusterCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV &
      setMaxClusterCountPerAccelerationStructure( uint32_t maxClusterCountPerAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterCountPerAccelerationStructure = maxClusterCountPerAccelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxTotalClusterCount, maxClusterCountPerAccelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureClustersBottomLevelInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxTotalClusterCount == rhs.maxTotalClusterCount ) &&
             ( maxClusterCountPerAccelerationStructure == rhs.maxClusterCountPerAccelerationStructure );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                                   = StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV;
    void *                              pNext                                   = {};
    uint32_t                            maxTotalClusterCount                    = {};
    uint32_t                            maxClusterCountPerAccelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV>
  {
    using Type = ClusterAccelerationStructureClustersBottomLevelInputNV;
  };

  struct ClusterAccelerationStructureTriangleClusterInputNV
  {
    using NativeType = VkClusterAccelerationStructureTriangleClusterInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureTriangleClusterInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureTriangleClusterInputNV( VULKAN_HPP_NAMESPACE::Format vertexFormat_          = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                          uint32_t                     maxGeometryIndexValue_ = {},
                                                          uint32_t                     maxClusterUniqueGeometryCount_ = {},
                                                          uint32_t                     maxClusterTriangleCount_       = {},
                                                          uint32_t                     maxClusterVertexCount_         = {},
                                                          uint32_t                     maxTotalTriangleCount_         = {},
                                                          uint32_t                     maxTotalVertexCount_           = {},
                                                          uint32_t                     minPositionTruncateBitCount_   = {},
                                                          void *                       pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , maxGeometryIndexValue{ maxGeometryIndexValue_ }
      , maxClusterUniqueGeometryCount{ maxClusterUniqueGeometryCount_ }
      , maxClusterTriangleCount{ maxClusterTriangleCount_ }
      , maxClusterVertexCount{ maxClusterVertexCount_ }
      , maxTotalTriangleCount{ maxTotalTriangleCount_ }
      , maxTotalVertexCount{ maxTotalVertexCount_ }
      , minPositionTruncateBitCount{ minPositionTruncateBitCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureTriangleClusterInputNV( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureTriangleClusterInputNV( VkClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureTriangleClusterInputNV( *reinterpret_cast<ClusterAccelerationStructureTriangleClusterInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureTriangleClusterInputNV &
      operator=( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureTriangleClusterInputNV & operator=( VkClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTriangleClusterInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxGeometryIndexValue( uint32_t maxGeometryIndexValue_ ) VULKAN_HPP_NOEXCEPT
    {
      maxGeometryIndexValue = maxGeometryIndexValue_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMaxClusterUniqueGeometryCount( uint32_t maxClusterUniqueGeometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterUniqueGeometryCount = maxClusterUniqueGeometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMaxClusterTriangleCount( uint32_t maxClusterTriangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterTriangleCount = maxClusterTriangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxClusterVertexCount( uint32_t maxClusterVertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterVertexCount = maxClusterVertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxTotalTriangleCount( uint32_t maxTotalTriangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalTriangleCount = maxTotalTriangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxTotalVertexCount( uint32_t maxTotalVertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalVertexCount = maxTotalVertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMinPositionTruncateBitCount( uint32_t minPositionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minPositionTruncateBitCount = minPositionTruncateBitCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureTriangleClusterInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

    operator VkClusterAccelerationStructureTriangleClusterInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexFormat,
                       maxGeometryIndexValue,
                       maxClusterUniqueGeometryCount,
                       maxClusterTriangleCount,
                       maxClusterVertexCount,
                       maxTotalTriangleCount,
                       maxTotalVertexCount,
                       minPositionTruncateBitCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureTriangleClusterInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( maxGeometryIndexValue == rhs.maxGeometryIndexValue ) && ( maxClusterUniqueGeometryCount == rhs.maxClusterUniqueGeometryCount ) &&
             ( maxClusterTriangleCount == rhs.maxClusterTriangleCount ) && ( maxClusterVertexCount == rhs.maxClusterVertexCount ) &&
             ( maxTotalTriangleCount == rhs.maxTotalTriangleCount ) && ( maxTotalVertexCount == rhs.maxTotalVertexCount ) &&
             ( minPositionTruncateBitCount == rhs.minPositionTruncateBitCount );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                         = StructureType::eClusterAccelerationStructureTriangleClusterInputNV;
    void *                              pNext                         = {};
    VULKAN_HPP_NAMESPACE::Format        vertexFormat                  = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint32_t                            maxGeometryIndexValue         = {};
    uint32_t                            maxClusterUniqueGeometryCount = {};
    uint32_t                            maxClusterTriangleCount       = {};
    uint32_t                            maxClusterVertexCount         = {};
    uint32_t                            maxTotalTriangleCount         = {};
    uint32_t                            maxTotalVertexCount           = {};
    uint32_t                            minPositionTruncateBitCount   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureTriangleClusterInputNV>
  {
    using Type = ClusterAccelerationStructureTriangleClusterInputNV;
  };

  struct ClusterAccelerationStructureMoveObjectsInputNV
  {
    using NativeType = VkClusterAccelerationStructureMoveObjectsInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureMoveObjectsInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureMoveObjectsInputNV(
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV type_          = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV::eClustersBottomLevel,
      VULKAN_HPP_NAMESPACE::Bool32                             noMoveOverlap_ = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                         maxMovedBytes_ = {},
      void *                                                   pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , noMoveOverlap{ noMoveOverlap_ }
      , maxMovedBytes{ maxMovedBytes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureMoveObjectsInputNV( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureMoveObjectsInputNV( VkClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureMoveObjectsInputNV( *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureMoveObjectsInputNV & operator=( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureMoveObjectsInputNV & operator=( VkClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureMoveObjectsInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV &
      setType( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setNoMoveOverlap( VULKAN_HPP_NAMESPACE::Bool32 noMoveOverlap_ ) VULKAN_HPP_NOEXCEPT
    {
      noMoveOverlap = noMoveOverlap_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV &
      setMaxMovedBytes( VULKAN_HPP_NAMESPACE::DeviceSize maxMovedBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      maxMovedBytes = maxMovedBytes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureMoveObjectsInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, noMoveOverlap, maxMovedBytes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureMoveObjectsInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( noMoveOverlap == rhs.noMoveOverlap ) &&
             ( maxMovedBytes == rhs.maxMovedBytes );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType         = StructureType::eClusterAccelerationStructureMoveObjectsInputNV;
    void *                                                   pNext         = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV type          = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTypeNV::eClustersBottomLevel;
    VULKAN_HPP_NAMESPACE::Bool32                             noMoveOverlap = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                         maxMovedBytes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureMoveObjectsInputNV>
  {
    using Type = ClusterAccelerationStructureMoveObjectsInputNV;
  };

  union ClusterAccelerationStructureOpInputNV
  {
    using NativeType = VkClusterAccelerationStructureOpInputNV;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14
      ClusterAccelerationStructureOpInputNV( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel_ = {} )
      : pClustersBottomLevel( pClustersBottomLevel_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      ClusterAccelerationStructureOpInputNV( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTriangleClusterInputNV * pTriangleClusters_ )
      : pTriangleClusters( pTriangleClusters_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureMoveObjectsInputNV * pMoveObjects_ )
      : pMoveObjects( pMoveObjects_ )
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPClustersBottomLevel( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      pClustersBottomLevel = pClustersBottomLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPTriangleClusters( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTriangleClusterInputNV * pTriangleClusters_ ) VULKAN_HPP_NOEXCEPT
    {
      pTriangleClusters = pTriangleClusters_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPMoveObjects( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureMoveObjectsInputNV * pMoveObjects_ ) VULKAN_HPP_NOEXCEPT
    {
      pMoveObjects = pMoveObjects_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureOpInputNV const &() const
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureOpInputNV *>( this );
    }

    operator VkClusterAccelerationStructureOpInputNV &()
    {
      return *reinterpret_cast<VkClusterAccelerationStructureOpInputNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureTriangleClusterInputNV *     pTriangleClusters;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureMoveObjectsInputNV *         pMoveObjects;
#else
    VkClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel;
    VkClusterAccelerationStructureTriangleClusterInputNV *     pTriangleClusters;
    VkClusterAccelerationStructureMoveObjectsInputNV *         pMoveObjects;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct ClusterAccelerationStructureInputInfoNV
  {
    using NativeType = VkClusterAccelerationStructureInputInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureInputInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV(
      uint32_t                                                    maxAccelerationStructureCount_ = {},
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR    flags_                         = {},
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV  opType_  = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV::eMoveObjects,
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV  opMode_  = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV::eImplicitDestinations,
      VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpInputNV opInput_ = {},
      void *                                                      pNext_   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxAccelerationStructureCount{ maxAccelerationStructureCount_ }
      , flags{ flags_ }
      , opType{ opType_ }
      , opMode{ opMode_ }
      , opInput{ opInput_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV( ClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureInputInfoNV( VkClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureInputInfoNV( *reinterpret_cast<ClusterAccelerationStructureInputInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureInputInfoNV & operator=( ClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureInputInfoNV & operator=( VkClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInputInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setMaxAccelerationStructureCount( uint32_t maxAccelerationStructureCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxAccelerationStructureCount = maxAccelerationStructureCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setOpType( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV opType_ ) VULKAN_HPP_NOEXCEPT
    {
      opType = opType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setOpMode( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV opMode_ ) VULKAN_HPP_NOEXCEPT
    {
      opMode = opMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setOpInput( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpInputNV const & opInput_ ) VULKAN_HPP_NOEXCEPT
    {
      opInput = opInput_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureInputInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureInputInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInputInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureInputInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpInputNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxAccelerationStructureCount, flags, opType, opMode, opInput );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                         sType                         = StructureType::eClusterAccelerationStructureInputInfoNV;
    void *                                                      pNext                         = {};
    uint32_t                                                    maxAccelerationStructureCount = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR    flags                         = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV  opType  = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpTypeNV::eMoveObjects;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV  opMode  = VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpModeNV::eImplicitDestinations;
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureOpInputNV opInput = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureInputInfoNV>
  {
    using Type = ClusterAccelerationStructureInputInfoNV;
  };

  struct StridedDeviceAddressRegionKHR
  {
    using NativeType = VkStridedDeviceAddressRegionKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR StridedDeviceAddressRegionKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceSize    stride_        = {},
                                                        VULKAN_HPP_NAMESPACE::DeviceSize    size_          = {} ) VULKAN_HPP_NOEXCEPT
      : deviceAddress{ deviceAddress_ }
      , stride{ stride_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR StridedDeviceAddressRegionKHR( StridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    StridedDeviceAddressRegionKHR( VkStridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : StridedDeviceAddressRegionKHR( *reinterpret_cast<StridedDeviceAddressRegionKHR const *>( &rhs ) )
    {
    }

    StridedDeviceAddressRegionKHR & operator=( StridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    StridedDeviceAddressRegionKHR & operator=( VkStridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setStride( VULKAN_HPP_NAMESPACE::DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkStridedDeviceAddressRegionKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkStridedDeviceAddressRegionKHR *>( this );
    }

    operator VkStridedDeviceAddressRegionKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkStridedDeviceAddressRegionKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( deviceAddress, stride, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( StridedDeviceAddressRegionKHR const & ) const = default;
#else
    bool                                                       operator==( StridedDeviceAddressRegionKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( deviceAddress == rhs.deviceAddress ) && ( stride == rhs.stride ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( StridedDeviceAddressRegionKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    stride        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size          = {};
  };

  struct ClusterAccelerationStructureCommandsInfoNV
  {
    using NativeType = VkClusterAccelerationStructureCommandsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureCommandsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      ClusterAccelerationStructureCommandsInfoNV( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInputInfoNV              input_                  = {},
                                                  VULKAN_HPP_NAMESPACE::DeviceAddress                                        dstImplicitData_        = {},
                                                  VULKAN_HPP_NAMESPACE::DeviceAddress                                        scratchData_            = {},
                                                  VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        dstAddressesArray_      = {},
                                                  VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        dstSizesArray_          = {},
                                                  VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        srcInfosArray_          = {},
                                                  VULKAN_HPP_NAMESPACE::DeviceAddress                                        srcInfosCount_          = {},
                                                  VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags_ = {},
                                                  void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , input{ input_ }
      , dstImplicitData{ dstImplicitData_ }
      , scratchData{ scratchData_ }
      , dstAddressesArray{ dstAddressesArray_ }
      , dstSizesArray{ dstSizesArray_ }
      , srcInfosArray{ srcInfosArray_ }
      , srcInfosCount{ srcInfosCount_ }
      , addressResolutionFlags{ addressResolutionFlags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV( ClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureCommandsInfoNV( VkClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureCommandsInfoNV( *reinterpret_cast<ClusterAccelerationStructureCommandsInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureCommandsInfoNV & operator=( ClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureCommandsInfoNV & operator=( VkClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureCommandsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setInput( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInputInfoNV const & input_ ) VULKAN_HPP_NOEXCEPT
    {
      input = input_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setDstImplicitData( VULKAN_HPP_NAMESPACE::DeviceAddress dstImplicitData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImplicitData = dstImplicitData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setScratchData( VULKAN_HPP_NAMESPACE::DeviceAddress scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setDstAddressesArray( VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const & dstAddressesArray_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAddressesArray = dstAddressesArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setDstSizesArray( VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const & dstSizesArray_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSizesArray = dstSizesArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setSrcInfosArray( VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const & srcInfosArray_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosArray = srcInfosArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setSrcInfosCount( VULKAN_HPP_NAMESPACE::DeviceAddress srcInfosCount_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosCount = srcInfosCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setAddressResolutionFlags( VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      addressResolutionFlags = addressResolutionFlags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureCommandsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureCommandsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInputInfoNV const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const &,
               VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const &,
               VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureAddressResolutionFlagsNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, input, dstImplicitData, scratchData, dstAddressesArray, dstSizesArray, srcInfosArray, srcInfosCount, addressResolutionFlags );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                        sType             = StructureType::eClusterAccelerationStructureCommandsInfoNV;
    void *                                                                     pNext             = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInputInfoNV              input             = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                        dstImplicitData   = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                        scratchData       = {};
    VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        dstAddressesArray = {};
    VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        dstSizesArray     = {};
    VULKAN_HPP_NAMESPACE::StridedDeviceAddressRegionKHR                        srcInfosArray     = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress                                        srcInfosCount     = {};
    VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureCommandsInfoNV>
  {
    using Type = ClusterAccelerationStructureCommandsInfoNV;
  };

  struct ClusterAccelerationStructureInstantiateClusterInfoNV
  {
    using NativeType = VkClusterAccelerationStructureInstantiateClusterInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureInstantiateClusterInfoNV( uint32_t                                     clusterIdOffset_        = {},
                                                            uint32_t                                     geometryIndexOffset_    = {},
                                                            uint32_t                                     reserved_               = {},
                                                            VULKAN_HPP_NAMESPACE::DeviceAddress          clusterTemplateAddress_ = {},
                                                            VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV vertexBuffer_           = {} ) VULKAN_HPP_NOEXCEPT
      : clusterIdOffset{ clusterIdOffset_ }
      , geometryIndexOffset{ geometryIndexOffset_ }
      , reserved{ reserved_ }
      , clusterTemplateAddress{ clusterTemplateAddress_ }
      , vertexBuffer{ vertexBuffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureInstantiateClusterInfoNV( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureInstantiateClusterInfoNV( VkClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureInstantiateClusterInfoNV( *reinterpret_cast<ClusterAccelerationStructureInstantiateClusterInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureInstantiateClusterInfoNV &
      operator=( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureInstantiateClusterInfoNV & operator=( VkClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureInstantiateClusterInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setClusterIdOffset( uint32_t clusterIdOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterIdOffset = clusterIdOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setGeometryIndexOffset( uint32_t geometryIndexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexOffset = geometryIndexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setReserved( uint32_t reserved_ ) VULKAN_HPP_NOEXCEPT
    {
      reserved = reserved_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV &
      setClusterTemplateAddress( VULKAN_HPP_NAMESPACE::DeviceAddress clusterTemplateAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterTemplateAddress = clusterTemplateAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV &
      setVertexBuffer( VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV const & vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterIdOffset, geometryIndexOffset, reserved, clusterTemplateAddress, vertexBuffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureInstantiateClusterInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterIdOffset == rhs.clusterIdOffset ) && ( geometryIndexOffset == rhs.geometryIndexOffset ) && ( reserved == rhs.reserved ) &&
             ( clusterTemplateAddress == rhs.clusterTemplateAddress ) && ( vertexBuffer == rhs.vertexBuffer );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                     clusterIdOffset = {};
    uint32_t                                     geometryIndexOffset : 24;
    uint32_t                                     reserved            : 8;
    VULKAN_HPP_NAMESPACE::DeviceAddress          clusterTemplateAddress = {};
    VULKAN_HPP_NAMESPACE::StridedDeviceAddressNV vertexBuffer           = {};
  };

  struct ClusterAccelerationStructureMoveObjectsInfoNV
  {
    using NativeType = VkClusterAccelerationStructureMoveObjectsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureMoveObjectsInfoNV( VULKAN_HPP_NAMESPACE::DeviceAddress srcAccelerationStructure_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcAccelerationStructure{ srcAccelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureMoveObjectsInfoNV( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureMoveObjectsInfoNV( VkClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureMoveObjectsInfoNV( *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureMoveObjectsInfoNV & operator=( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureMoveObjectsInfoNV & operator=( VkClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClusterAccelerationStructureMoveObjectsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInfoNV &
      setSrcAccelerationStructure( VULKAN_HPP_NAMESPACE::DeviceAddress srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureMoveObjectsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAccelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureMoveObjectsInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAccelerationStructure == rhs.srcAccelerationStructure );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress srcAccelerationStructure = {};
  };

  struct CoarseSampleLocationNV
  {
    using NativeType = VkCoarseSampleLocationNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( uint32_t pixelX_ = {}, uint32_t pixelY_ = {}, uint32_t sample_ = {} ) VULKAN_HPP_NOEXCEPT
      : pixelX{ pixelX_ }
      , pixelY{ pixelY_ }
      , sample{ sample_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleLocationNV( *reinterpret_cast<CoarseSampleLocationNV const *>( &rhs ) )
    {
    }

    CoarseSampleLocationNV & operator=( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CoarseSampleLocationNV & operator=( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelX( uint32_t pixelX_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelX = pixelX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelY( uint32_t pixelY_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelY = pixelY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setSample( uint32_t sample_ ) VULKAN_HPP_NOEXCEPT
    {
      sample = sample_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCoarseSampleLocationNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleLocationNV *>( this );
    }

    operator VkCoarseSampleLocationNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleLocationNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pixelX, pixelY, sample );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleLocationNV const & ) const = default;
#else
    bool operator==( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pixelX == rhs.pixelX ) && ( pixelY == rhs.pixelY ) && ( sample == rhs.sample );
#  endif
    }

    bool operator!=( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t pixelX = {};
    uint32_t pixelY = {};
    uint32_t sample = {};
  };

  struct CoarseSampleOrderCustomNV
  {
    using NativeType = VkCoarseSampleOrderCustomNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CoarseSampleOrderCustomNV( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ = VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations,
                                 uint32_t                                        sampleCount_ = {},
                                 uint32_t                                        sampleLocationCount_   = {},
                                 const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_ = {} ) VULKAN_HPP_NOEXCEPT
      : shadingRate{ shadingRate_ }
      , sampleCount{ sampleCount_ }
      , sampleLocationCount{ sampleLocationCount_ }
      , pSampleLocations{ pSampleLocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleOrderCustomNV( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleOrderCustomNV( *reinterpret_cast<CoarseSampleOrderCustomNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV                                                           shadingRate_,
                               uint32_t                                                                                                  sampleCount_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const & sampleLocations_ )
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CoarseSampleOrderCustomNV & operator=( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CoarseSampleOrderCustomNV & operator=( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setShadingRate( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ ) VULKAN_HPP_NOEXCEPT
    {
      shadingRate = shadingRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleCount( uint32_t sampleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleCount = sampleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleLocationCount( uint32_t sampleLocationCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = sampleLocationCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV &
      setPSampleLocations( const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations    = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCoarseSampleOrderCustomNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleOrderCustomNV *>( this );
    }

    operator VkCoarseSampleOrderCustomNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleOrderCustomNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( shadingRate, sampleCount, sampleLocationCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleOrderCustomNV const & ) const = default;
#else
    bool operator==( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( shadingRate == rhs.shadingRate ) && ( sampleCount == rhs.sampleCount ) && ( sampleLocationCount == rhs.sampleLocationCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV      shadingRate         = VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations;
    uint32_t                                             sampleCount         = {};
    uint32_t                                             sampleLocationCount = {};
    const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations    = {};
  };

  struct ColorBlendAdvancedEXT
  {
    using NativeType = VkColorBlendAdvancedEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ColorBlendAdvancedEXT( VULKAN_HPP_NAMESPACE::BlendOp         advancedBlendOp_  = VULKAN_HPP_NAMESPACE::BlendOp::eAdd,
                                                VULKAN_HPP_NAMESPACE::Bool32          srcPremultiplied_ = {},
                                                VULKAN_HPP_NAMESPACE::Bool32          dstPremultiplied_ = {},
                                                VULKAN_HPP_NAMESPACE::BlendOverlapEXT blendOverlap_     = VULKAN_HPP_NAMESPACE::BlendOverlapEXT::eUncorrelated,
                                                VULKAN_HPP_NAMESPACE::Bool32          clampResults_     = {} ) VULKAN_HPP_NOEXCEPT
      : advancedBlendOp{ advancedBlendOp_ }
      , srcPremultiplied{ srcPremultiplied_ }
      , dstPremultiplied{ dstPremultiplied_ }
      , blendOverlap{ blendOverlap_ }
      , clampResults{ clampResults_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ColorBlendAdvancedEXT( ColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ColorBlendAdvancedEXT( VkColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ColorBlendAdvancedEXT( *reinterpret_cast<ColorBlendAdvancedEXT const *>( &rhs ) )
    {
    }

    ColorBlendAdvancedEXT & operator=( ColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ColorBlendAdvancedEXT & operator=( VkColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ColorBlendAdvancedEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setAdvancedBlendOp( VULKAN_HPP_NAMESPACE::BlendOp advancedBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      advancedBlendOp = advancedBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setSrcPremultiplied( VULKAN_HPP_NAMESPACE::Bool32 srcPremultiplied_ ) VULKAN_HPP_NOEXCEPT
    {
      srcPremultiplied = srcPremultiplied_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setDstPremultiplied( VULKAN_HPP_NAMESPACE::Bool32 dstPremultiplied_ ) VULKAN_HPP_NOEXCEPT
    {
      dstPremultiplied = dstPremultiplied_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setBlendOverlap( VULKAN_HPP_NAMESPACE::BlendOverlapEXT blendOverlap_ ) VULKAN_HPP_NOEXCEPT
    {
      blendOverlap = blendOverlap_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setClampResults( VULKAN_HPP_NAMESPACE::Bool32 clampResults_ ) VULKAN_HPP_NOEXCEPT
    {
      clampResults = clampResults_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkColorBlendAdvancedEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkColorBlendAdvancedEXT *>( this );
    }

    operator VkColorBlendAdvancedEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkColorBlendAdvancedEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::BlendOp const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::BlendOverlapEXT const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( advancedBlendOp, srcPremultiplied, dstPremultiplied, blendOverlap, clampResults );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ColorBlendAdvancedEXT const & ) const = default;
#else
    bool operator==( ColorBlendAdvancedEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( advancedBlendOp == rhs.advancedBlendOp ) && ( srcPremultiplied == rhs.srcPremultiplied ) && ( dstPremultiplied == rhs.dstPremultiplied ) &&
             ( blendOverlap == rhs.blendOverlap ) && ( clampResults == rhs.clampResults );
#  endif
    }

    bool operator!=( ColorBlendAdvancedEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::BlendOp         advancedBlendOp  = VULKAN_HPP_NAMESPACE::BlendOp::eAdd;
    VULKAN_HPP_NAMESPACE::Bool32          srcPremultiplied = {};
    VULKAN_HPP_NAMESPACE::Bool32          dstPremultiplied = {};
    VULKAN_HPP_NAMESPACE::BlendOverlapEXT blendOverlap     = VULKAN_HPP_NAMESPACE::BlendOverlapEXT::eUncorrelated;
    VULKAN_HPP_NAMESPACE::Bool32          clampResults     = {};
  };

  struct ColorBlendEquationEXT
  {
    using NativeType = VkColorBlendEquationEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ColorBlendEquationEXT( VULKAN_HPP_NAMESPACE::BlendFactor srcColorBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                VULKAN_HPP_NAMESPACE::BlendFactor dstColorBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                VULKAN_HPP_NAMESPACE::BlendOp     colorBlendOp_        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd,
                                                VULKAN_HPP_NAMESPACE::BlendFactor srcAlphaBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                VULKAN_HPP_NAMESPACE::BlendFactor dstAlphaBlendFactor_ = VULKAN_HPP_NAMESPACE::BlendFactor::eZero,
                                                VULKAN_HPP_NAMESPACE::BlendOp     alphaBlendOp_ = VULKAN_HPP_NAMESPACE::BlendOp::eAdd ) VULKAN_HPP_NOEXCEPT
      : srcColorBlendFactor{ srcColorBlendFactor_ }
      , dstColorBlendFactor{ dstColorBlendFactor_ }
      , colorBlendOp{ colorBlendOp_ }
      , srcAlphaBlendFactor{ srcAlphaBlendFactor_ }
      , dstAlphaBlendFactor{ dstAlphaBlendFactor_ }
      , alphaBlendOp{ alphaBlendOp_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ColorBlendEquationEXT( ColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ColorBlendEquationEXT( VkColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ColorBlendEquationEXT( *reinterpret_cast<ColorBlendEquationEXT const *>( &rhs ) )
    {
    }

    ColorBlendEquationEXT & operator=( ColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ColorBlendEquationEXT & operator=( VkColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ColorBlendEquationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setSrcColorBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor srcColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcColorBlendFactor = srcColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setDstColorBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor dstColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstColorBlendFactor = dstColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setColorBlendOp( VULKAN_HPP_NAMESPACE::BlendOp colorBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      colorBlendOp = colorBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setSrcAlphaBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor srcAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAlphaBlendFactor = srcAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setDstAlphaBlendFactor( VULKAN_HPP_NAMESPACE::BlendFactor dstAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAlphaBlendFactor = dstAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setAlphaBlendOp( VULKAN_HPP_NAMESPACE::BlendOp alphaBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaBlendOp = alphaBlendOp_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkColorBlendEquationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkColorBlendEquationEXT *>( this );
    }

    operator VkColorBlendEquationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkColorBlendEquationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendOp const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendFactor const &,
               VULKAN_HPP_NAMESPACE::BlendOp const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcColorBlendFactor, dstColorBlendFactor, colorBlendOp, srcAlphaBlendFactor, dstAlphaBlendFactor, alphaBlendOp );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ColorBlendEquationEXT const & ) const = default;
#else
    bool operator==( ColorBlendEquationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcColorBlendFactor == rhs.srcColorBlendFactor ) && ( dstColorBlendFactor == rhs.dstColorBlendFactor ) && ( colorBlendOp == rhs.colorBlendOp ) &&
             ( srcAlphaBlendFactor == rhs.srcAlphaBlendFactor ) && ( dstAlphaBlendFactor == rhs.dstAlphaBlendFactor ) && ( alphaBlendOp == rhs.alphaBlendOp );
#  endif
    }

    bool operator!=( ColorBlendEquationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::BlendFactor srcColorBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendFactor dstColorBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendOp     colorBlendOp        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd;
    VULKAN_HPP_NAMESPACE::BlendFactor srcAlphaBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendFactor dstAlphaBlendFactor = VULKAN_HPP_NAMESPACE::BlendFactor::eZero;
    VULKAN_HPP_NAMESPACE::BlendOp     alphaBlendOp        = VULKAN_HPP_NAMESPACE::BlendOp::eAdd;
  };

  struct CommandBufferAllocateInfo
  {
    using NativeType = VkCommandBufferAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferAllocateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( VULKAN_HPP_NAMESPACE::CommandPool        commandPool_ = {},
                                                    VULKAN_HPP_NAMESPACE::CommandBufferLevel level_       = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary,
                                                    uint32_t                                 commandBufferCount_ = {},
                                                    const void *                             pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandPool{ commandPool_ }
      , level{ level_ }
      , commandBufferCount{ commandBufferCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferAllocateInfo( *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs ) )
    {
    }

    CommandBufferAllocateInfo & operator=( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferAllocateInfo & operator=( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandPool( VULKAN_HPP_NAMESPACE::CommandPool commandPool_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPool = commandPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setLevel( VULKAN_HPP_NAMESPACE::CommandBufferLevel level_ ) VULKAN_HPP_NOEXCEPT
    {
      level = level_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandPool const &,
               VULKAN_HPP_NAMESPACE::CommandBufferLevel const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPool, level, commandBufferCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferAllocateInfo const & ) const = default;
#else
    bool operator==( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPool == rhs.commandPool ) && ( level == rhs.level ) &&
             ( commandBufferCount == rhs.commandBufferCount );
#  endif
    }

    bool operator!=( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType              = StructureType::eCommandBufferAllocateInfo;
    const void *                             pNext              = {};
    VULKAN_HPP_NAMESPACE::CommandPool        commandPool        = {};
    VULKAN_HPP_NAMESPACE::CommandBufferLevel level              = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary;
    uint32_t                                 commandBufferCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferAllocateInfo>
  {
    using Type = CommandBufferAllocateInfo;
  };

  struct CommandBufferInheritanceInfo
  {
    using NativeType = VkCommandBufferInheritanceInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( VULKAN_HPP_NAMESPACE::RenderPass                  renderPass_           = {},
                                                       uint32_t                                          subpass_              = {},
                                                       VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer_          = {},
                                                       VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable_ = {},
                                                       VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags_           = {},
                                                       VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_   = {},
                                                       const void *                                      pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , renderPass{ renderPass_ }
      , subpass{ subpass_ }
      , framebuffer{ framebuffer_ }
      , occlusionQueryEnable{ occlusionQueryEnable_ }
      , queryFlags{ queryFlags_ }
      , pipelineStatistics{ pipelineStatistics_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceInfo( *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceInfo & operator=( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceInfo & operator=( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setFramebuffer( VULKAN_HPP_NAMESPACE::Framebuffer framebuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      framebuffer = framebuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setOcclusionQueryEnable( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryEnable = occlusionQueryEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setQueryFlags( VULKAN_HPP_NAMESPACE::QueryControlFlags queryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      queryFlags = queryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
      setPipelineStatistics( VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatistics = pipelineStatistics_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderPass const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Framebuffer const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::QueryControlFlags const &,
               VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, renderPass, subpass, framebuffer, occlusionQueryEnable, queryFlags, pipelineStatistics );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( renderPass == rhs.renderPass ) && ( subpass == rhs.subpass ) &&
             ( framebuffer == rhs.framebuffer ) && ( occlusionQueryEnable == rhs.occlusionQueryEnable ) && ( queryFlags == rhs.queryFlags ) &&
             ( pipelineStatistics == rhs.pipelineStatistics );
#  endif
    }

    bool operator!=( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                = StructureType::eCommandBufferInheritanceInfo;
    const void *                                      pNext                = {};
    VULKAN_HPP_NAMESPACE::RenderPass                  renderPass           = {};
    uint32_t                                          subpass              = {};
    VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer          = {};
    VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable = {};
    VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags           = {};
    VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceInfo>
  {
    using Type = CommandBufferInheritanceInfo;
  };

  struct CommandBufferBeginInfo
  {
    using NativeType = VkCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags_            = {},
                                                 const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ = {},
                                                 const void *                                               pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , pInheritanceInfo{ pInheritanceInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferBeginInfo( *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs ) )
    {
    }

    CommandBufferBeginInfo & operator=( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferBeginInfo & operator=( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo &
      setPInheritanceInfo( const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pInheritanceInfo = pInheritanceInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags const &,
               const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pInheritanceInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pInheritanceInfo == rhs.pInheritanceInfo );
#  endif
    }

    bool operator!=( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType            = StructureType::eCommandBufferBeginInfo;
    const void *                                               pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags            = {};
    const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferBeginInfo>
  {
    using Type = CommandBufferBeginInfo;
  };

  struct CommandBufferInheritanceConditionalRenderingInfoEXT
  {
    using NativeType = VkCommandBufferInheritanceConditionalRenderingInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceConditionalRenderingInfoEXT( VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ = {},
                                                                              const void *                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , conditionalRenderingEnable{ conditionalRenderingEnable_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceConditionalRenderingInfoEXT( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceConditionalRenderingInfoEXT( *reinterpret_cast<CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceConditionalRenderingInfoEXT &
      operator=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceConditionalRenderingInfoEXT & operator=( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT &
      setConditionalRenderingEnable( VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      conditionalRenderingEnable = conditionalRenderingEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, conditionalRenderingEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceConditionalRenderingInfoEXT const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( conditionalRenderingEnable == rhs.conditionalRenderingEnable );
#  endif
    }

    bool operator!=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;
    const void *                        pNext                      = {};
    VULKAN_HPP_NAMESPACE::Bool32        conditionalRenderingEnable = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT>
  {
    using Type = CommandBufferInheritanceConditionalRenderingInfoEXT;
  };

  struct CommandBufferInheritanceRenderPassTransformInfoQCOM
  {
    using NativeType = VkCommandBufferInheritanceRenderPassTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderPassTransformInfoQCOM(
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_  = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
      VULKAN_HPP_NAMESPACE::Rect2D                      renderArea_ = {},
      void *                                            pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , transform{ transform_ }
      , renderArea{ renderArea_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderPassTransformInfoQCOM( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderPassTransformInfoQCOM( *reinterpret_cast<CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceRenderPassTransformInfoQCOM &
      operator=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceRenderPassTransformInfoQCOM & operator=( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
      setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
      setRenderArea( VULKAN_HPP_NAMESPACE::Rect2D const & renderArea_ ) VULKAN_HPP_NOEXCEPT
    {
      renderArea = renderArea_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR const &,
               VULKAN_HPP_NAMESPACE::Rect2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform, renderArea );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderPassTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform ) && ( renderArea == rhs.renderArea );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType      = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;
    void *                                            pNext      = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform  = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
    VULKAN_HPP_NAMESPACE::Rect2D                      renderArea = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM>
  {
    using Type = CommandBufferInheritanceRenderPassTransformInfoQCOM;
  };

  struct CommandBufferInheritanceRenderingInfo
  {
    using NativeType = VkCommandBufferInheritanceRenderingInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderingInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags      flags_                   = {},
                                             uint32_t                                  viewMask_                = {},
                                             uint32_t                                  colorAttachmentCount_    = {},
                                             const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats_ = {},
                                             VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                             const void *                              pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , viewMask{ viewMask_ }
      , colorAttachmentCount{ colorAttachmentCount_ }
      , pColorAttachmentFormats{ pColorAttachmentFormats_ }
      , depthAttachmentFormat{ depthAttachmentFormat_ }
      , stencilAttachmentFormat{ stencilAttachmentFormat_ }
      , rasterizationSamples{ rasterizationSamples_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfo( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfo( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderingInfo( *reinterpret_cast<CommandBufferInheritanceRenderingInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags                                                      flags_,
                                           uint32_t                                                                                  viewMask_,
                                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_,
                                           VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                           const void *                              pNext_                   = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentFormats_.size() ) )
      , pColorAttachmentFormats( colorAttachmentFormats_.data() )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CommandBufferInheritanceRenderingInfo & operator=( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceRenderingInfo & operator=( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setFlags( VULKAN_HPP_NAMESPACE::RenderingFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setViewMask( uint32_t viewMask_ ) VULKAN_HPP_NOEXCEPT
    {
      viewMask = viewMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setPColorAttachmentFormats( const VULKAN_HPP_NAMESPACE::Format * pColorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentFormats = pColorAttachmentFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo & setColorAttachmentFormats(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentFormats_.size() );
      pColorAttachmentFormats = colorAttachmentFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setDepthAttachmentFormat( VULKAN_HPP_NAMESPACE::Format depthAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      depthAttachmentFormat = depthAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setStencilAttachmentFormat( VULKAN_HPP_NAMESPACE::Format stencilAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilAttachmentFormat = stencilAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
      setRasterizationSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceRenderingInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderingInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderingFlags const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Format * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, viewMask, colorAttachmentCount, pColorAttachmentFormats, depthAttachmentFormat, stencilAttachmentFormat, rasterizationSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderingInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( viewMask == rhs.viewMask ) &&
             ( colorAttachmentCount == rhs.colorAttachmentCount ) && ( pColorAttachmentFormats == rhs.pColorAttachmentFormats ) &&
             ( depthAttachmentFormat == rhs.depthAttachmentFormat ) && ( stencilAttachmentFormat == rhs.stencilAttachmentFormat ) &&
             ( rasterizationSamples == rhs.rasterizationSamples );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                   = StructureType::eCommandBufferInheritanceRenderingInfo;
    const void *                              pNext                   = {};
    VULKAN_HPP_NAMESPACE::RenderingFlags      flags                   = {};
    uint32_t                                  viewMask                = {};
    uint32_t                                  colorAttachmentCount    = {};
    const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats = {};
    VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat   = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderingInfo>
  {
    using Type = CommandBufferInheritanceRenderingInfo;
  };

  using CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

  struct Viewport
  {
    using NativeType = VkViewport;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      Viewport( float x_ = {}, float y_ = {}, float width_ = {}, float height_ = {}, float minDepth_ = {}, float maxDepth_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , width{ width_ }
      , height{ height_ }
      , minDepth{ minDepth_ }
      , maxDepth{ maxDepth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Viewport( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT : Viewport( *reinterpret_cast<Viewport const *>( &rhs ) ) {}

    Viewport & operator=( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Viewport & operator=( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Viewport const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Viewport & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setWidth( float width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setHeight( float height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMinDepth( float minDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepth = minDepth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMaxDepth( float maxDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepth = maxDepth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkViewport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkViewport *>( this );
    }

    operator VkViewport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkViewport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, width, height, minDepth, maxDepth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Viewport const & ) const = default;
#else
    bool operator==( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( width == rhs.width ) && ( height == rhs.height ) && ( minDepth == rhs.minDepth ) &&
             ( maxDepth == rhs.maxDepth );
#  endif
    }

    bool operator!=( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x        = {};
    float y        = {};
    float width    = {};
    float height   = {};
    float minDepth = {};
    float maxDepth = {};
  };

  struct CommandBufferInheritanceViewportScissorInfoNV
  {
    using NativeType = VkCommandBufferInheritanceViewportScissorInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceViewportScissorInfoNV( VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D_  = {},
                                                                        uint32_t                               viewportDepthCount_ = {},
                                                                        const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_    = {},
                                                                        const void *                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , viewportScissor2D{ viewportScissor2D_ }
      , viewportDepthCount{ viewportDepthCount_ }
      , pViewportDepths{ pViewportDepths_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceViewportScissorInfoNV( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceViewportScissorInfoNV( *reinterpret_cast<CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceViewportScissorInfoNV & operator=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceViewportScissorInfoNV & operator=( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
      setViewportScissor2D( VULKAN_HPP_NAMESPACE::Bool32 viewportScissor2D_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportScissor2D = viewportScissor2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setViewportDepthCount( uint32_t viewportDepthCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportDepthCount = viewportDepthCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
      setPViewportDepths( const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewportDepths = pViewportDepths_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceViewportScissorInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    operator VkCommandBufferInheritanceViewportScissorInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Viewport * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, viewportScissor2D, viewportDepthCount, pViewportDepths );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceViewportScissorInfoNV const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( viewportScissor2D == rhs.viewportScissor2D ) &&
             ( viewportDepthCount == rhs.viewportDepthCount ) && ( pViewportDepths == rhs.pViewportDepths );
#  endif
    }

    bool operator!=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType              = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;
    const void *                           pNext              = {};
    VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D  = {};
    uint32_t                               viewportDepthCount = {};
    const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceViewportScissorInfoNV>
  {
    using Type = CommandBufferInheritanceViewportScissorInfoNV;
  };

  struct CommandBufferSubmitInfo
  {
    using NativeType = VkCommandBufferSubmitInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferSubmitInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ = {},
                                                  uint32_t                            deviceMask_    = {},
                                                  const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandBuffer{ commandBuffer_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfo( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferSubmitInfo( *reinterpret_cast<CommandBufferSubmitInfo const *>( &rhs ) )
    {
    }

    CommandBufferSubmitInfo & operator=( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferSubmitInfo & operator=( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setCommandBuffer( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBuffer = commandBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferSubmitInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferSubmitInfo *>( this );
    }

    operator VkCommandBufferSubmitInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferSubmitInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandBuffer const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandBuffer, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferSubmitInfo const & ) const = default;
#else
    bool operator==( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandBuffer == rhs.commandBuffer ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eCommandBufferSubmitInfo;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer = {};
    uint32_t                            deviceMask    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferSubmitInfo>
  {
    using Type = CommandBufferSubmitInfo;
  };

  using CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;

  struct CommandPoolCreateInfo
  {
    using NativeType = VkCommandPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueFamilyIndex{ queueFamilyIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolCreateInfo( *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs ) )
    {
    }

    CommandPoolCreateInfo & operator=( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandPoolCreateInfo & operator=( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex );
#  endif
    }

    bool operator!=( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eCommandPoolCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolCreateInfo>
  {
    using Type = CommandPoolCreateInfo;
  };

  struct SpecializationMapEntry
  {
    using NativeType = VkSpecializationMapEntry;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( uint32_t constantID_ = {}, uint32_t offset_ = {}, size_t size_ = {} ) VULKAN_HPP_NOEXCEPT
      : constantID{ constantID_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationMapEntry( *reinterpret_cast<SpecializationMapEntry const *>( &rhs ) )
    {
    }

    SpecializationMapEntry & operator=( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SpecializationMapEntry & operator=( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationMapEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setConstantID( uint32_t constantID_ ) VULKAN_HPP_NOEXCEPT
    {
      constantID = constantID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setSize( size_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSpecializationMapEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( constantID, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationMapEntry const & ) const = default;
#else
    bool operator==( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( constantID == rhs.constantID ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t constantID = {};
    uint32_t offset     = {};
    size_t   size       = {};
  };

  struct SpecializationInfo
  {
    using NativeType = VkSpecializationInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationInfo( uint32_t                                             mapEntryCount_ = {},
                                             const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_   = {},
                                             size_t                                               dataSize_      = {},
                                             const void *                                         pData_         = {} ) VULKAN_HPP_NOEXCEPT
      : mapEntryCount{ mapEntryCount_ }
      , pMapEntries{ pMapEntries_ }
      , dataSize{ dataSize_ }
      , pData{ pData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationInfo( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : SpecializationInfo( *reinterpret_cast<SpecializationInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_,
                        VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const &                                            data_ = {} )
      : mapEntryCount( static_cast<uint32_t>( mapEntries_.size() ) )
      , pMapEntries( mapEntries_.data() )
      , dataSize( data_.size() * sizeof( T ) )
      , pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SpecializationInfo & operator=( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SpecializationInfo & operator=( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setMapEntryCount( uint32_t mapEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = mapEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPMapEntries( const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pMapEntries = pMapEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SpecializationInfo &
      setMapEntries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = static_cast<uint32_t>( mapEntries_.size() );
      pMapEntries   = mapEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo & setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSpecializationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( mapEntryCount, pMapEntries, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationInfo const & ) const = default;
#else
    bool operator==( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( mapEntryCount == rhs.mapEntryCount ) && ( pMapEntries == rhs.pMapEntries ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                             mapEntryCount = {};
    const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries   = {};
    size_t                                               dataSize      = {};
    const void *                                         pData         = {};
  };

  struct PipelineShaderStageCreateInfo
  {
    using NativeType = VkPipelineShaderStageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineShaderStageCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ = {},
                                                        VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_  = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex,
                                                        VULKAN_HPP_NAMESPACE::ShaderModule        module_ = {},
                                                        const char *                              pName_  = {},
                                                        const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ = {},
                                                        const void *                                     pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , module{ module_ }
      , pName{ pName_ }
      , pSpecializationInfo{ pSpecializationInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineShaderStageCreateInfo( *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs ) )
    {
    }

    PipelineShaderStageCreateInfo & operator=( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    PipelineShaderStageCreateInfo & operator=( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setStage( VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setModule( VULKAN_HPP_NAMESPACE::ShaderModule module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
      setPSpecializationInfo( const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pSpecializationInfo = pSpecializationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkPipelineShaderStageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlagBits const &,
               VULKAN_HPP_NAMESPACE::ShaderModule const &,
               const char * const &,
               const VULKAN_HPP_NAMESPACE::SpecializationInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, module, pName, pSpecializationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = stage <=> rhs.stage; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = pSpecializationInfo <=> rhs.pSpecializationInfo; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( module == rhs.module ) &&
             ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) ) && ( pSpecializationInfo == rhs.pSpecializationInfo );
    }

    bool operator!=( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType               = StructureType::ePipelineShaderStageCreateInfo;
    const void *                                         pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags               = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlagBits            stage               = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex;
    VULKAN_HPP_NAMESPACE::ShaderModule                   module              = {};
    const char *                                         pName               = {};
    const VULKAN_HPP_NAMESPACE::SpecializationInfo *     pSpecializationInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineShaderStageCreateInfo>
  {
    using Type = PipelineShaderStageCreateInfo;
  };

  struct ComputePipelineCreateInfo
  {
    using NativeType = VkComputePipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineLayout                layout_             = {},
                                                    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle_ = {},
                                                    int32_t                                             basePipelineIndex_  = {},
                                                    const void *                                        pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , layout{ layout_ }
      , basePipelineHandle{ basePipelineHandle_ }
      , basePipelineIndex{ basePipelineIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineCreateInfo( *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs ) )
    {
    }

    ComputePipelineCreateInfo & operator=( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComputePipelineCreateInfo & operator=( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setStage( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const & stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineHandle( VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComputePipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineCreateFlags const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               VULKAN_HPP_NAMESPACE::Pipeline const &,
               int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, layout, basePipelineHandle, basePipelineIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineCreateInfo const & ) const = default;
#else
    bool operator==( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( layout == rhs.layout ) &&
             ( basePipelineHandle == rhs.basePipelineHandle ) && ( basePipelineIndex == rhs.basePipelineIndex );
#  endif
    }

    bool operator!=( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType              = StructureType::eComputePipelineCreateInfo;
    const void *                                        pNext              = {};
    VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags              = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage              = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout                layout             = {};
    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle = {};
    int32_t                                             basePipelineIndex  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineCreateInfo>
  {
    using Type = ComputePipelineCreateInfo;
  };

  struct ComputePipelineIndirectBufferInfoNV
  {
    using NativeType = VkComputePipelineIndirectBufferInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineIndirectBufferInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineIndirectBufferInfoNV( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_                      = {},
                                                              VULKAN_HPP_NAMESPACE::DeviceSize    size_                               = {},
                                                              VULKAN_HPP_NAMESPACE::DeviceAddress pipelineDeviceAddressCaptureReplay_ = {},
                                                              const void *                        pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceAddress{ deviceAddress_ }
      , size{ size_ }
      , pipelineDeviceAddressCaptureReplay{ pipelineDeviceAddressCaptureReplay_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineIndirectBufferInfoNV( ComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineIndirectBufferInfoNV( VkComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineIndirectBufferInfoNV( *reinterpret_cast<ComputePipelineIndirectBufferInfoNV const *>( &rhs ) )
    {
    }

    ComputePipelineIndirectBufferInfoNV & operator=( ComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComputePipelineIndirectBufferInfoNV & operator=( VkComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComputePipelineIndirectBufferInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV &
      setPipelineDeviceAddressCaptureReplay( VULKAN_HPP_NAMESPACE::DeviceAddress pipelineDeviceAddressCaptureReplay_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineDeviceAddressCaptureReplay = pipelineDeviceAddressCaptureReplay_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComputePipelineIndirectBufferInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineIndirectBufferInfoNV *>( this );
    }

    operator VkComputePipelineIndirectBufferInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineIndirectBufferInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceAddress, size, pipelineDeviceAddressCaptureReplay );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineIndirectBufferInfoNV const & ) const = default;
#else
    bool operator==( ComputePipelineIndirectBufferInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress ) && ( size == rhs.size ) &&
             ( pipelineDeviceAddressCaptureReplay == rhs.pipelineDeviceAddressCaptureReplay );
#  endif
    }

    bool operator!=( ComputePipelineIndirectBufferInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                              = StructureType::eComputePipelineIndirectBufferInfoNV;
    const void *                        pNext                              = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress                      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size                               = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress pipelineDeviceAddressCaptureReplay = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineIndirectBufferInfoNV>
  {
    using Type = ComputePipelineIndirectBufferInfoNV;
  };

  struct ConditionalRenderingBeginInfoEXT
  {
    using NativeType = VkConditionalRenderingBeginInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eConditionalRenderingBeginInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( VULKAN_HPP_NAMESPACE::Buffer                       buffer_ = {},
                                                           VULKAN_HPP_NAMESPACE::DeviceSize                   offset_ = {},
                                                           VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_  = {},
                                                           const void *                                       pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConditionalRenderingBeginInfoEXT( *reinterpret_cast<ConditionalRenderingBeginInfoEXT const *>( &rhs ) )
    {
    }

    ConditionalRenderingBeginInfoEXT & operator=( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConditionalRenderingBeginInfoEXT & operator=( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConditionalRenderingBeginInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConditionalRenderingBeginInfoEXT *>( this );
    }

    operator VkConditionalRenderingBeginInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConditionalRenderingBeginInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, offset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConditionalRenderingBeginInfoEXT const & ) const = default;
#else
    bool operator==( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eConditionalRenderingBeginInfoEXT;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer                       buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                   offset = {};
    VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eConditionalRenderingBeginInfoEXT>
  {
    using Type = ConditionalRenderingBeginInfoEXT;
  };

  struct ConformanceVersion
  {
    using NativeType = VkConformanceVersion;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConformanceVersion( uint8_t major_ = {}, uint8_t minor_ = {}, uint8_t subminor_ = {}, uint8_t patch_ = {} ) VULKAN_HPP_NOEXCEPT
      : major{ major_ }
      , minor{ minor_ }
      , subminor{ subminor_ }
      , patch{ patch_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ConformanceVersion( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT : ConformanceVersion( *reinterpret_cast<ConformanceVersion const *>( &rhs ) ) {}

    ConformanceVersion & operator=( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConformanceVersion & operator=( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConformanceVersion const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMajor( uint8_t major_ ) VULKAN_HPP_NOEXCEPT
    {
      major = major_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMinor( uint8_t minor_ ) VULKAN_HPP_NOEXCEPT
    {
      minor = minor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setSubminor( uint8_t subminor_ ) VULKAN_HPP_NOEXCEPT
    {
      subminor = subminor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setPatch( uint8_t patch_ ) VULKAN_HPP_NOEXCEPT
    {
      patch = patch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConformanceVersion const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConformanceVersion *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint8_t const &, uint8_t const &, uint8_t const &, uint8_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( major, minor, subminor, patch );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConformanceVersion const & ) const = default;
#else
    bool operator==( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( major == rhs.major ) && ( minor == rhs.minor ) && ( subminor == rhs.subminor ) && ( patch == rhs.patch );
#  endif
    }

    bool operator!=( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint8_t major    = {};
    uint8_t minor    = {};
    uint8_t subminor = {};
    uint8_t patch    = {};
  };

  using ConformanceVersionKHR = ConformanceVersion;

  struct ConvertCooperativeVectorMatrixInfoNV
  {
    using NativeType = VkConvertCooperativeVectorMatrixInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eConvertCooperativeVectorMatrixInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV(
      size_t                                                srcSize_          = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR     srcData_          = {},
      size_t *                                              pDstSize_         = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR          dstData_          = {},
      VULKAN_HPP_NAMESPACE::ComponentTypeKHR                srcComponentType_ = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
      VULKAN_HPP_NAMESPACE::ComponentTypeKHR                dstComponentType_ = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
      uint32_t                                              numRows_          = {},
      uint32_t                                              numColumns_       = {},
      VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV srcLayout_        = VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV::eRowMajor,
      size_t                                                srcStride_        = {},
      VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV dstLayout_        = VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV::eRowMajor,
      size_t                                                dstStride_        = {},
      const void *                                          pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSize{ srcSize_ }
      , srcData{ srcData_ }
      , pDstSize{ pDstSize_ }
      , dstData{ dstData_ }
      , srcComponentType{ srcComponentType_ }
      , dstComponentType{ dstComponentType_ }
      , numRows{ numRows_ }
      , numColumns{ numColumns_ }
      , srcLayout{ srcLayout_ }
      , srcStride{ srcStride_ }
      , dstLayout{ dstLayout_ }
      , dstStride{ dstStride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV( ConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConvertCooperativeVectorMatrixInfoNV( VkConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConvertCooperativeVectorMatrixInfoNV( *reinterpret_cast<ConvertCooperativeVectorMatrixInfoNV const *>( &rhs ) )
    {
    }

    ConvertCooperativeVectorMatrixInfoNV & operator=( ConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConvertCooperativeVectorMatrixInfoNV & operator=( VkConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConvertCooperativeVectorMatrixInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcSize( size_t srcSize_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSize = srcSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setSrcData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & srcData_ ) VULKAN_HPP_NOEXCEPT
    {
      srcData = srcData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setPDstSize( size_t * pDstSize_ ) VULKAN_HPP_NOEXCEPT
    {
      pDstSize = pDstSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setDstData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & dstData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstData = dstData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setSrcComponentType( VULKAN_HPP_NAMESPACE::ComponentTypeKHR srcComponentType_ ) VULKAN_HPP_NOEXCEPT
    {
      srcComponentType = srcComponentType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setDstComponentType( VULKAN_HPP_NAMESPACE::ComponentTypeKHR dstComponentType_ ) VULKAN_HPP_NOEXCEPT
    {
      dstComponentType = dstComponentType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setNumRows( uint32_t numRows_ ) VULKAN_HPP_NOEXCEPT
    {
      numRows = numRows_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setNumColumns( uint32_t numColumns_ ) VULKAN_HPP_NOEXCEPT
    {
      numColumns = numColumns_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setSrcLayout( VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV srcLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcLayout = srcLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcStride( size_t srcStride_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStride = srcStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV &
      setDstLayout( VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV dstLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstLayout = dstLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setDstStride( size_t dstStride_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStride = dstStride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConvertCooperativeVectorMatrixInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

    operator VkConvertCooperativeVectorMatrixInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               size_t const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               size_t * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV const &,
               size_t const &,
               VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV const &,
               size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       srcSize,
                       srcData,
                       pDstSize,
                       dstData,
                       srcComponentType,
                       dstComponentType,
                       numRows,
                       numColumns,
                       srcLayout,
                       srcStride,
                       dstLayout,
                       dstStride );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType            = StructureType::eConvertCooperativeVectorMatrixInfoNV;
    const void *                                          pNext            = {};
    size_t                                                srcSize          = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR     srcData          = {};
    size_t *                                              pDstSize         = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR          dstData          = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR                srcComponentType = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR                dstComponentType = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    uint32_t                                              numRows          = {};
    uint32_t                                              numColumns       = {};
    VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV srcLayout        = VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV::eRowMajor;
    size_t                                                srcStride        = {};
    VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV dstLayout        = VULKAN_HPP_NAMESPACE::CooperativeVectorMatrixLayoutNV::eRowMajor;
    size_t                                                dstStride        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eConvertCooperativeVectorMatrixInfoNV>
  {
    using Type = ConvertCooperativeVectorMatrixInfoNV;
  };

  struct CooperativeMatrixFlexibleDimensionsPropertiesNV
  {
    using NativeType = VkCooperativeMatrixFlexibleDimensionsPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CooperativeMatrixFlexibleDimensionsPropertiesNV( uint32_t                               MGranularity_ = {},
                                                       uint32_t                               NGranularity_ = {},
                                                       uint32_t                               KGranularity_ = {},
                                                       VULKAN_HPP_NAMESPACE::ComponentTypeKHR AType_        = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                       VULKAN_HPP_NAMESPACE::ComponentTypeKHR BType_        = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                       VULKAN_HPP_NAMESPACE::ComponentTypeKHR CType_        = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                       VULKAN_HPP_NAMESPACE::ComponentTypeKHR ResultType_   = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                       VULKAN_HPP_NAMESPACE::Bool32           saturatingAccumulation_ = {},
                                                       VULKAN_HPP_NAMESPACE::ScopeKHR         scope_                  = VULKAN_HPP_NAMESPACE::ScopeKHR::eDevice,
                                                       uint32_t                               workgroupInvocations_   = {},
                                                       void *                                 pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MGranularity{ MGranularity_ }
      , NGranularity{ NGranularity_ }
      , KGranularity{ KGranularity_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , ResultType{ ResultType_ }
      , saturatingAccumulation{ saturatingAccumulation_ }
      , scope{ scope_ }
      , workgroupInvocations{ workgroupInvocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CooperativeMatrixFlexibleDimensionsPropertiesNV( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixFlexibleDimensionsPropertiesNV( VkCooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixFlexibleDimensionsPropertiesNV( *reinterpret_cast<CooperativeMatrixFlexibleDimensionsPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeMatrixFlexibleDimensionsPropertiesNV & operator=( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixFlexibleDimensionsPropertiesNV & operator=( VkCooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeMatrixFlexibleDimensionsPropertiesNV const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::ScopeKHR const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, MGranularity, NGranularity, KGranularity, AType, BType, CType, ResultType, saturatingAccumulation, scope, workgroupInvocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixFlexibleDimensionsPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MGranularity == rhs.MGranularity ) && ( NGranularity == rhs.NGranularity ) &&
             ( KGranularity == rhs.KGranularity ) && ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) &&
             ( ResultType == rhs.ResultType ) && ( saturatingAccumulation == rhs.saturatingAccumulation ) && ( scope == rhs.scope ) &&
             ( workgroupInvocations == rhs.workgroupInvocations );
#  endif
    }

    bool operator!=( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType                  = StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV;
    void *                                 pNext                  = {};
    uint32_t                               MGranularity           = {};
    uint32_t                               NGranularity           = {};
    uint32_t                               KGranularity           = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR AType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR BType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR CType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR ResultType             = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::Bool32           saturatingAccumulation = {};
    VULKAN_HPP_NAMESPACE::ScopeKHR         scope                  = VULKAN_HPP_NAMESPACE::ScopeKHR::eDevice;
    uint32_t                               workgroupInvocations   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV>
  {
    using Type = CooperativeMatrixFlexibleDimensionsPropertiesNV;
  };

  struct CooperativeMatrixPropertiesKHR
  {
    using NativeType = VkCooperativeMatrixPropertiesKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesKHR( uint32_t                               MSize_      = {},
                                                         uint32_t                               NSize_      = {},
                                                         uint32_t                               KSize_      = {},
                                                         VULKAN_HPP_NAMESPACE::ComponentTypeKHR AType_      = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                         VULKAN_HPP_NAMESPACE::ComponentTypeKHR BType_      = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                         VULKAN_HPP_NAMESPACE::ComponentTypeKHR CType_      = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                         VULKAN_HPP_NAMESPACE::ComponentTypeKHR ResultType_ = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                                         VULKAN_HPP_NAMESPACE::Bool32           saturatingAccumulation_ = {},
                                                         VULKAN_HPP_NAMESPACE::ScopeKHR         scope_ = VULKAN_HPP_NAMESPACE::ScopeKHR::eDevice,
                                                         void *                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MSize{ MSize_ }
      , NSize{ NSize_ }
      , KSize{ KSize_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , ResultType{ ResultType_ }
      , saturatingAccumulation{ saturatingAccumulation_ }
      , scope{ scope_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesKHR( CooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesKHR( VkCooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesKHR( *reinterpret_cast<CooperativeMatrixPropertiesKHR const *>( &rhs ) )
    {
    }

    CooperativeMatrixPropertiesKHR & operator=( CooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixPropertiesKHR & operator=( VkCooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesKHR const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixPropertiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesKHR *>( this );
    }

    operator VkCooperativeMatrixPropertiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::ScopeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, MSize, NSize, KSize, AType, BType, CType, ResultType, saturatingAccumulation, scope );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesKHR const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) && ( KSize == rhs.KSize ) &&
             ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) && ( ResultType == rhs.ResultType ) &&
             ( saturatingAccumulation == rhs.saturatingAccumulation ) && ( scope == rhs.scope );
#  endif
    }

    bool operator!=( CooperativeMatrixPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType                  = StructureType::eCooperativeMatrixPropertiesKHR;
    void *                                 pNext                  = {};
    uint32_t                               MSize                  = {};
    uint32_t                               NSize                  = {};
    uint32_t                               KSize                  = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR AType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR BType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR CType                  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR ResultType             = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::Bool32           saturatingAccumulation = {};
    VULKAN_HPP_NAMESPACE::ScopeKHR         scope                  = VULKAN_HPP_NAMESPACE::ScopeKHR::eDevice;
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesKHR>
  {
    using Type = CooperativeMatrixPropertiesKHR;
  };

  struct CooperativeMatrixPropertiesNV
  {
    using NativeType = VkCooperativeMatrixPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( uint32_t                              MSize_ = {},
                                                        uint32_t                              NSize_ = {},
                                                        uint32_t                              KSize_ = {},
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV AType_ = {},
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV BType_ = {},
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV CType_ = {},
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV DType_ = {},
                                                        VULKAN_HPP_NAMESPACE::ScopeNV         scope_ = {},
                                                        void *                                pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MSize{ MSize_ }
      , NSize{ NSize_ }
      , KSize{ KSize_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , DType{ DType_ }
      , scope{ scope_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesNV( *reinterpret_cast<CooperativeMatrixPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeMatrixPropertiesNV & operator=( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixPropertiesNV & operator=( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ScopeNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, MSize, NSize, KSize, AType, BType, CType, DType, scope );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) && ( KSize == rhs.KSize ) &&
             ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) && ( DType == rhs.DType ) && ( scope == rhs.scope );
#  endif
    }

    bool operator!=( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType   sType = StructureType::eCooperativeMatrixPropertiesNV;
    void *                                pNext = {};
    uint32_t                              MSize = {};
    uint32_t                              NSize = {};
    uint32_t                              KSize = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV AType = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV BType = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV CType = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV DType = {};
    VULKAN_HPP_NAMESPACE::ScopeNV         scope = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesNV>
  {
    using Type = CooperativeMatrixPropertiesNV;
  };

  struct CooperativeVectorPropertiesNV
  {
    using NativeType = VkCooperativeVectorPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeVectorPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CooperativeVectorPropertiesNV( VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputType_            = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                     VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputInterpretation_  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                     VULKAN_HPP_NAMESPACE::ComponentTypeKHR matrixInterpretation_ = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                     VULKAN_HPP_NAMESPACE::ComponentTypeKHR biasInterpretation_   = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                     VULKAN_HPP_NAMESPACE::ComponentTypeKHR resultType_           = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16,
                                     VULKAN_HPP_NAMESPACE::Bool32           transpose_            = {},
                                     void *                                 pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , inputType{ inputType_ }
      , inputInterpretation{ inputInterpretation_ }
      , matrixInterpretation{ matrixInterpretation_ }
      , biasInterpretation{ biasInterpretation_ }
      , resultType{ resultType_ }
      , transpose{ transpose_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeVectorPropertiesNV( CooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeVectorPropertiesNV( VkCooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeVectorPropertiesNV( *reinterpret_cast<CooperativeVectorPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeVectorPropertiesNV & operator=( CooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeVectorPropertiesNV & operator=( VkCooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeVectorPropertiesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setInputType( VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputType_ ) VULKAN_HPP_NOEXCEPT
    {
      inputType = inputType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV &
      setInputInterpretation( VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      inputInterpretation = inputInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV &
      setMatrixInterpretation( VULKAN_HPP_NAMESPACE::ComponentTypeKHR matrixInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      matrixInterpretation = matrixInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV &
      setBiasInterpretation( VULKAN_HPP_NAMESPACE::ComponentTypeKHR biasInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      biasInterpretation = biasInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setResultType( VULKAN_HPP_NAMESPACE::ComponentTypeKHR resultType_ ) VULKAN_HPP_NOEXCEPT
    {
      resultType = resultType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setTranspose( VULKAN_HPP_NAMESPACE::Bool32 transpose_ ) VULKAN_HPP_NOEXCEPT
    {
      transpose = transpose_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCooperativeVectorPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeVectorPropertiesNV *>( this );
    }

    operator VkCooperativeVectorPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeVectorPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeKHR const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, inputType, inputInterpretation, matrixInterpretation, biasInterpretation, resultType, transpose );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeVectorPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeVectorPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( inputType == rhs.inputType ) && ( inputInterpretation == rhs.inputInterpretation ) &&
             ( matrixInterpretation == rhs.matrixInterpretation ) && ( biasInterpretation == rhs.biasInterpretation ) && ( resultType == rhs.resultType ) &&
             ( transpose == rhs.transpose );
#  endif
    }

    bool operator!=( CooperativeVectorPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType                = StructureType::eCooperativeVectorPropertiesNV;
    void *                                 pNext                = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputType            = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR inputInterpretation  = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR matrixInterpretation = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR biasInterpretation   = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeKHR resultType           = VULKAN_HPP_NAMESPACE::ComponentTypeKHR::eFloat16;
    VULKAN_HPP_NAMESPACE::Bool32           transpose            = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeVectorPropertiesNV>
  {
    using Type = CooperativeVectorPropertiesNV;
  };

  struct CopyAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_   = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureInfoKHR( *reinterpret_cast<CopyAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }

    CopyAccelerationStructureInfoKHR & operator=( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyAccelerationStructureInfoKHR & operator=( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyAccelerationStructureInfoKHR const & ) const = default;
#else
    bool operator==( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) && ( mode == rhs.mode );
#  endif
    }

    bool operator!=( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyAccelerationStructureInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureInfoKHR>
  {
    using Type = CopyAccelerationStructureInfoKHR;
  };

  struct CopyAccelerationStructureToMemoryInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureToMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_   = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR           dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureToMemoryInfoKHR( *reinterpret_cast<CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs ) )
    {
    }

    CopyAccelerationStructureToMemoryInfoKHR & operator=( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyAccelerationStructureToMemoryInfoKHR & operator=( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setDst( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
      setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyAccelerationStructureToMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureToMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src   = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR           dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureToMemoryInfoKHR>
  {
    using Type = CopyAccelerationStructureToMemoryInfoKHR;
  };

  struct CopyBufferInfo2
  {
    using NativeType = VkCopyBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer              srcBuffer_   = {},
                                          VULKAN_HPP_NAMESPACE::Buffer              dstBuffer_   = {},
                                          uint32_t                                  regionCount_ = {},
                                          const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_    = {},
                                          const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyBufferInfo2( *reinterpret_cast<CopyBufferInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                   srcBuffer_,
                     VULKAN_HPP_NAMESPACE::Buffer                                                                   dstBuffer_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_,
                     const void *                                                                                   pNext_ = nullptr )
      : pNext( pNext_ ), srcBuffer( srcBuffer_ ), dstBuffer( dstBuffer_ ), regionCount( static_cast<uint32_t>( regions_.size() ) ), pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferInfo2 & operator=( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyBufferInfo2 & operator=( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferInfo2 *>( this );
    }

    operator VkCopyBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstBuffer == rhs.dstBuffer ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eCopyBufferInfo2;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::Buffer              srcBuffer   = {};
    VULKAN_HPP_NAMESPACE::Buffer              dstBuffer   = {};
    uint32_t                                  regionCount = {};
    const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferInfo2>
  {
    using Type = CopyBufferInfo2;
  };

  using CopyBufferInfo2KHR = CopyBufferInfo2;

  struct CopyBufferToImageInfo2
  {
    using NativeType = VkCopyBufferToImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferToImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer_      = {},
                                                 VULKAN_HPP_NAMESPACE::Image                    dstImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferToImageInfo2( *reinterpret_cast<CopyBufferToImageInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                        srcBuffer_,
                            VULKAN_HPP_NAMESPACE::Image                                                                         dstImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   dstImageLayout_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferToImageInfo2 & operator=( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyBufferToImageInfo2 & operator=( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyBufferToImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferToImageInfo2 *>( this );
    }

    operator VkCopyBufferToImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferToImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferToImageInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyBufferToImageInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer      = {};
    VULKAN_HPP_NAMESPACE::Image                    dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferToImageInfo2>
  {
    using Type = CopyBufferToImageInfo2;
  };

  using CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;

  struct CopyCommandTransformInfoQCOM
  {
    using NativeType = VkCopyCommandTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyCommandTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CopyCommandTransformInfoQCOM( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
                                    const void *                                      pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , transform{ transform_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyCommandTransformInfoQCOM( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyCommandTransformInfoQCOM( *reinterpret_cast<CopyCommandTransformInfoQCOM const *>( &rhs ) )
    {
    }

    CopyCommandTransformInfoQCOM & operator=( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyCommandTransformInfoQCOM & operator=( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyCommandTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyCommandTransformInfoQCOM *>( this );
    }

    operator VkCopyCommandTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyCommandTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyCommandTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform );
#  endif
    }

    bool operator!=( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType     = StructureType::eCopyCommandTransformInfoQCOM;
    const void *                                      pNext     = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyCommandTransformInfoQCOM>
  {
    using Type = CopyCommandTransformInfoQCOM;
  };

  struct CopyDescriptorSet
  {
    using NativeType = VkCopyDescriptorSet;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyDescriptorSet;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_          = {},
                                            uint32_t                            srcBinding_      = {},
                                            uint32_t                            srcArrayElement_ = {},
                                            VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_          = {},
                                            uint32_t                            dstBinding_      = {},
                                            uint32_t                            dstArrayElement_ = {},
                                            uint32_t                            descriptorCount_ = {},
                                            const void *                        pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSet{ srcSet_ }
      , srcBinding{ srcBinding_ }
      , srcArrayElement{ srcArrayElement_ }
      , dstSet{ dstSet_ }
      , dstBinding{ dstBinding_ }
      , dstArrayElement{ dstArrayElement_ }
      , descriptorCount{ descriptorCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT : CopyDescriptorSet( *reinterpret_cast<CopyDescriptorSet const *>( &rhs ) ) {}

    CopyDescriptorSet & operator=( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyDescriptorSet & operator=( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyDescriptorSet const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSet = srcSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcBinding( uint32_t srcBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBinding = srcBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcArrayElement( uint32_t srcArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      srcArrayElement = srcArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstSet( VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSet = dstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyDescriptorSet const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSet, srcBinding, srcArrayElement, dstSet, dstBinding, dstArrayElement, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyDescriptorSet const & ) const = default;
#else
    bool operator==( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSet == rhs.srcSet ) && ( srcBinding == rhs.srcBinding ) &&
             ( srcArrayElement == rhs.srcArrayElement ) && ( dstSet == rhs.dstSet ) && ( dstBinding == rhs.dstBinding ) &&
             ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eCopyDescriptorSet;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet srcSet          = {};
    uint32_t                            srcBinding      = {};
    uint32_t                            srcArrayElement = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet dstSet          = {};
    uint32_t                            dstBinding      = {};
    uint32_t                            dstArrayElement = {};
    uint32_t                            descriptorCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyDescriptorSet>
  {
    using Type = CopyDescriptorSet;
  };

  struct ImageCopy2
  {
    using NativeType = VkImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::Extent3D               extent_         = {},
                                     const void *                                 pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffset{ srcOffset_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffset{ dstOffset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCopy2( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCopy2( *reinterpret_cast<ImageCopy2 const *>( &rhs ) ) {}

    ImageCopy2 & operator=( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageCopy2 & operator=( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy2 *>( this );
    }

    operator VkImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy2 const & ) const = default;
#else
    bool operator==( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType          = StructureType::eImageCopy2;
    const void *                                 pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageCopy2>
  {
    using Type = ImageCopy2;
  };

  using ImageCopy2KHR = ImageCopy2;

  struct CopyImageInfo2
  {
    using NativeType = VkCopyImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         uint32_t                                 regionCount_    = {},
                                         const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_       = {},
                                         const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageInfo2( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyImageInfo2( *reinterpret_cast<CopyImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_,
                    const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageInfo2 & operator=( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageInfo2 & operator=( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageInfo2 *>( this );
    }

    operator VkCopyImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageInfo2 const & ) const = default;
#else
    bool operator==( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eCopyImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageInfo2>
  {
    using Type = CopyImageInfo2;
  };

  using CopyImageInfo2KHR = CopyImageInfo2;

  struct CopyImageToBufferInfo2
  {
    using NativeType = VkCopyImageToBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToBufferInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                    srcImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer_      = {},
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToBufferInfo2( *reinterpret_cast<CopyImageToBufferInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                                                                         srcImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   srcImageLayout_,
                            VULKAN_HPP_NAMESPACE::Buffer                                                                        dstBuffer_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToBufferInfo2 & operator=( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToBufferInfo2 & operator=( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToBufferInfo2 *>( this );
    }

    operator VkCopyImageToBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstBuffer == rhs.dstBuffer ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyImageToBufferInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                    srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer      = {};
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToBufferInfo2>
  {
    using Type = CopyImageToBufferInfo2;
  };

  using CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;

  struct CopyImageToImageInfo
  {
    using NativeType = VkCopyImageToImageInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToImageInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToImageInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags flags_          = {},
                                               VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                               VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                               VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                               VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                               uint32_t                                 regionCount_    = {},
                                               const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_       = {},
                                               const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToImageInfo( CopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToImageInfo( VkCopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToImageInfo( *reinterpret_cast<CopyImageToImageInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToImageInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags                                                      flags_,
                          VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                          VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                          VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                          VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                          VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_,
                          const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToImageInfo & operator=( CopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToImageInfo & operator=( VkCopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setFlags( VULKAN_HPP_NAMESPACE::HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setPRegions( const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToImageInfo &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToImageInfo *>( this );
    }

    operator VkCopyImageToImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::HostImageCopyFlags const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToImageInfo const & ) const = default;
#else
    bool operator==( CopyImageToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eCopyImageToImageInfo;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::HostImageCopyFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToImageInfo>
  {
    using Type = CopyImageToImageInfo;
  };

  using CopyImageToImageInfoEXT = CopyImageToImageInfo;

  struct ImageToMemoryCopy
  {
    using NativeType = VkImageToMemoryCopy;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageToMemoryCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageToMemoryCopy( void *                                       pHostPointer_      = {},
                                            uint32_t                                     memoryRowLength_   = {},
                                            uint32_t                                     memoryImageHeight_ = {},
                                            VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                            VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                            VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {},
                                            const void *                                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pHostPointer{ pHostPointer_ }
      , memoryRowLength{ memoryRowLength_ }
      , memoryImageHeight{ memoryImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageToMemoryCopy( ImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageToMemoryCopy( VkImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT : ImageToMemoryCopy( *reinterpret_cast<ImageToMemoryCopy const *>( &rhs ) ) {}

    ImageToMemoryCopy & operator=( ImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageToMemoryCopy & operator=( VkImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageToMemoryCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setPHostPointer( void * pHostPointer_ ) VULKAN_HPP_NOEXCEPT
    {
      pHostPointer = pHostPointer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setMemoryRowLength( uint32_t memoryRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryRowLength = memoryRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setMemoryImageHeight( uint32_t memoryImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryImageHeight = memoryImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy &
      setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageToMemoryCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageToMemoryCopy *>( this );
    }

    operator VkImageToMemoryCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageToMemoryCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pHostPointer, memoryRowLength, memoryImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageToMemoryCopy const & ) const = default;
#else
    bool operator==( ImageToMemoryCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pHostPointer == rhs.pHostPointer ) && ( memoryRowLength == rhs.memoryRowLength ) &&
             ( memoryImageHeight == rhs.memoryImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( ImageToMemoryCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eImageToMemoryCopy;
    const void *                                 pNext             = {};
    void *                                       pHostPointer      = {};
    uint32_t                                     memoryRowLength   = {};
    uint32_t                                     memoryImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageToMemoryCopy>
  {
    using Type = ImageToMemoryCopy;
  };

  using ImageToMemoryCopyEXT = ImageToMemoryCopy;

  struct CopyImageToMemoryInfo
  {
    using NativeType = VkCopyImageToMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToMemoryInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags        flags_          = {},
                                                VULKAN_HPP_NAMESPACE::Image                     srcImage_       = {},
                                                VULKAN_HPP_NAMESPACE::ImageLayout               srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                uint32_t                                        regionCount_    = {},
                                                const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy * pRegions_       = {},
                                                const void *                                    pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToMemoryInfo( CopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToMemoryInfo( VkCopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToMemoryInfo( *reinterpret_cast<CopyImageToMemoryInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToMemoryInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags                                                             flags_,
                           VULKAN_HPP_NAMESPACE::Image                                                                          srcImage_,
                           VULKAN_HPP_NAMESPACE::ImageLayout                                                                    srcImageLayout_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy> const & regions_,
                           const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToMemoryInfo & operator=( CopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToMemoryInfo & operator=( VkCopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setFlags( VULKAN_HPP_NAMESPACE::HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setPRegions( const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToMemoryInfo &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToMemoryInfo *>( this );
    }

    operator VkCopyImageToMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::HostImageCopyFlags const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, srcImage, srcImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToMemoryInfo const & ) const = default;
#else
    bool operator==( CopyImageToMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType          = StructureType::eCopyImageToMemoryInfo;
    const void *                                    pNext          = {};
    VULKAN_HPP_NAMESPACE::HostImageCopyFlags        flags          = {};
    VULKAN_HPP_NAMESPACE::Image                     srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout               srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                        regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageToMemoryCopy * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToMemoryInfo>
  {
    using Type = CopyImageToMemoryInfo;
  };

  using CopyImageToMemoryInfoEXT = CopyImageToMemoryInfo;

  struct CopyMemoryIndirectCommandNV
  {
    using NativeType = VkCopyMemoryIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMemoryIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress srcAddress_ = {},
                                                      VULKAN_HPP_NAMESPACE::DeviceAddress dstAddress_ = {},
                                                      VULKAN_HPP_NAMESPACE::DeviceSize    size_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcAddress{ srcAddress_ }
      , dstAddress{ dstAddress_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryIndirectCommandNV( CopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryIndirectCommandNV( VkCopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryIndirectCommandNV( *reinterpret_cast<CopyMemoryIndirectCommandNV const *>( &rhs ) )
    {
    }

    CopyMemoryIndirectCommandNV & operator=( CopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryIndirectCommandNV & operator=( VkCopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setSrcAddress( VULKAN_HPP_NAMESPACE::DeviceAddress srcAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAddress = srcAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setDstAddress( VULKAN_HPP_NAMESPACE::DeviceAddress dstAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAddress = dstAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, VULKAN_HPP_NAMESPACE::DeviceAddress const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAddress, dstAddress, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryIndirectCommandNV const & ) const = default;
#else
    bool operator==( CopyMemoryIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAddress == rhs.srcAddress ) && ( dstAddress == rhs.dstAddress ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( CopyMemoryIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress srcAddress = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress dstAddress = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size       = {};
  };

  struct CopyMemoryToAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyMemoryToAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      src_   = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToAccelerationStructureInfoKHR( *reinterpret_cast<CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }

    CopyMemoryToAccelerationStructureInfoKHR & operator=( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToAccelerationStructureInfoKHR & operator=( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
      setSrc( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
      setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyMemoryToAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToAccelerationStructureInfoKHR>
  {
    using Type = CopyMemoryToAccelerationStructureInfoKHR;
  };

  struct CopyMemoryToImageIndirectCommandNV
  {
    using NativeType = VkCopyMemoryToImageIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMemoryToImageIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress          srcAddress_        = {},
                                                             uint32_t                                     bufferRowLength_   = {},
                                                             uint32_t                                     bufferImageHeight_ = {},
                                                             VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                                             VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                                             VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcAddress{ srcAddress_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryToImageIndirectCommandNV( CopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToImageIndirectCommandNV( VkCopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToImageIndirectCommandNV( *reinterpret_cast<CopyMemoryToImageIndirectCommandNV const *>( &rhs ) )
    {
    }

    CopyMemoryToImageIndirectCommandNV & operator=( CopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToImageIndirectCommandNV & operator=( VkCopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToImageIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setSrcAddress( VULKAN_HPP_NAMESPACE::DeviceAddress srcAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAddress = srcAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV &
      setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToImageIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryToImageIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAddress, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryToImageIndirectCommandNV const & ) const = default;
#else
    bool operator==( CopyMemoryToImageIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAddress == rhs.srcAddress ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( CopyMemoryToImageIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress          srcAddress        = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  struct MemoryToImageCopy
  {
    using NativeType = VkMemoryToImageCopy;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eMemoryToImageCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MemoryToImageCopy( const void *                                 pHostPointer_      = {},
                                            uint32_t                                     memoryRowLength_   = {},
                                            uint32_t                                     memoryImageHeight_ = {},
                                            VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                            VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                            VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {},
                                            const void *                                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pHostPointer{ pHostPointer_ }
      , memoryRowLength{ memoryRowLength_ }
      , memoryImageHeight{ memoryImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR MemoryToImageCopy( MemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryToImageCopy( VkMemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : MemoryToImageCopy( *reinterpret_cast<MemoryToImageCopy const *>( &rhs ) ) {}

    MemoryToImageCopy & operator=( MemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    MemoryToImageCopy & operator=( VkMemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::MemoryToImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setPHostPointer( const void * pHostPointer_ ) VULKAN_HPP_NOEXCEPT
    {
      pHostPointer = pHostPointer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setMemoryRowLength( uint32_t memoryRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryRowLength = memoryRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setMemoryImageHeight( uint32_t memoryImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryImageHeight = memoryImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy &
      setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkMemoryToImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMemoryToImageCopy *>( this );
    }

    operator VkMemoryToImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMemoryToImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const void * const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pHostPointer, memoryRowLength, memoryImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MemoryToImageCopy const & ) const = default;
#else
    bool operator==( MemoryToImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pHostPointer == rhs.pHostPointer ) && ( memoryRowLength == rhs.memoryRowLength ) &&
             ( memoryImageHeight == rhs.memoryImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( MemoryToImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eMemoryToImageCopy;
    const void *                                 pNext             = {};
    const void *                                 pHostPointer      = {};
    uint32_t                                     memoryRowLength   = {};
    uint32_t                                     memoryImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eMemoryToImageCopy>
  {
    using Type = MemoryToImageCopy;
  };

  using MemoryToImageCopyEXT = MemoryToImageCopy;

  struct CopyMemoryToImageInfo
  {
    using NativeType = VkCopyMemoryToImageInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToImageInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMemoryToImageInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags        flags_          = {},
                                                VULKAN_HPP_NAMESPACE::Image                     dstImage_       = {},
                                                VULKAN_HPP_NAMESPACE::ImageLayout               dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                uint32_t                                        regionCount_    = {},
                                                const VULKAN_HPP_NAMESPACE::MemoryToImageCopy * pRegions_       = {},
                                                const void *                                    pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryToImageInfo( CopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToImageInfo( VkCopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToImageInfo( *reinterpret_cast<CopyMemoryToImageInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyMemoryToImageInfo( VULKAN_HPP_NAMESPACE::HostImageCopyFlags                                                             flags_,
                           VULKAN_HPP_NAMESPACE::Image                                                                          dstImage_,
                           VULKAN_HPP_NAMESPACE::ImageLayout                                                                    dstImageLayout_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryToImageCopy> const & regions_,
                           const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyMemoryToImageInfo & operator=( CopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToImageInfo & operator=( VkCopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setFlags( VULKAN_HPP_NAMESPACE::HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setPRegions( const VULKAN_HPP_NAMESPACE::MemoryToImageCopy * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyMemoryToImageInfo &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryToImageCopy> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToImageInfo *>( this );
    }

    operator VkCopyMemoryToImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::HostImageCopyFlags const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::MemoryToImageCopy * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryToImageInfo const & ) const = default;
#else
    bool operator==( CopyMemoryToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyMemoryToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType          = StructureType::eCopyMemoryToImageInfo;
    const void *                                    pNext          = {};
    VULKAN_HPP_NAMESPACE::HostImageCopyFlags        flags          = {};
    VULKAN_HPP_NAMESPACE::Image                     dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout               dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                        regionCount    = {};
    const VULKAN_HPP_NAMESPACE::MemoryToImageCopy * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToImageInfo>
  {
    using Type = CopyMemoryToImageInfo;
  };

  using CopyMemoryToImageInfoEXT = CopyMemoryToImageInfo;

  struct CopyMemoryToMicromapInfoEXT
  {
    using NativeType = VkCopyMemoryToMicromapInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToMicromapInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR src_ = {},
                                                         VULKAN_HPP_NAMESPACE::MicromapEXT                 dst_ = {},
                                                         VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode_  = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone,
                                                         const void *                              pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT( CopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToMicromapInfoEXT( VkCopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToMicromapInfoEXT( *reinterpret_cast<CopyMemoryToMicromapInfoEXT const *>( &rhs ) )
    {
    }

    CopyMemoryToMicromapInfoEXT & operator=( CopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToMicromapInfoEXT & operator=( VkCopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToMicromapInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setSrc( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setDst( VULKAN_HPP_NAMESPACE::MicromapEXT dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setMode( VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToMicromapInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToMicromapInfoEXT *>( this );
    }

    operator VkCopyMemoryToMicromapInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToMicromapInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &,
               VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eCopyMemoryToMicromapInfoEXT;
    const void *                                      pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR src   = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT                 dst   = {};
    VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT         mode  = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToMicromapInfoEXT>
  {
    using Type = CopyMemoryToMicromapInfoEXT;
  };

  struct CopyMicromapInfoEXT
  {
    using NativeType = VkCopyMicromapInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMicromapInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMicromapInfoEXT( VULKAN_HPP_NAMESPACE::MicromapEXT         src_   = {},
                                              VULKAN_HPP_NAMESPACE::MicromapEXT         dst_   = {},
                                              VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode_  = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone,
                                              const void *                              pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMicromapInfoEXT( CopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMicromapInfoEXT( VkCopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT : CopyMicromapInfoEXT( *reinterpret_cast<CopyMicromapInfoEXT const *>( &rhs ) )
    {
    }

    CopyMicromapInfoEXT & operator=( CopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMicromapInfoEXT & operator=( VkCopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMicromapInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setSrc( VULKAN_HPP_NAMESPACE::MicromapEXT src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setDst( VULKAN_HPP_NAMESPACE::MicromapEXT dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setMode( VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMicromapInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMicromapInfoEXT *>( this );
    }

    operator VkCopyMicromapInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMicromapInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &,
               VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMicromapInfoEXT const & ) const = default;
#else
    bool operator==( CopyMicromapInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) && ( mode == rhs.mode );
#  endif
    }

    bool operator!=( CopyMicromapInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType = StructureType::eCopyMicromapInfoEXT;
    const void *                              pNext = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT         src   = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode  = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMicromapInfoEXT>
  {
    using Type = CopyMicromapInfoEXT;
  };

  struct CopyMicromapToMemoryInfoEXT
  {
    using NativeType = VkCopyMicromapToMemoryInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMicromapToMemoryInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT( VULKAN_HPP_NAMESPACE::MicromapEXT            src_  = {},
                                                         VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR dst_  = {},
                                                         VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT    mode_ = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone,
                                                         const void *                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT( CopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMicromapToMemoryInfoEXT( VkCopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMicromapToMemoryInfoEXT( *reinterpret_cast<CopyMicromapToMemoryInfoEXT const *>( &rhs ) )
    {
    }

    CopyMicromapToMemoryInfoEXT & operator=( CopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMicromapToMemoryInfoEXT & operator=( VkCopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMicromapToMemoryInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setSrc( VULKAN_HPP_NAMESPACE::MicromapEXT src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setDst( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setMode( VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMicromapToMemoryInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMicromapToMemoryInfoEXT *>( this );
    }

    operator VkCopyMicromapToMemoryInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMicromapToMemoryInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::MicromapEXT const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &,
               VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType = StructureType::eCopyMicromapToMemoryInfoEXT;
    const void *                                 pNext = {};
    VULKAN_HPP_NAMESPACE::MicromapEXT            src   = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR dst   = {};
    VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT    mode  = VULKAN_HPP_NAMESPACE::CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMicromapToMemoryInfoEXT>
  {
    using Type = CopyMicromapToMemoryInfoEXT;
  };

  struct CuFunctionCreateInfoNVX
  {
    using NativeType = VkCuFunctionCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuFunctionCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CuFunctionCreateInfoNVX( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ = {}, const char * pName_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , module{ module_ }
      , pName{ pName_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CuFunctionCreateInfoNVX( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuFunctionCreateInfoNVX( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuFunctionCreateInfoNVX( *reinterpret_cast<CuFunctionCreateInfoNVX const *>( &rhs ) )
    {
    }

    CuFunctionCreateInfoNVX & operator=( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CuFunctionCreateInfoNVX & operator=( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setModule( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCuFunctionCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuFunctionCreateInfoNVX *>( this );
    }

    operator VkCuFunctionCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuFunctionCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CuModuleNVX const &, const char * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, module, pName );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( module == rhs.module ) && ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) );
    }

    bool operator!=( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eCuFunctionCreateInfoNVX;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::CuModuleNVX   module = {};
    const char *                        pName  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCuFunctionCreateInfoNVX>
  {
    using Type = CuFunctionCreateInfoNVX;
  };

  struct CuLaunchInfoNVX
  {
    using NativeType = VkCuLaunchInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuLaunchInfoNVX;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_       = {},
                                          uint32_t                            gridDimX_       = {},
                                          uint32_t                            gridDimY_       = {},
                                          uint32_t                            gridDimZ_       = {},
                                          uint32_t                            blockDimX_      = {},
                                          uint32_t                            blockDimY_      = {},
                                          uint32_t                            blockDimZ_      = {},
                                          uint32_t                            sharedMemBytes_ = {},
                                          size_t                              paramCount_     = {},
                                          const void * const *                pParams_        = {},
                                          size_t                              extraCount_     = {},
                                          const void * const *                pExtras_        = {},
                                          const void *                        pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , function{ function_ }
      , gridDimX{ gridDimX_ }
      , gridDimY{ gridDimY_ }
      , gridDimZ{ gridDimZ_ }
      , blockDimX{ blockDimX_ }
      , blockDimY{ blockDimY_ }
      , blockDimZ{ blockDimZ_ }
      , sharedMemBytes{ sharedMemBytes_ }
      , paramCount{ paramCount_ }
      , pParams{ pParams_ }
      , extraCount{ extraCount_ }
      , pExtras{ pExtras_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuLaunchInfoNVX( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT : CuLaunchInfoNVX( *reinterpret_cast<CuLaunchInfoNVX const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX                                       function_,
                     uint32_t                                                                  gridDimX_,
                     uint32_t                                                                  gridDimY_,
                     uint32_t                                                                  gridDimZ_,
                     uint32_t                                                                  blockDimX_,
                     uint32_t                                                                  blockDimY_,
                     uint32_t                                                                  blockDimZ_,
                     uint32_t                                                                  sharedMemBytes_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ = {},
                     const void *                                                              pNext_  = nullptr )
      : pNext( pNext_ )
      , function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( params_.size() )
      , pParams( params_.data() )
      , extraCount( extras_.size() )
      , pExtras( extras_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CuLaunchInfoNVX & operator=( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CuLaunchInfoNVX & operator=( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setFunction( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_ ) VULKAN_HPP_NOEXCEPT
    {
      function = function_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimX( uint32_t gridDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimX = gridDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimY( uint32_t gridDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimY = gridDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimZ( uint32_t gridDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimZ = gridDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimX( uint32_t blockDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimX = blockDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimY( uint32_t blockDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimY = blockDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimZ( uint32_t blockDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimZ = blockDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setSharedMemBytes( uint32_t sharedMemBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      sharedMemBytes = sharedMemBytes_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setParamCount( size_t paramCount_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = paramCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPParams( const void * const * pParams_ ) VULKAN_HPP_NOEXCEPT
    {
      pParams = pParams_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX & setParams( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = params_.size();
      pParams    = params_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setExtraCount( size_t extraCount_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extraCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPExtras( const void * const * pExtras_ ) VULKAN_HPP_NOEXCEPT
    {
      pExtras = pExtras_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX & setExtras( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extras_.size();
      pExtras    = extras_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCuLaunchInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuLaunchInfoNVX *>( this );
    }

    operator VkCuLaunchInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuLaunchInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CuFunctionNVX const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               size_t const &,
               const void * const * const &,
               size_t const &,
               const void * const * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, function, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, paramCount, pParams, extraCount, pExtras );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuLaunchInfoNVX const & ) const = default;
#else
    bool operator==( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( function == rhs.function ) && ( gridDimX == rhs.gridDimX ) && ( gridDimY == rhs.gridDimY ) &&
             ( gridDimZ == rhs.gridDimZ ) && ( blockDimX == rhs.blockDimX ) && ( blockDimY == rhs.blockDimY ) && ( blockDimZ == rhs.blockDimZ ) &&
             ( sharedMemBytes == rhs.sharedMemBytes ) && ( paramCount == rhs.paramCount ) && ( pParams == rhs.pParams ) && ( extraCount == rhs.extraCount ) &&
             ( pExtras == rhs.pExtras );
#  endif
    }

    bool operator!=( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eCuLaunchInfoNVX;
    const void *                        pNext          = {};
    VULKAN_HPP_NAMESPACE::CuFunctionNVX function       = {};
    uint32_t                            gridDimX       = {};
    uint32_t                            gridDimY       = {};
    uint32_t                            gridDimZ       = {};
    uint32_t                            blockDimX      = {};
    uint32_t                            blockDimY      = {};
    uint32_t                            blockDimZ      = {};
    uint32_t                            sharedMemBytes = {};
    size_t                              paramCount     = {};
    const void * const *                pParams        = {};
    size_t                              extraCount     = {};
    const void * const *                pExtras        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCuLaunchInfoNVX>
  {
    using Type = CuLaunchInfoNVX;
  };

  struct CuModuleCreateInfoNVX
  {
    using NativeType = VkCuModuleCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuModuleCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( size_t dataSize_ = {}, const void * pData_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , dataSize{ dataSize_ }
      , pData{ pData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleCreateInfoNVX( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuModuleCreateInfoNVX( *reinterpret_cast<CuModuleCreateInfoNVX const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), dataSize( data_.size() * sizeof( T ) ), pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CuModuleCreateInfoNVX & operator=( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CuModuleCreateInfoNVX & operator=( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX & setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCuModuleCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuModuleCreateInfoNVX *>( this );
    }

    operator VkCuModuleCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuModuleCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuModuleCreateInfoNVX const & ) const = default;
#else
    bool operator==( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eCuModuleCreateInfoNVX;
    const void *                        pNext    = {};
    size_t                              dataSize = {};
    const void *                        pData    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCuModuleCreateInfoNVX>
  {
    using Type = CuModuleCreateInfoNVX;
  };

  struct CuModuleTexturingModeCreateInfoNVX
  {
    using NativeType = VkCuModuleTexturingModeCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuModuleTexturingModeCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuModuleTexturingModeCreateInfoNVX( VULKAN_HPP_NAMESPACE::Bool32 use64bitTexturing_ = {},
                                                             const void *                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , use64bitTexturing{ use64bitTexturing_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CuModuleTexturingModeCreateInfoNVX( CuModuleTexturingModeCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleTexturingModeCreateInfoNVX( VkCuModuleTexturingModeCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuModuleTexturingModeCreateInfoNVX( *reinterpret_cast<CuModuleTexturingModeCreateInfoNVX const *>( &rhs ) )
    {
    }

    CuModuleTexturingModeCreateInfoNVX & operator=( CuModuleTexturingModeCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CuModuleTexturingModeCreateInfoNVX & operator=( VkCuModuleTexturingModeCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuModuleTexturingModeCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuModuleTexturingModeCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleTexturingModeCreateInfoNVX & setUse64bitTexturing( VULKAN_HPP_NAMESPACE::Bool32 use64bitTexturing_ ) VULKAN_HPP_NOEXCEPT
    {
      use64bitTexturing = use64bitTexturing_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCuModuleTexturingModeCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuModuleTexturingModeCreateInfoNVX *>( this );
    }

    operator VkCuModuleTexturingModeCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuModuleTexturingModeCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, use64bitTexturing );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuModuleTexturingModeCreateInfoNVX const & ) const = default;
#else
    bool operator==( CuModuleTexturingModeCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( use64bitTexturing == rhs.use64bitTexturing );
#  endif
    }

    bool operator!=( CuModuleTexturingModeCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType             = StructureType::eCuModuleTexturingModeCreateInfoNVX;
    const void *                        pNext             = {};
    VULKAN_HPP_NAMESPACE::Bool32        use64bitTexturing = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCuModuleTexturingModeCreateInfoNVX>
  {
    using Type = CuModuleTexturingModeCreateInfoNVX;
  };

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  struct CudaFunctionCreateInfoNV
  {
    using NativeType = VkCudaFunctionCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCudaFunctionCreateInfoNV;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CudaFunctionCreateInfoNV( VULKAN_HPP_NAMESPACE::CudaModuleNV module_ = {}, const char * pName_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , module{ module_ }
      , pName{ pName_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CudaFunctionCreateInfoNV( CudaFunctionCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CudaFunctionCreateInfoNV( VkCudaFunctionCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CudaFunctionCreateInfoNV( *reinterpret_cast<CudaFunctionCreateInfoNV const *>( &rhs ) )
    {
    }

    CudaFunctionCreateInfoNV & operator=( CudaFunctionCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CudaFunctionCreateInfoNV & operator=( VkCudaFunctionCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CudaFunctionCreateInfoNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CudaFunctionCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CudaFunctionCreateInfoNV & setModule( VULKAN_HPP_NAMESPACE::CudaModuleNV module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CudaFunctionCreateInfoNV & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCudaFunctionCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCudaFunctionCreateInfoNV *>( this );
    }

    operator VkCudaFunctionCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCudaFunctionCreateInfoNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CudaModuleNV const &, const char * const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, module, pName );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( CudaFunctionCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( CudaFunctionCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( module == rhs.module ) && ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) );
    }

    bool operator!=( CudaFunctionCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eCudaFunctionCreateInfoNV;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::CudaModuleNV  module = {};
    const char *                        pName  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCudaFunctionCreateInfoNV>
  {
    using Type = CudaFunctionCreateInfoNV;
  };
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  struct CudaLaunchInfoNV
  {
    using NativeType = VkCudaLaunchInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCudaLaunchInfoNV;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CudaLaunchInfoNV( VULKAN_HPP_NAMESPACE::CudaFunctionNV function_       = {},
                                           uint32_t                             gridDimX_       = {},
                                           uint32_t                             gridDimY_       = {},
                                           uint32_t                             gridDimZ_       = {},
                                           uint32_t                             blockDimX_      = {},
                                           uint32_t                             blockDimY_      = {},
                                           uint32_t                             blockDimZ_      = {},
                                           uint32_t                             sharedMemBytes_ = {},
                                           size_t                               paramCount_     = {},
                                           const void * const *                 pParams_        = {},
                                           size_t                               extraCount_     = {},
                                           const void * const *                 pExtras_        = {},
                                           const void *                         pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , function{ function_ }
      , gridDimX{ gridDimX_ }
      , gridDimY{ gridDimY_ }
      , gridDimZ{ gridDimZ_ }
      , blockDimX{ blockDimX_ }
      , blockDimY{ blockDimY_ }
      , blockDimZ{ blockDimZ_ }
      , sharedMemBytes{ sharedMemBytes_ }
      , paramCount{ paramCount_ }
      , pParams{ pParams_ }
      , extraCount{ extraCount_ }
      , pExtras{ pExtras_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CudaLaunchInfoNV( CudaLaunchInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CudaLaunchInfoNV( VkCudaLaunchInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT : CudaLaunchInfoNV( *reinterpret_cast<CudaLaunchInfoNV const *>( &rhs ) ) {}

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CudaLaunchInfoNV( VULKAN_HPP_NAMESPACE::CudaFunctionNV                                      function_,
                      uint32_t                                                                  gridDimX_,
                      uint32_t                                                                  gridDimY_,
                      uint32_t                                                                  gridDimZ_,
                      uint32_t                                                                  blockDimX_,
                      uint32_t                                                                  blockDimY_,
                      uint32_t                                                                  blockDimZ_,
                      uint32_t                                                                  sharedMemBytes_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ = {},
                      const void *                                                              pNext_  = nullptr )
      : pNext( pNext_ )
      , function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( params_.size() )
      , pParams( params_.data() )
      , extraCount( extras_.size() )
      , pExtras( extras_.data() )
    {
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CudaLaunchInfoNV & operator=( CudaLaunchInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CudaLaunchInfoNV & operator=( VkCudaLaunchInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CudaLaunchInfoNV const *>( &rhs );
   