/*
 * Copyright Evan Miller, 2020
 * Use, modification and distribution are subject to the
 * Boost Software License, Version 1.0. (See accompanying file
 * LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 6>, 400> jacobi_theta_small_tau_data = {{
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(5.1615323244600500649545371516467594502339e-315), SC_(-4.3780502833417106909791663988832605163066e+00), SC_(4.3780502833417106909791663988832605163066e+00), SC_(5.1615323244600500649545371516467594502339e-315) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(7.6430439369569174389347068283521036429672e-242), SC_(-6.0865658997775425224262998368808341926984e+00), SC_(6.0865658997775425224262998368808341926984e+00), SC_(7.6430439369569174389347068283521036429672e-242) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(1.1760957872749565003121989529395437341179e-226), SC_(-6.4850771264231212243563032744767576741018e+00), SC_(6.4850771264231212243563032744767576741018e+00), SC_(1.1760957872749565003121989529395437341179e-226) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(7.1025002479325416701758628685035692684694e-163), SC_(-8.2234254266951768675205774105632204328466e+00), SC_(8.2234254266951768675205774105632204328466e+00), SC_(7.1025002479325416701758628685035692825763e-163) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(9.3592754511549804983125853481683158222014e-139), SC_(-8.8397242219203887650514800391643853378049e+00), SC_(8.8397242219203887650514800391643853378049e+00), SC_(9.3592754511549804983125853481721864294068e-139) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(4.7349630983209456446334089569796182213195e-110), SC_(-9.4392938099316833265381984132336138920105e+00), SC_(9.4392938099316833265381984132336138920105e+00), SC_(4.7349630983209456446334131561768191487952e-110) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(2.0024690749488476082733962180765680248367e-99), SC_(-9.5961098280739991392869199238111380831923e+00), SC_(9.5961098280739991392869199238111380831923e+00), SC_(2.0024690749488476082737888786829895365012e-99) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(6.4131277720454735017551264530111304632156e-56), SC_(-9.4826539959185686661315556796637307193586e+00), SC_(9.4826539959185686661315556796637307193586e+00), SC_(6.4131277720505585143665220465532723256897e-56) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(6.9477943900160451037996656203338639063668e-56), SC_(-9.4818001660105784722948668449452767293859e+00), SC_(9.4818001660105784722948668449452767293859e+00), SC_(6.9477943900216524349095314800071661149121e-56) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(2.4491570766696341565123914107087704724537e-48), SC_(-9.2518346790262426950579564979192312960068e+00), SC_(9.2518346790262426950579564979192312960068e+00), SC_(2.4491570767618123983738490121987155799618e-48) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(1.7264275083436298725948655034893741201329e-37), SC_(-8.7305133592162124969183486513736449072663e+00), SC_(8.7305133592162124969183486513736449072663e+00), SC_(1.7264275246926935666999502488712354839464e-37) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(1.4134026164023111766303263325983681587019e-36), SC_(-8.6738660900234766063217601605909634023760e+00), SC_(8.6738660900234766063217601605909634023760e+00), SC_(1.4134026377250453605915818694283348447390e-36) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(1.0358115256386037315460721336816526624795e-33), SC_(-8.4807080921987746280295775704402651111767e+00), SC_(8.4807080921987746280295775704402651111767e+00), SC_(1.0358115930273133119654761884896609554231e-33) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(1.9761992092970055504105877284110361303091e-33), SC_(-8.4604646224109365244823815804685302214659e+00), SC_(8.4604646224109365244823815804685302214659e+00), SC_(1.9761993576544134564835929494402375462989e-33) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(6.9166609472247469917357885960635247858819e-32), SC_(-8.3445175041575761354715295025805414169377e+00), SC_(8.3445175041575761354715295025805414169377e+00), SC_(6.9166620890884732561187530590698801239873e-32) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(1.2143244008561925655808144445819183624027e-31), SC_(-8.3254371022231133031788765543824537827812e+00), SC_(8.3254371022231133031788765543824537827812e+00), SC_(1.2143246279691032202725996339961765031120e-31) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(1.5006950800192111640309490471640623626620e-31), SC_(-8.3182063021352674973353614290035171848394e+00), SC_(8.3182063021352674973353614290035171848394e+00), SC_(1.5006953741810513696010048960806751470948e-31) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(1.6389195832773134047884289306680529421843e-31), SC_(-8.3151888979053563469854733524666893385088e+00), SC_(8.3151888979053563469854733524666893385088e+00), SC_(1.6389199108705481931671830053604362752416e-31) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(9.5096091399561686042229404175751626522686e-31), SC_(-8.2539104114521052066577504059751867332835e+00), SC_(8.2539104114521052066577504059751867332835e+00), SC_(9.5096119469823547741934858681020192006904e-31) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(1.2269854138761437695087156034714816775203e-30), SC_(-8.2448581612034721395993414368627623106612e+00), SC_(8.2448581612034721395993414368627623106612e+00), SC_(1.2269857971108787365185400090556063478471e-30) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-2.6021757086306117598549792277844469212377e-282), SC_(-9.7794073627636670087505128789578313949199e-03), SC_(9.7794073627636670087505128789578313949199e-03), SC_(2.6021757086306117598549792277844469212377e-282) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-1.0059371743457995453338481687497339151516e-216), SC_(-5.5991947116989226750249122279060083224555e-02), SC_(5.5991947116989226750249122279060083224555e-02), SC_(1.0059371743457995453338481687497339151516e-216) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-4.1262206477691695573389945729956871228971e-203), SC_(-8.0034525100230130149036532234650647113379e-02), SC_(8.0034525100230130149036532234650647113379e-02), SC_(4.1262206477691695573389945729956871228971e-203) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-6.0832791123274026422660992581718361956424e-146), SC_(-3.4868620202313117021547746496645749810273e-01), SC_(3.4868620202313117021547746496645749810273e-01), SC_(6.0832791123274026422660992581718361956424e-146) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-2.5269423976909499081650280722050198931476e-124), SC_(-5.9784638448453563552103476865613728264791e-01), SC_(5.9784638448453563552103476865613728264791e-01), SC_(2.5269423976909499081650280722050198931476e-124) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.3457467515415084849573946922422232461470e-98), SC_(-1.1129413417696964805134442845927035310750e+00), SC_(1.1129413417696964805134442845927035310750e+00), SC_(1.3457467515415084849573946922422232461470e-98) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-4.4927577052831366390230155605393544446133e-89), SC_(-1.3900042901764530116721429963079329422942e+00), SC_(1.3900042901764530116721429963079329422942e+00), SC_(4.4927577052831366390230155605393544446133e-89) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-4.3633127593902357316059113899455401270855e-50), SC_(-3.1923451818754431758460698836058215362536e+00), SC_(3.1923451818754431758460698836058215362536e+00), SC_(4.3633127593902357316059122369885516259047e-50) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-4.6878969407592671365094581293251533477283e-50), SC_(-3.1942125370023676254494873398223319458727e+00), SC_(3.1942125370023676254494873398223319458727e+00), SC_(4.6878969407592671365094590724542150493011e-50) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-2.7122718943179592097482750418612361965036e-43), SC_(-3.6084468478385766509934635930300209622555e+00), SC_(3.6084468478385766509934635930300209622555e+00), SC_(2.7122718943179592097495412256063998702188e-43) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-1.4202546064066779145763219993451840018895e-33), SC_(-4.2039775298758185192397892131677217211784e+00), SC_(4.2039775298758185192397892131677217211784e+00), SC_(1.4202546064066779606567217884068179796590e-33) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-9.3405177662756445267805503906043796056484e-33), SC_(-4.2515123900979719632460750665254360359005e+00), SC_(4.2515123900979719632460750665254360359005e+00), SC_(9.3405177662756453019547477006288398495201e-33) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-3.4424176498782496688115029676435581607486e-30), SC_(-4.3950312457778445600908806802885707920067e+00), SC_(4.3950312457778445600908806802885707920067e+00), SC_(3.4424176498782551146409723861346453323448e-30) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-6.1400670843773272018846009165892140499919e-30), SC_(-4.4085359157680499908117327776151880273363e+00), SC_(4.4085359157680499908117327776151880273363e+00), SC_(6.1400670843773401667256639416373928865559e-30) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-1.4834705100141561219912346664808026176558e-28), SC_(-4.4807354417075548821247547889223789156049e+00), SC_(4.4807354417075548821247547889223789156049e+00), SC_(1.4834705100141714726856864238612408467916e-28) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-2.4560157969672088870460275062300344511276e-28), SC_(-4.4918070122390737533405895786120711804667e+00), SC_(4.4918070122390737533405895786120711804667e+00), SC_(2.4560157969672415739298338130499167001034e-28) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-2.9689351138850522397079687340237615411310e-28), SC_(-4.4959448931184453720119486941198509206321e+00), SC_(4.4959448931184453720119486941198509206321e+00), SC_(2.9689351138850956767970254343942237855872e-28) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-3.2127433066278919590869646000895985168525e-28), SC_(-4.4976622834715182147762445415605359517456e+00), SC_(4.4976622834715182147762445415605359517456e+00), SC_(3.2127433066279408520132042309130678272885e-28) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-1.5518645759442135865799548659902914643729e-27), SC_(-4.5313676426939707363904103444214808851528e+00), SC_(4.5313676426939707363904103444214808851528e+00), SC_(1.5518645759442654300989408605213494798416e-27) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-1.9497919042745756516397393706620948086052e-27), SC_(-4.5361602689364914292392062299168619648290e+00), SC_(4.5361602689364914292392062299168619648290e+00), SC_(1.9497919042746486522470729740508918517125e-27) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-9.3607345628832630732153847118920330750627e-256), SC_(-2.0158731835153730285394252756139301955905e-06), SC_(2.0158731835153730285394252756139301955905e-06), SC_(9.3607345628832630732153847118920330750627e-256) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-2.5153324791790336502498324486859839072643e-196), SC_(-8.2598423476909117655349780372930457668051e-05), SC_(8.2598423476909117655349780372930457668051e-05), SC_(2.5153324791790336502498324486859839072643e-196) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-5.4357419233225854067924324254429896469660e-184), SC_(-1.7764310501750845723263754624635432661580e-04), SC_(1.7764310501750845723263754624635432661580e-04), SC_(5.4357419233225854067924324254429896469660e-184) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-3.4220501823288920472333798493570905032869e-132), SC_(-4.3050296279681943709761856060017884789489e-03), SC_(4.3050296279681943709761856060017884789489e-03), SC_(3.4220501823288920472333798493570905032869e-132) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.3228614139878042091095143997184223348497e-112), SC_(-1.4127213247956847579313557224225649359618e-02), SC_(1.4127213247956847579313557224225649359618e-02), SC_(1.3228614139878042091095143997184223348497e-112) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-2.6905962580604782922225224869976756583646e-89), SC_(-5.6957557448132341028629313029666048262336e-02), SC_(5.6957557448132341028629313029666048262336e-02), SC_(2.6905962580604782922225224869976756583646e-89) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-1.1427617501667056990141268005952706196131e-80), SC_(-9.4706241671482476777742600383642940754444e-02), SC_(9.4706241671482476777742600383642940754444e-02), SC_(1.1427617501667056990141268005952706196131e-80) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-2.3783366517414482809364070156602737733548e-45), SC_(-7.0260457981089215676315856360139073533280e-01), SC_(7.0260457981089215676315856360139073533280e-01), SC_(2.3783366517414482809364070156602737808823e-45) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-2.5380443559552176985705916219824544362263e-45), SC_(-7.0367548634482648616585826186018823201132e-01), SC_(7.0367548634482648616585826186018823201132e-01), SC_(2.5380443559552176985705916219824544446804e-45) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-3.3849252538648807119497755569739871926381e-39), SC_(-9.7450489515955478417483754818492789572317e-01), SC_(9.7450489515955478417483754818492789572317e-01), SC_(3.3849252538648807119497755569747271527330e-39) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-2.1463583873424627447226918154111571019812e-30), SC_(-1.5218886680708008464171967815353481555765e+00), SC_(1.5218886680708008464171967815353481555765e+00), SC_(2.1463583873424627447226958114085802222853e-30) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-1.1816015130127667969685537689448331086979e-29), SC_(-1.5775602227010017677710339417125323261828e+00), SC_(1.5775602227010017677710339417125323261828e+00), SC_(1.1816015130127667969685622058703872984005e-29) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-2.4920108100991958595769172351677050045327e-27), SC_(-1.7621805237599455396557071377405790748376e+00), SC_(1.7621805237599455396557071377405790748376e+00), SC_(2.4920108100991958595781265922034589733570e-27) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-4.2083796610773790620950927152123423785552e-27), SC_(-1.7810595968901577156616665581776308089461e+00), SC_(1.7810595968901577156616665581776308089461e+00), SC_(4.2083796610773790620981801197443743989187e-27) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-7.5251271516724746402373608304719044437042e-26), SC_(-1.8874475645460031244656718754413132109206e+00), SC_(1.8874475645460031244656718754413132109206e+00), SC_(7.5251271516724746402910571214054945849959e-26) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-1.1878737415371270832480623446871201182626e-25), SC_(-1.9046674730864391547128058891229860519946e+00), SC_(1.9046674730864391547128058891229860519946e+00), SC_(1.1878737415371270832602138629997028209552e-25) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-1.4104373005413640822096538564675358780757e-25), SC_(-1.9111717803323480365530832699113040308902e+00), SC_(1.9111717803323480365530832699113040308902e+00), SC_(1.4104373005413640822261759518122659663630e-25) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-1.5149180940874006034626046197890578864021e-25), SC_(-1.9138825292332503695891514447109108603393e+00), SC_(1.9138825292332503695891514447109108603393e+00), SC_(1.5149180940874006034813800447882145057256e-25) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-6.3053031849488862081600123362419533575260e-25), SC_(-1.9684862516429755593025761529421056825438e+00), SC_(1.9684862516429755593025761529421056825438e+00), SC_(6.3053031849488862084008079056202421756105e-25) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-7.7529600626582306739560328149923181445545e-25), SC_(-1.9764798417570122653878653204542018929044e+00), SC_(1.9764798417570122653878653204542018929044e+00), SC_(7.7529600626582306743045748697073123676347e-25) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-9.7164210283629195800824979203474180594063e-120), SC_(-7.4983787014513194761861132864213674443123e-59), SC_(7.4983787014513194761861132864213674443123e-59), SC_(9.7164210283629195800824979203474180594063e-120) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-7.5264388044969703361545955640312072039076e-92), SC_(-4.4169545270054574975297229652300119172543e-45), SC_(4.4169545270054574975297229652300119172543e-45), SC_(7.5264388044969703361545955640312072039076e-92) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-4.6118564190005330897869595414049876066367e-86), SC_(-3.1731082204028170333974372338431115476210e-42), SC_(3.1731082204028170333974372338431115476210e-42), SC_(4.6118564190005330897869595414049876066367e-86) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-9.1355772835260834509508014349845863060127e-62), SC_(-3.0692917252098387956987850147064388275114e-30), SC_(3.0692917252098387956987850147064388275114e-30), SC_(9.1355772835260834509508014349845863060127e-62) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.3940343114621711735776838595076775971402e-52), SC_(-1.0312834710564025583027197020409685211717e-25), SC_(1.0312834710564025583027197020409685211717e-25), SC_(1.3940343114621711735776838595076775971402e-52) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.1688453367791440551585417035338009808077e-41), SC_(-2.4705890112013090284457721449881003363750e-20), SC_(2.4705890112013090284457721449881003363750e-20), SC_(1.1688453367791440551585417035338009808077e-41) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-1.2868434790457589692937453345866153980527e-37), SC_(-2.4071388526181527669217713089288822929713e-18), SC_(2.4071388526181527669217713089288822929713e-18), SC_(1.2868434790457589692937453345866153980527e-37) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-4.3229672693285451525228170345210392414228e-21), SC_(-3.1298045862531463841760210350208806817327e-10), SC_(3.1298045862531463841760210350208806817327e-10), SC_(4.3229672693285451525228170345210392414228e-21) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-4.4562636704628792376427675399717672910289e-21), SC_(-3.1766903691648257983586766658331441568267e-10), SC_(3.1766903691648257983586766658331441568267e-10), SC_(4.4562636704628792376427675399717672910289e-21) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-3.2346479009870589183542164615927611488452e-18), SC_(-7.9729535605424845117793606160971305559806e-09), SC_(7.9729535605424845117793606160971305559806e-09), SC_(3.2346479009870589183542164615927611488452e-18) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-4.1289774003468222582206751636505683191789e-14), SC_(-8.0429475385443523634332887337055106662076e-07), SC_(8.0429475385443523634332887337055106662076e-07), SC_(4.1289774003468222582206751636505683191789e-14) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-9.1415316376053811610605188263096620214376e-14), SC_(-1.1844189228614855564113286595587525323799e-06), SC_(1.1844189228614855564113286595587525323799e-06), SC_(9.1415316376053811610605188263096620214376e-14) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-1.1053165884517830915322313837387669341952e-12), SC_(-3.9826078874388788858765571992310369570428e-06), SC_(3.9826078874388788858765571992310369570428e-06), SC_(1.1053165884517830915322313837387669341952e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.4107015523754051251054951704257776602280e-12), SC_(-4.4840921950766279638397095126750242298647e-06), SC_(4.4840921950766279638397095126750242298647e-06), SC_(1.4107015523754051251054951704257776602280e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-5.3997132641489025134493571011278753871708e-12), SC_(-8.6084654187005212937644149952768399062271e-06), SC_(8.6084654187005212937644149952768399062271e-06), SC_(5.3997132641489025134493571011278753871708e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-6.6776858370740065972688211987246861258105e-12), SC_(-9.5439851348719081181949639996489675645440e-06), SC_(9.5439851348719081181949639996489675645440e-06), SC_(6.6776858370740065972688211987246861258105e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-7.2331983629686132953611804298357805515809e-12), SC_(-9.9216138030813975284752528193020956163251e-06), SC_(9.9216138030813975284752528193020956163251e-06), SC_(7.2331983629686132953611804298357805515809e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-7.4777532355178131015019303751419725847885e-12), SC_(-1.0083110264285387907086452682007356166670e-05), SC_(1.0083110264285387907086452682007356166670e-05), SC_(7.4777532355178131015019303751419725847885e-12) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-1.4517872461971860989892983069714149139070e-11), SC_(-1.3914636683168701149535316033963709329246e-05), SC_(1.3914636683168701149535316033963709329246e-05), SC_(1.4517872461971860989892983069714149139070e-11) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-1.5982986860759319188804833202924545073154e-11), SC_(-1.4579302461389581292709092414796317984275e-05), SC_(1.4579302461389581292709092414796317984275e-05), SC_(1.5982986860759319188804833202924545073154e-11) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-3.9369544755518106559445184530760007153326e-61), SC_(-1.5024613769372449030232839852511122968697e-116), SC_(1.5024613769372449030232839852511122968697e-116), SC_(3.9369544755518106559445184530760007153326e-61) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-7.8337632531911085072746202198381613597833e-47), SC_(-2.1199926917553863934147373143961749402977e-89), SC_(2.1199926917553863934147373143961749402977e-89), SC_(7.8337632531911085072746202198381613597833e-47) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-7.2456089195257820549321320818261944676187e-44), SC_(-9.1221713469225329524114216764644982550302e-84), SC_(9.1221713469225329524114216764644982550302e-84), SC_(7.2456089195257820549321320818261944676187e-44) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-2.0258159634802329767645874781881771453623e-31), SC_(-4.0934529607355802821644501103159011176841e-60), SC_(4.0934529607355802821644501103159011176841e-60), SC_(2.0258159634802329767645874781881771453623e-31) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.0169957928190736994472243750258053597484e-26), SC_(-3.5619052370623168534016931306630218020519e-51), SC_(3.5619052370623168534016931306630218020519e-51), SC_(1.0169957928190736994472243750258053597484e-26) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-3.9294130487966738547894871552723674435863e-21), SC_(-1.5302660781601027074980221368851632164972e-40), SC_(1.5302660781601027074980221368851632164972e-40), SC_(3.9294130487966738547894871552723674435863e-21) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-4.5698429160254703730358287288758865022394e-19), SC_(-1.3152112880463896451951868031682607901695e-36), SC_(1.3152112880463896451951868031682607901695e-36), SC_(4.5698429160254703730358287288758865022394e-19) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.2271468920266867422493646443989121264444e-10), SC_(-1.6018320630007401094266383030813815419742e-20), SC_(1.6018320630007401094266383030813815419742e-20), SC_(1.2271468920266867422493646443989121264444e-10) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.2462531073890081478652170686257957160589e-10), SC_(-1.6498836904443466049695406990605101417729e-20), SC_(1.6498836904443466049695406990605101417729e-20), SC_(1.2462531073890081478652170686257957160589e-10) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-3.5478291834995438504791478328561122976487e-09), SC_(-1.0040859901162693593795938612377161173382e-17), SC_(1.0040859901162693593795938612377161173382e-17), SC_(3.5478291834995438504791478328561122976487e-09) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-4.2901455915120381139812871653189896421403e-07), SC_(-9.9465331856967794651703524886691477775004e-14), SC_(9.9465331856967794651703524886691477775004e-14), SC_(4.2901455915120381139812871653189896421403e-07) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-6.4149425327868629109474025411474351750926e-07), SC_(-2.1556208668734525692768937732165166158411e-13), SC_(2.1556208668734525692768937732165166158411e-13), SC_(6.4149425327868629109474025411474351750926e-07) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-2.2629032582900103025996597523137177465153e-06), SC_(-2.4374005240438908591082027371386048377086e-12), SC_(2.4374005240438908591082027371386048377086e-12), SC_(2.2629032582900103025996597523137177465153e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-2.5598317514350339241046840366348927457539e-06), SC_(-3.0904640901784868770398534843749201636381e-12), SC_(3.0904640901784868770398534843749201636381e-12), SC_(2.5598317514350339241046840366348927457539e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-5.0429387989961656436646854993930413774264e-06), SC_(-1.1409371771672326275111441015036905175109e-11), SC_(1.1409371771672326275111441015036905175109e-11), SC_(5.0429387989961656436646854993930413774264e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-5.6138968521922915997819731319885692032962e-06), SC_(-1.4029154874891244675988550184864002599364e-11), SC_(1.4029154874891244675988550184864002599364e-11), SC_(5.6138968521922915997819731319885692032962e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-5.8450121479896082546955243168809134347761e-06), SC_(-1.5163547627040793593676824516352281932615e-11), SC_(1.5163547627040793593676824516352281932615e-11), SC_(5.8450121479896082546955243168809134347761e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-5.9439584308730480657339045397316854942778e-06), SC_(-1.5662189149547481840723101450334673054023e-11), SC_(1.5662189149547481840723101450334673054023e-11), SC_(5.9439584308730480657339045397316854942778e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-8.3081476448882081643255565918776884129230e-06), SC_(-2.9868864519272286768380743159075461601692e-11), SC_(2.9868864519272286768380743159075461601692e-11), SC_(8.3081476448882081643255565918776884129230e-06) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-8.7211495374462413542617148685857493308416e-06), SC_(-3.2798049987738521888667879517949463315155e-11), SC_(3.2798049987738521888667879517949463315155e-11), SC_(8.7211495374462413542617148685857493308416e-06) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-5.8494336959278044988394095706674787975674e-05), SC_(-4.6055437626879395773256289819433261721987e-265), SC_(4.6055437626879395773256289819433261721987e-265), SC_(5.8494336959278044988394095706674787975674e-05) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-1.0976268053708212914650311649381955923231e-03), SC_(-1.7822335452815350797049432282680108850033e-203), SC_(1.7822335452815350797049432282680108850033e-203), SC_(1.0976268053708212914650311649381955923231e-03) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-2.0073544253589500404159602509388426086883e-03), SC_(-1.0806530386445497877873326691183792214675e-190), SC_(1.0806530386445497877873326691183792214675e-190), SC_(2.0073544253589500404159602509388426086883e-03) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-2.4621085832174173223994144434343177414204e-02), SC_(-5.1853281055101693504991272581285871074779e-137), SC_(5.1853281055101693504991272581285871074779e-137), SC_(2.4621085832174173223994144434343177414204e-02) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-6.2446979700738005739164705643221518359129e-02), SC_(-1.0326721545328129062465692301437461259191e-116), SC_(1.0326721545328129062465692301437461259191e-116), SC_(6.2446979700738005739164705643221518359129e-02) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.8527881424275369210751688096674170210736e-01), SC_(-1.4785366883604945420568720708619891561542e-92), SC_(1.4785366883604945420568720708619891561542e-92), SC_(1.8527881424275369210751688096674170210736e-01) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-2.7500070182825139309244488895212118741222e-01), SC_(-1.2935918465947925577578597155696221709205e-83), SC_(1.2935918465947925577578597155696221709205e-83), SC_(2.7500070182825139309244488895212118741222e-01) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.2811078194861053423365376845003410143274e+00), SC_(-5.2013556726604872031659754483456571786804e-47), SC_(5.2013556726604872031659754483457716131682e-47), SC_(1.2811078194861053423365376845003410143274e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.2825828478740302973793081855670872967570e+00), SC_(-5.5637993346500438279428730288074839103849e-47), SC_(5.5637993346500438279428730288076120315739e-47), SC_(1.2825828478740302973793081855670872967570e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-1.6383078518872602989442802028745517183363e+00), SC_(-1.2410826013571970827231621521475534261802e-40), SC_(1.2410826013571970827231621527179536280028e-40), SC_(1.6383078518872602989442802028745517183363e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-2.2776890775132021544820908457366304210100e+00), SC_(-1.6493991263751257364047557462018576174585e-31), SC_(1.6493991263751257364059204749389692998532e-31), SC_(2.2776890775132021544820908457366304210100e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-2.3379945776889911071590261109415384936838e+00), SC_(-9.6642070120566698061916213004665779378151e-31), SC_(9.6642070120566698062142783907875848040169e-31), SC_(2.3379945776889911071590261109415384936838e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-2.5325398022587643030133123168676934169390e+00), SC_(-2.4786350254104575681857554948156169524587e-28), SC_(2.4786350254104575684368884113734661231138e-28), SC_(2.5325398022587643030133123168676934169390e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-2.5519756763974216184170986078353870960351e+00), SC_(-4.2667793738640490369034499776911657704886e-28), SC_(4.2667793738640490375286290346297096431915e-28), SC_(2.5519756763974216184170986078353870960351e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-2.6599525992446178590756635887999859874782e+00), SC_(-8.4783758364224524192943641198908976876456e-27), SC_(8.4783758364224524287598621733814115085084e-27), SC_(2.6599525992446178590756635887999859874782e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-2.6771843875082966964693883394338479885036e+00), SC_(-1.3608902621691167754887248100705069938792e-26), SC_(1.3608902621691167775842648254792907337786e-26), SC_(2.6771843875082966964693883394338479885036e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-2.6836755066081749465109071200173024278369e+00), SC_(-1.6260566276776162314914823159645116490325e-26), SC_(1.6260566276776162343172977941603357836400e-26), SC_(2.6836755066081749465109071200173024278369e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-2.6863779006629385438066719057199113475031e+00), SC_(-1.7510826986806160132623118543073062400508e-26), SC_(1.7510826986806160164625030669841548107750e-26), SC_(2.6863779006629385438066719057199113475031e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-2.7404558848731331416896657152589332643869e+00), SC_(-7.6786971486163099519080988093607387678187e-26), SC_(7.6786971486163099902300651744652946260884e-26), SC_(2.7404558848731331416896657152589332643869e+00) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-2.7483154510808494875591999333736625860286e+00), SC_(-9.5133693786194709323733397371700872108393e-26), SC_(9.5133693786194709872941270890892693912464e-26), SC_(2.7483154510808494875591999333736625860286e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-2.0910989959234630411850768636608104004209e+01), SC_(5.1649890439000093667458793528048112120415e-333), SC_(5.1649890439000093667458793528048801217151e-333), SC_(2.0910989959234630411850768636608104004209e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-2.0229915446423363161449360835880566190621e+01), SC_(1.1413823241895772054938862383588076661904e-255), SC_(1.1413823241895772054938866786624151795107e-255), SC_(2.0229915446423363161449360835880566190621e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-1.9991598266453797476723764816902105373830e+01), SC_(1.2913825831013363340956256885843578901568e-239), SC_(1.2913825831013363340956433170812593005238e-239), SC_(1.9991598266453797476723764816902105373830e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-1.8478805254981924051266239592271147786142e+01), SC_(3.4003529124406607007091060280064085440324e-172), SC_(3.4003529124406608494951629348303102452919e-172), SC_(1.8478805254981924051266239592271147786142e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.7624503785242225723428784156045117630893e+01), SC_(1.0669100336777835288091220077543039692030e-146), SC_(1.0669100336777970262021605625512552972018e-146), SC_(1.7624503785242225723428784156045117630893e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.6322373672042287724106942632295847076089e+01), SC_(2.3504548330122026241252051091984145009669e-116), SC_(2.3504548330374966863402743325782352879115e-116), SC_(1.6322373672042287724106942632295847076089e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-1.5741300673767465488082991930691015901729e+01), SC_(4.0210033162127899411798972946619550463255e-105), SC_(4.0210033167389762317272255953722054080642e-105), SC_(1.5741300673767465488082991930691015901729e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.2532894522810517594102854000625209274047e+01), SC_(3.9508084628795997802131349539240894471013e-59), SC_(3.9508228813144676823313482254435932711772e-59), SC_(1.2532894522810517594102854000625209274047e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.2529599891776835408714387845361449681020e+01), SC_(4.2998464688956767271678745652821869922709e-59), SC_(4.2998622901976968525954267128275393674812e-59), SC_(1.2529599891776835408714387845361449681020e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-1.1775435816887856225441581359809178359920e+01), SC_(4.0981317988405697117629704353373480875410e-51), SC_(4.0982210374227769414066226694839457838791e-51), SC_(1.1775435816887856225441581359809178359920e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-1.0527913326578438179887541165009961571747e+01), SC_(1.2081612297634261125103036390361530081548e-39), SC_(1.2085009022207944118275019415252006610454e-39), SC_(1.0527913326578438179887541165009961571747e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-1.0412143430785756018889364436930887873359e+01), SC_(1.1157797849581505394923752965848637644160e-38), SC_(1.1161689281436758807171367675642776654767e-38), SC_(1.0412143430785756018889364436930887873359e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-1.0035996450687491743991938289799856609221e+01), SC_(1.1935175403954522458278923800624138395029e-35), SC_(1.1943362821142320239184108903270379980502e-35), SC_(1.0035996450687491743991938289799856609221e+01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-9.9980521531318887469130958539583529744871e+00), SC_(2.3629945362725923099590576877991904561943e-35), SC_(2.3647265865219386934201091365456271555435e-35), SC_(9.9980521531318887469130958539583529744871e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-9.7854309289713613409282915528683788612630e+00), SC_(1.0140326208911496646811636929604284552383e-33), SC_(1.0151031220609244977980060486302961187851e-33), SC_(9.7854309289713613409282915528683788612630e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-9.7511656331855239641457959413655393274576e+00), SC_(1.8386717667072487779740346482735401028263e-33), SC_(1.8407282659414304646299140318262424500781e-33), SC_(9.7511656331855239641457959413655393274576e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-9.7382309594899592364666295203052710940725e+00), SC_(2.3000327320660759174901777030273571975503e-33), SC_(2.3026617735961728638821560124263965345780e-33), SC_(9.7382309594899592364666295203052710940725e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-9.7328414832945401656540477981502920458097e+00), SC_(2.5246024450567800626859689966695759052360e-33), SC_(2.5275143975342440954120230492041715658766e-33), SC_(9.7328414832945401656540477981502920458097e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-9.6244021165978106730056107014393004867292e+00), SC_(1.6202271386463886174230891797777074605881e-32), SC_(1.6224656608283760981258410222910686221223e-32), SC_(9.6244021165978106730056107014393004867292e+00) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-9.6085424541354885690114475020305372539125e+00), SC_(2.1212782874194525299375965096088644571516e-32), SC_(2.1242867698355609746022255535564523987285e-32), SC_(9.6085424541354885690114475020305372539125e+00) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.7540393471717834472656250000000000000000e-04), SC_(7.3238310791477491181239944843479048776381e-202), SC_(3.7123192846757903928336387265340649053411e-19), SC_(3.7123192846757903928336387265340649053411e-19), SC_(7.3238310791477491181239944843479048776381e-202) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.2698681093752384185791015625000000000000e-03), SC_(6.2648669020625281187985045329837216256362e-155), SC_(1.3651338062906082577574598141893972985350e-14), SC_(1.3651338062906082577574598141893972985350e-14), SC_(6.2648669020625281187985045329837216256362e-155) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.3547698035836219787597656250000000000000e-03), SC_(3.4460452065046344351273189140648447772688e-145), SC_(1.2043827356132338085577316039959707426636e-13), SC_(1.2043827356132338085577316039959707426636e-13), SC_(3.4460452065046344351273189140648447772688e-145) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000e-03), SC_(2.7492812388099401520223643033280829552883e-104), SC_(1.0968410323609394734239862244450401677968e-09), SC_(1.0968410323609394734239862244450401677968e-09), SC_(2.7492812388099401520223643033280829552883e-104) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(2.2103404626250267028808593750000000000000e-03), SC_(8.0207215098122251363351409025692180964705e-89), SC_(3.3907254811203045734635327654527110380159e-08), SC_(3.3907254811203045734635327654527110380159e-08), SC_(8.0207215098122251363351409025692180964705e-89) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(2.7849823236465454101562500000000000000000e-03), SC_(2.0198669945757426666268034551156135205221e-70), SC_(1.9739973993202588098213710602915240238757e-06), SC_(1.9739973993202588098213710602915240238757e-06), SC_(2.0198669945757426666268034551156135205221e-70) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(3.0816700309514999389648437500000000000000e-03), SC_(1.3067548207377777439852590425790123304429e-63), SC_(8.8222615402170340990764797653771915885880e-06), SC_(8.8222615402170340990764797653771915885880e-06), SC_(1.3067548207377777439852590425790123304429e-63) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(5.4688137024641036987304687500000000000000e-03), SC_(9.7402573368921593956915967314574288135233e-36), SC_(3.7614968924212621954781126570459999630250e-03), SC_(3.7614968924212621954781126570459999630250e-03), SC_(9.7402573368921593956915967314574288135233e-36) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(5.4722055792808532714843750000000000000000e-03), SC_(1.0252700012623552010114565570438427313640e-35), SC_(3.7794623246391952662962691693552452821433e-03), SC_(3.7794623246391952662962691693552452821433e-03), SC_(1.0252700012623552010114565570438427313640e-35) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(6.3235927373170852661132812500000000000000e-03), SC_(6.9586196293371156451496581241790605505700e-31), SC_(1.0579350311956922377148290024084055339132e-02), SC_(1.0579350311956922377148290024084055339132e-02), SC_(6.9586196293371156451496581241790605505700e-31) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(8.1472359597682952880859375000000000000000e-03), SC_(6.0804387650702682811402916637021975951427e-24), SC_(4.5472010324648003975295109130329853514865e-02), SC_(4.5472010324648003975295109130329853514865e-02), SC_(6.0804387650702682811402916637021975951440e-24) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(8.3500854671001434326171875000000000000000e-03), SC_(2.3332375030943869473254924129197413378673e-23), SC_(5.1331674098749817053418749122219843362709e-02), SC_(5.1331674098749817053418749122219843362709e-02), SC_(2.3332375030943869473254924129197413378719e-23) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.0579167008399963378906250000000000000000e-03), SC_(1.5851731138307916024987742727368600828434e-21), SC_(7.4937374873142012893508363879421912505181e-02), SC_(7.4937374873142012893508363879421912505181e-02), SC_(1.5851731138307916024987742727368600862816e-21) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.1337561607360839843750000000000000000000e-03), SC_(2.3958179244494374086496426670343293632867e-21), SC_(7.7752282634744415771232246846122744024983e-02), SC_(7.7752282634744415771232246846122744024983e-02), SC_(2.3958179244494374086496426670343293736220e-21) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.5750652253627777099609375000000000000000e-03), SC_(2.3259083119186850184338950402218282880499e-20), SC_(9.5189617940647481341903810495970514169078e-02), SC_(9.5189617940647481341903810495970514169078e-02), SC_(2.3259083119186850184338950402218287299203e-20) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.6488818526268005371093750000000000000000e-03), SC_(3.3331004509641313792721367634507783790119e-20), SC_(9.8278483574667329815154278076396542413714e-02), SC_(9.8278483574667329815154278076396542413714e-02), SC_(3.3331004509641313792721367634507795320163e-20) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.6769481897354125976562500000000000000000e-03), SC_(3.8161961055868720233060235669326639209366e-20), SC_(9.9465570012406649463615731832331438860234e-02), SC_(9.9465570012406649463615731832331438860234e-02), SC_(3.8161961055868720233060235669326655749321e-20) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.6886754035949707031250000000000000000000e-03), SC_(4.0372979472356214164566010038290315120200e-20), SC_(9.9963634331827556694962720779053127247103e-02), SC_(9.9963634331827556694962720779053127247103e-02), SC_(4.0372979472356214164566010038290334339681e-20) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.9288113415241241455078125000000000000000e-03), SC_(1.2421752027843772626679694575319666549598e-19), SC_(1.1042491468243943568021805673266767179271e-01), SC_(1.1042491468243943568021805673266767179271e-01), SC_(1.2421752027843772626679694575319705012406e-19) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.9646113812923431396484375000000000000000e-03), SC_(1.4619175005710964074080554394211399099921e-19), SC_(1.1202676648334374885280137136400866364600e-01), SC_(1.1202676648334374885280137136400866364600e-01), SC_(1.4619175005710964074080554394211458482451e-19) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.7540393471717834472656250000000000000000e-04), SC_(6.0692814643925295690117065666866354616978e-201), SC_(1.9064008534478708028659867576903487021136e-19), SC_(1.9064008534478708028659867576903487021136e-19), SC_(6.0692814643925295690117065666866354616978e-201) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.2698681093752384185791015625000000000000e-03), SC_(3.1794154560583687055856319919960884568884e-154), SC_(8.1819917695969850760036522509753778753966e-15), SC_(8.1819917695969850760036522509753778753966e-15), SC_(3.1794154560583687055856319919960884568884e-154) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.3547698035836219787597656250000000000000e-03), SC_(1.5796019627047681062473185161136226146002e-144), SC_(7.4538493241316865156273810953526918933635e-14), SC_(7.4538493241316865156273810953526918933635e-14), SC_(1.5796019627047681062473185161136226146002e-144) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000e-03), SC_(8.2176505639250501828071243600106940012222e-104), SC_(7.7675148160955110218188767137498767298107e-10), SC_(7.7675148160955110218188767137498767298107e-10), SC_(8.2176505639250501828071243600106940012222e-104) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(2.2103404626250267028808593750000000000000e-03), SC_(2.0393645898297263768727626405356342071877e-88), SC_(2.5267903830500762400322322241314293625096e-08), SC_(2.5267903830500762400322322241314293625096e-08), SC_(2.0393645898297263768727626405356342071877e-88) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(2.7849823236465454101562500000000000000000e-03), SC_(4.2362355034855019549113619121930716526139e-70), SC_(1.5630651796545927100477259516257333865906e-06), SC_(1.5630651796545927100477259516257333865906e-06), SC_(4.2362355034855019549113619121930716526139e-70) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(3.0816700309514999389648437500000000000000e-03), SC_(2.5520188797295515095210405318266699616909e-63), SC_(7.1444661964406484210530688990967913360122e-06), SC_(7.1444661964406484210530688990967913360122e-06), SC_(2.5520188797295515095210405318266699616909e-63) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(5.4688137024641036987304687500000000000000e-03), SC_(1.4202793496445721914430673067290552161829e-35), SC_(3.3399387356111582094394952325564359719234e-03), SC_(3.3399387356111582094394952325564359719234e-03), SC_(1.4202793496445721914430673067290552161829e-35) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(5.4722055792808532714843750000000000000000e-03), SC_(1.4946519068195306406394922536350420358550e-35), SC_(3.3561380073772493501200853196904905278304e-03), SC_(3.3561380073772493501200853196904905278304e-03), SC_(1.4946519068195306406394922536350420358550e-35) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(6.3235927373170852661132812500000000000000e-03), SC_(9.6423890288666440143798447190312889024808e-31), SC_(9.5458525153659480402670829124238033187673e-03), SC_(9.5458525153659480402670829124238033187673e-03), SC_(9.6423890288666440143798447190312889024808e-31) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(8.1472359597682952880859375000000000000000e-03), SC_(7.8322680362739217044020716379014161608090e-24), SC_(4.1984875085729684382458039984433632843940e-02), SC_(4.1984875085729684382458039984433632843940e-02), SC_(7.8322680362739217044020716379014161608099e-24) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(8.3500854671001434326171875000000000000000e-03), SC_(2.9870361604268213042902137455794081018554e-23), SC_(4.7487130387108099734507995301318092952715e-02), SC_(4.7487130387108099734507995301318092952715e-02), SC_(2.9870361604268213042902137455794081018584e-23) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.0579167008399963378906250000000000000000e-03), SC_(1.9905574212050610851642898722982304317584e-21), SC_(6.9747881020101484906294575529809269467536e-02), SC_(6.9747881020101484906294575529809269467536e-02), SC_(1.9905574212050610851642898722982304341303e-21) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.1337561607360839843750000000000000000000e-03), SC_(3.0028293473163387308983809147369355860503e-21), SC_(7.2410989201324397024028394516906758876918e-02), SC_(7.2410989201324397024028394516906758876918e-02), SC_(3.0028293473163387308983809147369355932023e-21) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.5750652253627777099609375000000000000000e-03), SC_(2.8850219998555167450037176235425767979834e-20), SC_(8.8941710701387287476084733202047853832038e-02), SC_(8.8941710701387287476084733202047853832038e-02), SC_(2.8850219998555167450037176235425771089904e-20) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.6488818526268005371093750000000000000000e-03), SC_(4.1275202001535401554431651844253415806709e-20), SC_(9.1875539652811867351728689469842962629671e-02), SC_(9.1875539652811867351728689469842962629671e-02), SC_(4.1275202001535401554431651844253423943874e-20) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.6769481897354125976562500000000000000000e-03), SC_(4.7228289869659531477772595203991613060555e-20), SC_(9.3003456922742819834371297400345080022615e-02), SC_(9.3003456922742819834371297400345080022615e-02), SC_(4.7228289869659531477772595203991624745197e-20) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.6886754035949707031250000000000000000000e-03), SC_(4.9951701722305876488602103323741261307800e-20), SC_(9.3476763001430204376245482159123665070860e-02), SC_(9.3476763001430204376245482159123665070860e-02), SC_(4.9951701722305876488602103323741274891104e-20) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.9288113415241241455078125000000000000000e-03), SC_(1.5289952584083580249894321327129326644704e-19), SC_(1.0342688241115083779669457203101137968057e-01), SC_(1.0342688241115083779669457203101137968057e-01), SC_(1.5289952584083580249894321327129354057317e-19) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.9646113812923431396484375000000000000000e-03), SC_(1.7981337871678406841642492453043897366803e-19), SC_(1.0495190269634074607073834037653829402006e-01), SC_(1.0495190269634074607073834037653829402006e-01), SC_(1.7981337871678406841642492453043939740522e-19) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(2.3122941919600886792668249687782875593639e-36), SC_(3.9812916097167231467626496469672188351153e-158), SC_(3.9812916097167231467626496469672188351153e-158), SC_(2.3122941919600886792668249687782875593639e-36) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(8.3043378913549558783327261855825175673694e-28), SC_(2.4581759695725395860704538164555741804867e-121), SC_(2.4581759695725395860704538164555741804867e-121), SC_(8.3043378913549558783327261855825175673694e-28) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(4.9330557913828619113126518326228874830219e-26), SC_(1.0610790113032433952325963425990996407485e-113), SC_(1.0610790113032433952325963425990996407485e-113), SC_(4.9330557913828619113126518326228874830219e-26) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(1.3534089925860414960872761958746843614471e-18), SC_(1.2147028817354921634965184502548621263422e-81), SC_(1.2147028817354921634965184502548621263422e-81), SC_(1.3534089925860414960872761958746843614471e-18) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(8.6618505751854067011228322278502408794112e-16), SC_(1.6003423354357394787081516501276202393955e-69), SC_(1.6003423354357394787081516501276202393955e-69), SC_(8.6618505751854067011228322278502408794112e-16) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(1.8591206240373062404351231906175937175363e-12), SC_(4.1979695685488647639132833584424834635570e-55), SC_(4.1979695685488647639132833584424834635570e-55), SC_(1.8591206240373062404351231906175937175363e-12) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(3.1600771091632093716325805824627626327794e-11), SC_(9.1032787069884175313568790067294385978387e-50), SC_(9.1032787069884175313568790067294385978387e-50), SC_(3.1600771091632093716325805824627626327794e-11) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(3.2107945970045853632326387592959033404933e-06), SC_(6.1529955805001741480990400756537162058948e-28), SC_(6.1529955805001741480990400756537162058948e-28), SC_(3.2107945970045853632326387592959033404933e-06) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(3.2402906005997394529674791599251187032631e-06), SC_(6.4050035094242889237399711811239245556878e-28), SC_(6.4050035094242889237399711811239245556878e-28), SC_(3.2402906005997394529674791599251187032631e-06) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(2.3470520927363113215746607541003824432805e-05), SC_(3.8781093957862794979225171162556810171291e-24), SC_(3.8781093957862794979225171162556810171291e-24), SC_(2.3470520927363113215746607541003824432805e-05) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(3.9614472780885540462985426813052361235849e-04), SC_(1.0471616980474839840593473747355829181362e-18), SC_(1.0471616980474839840593473747355829181362e-18), SC_(3.9614472780885540462985426813052361235849e-04) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(5.0180650358102531670656913320122830288902e-04), SC_(2.9980382018223608706347573031310681469267e-18), SC_(2.9980382018223608706347573031310681469267e-18), SC_(5.0180650358102531670656913320122830288902e-04) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(1.0517416379650347583615445393822316460396e-03), SC_(8.1230931927768766430582570524521038460890e-17), SC_(8.1230931927768766430582570524521038460890e-17), SC_(1.0517416379650347583615445393822316460396e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(1.1305970101088376249464991388033556063093e-03), SC_(1.1220013951751066356866447663395099018142e-16), SC_(1.1220013951751066356866447663395099018142e-16), SC_(1.1305970101088376249464991388033556063093e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(1.6821673036011417865016710333038951356452e-03), SC_(6.6354408871901199560830496840394663373192e-16), SC_(6.6354408871901199560830496840394663373192e-16), SC_(1.6821673036011417865016710333038951356452e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(1.7912114156459653463462933985057797054651e-03), SC_(8.7910649297744933910722095249899739202058e-16), SC_(8.7910649297744933910722095249899739202058e-16), SC_(1.7912114156459653463462933985057797054651e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(1.8340271226762282567673502906077916311400e-03), SC_(9.7723914074463439416765993010049761685257e-16), SC_(9.7723914074463439416765993010049761685257e-16), SC_(1.8340271226762282567673502906077916311400e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(1.8521415710776509601744233375005491081259e-03), SC_(1.0212335174261001309895740201648123466957e-15), SC_(1.0212335174261001309895740201648123466957e-15), SC_(1.8521415710776509601744233375005491081259e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(2.2531651559259363080354669298412020306923e-03), SC_(2.4588177795882791290373470666525460224849e-15), SC_(2.4588177795882791290373470666525460224849e-15), SC_(2.2531651559259363080354669298412020306923e-03) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(2.3180373695415124838779716112744157043625e-03), SC_(2.7927372964936536599938861422827776642204e-15), SC_(2.7927372964936536599938861422827776642204e-15), SC_(2.3180373695415124838779716112744157043625e-03) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(2.5476150428227392678715305000134335925798e-126), SC_(-2.2665036971062929857910288868782468762517e-54), SC_(2.2665036971062929857910288868782468762517e-54), SC_(2.5476150428227392678715305000134335925798e-126) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(6.6273936815595041723580460412384205376225e-97), SC_(-1.2206021225526338494688243646961895694975e-41), SC_(1.2206021225526338494688243646961895694975e-41), SC_(6.6273936815595041723580460412384205376225e-97) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(8.4223808184691039240652991216852615859555e-91), SC_(-5.3366008819742803647180852022429973446853e-39), SC_(5.3366008819742803647180852022429973446853e-39), SC_(8.4223808184691039240652991216852615859555e-91) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(3.5730058960436658723344035044736946009492e-65), SC_(-6.4105231321093486481718984007414544003942e-28), SC_(6.4105231321093486481718984007414544003942e-28), SC_(3.5730058960436658723344035044736946009492e-65) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(1.7376858729306831061605956755227887396677e-55), SC_(-9.7844091562993724293968445774053537076413e-24), SC_(9.7844091562993724293968445774053537076413e-24), SC_(1.7376858729306831061605956755227887396677e-55) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(5.7905083267633958779772477635279396276938e-44), SC_(-9.1621766066380866442106789589881214946978e-19), SC_(9.1621766066380866442106789589881214946978e-19), SC_(5.7905083267633958779772477635279396276938e-44) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(1.0626813835613392870997879802990912171947e-39), SC_(-6.3041245086943347411730086982129302552737e-17), SC_(6.3041245086943347411730086982129302552737e-17), SC_(1.0626813835613392870997879802990912171947e-39) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(2.8969753795010521179721781592201454570874e-22), SC_(-1.9707349123022683160971835266509408314260e-09), SC_(1.9707349123022683160971835266509408314260e-09), SC_(2.8969753795010521179721781592201454570874e-22) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(2.9913093219650172248641405914923897050862e-22), SC_(-1.9979773260764812412802241586505300817976e-09), SC_(1.9979773260764812412802241586505300817976e-09), SC_(2.9913093219650172248641405914923897050862e-22) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(3.1236399234905887034712789411310349132369e-19), SC_(-3.9148217131515580521143995609735832600497e-08), SC_(3.9148217131515580521143995609735832600497e-08), SC_(3.1236399234905887034712789411310349132369e-19) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(6.7283252871939885977633660945857990701516e-15), SC_(-2.7657739272617288977774577745378453487523e-06), SC_(2.7657739272617288977774577745378453487523e-06), SC_(6.7283252871939885977633660945857990701516e-15) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(1.5567713891071657203220261129057963781172e-14), SC_(-3.9525368056477915583674736993267726210776e-06), SC_(3.9525368056477915583674736993267726210776e-06), SC_(1.5567713891071657203220261129057963781172e-14) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(2.1615735020381152854845438308977430707572e-13), SC_(-1.2095931572266664451418193816767960840363e-05), SC_(1.2095931572266664451418193816767960840363e-05), SC_(2.1615735020381152854845438308977430707572e-13) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(2.7964244127369678662061851260779436648647e-13), SC_(-1.3493985606122761739468459135596061251000e-05), SC_(1.3493985606122761739468459135596061251000e-05), SC_(2.7964244127369678662061851260779436648647e-13) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(1.1532720077574773465063271474181765447387e-12), SC_(-2.4622902664546617053736553907009954233835e-05), SC_(2.4622902664546617053736553907009954233835e-05), SC_(1.1532720077574773465063271474181765447387e-12) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(1.4431653059317871364857346065117732660950e-12), SC_(-2.7080181648379894671860218449897559092660e-05), SC_(2.7080181648379894671860218449897559092660e-05), SC_(1.4431653059317871364857346065117732660950e-12) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(1.5701823449930989932433044261876197007745e-12), SC_(-2.8066645851516129045594312456678147568843e-05), SC_(2.8066645851516129045594312456678147568843e-05), SC_(1.5701823449930989932433044261876197007745e-12) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(1.6262743126230709615372563672796884085717e-12), SC_(-2.8487614547731800206099418303318531991248e-05), SC_(2.8487614547731800206099418303318531991248e-05), SC_(1.6262743126230709615372563672796884085717e-12) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(3.2760505314173501936377728744207077125807e-12), SC_(-3.8337533485508570958702302872136828123512e-05), SC_(3.8337533485508570958702302872136828123512e-05), SC_(3.2760505314173501936377728744207077125807e-12) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(3.6260053284189544593120969012851263888804e-12), SC_(-4.0022821308506040669775564295481895798215e-05), SC_(4.0022821308506040669775564295481895798215e-05), SC_(3.6260053284189544593120969012851263888804e-12) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(1.2993161342679565061622949864800878928760e-173), SC_(-2.0750769397921058831474517842953742811777e-29), SC_(2.0750769397921058831474517842953742811777e-29), SC_(1.2993161342679565061622949864800878928760e-173) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(3.1286462824717683344987219538152696990815e-133), SC_(-1.8196897880700531825333559222330856835734e-22), SC_(1.8196897880700531825333559222330856835734e-22), SC_(3.1286462824717683344987219538152696990815e-133) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(7.5153941331530805728905729948144468271485e-125), SC_(-5.0016581041629485865497513919250208757916e-21), SC_(5.0016581041629485865497513919250208757916e-21), SC_(7.5153941331530805728905729948144468271485e-125) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(1.1640477355864833364080724508288902656910e-89), SC_(-5.3894934921752602430788668784365687522654e-15), SC_(5.3894934921752602430788668784365687522654e-15), SC_(1.1640477355864833364080724508288902656910e-89) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(2.3455244521242777107939125524821917463612e-76), SC_(-1.0136894336221967888299481901422099364795e-12), SC_(1.0136894336221967888299481901422099364795e-12), SC_(2.3455244521242777107939125524821917463612e-76) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(1.5818320742615230335414950351270469848574e-60), SC_(-5.0641028732247261924161882323150237606725e-10), SC_(5.0641028732247261924161882323150237606725e-10), SC_(1.5818320742615230335414950351270469848574e-60) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(1.1415705087508329211048178255190615626266e-54), SC_(-5.0170022528083452547679969687797657726995e-09), SC_(5.0170022528083452547679969687797657726995e-09), SC_(1.1415705087508329211048178255190615626266e-54) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(1.0641117345033440878872531716821892403120e-30), SC_(-5.5812391221795155665776284238615354563421e-05), SC_(5.5812391221795155665776284238615354563421e-05), SC_(1.0641117345033440878872531716821892403120e-30) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(1.1120698163671566480173986732459741837389e-30), SC_(-5.6225509025559091093174902381725600278735e-05), SC_(5.6225509025559091093174902381725600278735e-05), SC_(1.1120698163671566480173986732459741837389e-30) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(1.5844624741690305079173473541291644635430e-26), SC_(-2.7733861586284890885263690398424536260163e-04), SC_(2.7733861586284890885263690398424536260163e-04), SC_(1.5844624741690305079173473541291644635430e-26) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(1.4654155515704986511175001114250123703574e-20), SC_(-2.6932728498399941283259872126637594248093e-03), SC_(2.6932728498399941283259872126637594248093e-03), SC_(1.4654155515704986511175001114250123703574e-20) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(4.6539843003405515264248742272793607815551e-20), SC_(-3.2564209058601638967995130816176312463602e-03), SC_(3.2564209058601638967995130816176312463602e-03), SC_(4.6539843003405515264248742272793607815551e-20) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(1.7461217253962078005871721626287661405025e-18), SC_(-5.8971691574328227797480110696208148177942e-03), SC_(5.8971691574328227797480110696208148177942e-03), SC_(1.7461217253962078005871721626287661405025e-18) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(2.4899652906053706469483648528888801624252e-18), SC_(-6.2492148097843837167926572288936815160354e-03), SC_(6.2492148097843837167926572288936815160354e-03), SC_(2.4899652906053706469483648528888801624252e-18) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(1.7550615207081695430943995874171375117099e-17), SC_(-8.5933917826207685293776513702927811161923e-03), SC_(8.5933917826207685293776513702927811161923e-03), SC_(1.7550615207081695430943995874171375117099e-17) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(2.3907433336397378547150570412028081496986e-17), SC_(-9.0369861462957829235654876306024236900746e-03), SC_(9.0369861462957829235654876306024236900746e-03), SC_(2.3907433336397378547150570412028081496986e-17) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(2.6855473209726364445581516602760124967880e-17), SC_(-9.2096674356648869974491261054837146377425e-03), SC_(9.2096674356648869974491261054837146377425e-03), SC_(2.6855473209726364445581516602760124967881e-17) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(2.8186841841471986392027866851133015766278e-17), SC_(-9.2824811499839181622940662964440256573081e-03), SC_(9.2824811499839181622940662964440256573081e-03), SC_(2.8186841841471986392027866851133015766279e-17) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(7.4021046234758446051346304774679659185348e-17), SC_(-1.0860582749498234023329828110304562715346e-02), SC_(1.0860582749498234023329828110304562715346e-02), SC_(7.4021046234758446051346304774679659185354e-17) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(8.5138269193839086635202104592147927352018e-17), SC_(-1.1110318091962087391854291468294230373426e-02), SC_(1.1110318091962087391854291468294230373426e-02), SC_(8.5138269193839086635202104592147927352028e-17) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-7.7879107787424887377630721042418950411500e-304), SC_(-8.9235007427925185697730055539532575883895e-01), SC_(8.9235007427925185697730055539532575883895e-01), SC_(7.7879107787424887377630721042418950411500e-304) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-2.9494571077971945074311899544727419484513e-233), SC_(-1.7939106280040397947526118582400704162530e+00), SC_(1.7939106280040397947526118582400704162530e+00), SC_(2.9494571077971945074311899544727419484513e-233) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-1.3146645425833625008209050519274483749306e-218), SC_(-2.0634495733188405009902222776384947797531e+00), SC_(2.0634495733188405009902222776384947797531e+00), SC_(1.3146645425833625008209050519274483749306e-218) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-4.3600082992602925885409195347997181747915e-157), SC_(-3.6090977702187997464624180615209958274309e+00), SC_(3.6090977702187997464624180615209958274309e+00), SC_(4.3600082992602925885409195347997181747915e-157) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-8.0219401389878722949112436947291625321476e-134), SC_(-4.3814591847708833597692458252508426765742e+00), SC_(4.3814591847708833597692458252508426765742e+00), SC_(8.0219401389878722949112436947291625321477e-134) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-3.8948530002701842002124820076323792898146e-106), SC_(-5.4077282492303881944754587478647270207831e+00), SC_(5.4077282492303881944754587478647270207831e+00), SC_(3.8948530002701842002124820076323960447404e-106) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-6.9152353153924541990820655781188156084883e-96), SC_(-5.8004522248414584101919288562748523263134e+00), SC_(5.8004522248414584101919288562748523263134e+00), SC_(6.9152353153924541990820655781603597200805e-96) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-6.3221468429649415094070649839228474758770e-54), SC_(-7.1405270346833606874050521934554959549334e+00), SC_(7.1405270346833606874050521934554959549334e+00), SC_(6.3221468429649418018883453155846831083903e-54) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-6.8297658649194119409729013442280899108918e-54), SC_(-7.1411396373340116929497824813813185257163e+00), SC_(7.1411396373340116929497824813813185257163e+00), SC_(6.8297658649194122645298999732429958917624e-54) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-1.2980879126349778601096067286402278735308e-46), SC_(-7.2390486012926846199735838169300073550249e+00), SC_(7.2390486012926846199735838169300073550249e+00), SC_(1.2980879126349885076233983912944656744120e-46) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-3.7625174336785168247895364350098527052790e-36), SC_(-7.2167606867289564274500896240084471868698e+00), SC_(7.2167606867289564274500896240084471868698e+00), SC_(3.7625174337297755451123776082916533853149e-36) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-2.8581424461468046298858341917876998871971e-35), SC_(-7.2031791196635683191380837924865443023025e+00), SC_(7.2031791196635683191380837924865443023025e+00), SC_(2.8581424462195236335725949156747991479529e-35) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-1.6559817071255046217481888171142874608284e-32), SC_(-7.1457698101842832769128330089089501739798e+00), SC_(7.1457698101842832769128330089089501739798e+00), SC_(1.6559817074247628996670372524100101427018e-32) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-3.0875239071999645114497749325857428718907e-32), SC_(-7.1388579265392401519030758133769124395432e+00), SC_(7.1388579265392401519030758133769124395432e+00), SC_(3.0875239078760454559824955315255413965602e-32) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-9.5204071710934058417644724486141255328765e-31), SC_(-7.0963587389182888392680475924713097150903e+00), SC_(7.0963587389182888392680475924713097150903e+00), SC_(9.5204071770930285622110950962999859953989e-31) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-1.6382566497559642977781029505879743617061e-30), SC_(-7.0889137615343603248991425981660589271531e+00), SC_(7.0889137615343603248991425981660589271531e+00), SC_(1.6382566509764703688229927854486145092412e-30) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-2.0093804345415882011603391776650132430939e-30), SC_(-7.0860605413409204466070338489930881180753e+00), SC_(7.0860605413409204466070338489930881180753e+00), SC_(2.0093804361358770490462818940570566883696e-30) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-2.1875778085938991145486880262017637408089e-30), SC_(-7.0848647681954371371822013205107153969338e+00), SC_(7.0848647681954371371822013205107153969338e+00), SC_(2.1875778103756541470252948843713330146402e-30) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-1.1922017278929563891526274706296560766950e-29), SC_(-7.0599412650269020882054638861952760558921e+00), SC_(7.0599412650269020882054638861952760558921e+00), SC_(1.1922017295310628476735381595125418346789e-29) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-1.5243370553959434898482274437638781436135e-29), SC_(-7.0561584255591462798452696881313767986816e+00), SC_(7.0561584255591462798452696881313767986816e+00), SC_(1.5243370576553459328438947259199126230575e-29) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-3.8218138710269477167954364630319909601686e-279), SC_(-4.2414888641666168518376605800213393138353e-03), SC_(4.2414888641666168518376605800213393138353e-03), SC_(3.8218138710269477167954364630319909601686e-279) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-2.7235635769596428029611745214144728484904e-214), SC_(-2.9475292915743551305378239333737327816054e-02), SC_(2.9475292915743551305378239333737327816054e-02), SC_(2.7235635769596428029611745214144728484904e-214) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-7.8645388186722345238574330666863514288129e-201), SC_(-4.3860508706408795021809038237528550972944e-02), SC_(4.3860508706408795021809038237528550972944e-02), SC_(7.8645388186722345238574330666863514288129e-201) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-2.6540669997080629579823180157652258472978e-144), SC_(-2.2624928857125692960585991917748440628900e-01), SC_(2.2624928857125692960585991917748440628900e-01), SC_(2.6540669997080629579823180157652258472978e-144) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-6.3115375163138397430770386781319031820800e-123), SC_(-4.1351540543244517688779513041123356792462e-01), SC_(4.1351540543244517688779513041123356792462e-01), SC_(6.3115375163138397430770386781319031820800e-123) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.7303761272495051424979346585586283335785e-97), SC_(-8.3063133465142462483823261160252439192850e-01), SC_(8.3063133465142462483823261160252439192850e-01), SC_(1.7303761272495051424979346585586283335785e-97) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-4.5175624703018364386316355453473921476800e-88), SC_(-1.0670511936939712629708234662588148326329e+00), SC_(1.0670511936939712629708234662588148326329e+00), SC_(4.5175624703018364386316355453473921476800e-88) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.6020002451971748512846188776997380801968e-49), SC_(-2.7504438123537830122639465995516459243693e+00), SC_(2.7504438123537830122639465995516459243693e+00), SC_(1.6020002451971748512846188948253104355109e-49) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.7197850802902198446896205514299583939590e-49), SC_(-2.7523068468532179445424707278135331864043e+00), SC_(2.7523068468532179445424707278135331864043e+00), SC_(1.7197850802902198446896205705171084257269e-49) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-8.3527117600612900079451243606561768976848e-43), SC_(-3.1721951299884651387181678602983073533749e+00), SC_(3.1721951299884651387181678602983073533749e+00), SC_(8.3527117600612900079454421077782736973156e-43) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-3.4003056969911075225540986281473287327436e-33), SC_(-3.8038721669865046750184461843252328176283e+00), SC_(3.8038721669865046750184461843252328176283e+00), SC_(3.4003056969911075383118969144262012951089e-33) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-2.1893335570154485523511177420597381773999e-32), SC_(-3.8562407072788424277762073973547671973628e+00), SC_(3.8562407072788424277762073973547671973628e+00), SC_(2.1893335570154485795593105674166751581984e-32) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-7.5491054347142114375812761534657303513422e-30), SC_(-4.0169311294712766841907462646881123731969e+00), SC_(4.0169311294712766841907462646881123731969e+00), SC_(7.5491054347142135120024857544975752812436e-30) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.3377451617461182415352576426792415195876e-29), SC_(-4.0322847031889961016449241695127967252344e+00), SC_(4.0322847031889961016449241695127967252344e+00), SC_(1.3377451617461187393646500797909339535577e-29) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-3.1181122154204677781408299524082852177561e-28), SC_(-4.1152076877932488824487440158561314568334e+00), SC_(4.1152076877932488824487440158561314568334e+00), SC_(3.1181122154204739384160550997320853353164e-28) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-5.1330548068998766229904911228618886047427e-28), SC_(-4.1280626529858052436379394775518022194387e+00), SC_(4.1280626529858052436379394775518022194387e+00), SC_(5.1330548068998898322708019025183430171473e-28) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-6.1918000947675980932600962348923984243506e-28), SC_(-4.1328775661170746768561679616181033716906e+00), SC_(4.1328775661170746768561679616181033716906e+00), SC_(6.1918000947676156930552731345420383574982e-28) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-6.6943107292332944824543581350629439404312e-28), SC_(-4.1348776682478570282951998011387186465643e+00), SC_(4.1348776682478570282951998011387186465643e+00), SC_(6.6943107292333143145147732951925109927958e-28) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-3.1766730197769476890906031547046264616432e-27), SC_(-4.1743464200409483976940849150461241550181e+00), SC_(4.1743464200409483976940849150461241550181e+00), SC_(3.1766730197769691819478520904737434883311e-27) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-3.9809726675797011028776864437398168389685e-27), SC_(-4.1799936885160899972900179845072694573110e+00), SC_(4.1799936885160899972900179845072694573110e+00), SC_(3.9809726675797314627549526189688066228583e-27) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-3.6031937707821603160156579772361603327406e-156), SC_(-2.5649905132695119460090859221610377671614e-37), SC_(2.5649905132695119460090859221610377671614e-37), SC_(3.6031937707821603160156579772361603327406e-156) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-7.8262624437152878817921286113791391605446e-120), SC_(-1.5338700711974470220563155441437663267656e-28), SC_(1.5338700711974470220563155441437663267656e-28), SC_(7.8262624437152878817921286113791391605446e-120) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-2.7195793891013347647637761615581465071404e-112), SC_(-1.0129036310335264517433396465867413036390e-26), SC_(1.0129036310335264517433396465867413036390e-26), SC_(2.7195793891013347647637761615581465071404e-112) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-1.2519619151441472700754468254776873985120e-80), SC_(-4.3348230114188805520184819609626158734371e-19), SC_(4.3348230114188805520184819609626158734371e-19), SC_(1.2519619151441472700754468254776873985120e-80) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.1686150061019689308150922320673855951047e-68), SC_(-3.2824367266398871658789930317300768216857e-16), SC_(3.2824367266398871658789930317300768216857e-16), SC_(1.1686150061019689308150922320673855951047e-68) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-2.0339269095930003086862738966129720237203e-54), SC_(-8.6068880155744659183949200601774224820951e-13), SC_(8.6068880155744659183949200601774224820951e-13), SC_(2.0339269095930003086862738966129720237203e-54) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-3.7889339485433925662270522758726777409447e-49), SC_(-1.5755657388696602196791144374269677304439e-11), SC_(1.5755657388696602196791144374269677304439e-11), SC_(3.7889339485433925662270522758726777409447e-49) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.3742705332194966824159173240684135808242e-27), SC_(-2.1691456951893061403507406704708919385051e-06), SC_(2.1691456951893061403507406704708919385051e-06), SC_(1.3742705332194966824159173240684135808242e-27) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.4298441048791369509443231834067638856995e-27), SC_(-2.1896047867848465635607265753786402557507e-06), SC_(2.1896047867848465635607265753786402557507e-06), SC_(1.4298441048791369509443231834067638856995e-27) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-7.7702009502039420279546143341839256722974e-24), SC_(-1.6719454686763630444498345300950451832001e-05), SC_(1.6719454686763630444498345300950451832001e-05), SC_(7.7702009502039420279546143341839256722974e-24) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-1.7958479534246915291363011834602349191541e-18), SC_(-3.0445591423991458677328064687436383356869e-04), SC_(3.0445591423991458677328064687436383356869e-04), SC_(1.7958479534246915291363011834602349191541e-18) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-5.0746042237352493686220216165342376456433e-18), SC_(-3.8813627888736398894736330872109968201328e-04), SC_(3.8813627888736398894736330872109968201328e-04), SC_(5.0746042237352493686220216165342376456433e-18) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-1.3195481084047234153967605417111778178482e-16), SC_(-8.2999267377321712433847991092372972832643e-04), SC_(8.2999267377321712433847991092372972832643e-04), SC_(1.3195481084047234153967605417111778178482e-16) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.8152969278021679045164968870511951275589e-16), SC_(-8.9397810512147852733933720907632339358793e-04), SC_(8.9397810512147852733933720907632339358793e-04), SC_(1.8152969278021679045164968870511951275589e-16) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-1.0500101129172192913013660027995048349565e-15), SC_(-1.3445856701088725867718937736105967515739e-03), SC_(1.3445856701088725867718937736105967515739e-03), SC_(1.0500101129172192913013660027995048349565e-15) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-1.3862459916380826882588093599051846244974e-15), SC_(-1.4342021327952091805978987717343136186003e-03), SC_(1.4342021327952091805978987717343136186003e-03), SC_(1.3862459916380826882588093599051846244974e-15) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-1.5389552344190380358528407465886929566839e-15), SC_(-1.4694312011375382946221193467338020326125e-03), SC_(1.4694312011375382946221193467338020326125e-03), SC_(1.5389552344190380358528407465886929566839e-15) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-1.6073537654590508119476855253274849385421e-15), SC_(-1.4843427377824311295669460605582040816529e-03), SC_(1.4843427377824311295669460605582040816529e-03), SC_(1.6073537654590508119476855253274849385421e-15) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-3.8277933956092457700190995976184180486032e-15), SC_(-1.8154247772420045742823398439244305395032e-03), SC_(1.8154247772420045742823398439244305395032e-03), SC_(3.8277933956092457700190995976184180486032e-15) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-4.3407185664699606374331998505812869695492e-15), SC_(-1.8691438023553833111065412878023167101253e-03), SC_(1.8691438023553833111065412878023167101253e-03), SC_(4.3407185664699606374331998505812869695492e-15) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-4.7565682883947096082134555253788489712165e-139), SC_(-1.7234774637787371972462841071851217459094e-46), SC_(1.7234774637787371972462841071851217459094e-46), SC_(4.7565682883947096082134555253788489712165e-139) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-1.1069751725969163303053561384808743593345e-106), SC_(-1.3807695283234627184406520681005357845162e-35), SC_(1.3807695283234627184406520681005357845162e-35), SC_(1.1069751725969163303053561384808743593345e-106) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-5.7670661775296736110296704772619130194529e-100), SC_(-2.5202506148312414452489679214132195805465e-33), SC_(2.5202506148312414452489679214132195805465e-33), SC_(5.7670661775296736110296704772619130194529e-100) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-9.1684616082402776227356181215159366125958e-72), SC_(-7.7186643496317904512713282839228628420428e-24), SC_(7.7186643496317904512713282839228628420428e-24), SC_(9.1684616082402776227356181215159366125958e-72) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-4.1960954464441621813907637255720077170127e-61), SC_(-2.9401720963252266545864663005767301159753e-20), SC_(2.9401720963252266545864663005767301159753e-20), SC_(4.1960954464441621813907637255720077170127e-61) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-2.0165340650771786513699168981959761802595e-48), SC_(-5.2751389981561688495934756790211983025914e-16), SC_(5.2751389981561688495934756790211983025914e-16), SC_(2.0165340650771786513699168981959761802595e-48) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-9.9425202767847260671923664392583420628782e-44), SC_(-1.9684230837965902778872319125250200739208e-14), SC_(1.9684230837965902778872319125250200739208e-14), SC_(9.9425202767847260671923664392583420628782e-44) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.5547505672121296130392106483675653383267e-24), SC_(-5.0150172527959559654652405291168344998614e-08), SC_(5.0150172527959559654652405291168344998614e-08), SC_(1.5547505672121296130392106483675653383267e-24) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.6105879691624656990643965248687892740491e-24), SC_(-5.0741523868123427323815545304454884750325e-08), SC_(5.0741523868123427323815545304454884750325e-08), SC_(1.6105879691624656990643965248687892740491e-24) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-3.3982709793018355281017391487035417427047e-21), SC_(-6.4320743472516763828922139501460122436524e-07), SC_(6.4320743472516763828922139501460122436524e-07), SC_(3.3982709793018355281017391487035417427047e-21) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-2.0136497286809957733934298034682036536482e-16), SC_(-2.4285786959496733718139757322284841751909e-05), SC_(2.4285786959496733718139757322284841751909e-05), SC_(2.0136497286809957733934298034682036536482e-16) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-5.0736746328711878406334529544462008880793e-16), SC_(-3.2922288619670063805684647412975026371992e-05), SC_(3.2922288619670063805684647412975026371992e-05), SC_(5.0736746328711878406334529544462008880793e-16) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-9.2058057971142669818632882451524624613577e-15), SC_(-8.5371319549431409033709016893117151261965e-05), SC_(8.5371319549431409033709016893117151261965e-05), SC_(9.2058057971142669818632882451524624613577e-15) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.2225768235815330577066371513013453198390e-14), SC_(-9.3705743590974651085860587222608723506366e-05), SC_(9.3705743590974651085860587222608723506366e-05), SC_(1.2225768235815330577066371513013453198390e-14) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-5.8244563475549547711832550232807702598061e-14), SC_(-1.5637782789278203687643524893232794453618e-04), SC_(1.5637782789278203687643524893232794453618e-04), SC_(5.8244563475549547711832550232807702598061e-14) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-7.4569229890505557163492853191970993034195e-14), SC_(-1.6956865811277653447283757678080383708998e-04), SC_(1.6956865811277653447283757678080383708998e-04), SC_(7.4569229890505557163492853191970993034195e-14) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-8.1832474817414181188415410600940013463095e-14), SC_(-1.7481304989667968846826785428556395456213e-04), SC_(1.7481304989667968846826785428556395456213e-04), SC_(8.1832474817414181188415410600940013463095e-14) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-8.5059411982764980534071732177545111604637e-14), SC_(-1.7704264719338504308223806319058499071023e-04), SC_(1.7704264719338504308223806319058499071023e-04), SC_(8.5059411982764980534071732177545111604637e-14) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-1.8402318273600467452585045665223788575081e-13), SC_(-2.2795885234545206358891363709107320723417e-04), SC_(2.2795885234545206358891363709107320723417e-04), SC_(1.8402318273600467452585045665223788575081e-13) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-2.0579887619346373499724955565261111626478e-13), SC_(-2.3646038645828192050187173122582470722607e-04), SC_(2.3646038645828192050187173122582470722607e-04), SC_(2.0579887619346373499724955565261111626478e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-8.4527511233234616820681567685764871838811e-133), SC_(-3.0882937383097528454841062020993508240524e-50), SC_(3.0882937383097528454841062020993508240524e-50), SC_(8.4527511233234616820681567685764871838811e-133) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-6.9923886162786225290041059485642869099039e-102), SC_(-1.8290984735622862634822419238118624196110e-38), SC_(1.8290984735622862634822419238118624196110e-38), SC_(6.9923886162786225290041059485642869099039e-102) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-1.8222257388557590453891716200192517981943e-95), SC_(-5.0572327975659976126130334362619606452252e-36), SC_(5.0572327975659976126130334362619606452252e-36), SC_(1.8222257388557590453891716200192517981943e-95) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-1.5785837458587507689959719400887777839819e-68), SC_(-8.8630461887059148246282223853577530432909e-26), SC_(8.8630461887059148246282223853577530432909e-26), SC_(1.5785837458587507689959719400887777839819e-68) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-2.4031743689501148626789350545720960492598e-58), SC_(-6.5311928746345011085336459251009131488841e-22), SC_(6.5311928746345011085336459251009131488841e-22), SC_(2.4031743689501148626789350545720960492598e-58) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-3.1151821440951480299961396528104956264599e-46), SC_(-2.5704276337927733038201651165785059020184e-17), SC_(2.5704276337927733038201651165785059020184e-17), SC_(3.1151821440951480299961396528104956264599e-46) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-9.4545356213306515565760822975030854244578e-42), SC_(-1.2829941989444333089367016002348574442300e-15), SC_(1.2829941989444333089367016002348574442300e-15), SC_(9.4545356213306515565760822975030854244578e-42) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-2.0246145837701731243450397559432209225787e-23), SC_(-1.0765214977871771673245776912597883893598e-08), SC_(1.0765214977871771673245776912597883893598e-08), SC_(2.0246145837701731243450397559432209225787e-23) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-2.0939927147640952341785203616269429191389e-23), SC_(-1.0902547498242933540406289777245840869916e-08), SC_(1.0902547498242933540406289777245840869916e-08), SC_(2.0939927147640952341785203616269429191389e-23) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-3.1279858282645303350140088549775064559308e-20), SC_(-1.6999284989679718951529299499427442682618e-07), SC_(1.6999284989679718951529299499427442682618e-07), SC_(3.1279858282645303350140088549775064559308e-20) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-1.1277464129642928300941666952811474805926e-15), SC_(-8.6455189196899021323251860368081696280296e-06), SC_(8.6455189196899021323251860368081696280296e-06), SC_(1.1277464129642928300941666952811474805926e-15) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-2.7250430609569476201819037661856220392002e-15), SC_(-1.2017824151643068972482462583850751836402e-05), SC_(1.2017824151643068972482462583850751836402e-05), SC_(2.7250430609569476201819037661856220392002e-15) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-4.3357349168567137535522791181722264593265e-14), SC_(-3.3717013835998123364644285445432253519252e-05), SC_(3.3717013835998123364644285445432253519252e-05), SC_(4.3357349168567137535522791181722264593265e-14) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-5.6844572713629097346734022734939240078401e-14), SC_(-3.7295235754569334347577605455911310277809e-05), SC_(3.7295235754569334347577605455911310277809e-05), SC_(5.6844572713629097346734022734939240078401e-14) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-2.5229438265158936400163769272013868578036e-13), SC_(-6.4938654434549273266702408035073545441080e-05), SC_(6.4938654434549273266702408035073545441080e-05), SC_(2.5229438265158936400163769272013868578036e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-3.1940468213896847812701395671104986554075e-13), SC_(-7.0891405780533738967872961853947418808754e-05), SC_(7.0891405780533738967872961853947418808754e-05), SC_(3.1940468213896847812701395671104986554075e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-3.4903978375668985958002441064491941447463e-13), SC_(-7.3269016254197998713945946602449443518597e-05), SC_(7.3269016254197998713945946602449443518597e-05), SC_(3.4903978375668985958002441064491941447463e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-3.6216721065083133826907744084647357774452e-13), SC_(-7.4281646011827824274379014599786094597594e-05), SC_(7.4281646011827824274379014599786094597594e-05), SC_(3.6216721065083133826907744084647357774452e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-7.5655747115244396931399338225228512396960e-13), SC_(-9.7674876406170760452991734450208112207949e-05), SC_(9.7674876406170760452991734450208112207949e-05), SC_(7.5655747115244396931399338225228512396960e-13) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-8.4179543570306386015905476016228702472760e-13), SC_(-1.0162655133778969889301247926872770847275e-04), SC_(1.0162655133778969889301247926872770847275e-04), SC_(8.4179543570306386015905476016228702472760e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-3.1378078422967139261503847470441251218059e-130), SC_(-7.6123015654161815557718386437425084946103e-52), SC_(7.6123015654161815557718386437425084946103e-52), SC_(3.1378078422967139261503847470441251218059e-130) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-6.5825464787594334539462446991769371401884e-100), SC_(-1.0640292290408846408130218819932202194483e-39), SC_(1.0640292290408846408130218819932202194483e-39), SC_(6.5825464787594334539462446991769371401884e-100) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-1.2902593332640932226590812157766322241372e-93), SC_(-3.5159529814195239790841481597306397605593e-37), SC_(3.5159529814195239790841481597306397605593e-37), SC_(1.2902593332640932226590812157766322241372e-93) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-3.3788540718576517742447099217325712093118e-67), SC_(-1.3028309216911078611312413492746299035821e-26), SC_(1.3028309216911078611312413492746299035821e-26), SC_(3.3788540718576517742447099217325712093118e-67) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-3.2714462175618158648607176001920073589808e-57), SC_(-1.2744028833336989688369358264201060926622e-22), SC_(1.2744028833336989688369358264201060926622e-22), SC_(3.2714462175618158648607176001920073589808e-57) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-2.4743573022989740528371956122703552516244e-45), SC_(-7.0267301468784198441453679814366693406750e-18), SC_(7.0267301468784198441453679814366693406750e-18), SC_(2.4743573022989740528371956122703552516244e-45) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-6.1513964429642307895891005021864666062681e-41), SC_(-3.9737420250153426505541627263816116272833e-16), SC_(3.9737420250153426505541627263816116272833e-16), SC_(6.1513964429642307895891005021864666062681e-41) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-5.8164075717643353616248157174602162557393e-23), SC_(-5.5614458167676913494301960743787231205590e-09), SC_(5.5614458167676913494301960743787231205590e-09), SC_(5.8164075717643353616248157174602162557393e-23) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-6.0117866203166835879237830021018563335732e-23), SC_(-5.6346997839893176463452574243450469400897e-09), SC_(5.6346997839893176463452574243450469400897e-09), SC_(6.0117866203166835879237830021018563335732e-23) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-7.7915842863141939389850304007552127974710e-20), SC_(-9.6021394039407643377378157359919283906547e-08), SC_(9.6021394039407643377378157359919283906547e-08), SC_(7.7915842863141939389850304007552127974710e-20) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-2.2900905941292586529733991035546983758788e-15), SC_(-5.5494983056632462563888547294917429062500e-06), SC_(5.5494983056632462563888547294917429062500e-06), SC_(2.2900905941292586529733991035546983758788e-15) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-5.4392750138794216834165539430787574783934e-15), SC_(-7.7976876104872485539767263473392923827483e-06), SC_(7.7976876104872485539767263473392923827483e-06), SC_(5.4392750138794216834165539430787574783934e-15) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-8.1992430106482233839122266425647512276357e-14), SC_(-2.2629211385118935725231482288076202844307e-05), SC_(2.2629211385118935725231482288076202844307e-05), SC_(8.1992430106482233839122266425647512276357e-14) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.0693071085451105916089099818643768030579e-13), SC_(-2.5113753002024507029439271381282483038360e-05), SC_(2.5113753002024507029439271381282483038360e-05), SC_(1.0693071085451105916089099818643768030579e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-4.6097086355788453068515036947314365089586e-13), SC_(-4.4532494399592773360875507246909758858988e-05), SC_(4.4532494399592773360875507246909758858988e-05), SC_(4.6097086355788453068515036947314365089586e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-5.8090429997558788905629209203401270290074e-13), SC_(-4.8755166214724664408167185191402879754196e-05), SC_(4.8755166214724664408167185191402879754196e-05), SC_(5.8090429997558788905629209203401270290074e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-6.3370166007285993268578283462192033575324e-13), SC_(-5.0445093166106177735330494884077060478199e-05), SC_(5.0445093166106177735330494884077060478199e-05), SC_(6.3370166007285993268578283462192033575324e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-6.5706076572777654888368477228670631596485e-13), SC_(-5.1165390720351863001494293605697086528187e-05), SC_(5.1165390720351863001494293605697086528187e-05), SC_(6.5706076572777654888368477228670631596485e-13) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-1.3529494175542795516129328354068212518024e-12), SC_(-6.7888067917223552374764755398210868167551e-05), SC_(6.7888067917223552374764755398210868167551e-05), SC_(1.3529494175542795516129328354068212518024e-12) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-1.5022397790238570533957611878828186607339e-12), SC_(-7.0727022966499727753011314110449501485728e-05), SC_(7.0727022966499727753011314110449501485728e-05), SC_(1.5022397790238570533957611878828186607339e-12) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-4.1713709257564405906218513107195237067111e-83), SC_(-2.9500148321152304064828487937308813529006e-90), SC_(2.9500148321152304064828487937308813529006e-90), SC_(4.1713709257564405906218513107195237067111e-83) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-1.0345423164793172977570752428831839024453e-63), SC_(-3.3295179990084659888672987021388023867952e-69), SC_(3.3295179990084659888672987021388023867952e-69), SC_(1.0345423164793172977570752428831839024453e-63) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-1.0930801661042691324566315757622799959063e-59), SC_(-7.7711401897993967553472958107550131498030e-65), SC_(7.7711401897993967553472958107550131498030e-65), SC_(1.0930801661042691324566315757622799959063e-59) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-8.4810275963385083892561342169041260823060e-43), SC_(-1.6830110141946545726544204256160603162940e-46), SC_(1.6830110141946545726544204256160603162940e-46), SC_(8.4810275963385083892561342169041260823060e-43) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-2.0417186939052755053223431130272292583183e-36), SC_(-1.4274560913888382219048736143854028947712e-39), SC_(1.4274560913888382219048736143854028947712e-39), SC_(2.0417186939052755053223431130272292583183e-36) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-7.9051560197339788766367376956917473595135e-29), SC_(-2.4748932286595005897727691188045019742552e-31), SC_(2.4748932286595005897727691188045019742552e-31), SC_(7.9051560197339788766367376956917473595135e-29) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-5.0635653232011455103829158765947940369312e-26), SC_(-2.7619070400040255094310280956368812744302e-28), SC_(2.7619070400040255094310280956368812744302e-28), SC_(5.0635653232011455103829158765947940369312e-26) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.4774460484196530650834605463743907452412e-14), SC_(-7.8374436163992375210150388101991579591329e-16), SC_(7.8374436163992375210150388101991579591329e-16), SC_(1.4774460484196530650834605463743907452412e-14) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.5088661440420338417226689776724128915015e-14), SC_(-8.0187008935246434780512048093736175089718e-16), SC_(8.0187008935246434780512048093736175089718e-16), SC_(1.5088661440420338417226689776724128915015e-14) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-1.4466811398103564156532053308013443691016e-12), SC_(-1.1413708603914626496619057728935710216152e-13), SC_(1.1413708603914626496619057728935710216152e-13), SC_(1.4466811398103564156532053308013443691016e-12) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-1.0036765360305196379411604137190374144519e-09), SC_(-1.3980624159861060629499860250436035900841e-10), SC_(1.3980624159861060629499860250436035900841e-10), SC_(1.0036765360305196379411604137190374144519e-09) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-1.7387082463064811963200142922934791715600e-09), SC_(-2.5407154843955499463213571551461520681004e-10), SC_(2.5407154843955499463213571551461520681004e-10), SC_(1.7387082463064811963200142922934791715600e-09) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-9.7340951778214803373298864255392015144328e-09), SC_(-1.6530925431265441280178159027013751596307e-09), SC_(1.6530925431265441280178159027013751596307e-09), SC_(9.7340951778214803373298864255392015144328e-09) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-1.1520981609328160761357573973849453322521e-08), SC_(-1.9855668682378720580326018134500931924412e-09), SC_(1.9855668682378720580326018134500931924412e-09), SC_(1.1520981609328160761357573973849453322521e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-2.9115267094005380336206999576820997217823e-08), SC_(-5.4413907197081789107399644468235597819002e-09), SC_(5.4413907197081789107399644468235597819002e-09), SC_(2.9115267094005380336206999576820997217823e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-3.3715308514962355773504436233980920429366e-08), SC_(-6.3824705075072844074371161377620951693296e-09), SC_(6.3824705075072844074371161377620951693296e-09), SC_(3.3715308514962355773504436233980920429366e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-3.5627965839269457458268622952811305548834e-08), SC_(-6.7771824110679011119080311599992819429806e-09), SC_(6.7771824110679011119080311599992819429806e-09), SC_(3.5627965839269457458268622952811305548834e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-3.6455445617846818484560024297325234998095e-08), SC_(-6.9485301785063638021784118834145670449721e-09), SC_(6.9485301785063638021784118834145670449721e-09), SC_(3.6455445617846818484560024297325234998095e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-5.7636467233594629586969076386871000144855e-08), SC_(-1.1435061027210169208985744449071965847688e-08), SC_(1.1435061027210169208985744449071965847688e-08), SC_(5.7636467233594629586969076386871000144855e-08) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-6.1591795575045432944711115634962744103417e-08), SC_(-1.2291014619883267276651125656375882351262e-08), SC_(1.2291014619883267276651125656375882351262e-08), SC_(6.1591795575045432944711115634962744103417e-08) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.7540393471717834472656250000000000000000e-04), SC_(-5.6173489553322618088731015958471837000827e-77), SC_(-7.0360635913589259822406963090864947687824e-97), SC_(7.0360635913589259822406963090864947687824e-97), SC_(5.6173489553322618088731015958471837000827e-77) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.2698681093752384185791015625000000000000e-03), SC_(-5.2809884186037731075845628844174261664194e-59), SC_(-2.7261406698750549475005353229241972920506e-74), SC_(2.7261406698750549475005353229241972920506e-74), SC_(5.2809884186037731075845628844174261664194e-59) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.3547698035836219787597656250000000000000e-03), SC_(-2.8286335639023020687096687968060207767851e-55), SC_(-1.3256747236227021046170404409936042498238e-69), SC_(1.3256747236227021046170404409936042498238e-69), SC_(2.8286335639023020687096687968060207767851e-55) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(1.8838196992874145507812500000000000000000e-03), SC_(-1.2648881928850376725288837254305451739455e-39), SC_(-6.2674747188012459421900673516458930582759e-50), SC_(6.2674747188012459421900673516458930582759e-50), SC_(1.2648881928850376725288837254305451739455e-39) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(2.2103404626250267028808593750000000000000e-03), SC_(-1.0346215603089819476696547093184959030510e-33), SC_(-1.7065295783049726507389573182181263384480e-42), SC_(1.7065295783049726507389573182181263384480e-42), SC_(1.0346215603089819476696547093184959030510e-33) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(2.7849823236465454101562500000000000000000e-03), SC_(-1.1081579434732428339153166363715720493963e-26), SC_(-1.1860791983580166453724690845388598221551e-33), SC_(1.1860791983580166453724690845388598221551e-33), SC_(1.1081579434732428339153166363715720493963e-26) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(3.0816700309514999389648437500000000000000e-03), SC_(-4.4103696442359646961452416237039696522205e-24), SC_(-2.2134543824662188553918959881202119583486e-30), SC_(2.2134543824662188553918959881202119583486e-30), SC_(4.4103696442359646961452416237039696522205e-24) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(5.4688137024641036987304687500000000000000e-03), SC_(-1.8310904367219332010844067758416022426091e-13), SC_(-5.1641979752415536255106578856064382126707e-17), SC_(5.1641979752415536255106578856064382126707e-17), SC_(1.8310904367219332010844067758416022426091e-13) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(5.4722055792808532714843750000000000000000e-03), SC_(-1.8671158798297357218915719791713904778185e-13), SC_(-5.2925455180741283168482102122250827171543e-17), SC_(5.2925455180741283168482102122250827171543e-17), SC_(1.8671158798297357218915719791713904778185e-13) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(6.3235927373170852661132812500000000000000e-03), SC_(-1.2758514222409018931575116736030103520537e-11), SC_(-1.0862198675360034655022613824559574625590e-14), SC_(1.0862198675360034655022613824559574625590e-14), SC_(1.2758514222409018931575116736030103520537e-11) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(8.1472359597682952880859375000000000000000e-03), SC_(-5.4375162140194392613427188677521534157644e-09), SC_(-2.2525157326688803565679579886800560602050e-11), SC_(2.2525157326688803565679579886800560602050e-11), SC_(5.4375162140194392613427188677521534157644e-09) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(8.3500854671001434326171875000000000000000e-03), SC_(-9.0408041584808290554254899572317089415384e-09), SC_(-4.2791578528072197371349881749868837713689e-11), SC_(4.2791578528072197371349881749868837713689e-11), SC_(9.0408041584808290554254899572317089415384e-09) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.0579167008399963378906250000000000000000e-03), SC_(-4.4496476833876149950359226943594589957380e-08), SC_(-3.2000168315292794463277290470620585059264e-10), SC_(3.2000168315292794463277290470620585059264e-10), SC_(4.4496476833876149950359226943594589957380e-08) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.1337561607360839843750000000000000000000e-03), SC_(-5.2004288043651053596437064182942052960991e-08), SC_(-3.8963772806793672629722565038960258717719e-10), SC_(3.8963772806793672629722565038960258717719e-10), SC_(5.2004288043651053596437064182942052960991e-08) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.5750652253627777099609375000000000000000e-03), SC_(-1.2260343695853710995888073161591407125877e-07), SC_(-1.1510174503363983761669153800733184721993e-09), SC_(1.1510174503363983761669153800733184721993e-09), SC_(1.2260343695853710995888073161591407125877e-07) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.6488818526268005371093750000000000000000e-03), SC_(-1.4042108026568271788429691487456901458281e-07), SC_(-1.3662239827462324315451988095558208925344e-09), SC_(1.3662239827462324315451988095558208925344e-09), SC_(1.4042108026568271788429691487456901458281e-07) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.6769481897354125976562500000000000000000e-03), SC_(-1.4777437793291791135639522556921613031252e-07), SC_(-1.4572160219071226504142505428659079461409e-09), SC_(1.4572160219071226504142505428659079461409e-09), SC_(1.4777437793291791135639522556921613031252e-07) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.6886754035949707031250000000000000000000e-03), SC_(-1.5094638836532006324414453438350092758494e-07), SC_(-1.4968410537389376971043480357981388174792e-09), SC_(1.4968410537389376971043480357981388174792e-09), SC_(1.5094638836532006324414453438350092758494e-07) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.9288113415241241455078125000000000000000e-03), SC_(-2.3058634749348361720491150310227990973128e-07), SC_(-2.5565029274937194447020017467519802307083e-09), SC_(2.5565029274937194447020017467519802307083e-09), SC_(2.3058634749348361720491150310227990973128e-07) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(9.9646113812923431396484375000000000000000e-03), SC_(-2.4518607206180375945908050567394504116941e-07), SC_(-2.7626949719007798133896374132255843417443e-09), SC_(2.7626949719007798133896374132255843417443e-09), SC_(2.4518607206180375945908050567394504116941e-07) }
   }};
//#undef SC_

