; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple thumbv7s-apple-darwin  -asm-verbose=false | FileCheck %s
; RUN: llc < %s -mtriple thumbv7s-apple-darwin  -asm-verbose=false -stop-after=if-converter | FileCheck --check-prefix=CHECK-PROB %s

declare i32 @foo(i32)
declare i8* @bar(i32, i8*, i8*)

; Verify that we don't try to iteratively re-ifconvert a block with a
; (predicated) indirectbr terminator.
; If we do, we would ignore its fallthrough successor.

; CHECK-PROB: bb.0{{[0-9a-zA-Z.]*}}:
; CHECK-PROB: successors: %bb.1(0x40000000), %bb.3(0x20000000), %bb.4(0x20000000)
; CHECK-PROB: bb.2{{[0-9a-zA-Z.]*}}:
; CHECK-PROB: successors: %bb.3(0x40000000), %bb.4(0x40000000)

define i32 @test(i32 %a, i32 %a2, i32* %p, i32* %p2) "frame-pointer"="all" {
; CHECK-LABEL: test:
; CHECK:         push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    add r7, sp, #12
; CHECK-NEXT:    push.w {r8, r10, r11}
; CHECK-NEXT:    str r3, [sp, #-4]!
; CHECK-NEXT:    mov r11, r2
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    ldr r6, LCPI0_0
; CHECK-NEXT:  LPC0_1:
; CHECK-NEXT:    add r6, pc
; CHECK-NEXT:    ldr.w r8, LCPI0_1
; CHECK-NEXT:  LPC0_0:
; CHECK-NEXT:    add r8, pc
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    mov r2, r8
; CHECK-NEXT:    bl _bar
; CHECK-NEXT:    mov r10, r0
; CHECK-NEXT:    movs r0, #2
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    mov r2, r8
; CHECK-NEXT:    bl _bar
; CHECK-NEXT:    movs r0, #3
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    mov r2, r8
; CHECK-NEXT:    bl _bar
; CHECK-NEXT:    cmp r5, #21
; CHECK-NEXT:    itttt eq
; CHECK-NEXT:    moveq r1, r0
; CHECK-NEXT:    streq.w r5, [r11]
; CHECK-NEXT:    movweq r0, #1234
; CHECK-NEXT:    moveq pc, r1
; CHECK-NEXT:  LBB0_1:
; CHECK-NEXT:    cmp r4, #42
; CHECK-NEXT:    beq LBB0_4
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    str r5, [r0]
; CHECK-NEXT:    movw r0, #1234
; CHECK-NEXT:    mov pc, r10
; CHECK-NEXT:  Ltmp0:
; CHECK-NEXT:  LBB0_3:
; CHECK-NEXT:    movw r0, #4567
; CHECK-NEXT:    b LBB0_5
; CHECK-NEXT:  LBB0_4:
; CHECK-NEXT:    movw r0, #1234
; CHECK-NEXT:  Ltmp1:
; CHECK-NEXT:  LBB0_5:
; CHECK-NEXT:    bl _foo
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r8, r10, r11}
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECK-NEXT:    .p2align 2
entry:
  %dst1 = call i8* @bar(i32 1, i8* blockaddress(@test, %bb1), i8* blockaddress(@test, %bb2))
  %dst2 = call i8* @bar(i32 2, i8* blockaddress(@test, %bb1), i8* blockaddress(@test, %bb2))
  %dst3 = call i8* @bar(i32 3, i8* blockaddress(@test, %bb1), i8* blockaddress(@test, %bb2))
  %cc1 = icmp eq i32 %a, 21
  br i1 %cc1, label %cc1t, label %cc1f

cc1t:
  store i32 %a, i32* %p
  indirectbr i8* %dst3, [label %bb1, label %bb2]

cc1f:
  %cc2 = icmp ne i32 %a2, 42
  br i1 %cc2, label %cc2t, label %bb1
cc2t:
  store i32 %a, i32* %p2
  indirectbr i8* %dst1, [label %bb1, label %bb2]

bb1:
  %ret_bb1 = call i32 @foo(i32 1234)
  ret i32 %ret_bb1
bb2:
  %ret_bb2 = call i32 @foo(i32 4567)
  ret i32 %ret_bb2
}
