/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.xbean.classloader;

import java.util.jar.Manifest;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;

/**
 * @version $Rev: 437551 $ $Date: 2006-08-28 08:14:47 +0200 (Mon, 28 Aug 2006) $
 */
public class JarResourceLocation extends AbstractUrlResourceLocation  {
    private final JarFile jarFile;

    public JarResourceLocation(URL codeSource, JarFile jarFile) {
        super(codeSource);
        this.jarFile = jarFile;
    }

    public ResourceHandle getResourceHandle(String resourceName) {
        JarEntry jarEntry = jarFile.getJarEntry(resourceName);
        if (jarEntry != null) {
            try {
                URL url = new URL(getCodeSource(), resourceName);
                return new JarResourceHandle(jarFile, jarEntry, getCodeSource());
            } catch (MalformedURLException e) {
            }
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return jarFile.getManifest();
    }

    public void close() {
        IoUtil.close(jarFile);
    }
}
