--TEST--
The right events are emitted in the right order for a test that uses custom test method invocation
--FILE--
<?php declare(strict_types=1);
$_SERVER['argv'][] = '--do-not-cache-result';
$_SERVER['argv'][] = '--no-configuration';
$_SERVER['argv'][] = '--debug';
$_SERVER['argv'][] = __DIR__ . '/_files/CustomTestMethodInvocationTest.php';

require __DIR__ . '/../../bootstrap.php';

(new PHPUnit\TextUI\Application)->run($_SERVER['argv']);
--EXPECTF--
PHPUnit Started (PHPUnit %s using %s)
Test Runner Configured
Event Facade Sealed
Test Suite Loaded (1 test)
Test Runner Started
Test Suite Sorted
Test Runner Execution Started (1 test)
Test Suite Started (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest, 1 test)
Test Preparation Started (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest::testOne)
Test Prepared (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest::testOne)
Custom Test Method Invocation Used (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest::invokeTestMethod)
Test Passed (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest::testOne)
Test Finished (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest::testOne)
Test Suite Finished (PHPUnit\TestFixture\Event\CustomTestMethodInvocationTest, 1 test)
Test Runner Execution Finished
Test Runner Finished
PHPUnit Finished (Shell Exit Code: 0)
