# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class BgpSession(msrest.serialization.Model):
    """The properties that define a BGP session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param session_prefix_v4: The IPv4 prefix that contains both ends' IPv4 addresses.
    :type session_prefix_v4: str
    :param session_prefix_v6: The IPv6 prefix that contains both ends' IPv6 addresses.
    :type session_prefix_v6: str
    :param microsoft_session_i_pv4_address: The IPv4 session address on Microsoft's end.
    :type microsoft_session_i_pv4_address: str
    :param microsoft_session_i_pv6_address: The IPv6 session address on Microsoft's end.
    :type microsoft_session_i_pv6_address: str
    :param peer_session_i_pv4_address: The IPv4 session address on peer's end.
    :type peer_session_i_pv4_address: str
    :param peer_session_i_pv6_address: The IPv6 session address on peer's end.
    :type peer_session_i_pv6_address: str
    :ivar session_state_v4: The state of the IPv4 session. Possible values include: "None", "Idle",
     "Connect", "Active", "OpenSent", "OpenConfirm", "OpenReceived", "Established", "PendingAdd",
     "PendingUpdate", "PendingRemove".
    :vartype session_state_v4: str or ~azure.mgmt.peering.models.SessionStateV4
    :ivar session_state_v6: The state of the IPv6 session. Possible values include: "None", "Idle",
     "Connect", "Active", "OpenSent", "OpenConfirm", "OpenReceived", "Established", "PendingAdd",
     "PendingUpdate", "PendingRemove".
    :vartype session_state_v6: str or ~azure.mgmt.peering.models.SessionStateV6
    :param max_prefixes_advertised_v4: The maximum number of prefixes advertised over the IPv4
     session.
    :type max_prefixes_advertised_v4: int
    :param max_prefixes_advertised_v6: The maximum number of prefixes advertised over the IPv6
     session.
    :type max_prefixes_advertised_v6: int
    :param md5_authentication_key: The MD5 authentication key of the session.
    :type md5_authentication_key: str
    """

    _validation = {
        'session_state_v4': {'readonly': True},
        'session_state_v6': {'readonly': True},
    }

    _attribute_map = {
        'session_prefix_v4': {'key': 'sessionPrefixV4', 'type': 'str'},
        'session_prefix_v6': {'key': 'sessionPrefixV6', 'type': 'str'},
        'microsoft_session_i_pv4_address': {'key': 'microsoftSessionIPv4Address', 'type': 'str'},
        'microsoft_session_i_pv6_address': {'key': 'microsoftSessionIPv6Address', 'type': 'str'},
        'peer_session_i_pv4_address': {'key': 'peerSessionIPv4Address', 'type': 'str'},
        'peer_session_i_pv6_address': {'key': 'peerSessionIPv6Address', 'type': 'str'},
        'session_state_v4': {'key': 'sessionStateV4', 'type': 'str'},
        'session_state_v6': {'key': 'sessionStateV6', 'type': 'str'},
        'max_prefixes_advertised_v4': {'key': 'maxPrefixesAdvertisedV4', 'type': 'int'},
        'max_prefixes_advertised_v6': {'key': 'maxPrefixesAdvertisedV6', 'type': 'int'},
        'md5_authentication_key': {'key': 'md5AuthenticationKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpSession, self).__init__(**kwargs)
        self.session_prefix_v4 = kwargs.get('session_prefix_v4', None)
        self.session_prefix_v6 = kwargs.get('session_prefix_v6', None)
        self.microsoft_session_i_pv4_address = kwargs.get('microsoft_session_i_pv4_address', None)
        self.microsoft_session_i_pv6_address = kwargs.get('microsoft_session_i_pv6_address', None)
        self.peer_session_i_pv4_address = kwargs.get('peer_session_i_pv4_address', None)
        self.peer_session_i_pv6_address = kwargs.get('peer_session_i_pv6_address', None)
        self.session_state_v4 = None
        self.session_state_v6 = None
        self.max_prefixes_advertised_v4 = kwargs.get('max_prefixes_advertised_v4', None)
        self.max_prefixes_advertised_v6 = kwargs.get('max_prefixes_advertised_v6', None)
        self.md5_authentication_key = kwargs.get('md5_authentication_key', None)


class Resource(msrest.serialization.Model):
    """The ARM resource class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class CdnPeeringPrefix(Resource):
    """The CDN peering prefix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar prefix: The prefix.
    :vartype prefix: str
    :ivar azure_region: The Azure region.
    :vartype azure_region: str
    :ivar azure_service: The Azure service.
    :vartype azure_service: str
    :ivar is_primary_region: The flag that indicates whether or not this is the primary region.
    :vartype is_primary_region: bool
    :ivar bgp_community: The BGP Community.
    :vartype bgp_community: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'prefix': {'readonly': True},
        'azure_region': {'readonly': True},
        'azure_service': {'readonly': True},
        'is_primary_region': {'readonly': True},
        'bgp_community': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'azure_region': {'key': 'properties.azureRegion', 'type': 'str'},
        'azure_service': {'key': 'properties.azureService', 'type': 'str'},
        'is_primary_region': {'key': 'properties.isPrimaryRegion', 'type': 'bool'},
        'bgp_community': {'key': 'properties.bgpCommunity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CdnPeeringPrefix, self).__init__(**kwargs)
        self.prefix = None
        self.azure_region = None
        self.azure_service = None
        self.is_primary_region = None
        self.bgp_community = None


class CdnPeeringPrefixListResult(msrest.serialization.Model):
    """The paginated list of CDN peering prefixes.

    :param value: The list of CDN peering prefixes.
    :type value: list[~azure.mgmt.peering.models.CdnPeeringPrefix]
    :param next_link: The link to fetch the next page of CDN peering prefixes.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CdnPeeringPrefix]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CdnPeeringPrefixListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class CheckServiceProviderAvailabilityInput(msrest.serialization.Model):
    """Class for CheckServiceProviderAvailabilityInput.

    :param peering_service_location: Gets or sets the peering service location.
    :type peering_service_location: str
    :param peering_service_provider: Gets or sets the peering service provider.
    :type peering_service_provider: str
    """

    _attribute_map = {
        'peering_service_location': {'key': 'peeringServiceLocation', 'type': 'str'},
        'peering_service_provider': {'key': 'peeringServiceProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckServiceProviderAvailabilityInput, self).__init__(**kwargs)
        self.peering_service_location = kwargs.get('peering_service_location', None)
        self.peering_service_provider = kwargs.get('peering_service_provider', None)


class ContactDetail(msrest.serialization.Model):
    """The contact detail class.

    :param role: The role of the contact. Possible values include: "Noc", "Policy", "Technical",
     "Service", "Escalation", "Other".
    :type role: str or ~azure.mgmt.peering.models.Role
    :param email: The e-mail address of the contact.
    :type email: str
    :param phone: The phone number of the contact.
    :type phone: str
    """

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactDetail, self).__init__(**kwargs)
        self.role = kwargs.get('role', None)
        self.email = kwargs.get('email', None)
        self.phone = kwargs.get('phone', None)


class DirectConnection(msrest.serialization.Model):
    """The properties that define a direct connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param bandwidth_in_mbps: The bandwidth of the connection.
    :type bandwidth_in_mbps: int
    :ivar provisioned_bandwidth_in_mbps: The bandwidth that is actually provisioned.
    :vartype provisioned_bandwidth_in_mbps: int
    :param session_address_provider: The field indicating if Microsoft provides session ip
     addresses. Possible values include: "Microsoft", "Peer".
    :type session_address_provider: str or ~azure.mgmt.peering.models.SessionAddressProvider
    :param use_for_peering_service: The flag that indicates whether or not the connection is used
     for peering service.
    :type use_for_peering_service: bool
    :ivar microsoft_tracking_id: The ID used within Microsoft's peering provisioning system to
     track the connection.
    :vartype microsoft_tracking_id: str
    :param peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection has
     to be set up.
    :type peering_db_facility_id: int
    :ivar connection_state: The state of the connection. Possible values include: "None",
     "PendingApproval", "Approved", "ProvisioningStarted", "ProvisioningFailed",
     "ProvisioningCompleted", "Validating", "Active".
    :vartype connection_state: str or ~azure.mgmt.peering.models.ConnectionState
    :param bgp_session: The BGP session associated with the connection.
    :type bgp_session: ~azure.mgmt.peering.models.BgpSession
    :param connection_identifier: The unique identifier (GUID) for the connection.
    :type connection_identifier: str
    :ivar error_message: The error message related to the connection state, if any.
    :vartype error_message: str
    """

    _validation = {
        'provisioned_bandwidth_in_mbps': {'readonly': True},
        'microsoft_tracking_id': {'readonly': True},
        'connection_state': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
        'provisioned_bandwidth_in_mbps': {'key': 'provisionedBandwidthInMbps', 'type': 'int'},
        'session_address_provider': {'key': 'sessionAddressProvider', 'type': 'str'},
        'use_for_peering_service': {'key': 'useForPeeringService', 'type': 'bool'},
        'microsoft_tracking_id': {'key': 'microsoftTrackingId', 'type': 'str'},
        'peering_db_facility_id': {'key': 'peeringDBFacilityId', 'type': 'int'},
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'bgp_session': {'key': 'bgpSession', 'type': 'BgpSession'},
        'connection_identifier': {'key': 'connectionIdentifier', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DirectConnection, self).__init__(**kwargs)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)
        self.provisioned_bandwidth_in_mbps = None
        self.session_address_provider = kwargs.get('session_address_provider', None)
        self.use_for_peering_service = kwargs.get('use_for_peering_service', None)
        self.microsoft_tracking_id = None
        self.peering_db_facility_id = kwargs.get('peering_db_facility_id', None)
        self.connection_state = None
        self.bgp_session = kwargs.get('bgp_session', None)
        self.connection_identifier = kwargs.get('connection_identifier', None)
        self.error_message = None


class DirectPeeringFacility(msrest.serialization.Model):
    """The properties that define a direct peering facility.

    :param address: The address of the direct peering facility.
    :type address: str
    :param direct_peering_type: The type of the direct peering. Possible values include: "Edge",
     "Transit", "Cdn", "Internal", "Ix", "IxRs".
    :type direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
    :param peering_db_facility_id: The PeeringDB.com ID of the facility.
    :type peering_db_facility_id: int
    :param peering_db_facility_link: The PeeringDB.com URL of the facility.
    :type peering_db_facility_link: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'direct_peering_type': {'key': 'directPeeringType', 'type': 'str'},
        'peering_db_facility_id': {'key': 'peeringDBFacilityId', 'type': 'int'},
        'peering_db_facility_link': {'key': 'peeringDBFacilityLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DirectPeeringFacility, self).__init__(**kwargs)
        self.address = kwargs.get('address', None)
        self.direct_peering_type = kwargs.get('direct_peering_type', None)
        self.peering_db_facility_id = kwargs.get('peering_db_facility_id', None)
        self.peering_db_facility_link = kwargs.get('peering_db_facility_link', None)


class ErrorDetail(msrest.serialization.Model):
    """The error detail that describes why an operation has failed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponse(msrest.serialization.Model):
    """The error response that indicates why an operation has failed.

    :param error: The error detail that describes why an operation has failed.
    :type error: ~azure.mgmt.peering.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExchangeConnection(msrest.serialization.Model):
    """The properties that define an exchange connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param peering_db_facility_id: The PeeringDB.com ID of the facility at which the connection has
     to be set up.
    :type peering_db_facility_id: int
    :ivar connection_state: The state of the connection. Possible values include: "None",
     "PendingApproval", "Approved", "ProvisioningStarted", "ProvisioningFailed",
     "ProvisioningCompleted", "Validating", "Active".
    :vartype connection_state: str or ~azure.mgmt.peering.models.ConnectionState
    :param bgp_session: The BGP session associated with the connection.
    :type bgp_session: ~azure.mgmt.peering.models.BgpSession
    :param connection_identifier: The unique identifier (GUID) for the connection.
    :type connection_identifier: str
    :ivar error_message: The error message related to the connection state, if any.
    :vartype error_message: str
    """

    _validation = {
        'connection_state': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'peering_db_facility_id': {'key': 'peeringDBFacilityId', 'type': 'int'},
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'bgp_session': {'key': 'bgpSession', 'type': 'BgpSession'},
        'connection_identifier': {'key': 'connectionIdentifier', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangeConnection, self).__init__(**kwargs)
        self.peering_db_facility_id = kwargs.get('peering_db_facility_id', None)
        self.connection_state = None
        self.bgp_session = kwargs.get('bgp_session', None)
        self.connection_identifier = kwargs.get('connection_identifier', None)
        self.error_message = None


class ExchangePeeringFacility(msrest.serialization.Model):
    """The properties that define an exchange peering facility.

    :param exchange_name: The name of the exchange peering facility.
    :type exchange_name: str
    :param bandwidth_in_mbps: The bandwidth of the connection between Microsoft and the exchange
     peering facility.
    :type bandwidth_in_mbps: int
    :param microsoft_i_pv4_address: The IPv4 address of Microsoft at the exchange peering facility.
    :type microsoft_i_pv4_address: str
    :param microsoft_i_pv6_address: The IPv6 address of Microsoft at the exchange peering facility.
    :type microsoft_i_pv6_address: str
    :param facility_i_pv4_prefix: The IPv4 prefixes associated with the exchange peering facility.
    :type facility_i_pv4_prefix: str
    :param facility_i_pv6_prefix: The IPv6 prefixes associated with the exchange peering facility.
    :type facility_i_pv6_prefix: str
    :param peering_db_facility_id: The PeeringDB.com ID of the facility.
    :type peering_db_facility_id: int
    :param peering_db_facility_link: The PeeringDB.com URL of the facility.
    :type peering_db_facility_link: str
    """

    _attribute_map = {
        'exchange_name': {'key': 'exchangeName', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
        'microsoft_i_pv4_address': {'key': 'microsoftIPv4Address', 'type': 'str'},
        'microsoft_i_pv6_address': {'key': 'microsoftIPv6Address', 'type': 'str'},
        'facility_i_pv4_prefix': {'key': 'facilityIPv4Prefix', 'type': 'str'},
        'facility_i_pv6_prefix': {'key': 'facilityIPv6Prefix', 'type': 'str'},
        'peering_db_facility_id': {'key': 'peeringDBFacilityId', 'type': 'int'},
        'peering_db_facility_link': {'key': 'peeringDBFacilityLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangePeeringFacility, self).__init__(**kwargs)
        self.exchange_name = kwargs.get('exchange_name', None)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)
        self.microsoft_i_pv4_address = kwargs.get('microsoft_i_pv4_address', None)
        self.microsoft_i_pv6_address = kwargs.get('microsoft_i_pv6_address', None)
        self.facility_i_pv4_prefix = kwargs.get('facility_i_pv4_prefix', None)
        self.facility_i_pv6_prefix = kwargs.get('facility_i_pv6_prefix', None)
        self.peering_db_facility_id = kwargs.get('peering_db_facility_id', None)
        self.peering_db_facility_link = kwargs.get('peering_db_facility_link', None)


class Operation(msrest.serialization.Model):
    """The peering API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar display: The information related to the operation.
    :vartype display: ~azure.mgmt.peering.models.OperationDisplayInfo
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'is_data_action': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayInfo'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = None


class OperationDisplayInfo(msrest.serialization.Model):
    """The information related to the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The name of the resource provider.
    :vartype provider: str
    :ivar resource: The type of the resource.
    :vartype resource: str
    :ivar operation: The name of the operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplayInfo, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """The paginated list of peering API operations.

    :param value: The list of peering API operations.
    :type value: list[~azure.mgmt.peering.models.Operation]
    :param next_link: The link to fetch the next page of peering API operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeerAsn(Resource):
    """The essential information related to the peer's ASN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param peer_asn: The Autonomous System Number (ASN) of the peer.
    :type peer_asn: int
    :param peer_contact_detail: The contact details of the peer.
    :type peer_contact_detail: list[~azure.mgmt.peering.models.ContactDetail]
    :param peer_name: The name of the peer.
    :type peer_name: str
    :param validation_state: The validation state of the ASN associated with the peer. Possible
     values include: "None", "Pending", "Approved", "Failed".
    :type validation_state: str or ~azure.mgmt.peering.models.ValidationState
    :ivar error_message: The error message for the validation state.
    :vartype error_message: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'peer_asn': {'key': 'properties.peerAsn', 'type': 'int'},
        'peer_contact_detail': {'key': 'properties.peerContactDetail', 'type': '[ContactDetail]'},
        'peer_name': {'key': 'properties.peerName', 'type': 'str'},
        'validation_state': {'key': 'properties.validationState', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeerAsn, self).__init__(**kwargs)
        self.peer_asn = kwargs.get('peer_asn', None)
        self.peer_contact_detail = kwargs.get('peer_contact_detail', None)
        self.peer_name = kwargs.get('peer_name', None)
        self.validation_state = kwargs.get('validation_state', None)
        self.error_message = None


class PeerAsnListResult(msrest.serialization.Model):
    """The paginated list of peer ASNs.

    :param value: The list of peer ASNs.
    :type value: list[~azure.mgmt.peering.models.PeerAsn]
    :param next_link: The link to fetch the next page of peer ASNs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeerAsn]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeerAsnListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Peering(Resource):
    """Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param sku: Required. The SKU that defines the tier and kind of the peering.
    :type sku: ~azure.mgmt.peering.models.PeeringSku
    :param kind: Required. The kind of the peering. Possible values include: "Direct", "Exchange".
    :type kind: str or ~azure.mgmt.peering.models.Kind
    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param direct: The properties that define a direct peering.
    :type direct: ~azure.mgmt.peering.models.PeeringPropertiesDirect
    :param exchange: The properties that define an exchange peering.
    :type exchange: ~azure.mgmt.peering.models.PeeringPropertiesExchange
    :param peering_location: The location of the peering.
    :type peering_location: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'PeeringSku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'direct': {'key': 'properties.direct', 'type': 'PeeringPropertiesDirect'},
        'exchange': {'key': 'properties.exchange', 'type': 'PeeringPropertiesExchange'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Peering, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.kind = kwargs['kind']
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.direct = kwargs.get('direct', None)
        self.exchange = kwargs.get('exchange', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.provisioning_state = None


class PeeringBandwidthOffer(msrest.serialization.Model):
    """The properties that define a peering bandwidth offer.

    :param offer_name: The name of the bandwidth offer.
    :type offer_name: str
    :param value_in_mbps: The value of the bandwidth offer in Mbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringBandwidthOffer, self).__init__(**kwargs)
        self.offer_name = kwargs.get('offer_name', None)
        self.value_in_mbps = kwargs.get('value_in_mbps', None)


class PeeringListResult(msrest.serialization.Model):
    """The paginated list of peerings.

    :param value: The list of peerings.
    :type value: list[~azure.mgmt.peering.models.Peering]
    :param next_link: The link to fetch the next page of peerings.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Peering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringLocation(Resource):
    """Peering location is where connectivity could be established to the Microsoft Cloud Edge.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param kind: The kind of peering that the peering location supports. Possible values include:
     "Direct", "Exchange".
    :type kind: str or ~azure.mgmt.peering.models.Kind
    :param direct: The properties that define a direct peering location.
    :type direct: ~azure.mgmt.peering.models.PeeringLocationPropertiesDirect
    :param exchange: The properties that define an exchange peering location.
    :type exchange: ~azure.mgmt.peering.models.PeeringLocationPropertiesExchange
    :param peering_location: The name of the peering location.
    :type peering_location: str
    :param country: The country in which the peering location exists.
    :type country: str
    :param azure_region: The Azure region associated with the peering location.
    :type azure_region: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'direct': {'key': 'properties.direct', 'type': 'PeeringLocationPropertiesDirect'},
        'exchange': {'key': 'properties.exchange', 'type': 'PeeringLocationPropertiesExchange'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'azure_region': {'key': 'properties.azureRegion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringLocation, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.direct = kwargs.get('direct', None)
        self.exchange = kwargs.get('exchange', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.country = kwargs.get('country', None)
        self.azure_region = kwargs.get('azure_region', None)


class PeeringLocationListResult(msrest.serialization.Model):
    """The paginated list of peering locations.

    :param value: The list of peering locations.
    :type value: list[~azure.mgmt.peering.models.PeeringLocation]
    :param next_link: The link to fetch the next page of peering locations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringLocation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringLocationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringLocationPropertiesDirect(msrest.serialization.Model):
    """The properties that define a direct peering location.

    :param peering_facilities: The list of direct peering facilities at the peering location.
    :type peering_facilities: list[~azure.mgmt.peering.models.DirectPeeringFacility]
    :param bandwidth_offers: The list of bandwidth offers available at the peering location.
    :type bandwidth_offers: list[~azure.mgmt.peering.models.PeeringBandwidthOffer]
    """

    _attribute_map = {
        'peering_facilities': {'key': 'peeringFacilities', 'type': '[DirectPeeringFacility]'},
        'bandwidth_offers': {'key': 'bandwidthOffers', 'type': '[PeeringBandwidthOffer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringLocationPropertiesDirect, self).__init__(**kwargs)
        self.peering_facilities = kwargs.get('peering_facilities', None)
        self.bandwidth_offers = kwargs.get('bandwidth_offers', None)


class PeeringLocationPropertiesExchange(msrest.serialization.Model):
    """The properties that define an exchange peering location.

    :param peering_facilities: The list of exchange peering facilities at the peering location.
    :type peering_facilities: list[~azure.mgmt.peering.models.ExchangePeeringFacility]
    """

    _attribute_map = {
        'peering_facilities': {'key': 'peeringFacilities', 'type': '[ExchangePeeringFacility]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringLocationPropertiesExchange, self).__init__(**kwargs)
        self.peering_facilities = kwargs.get('peering_facilities', None)


class PeeringPropertiesDirect(msrest.serialization.Model):
    """The properties that define a direct peering.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param connections: The set of connections that constitute a direct peering.
    :type connections: list[~azure.mgmt.peering.models.DirectConnection]
    :ivar use_for_peering_service: The flag that indicates whether or not the peering is used for
     peering service.
    :vartype use_for_peering_service: bool
    :param peer_asn: The reference of the peer ASN.
    :type peer_asn: ~azure.mgmt.peering.models.SubResource
    :param direct_peering_type: The type of direct peering. Possible values include: "Edge",
     "Transit", "Cdn", "Internal", "Ix", "IxRs".
    :type direct_peering_type: str or ~azure.mgmt.peering.models.DirectPeeringType
    """

    _validation = {
        'use_for_peering_service': {'readonly': True},
    }

    _attribute_map = {
        'connections': {'key': 'connections', 'type': '[DirectConnection]'},
        'use_for_peering_service': {'key': 'useForPeeringService', 'type': 'bool'},
        'peer_asn': {'key': 'peerAsn', 'type': 'SubResource'},
        'direct_peering_type': {'key': 'directPeeringType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringPropertiesDirect, self).__init__(**kwargs)
        self.connections = kwargs.get('connections', None)
        self.use_for_peering_service = None
        self.peer_asn = kwargs.get('peer_asn', None)
        self.direct_peering_type = kwargs.get('direct_peering_type', None)


class PeeringPropertiesExchange(msrest.serialization.Model):
    """The properties that define an exchange peering.

    :param connections: The set of connections that constitute an exchange peering.
    :type connections: list[~azure.mgmt.peering.models.ExchangeConnection]
    :param peer_asn: The reference of the peer ASN.
    :type peer_asn: ~azure.mgmt.peering.models.SubResource
    """

    _attribute_map = {
        'connections': {'key': 'connections', 'type': '[ExchangeConnection]'},
        'peer_asn': {'key': 'peerAsn', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringPropertiesExchange, self).__init__(**kwargs)
        self.connections = kwargs.get('connections', None)
        self.peer_asn = kwargs.get('peer_asn', None)


class PeeringReceivedRoute(msrest.serialization.Model):
    """The properties that define a received route.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prefix: The prefix.
    :vartype prefix: str
    :ivar next_hop: The next hop for the prefix.
    :vartype next_hop: str
    :ivar as_path: The AS path for the prefix.
    :vartype as_path: str
    :ivar origin_as_validation_state: The origin AS change information for the prefix.
    :vartype origin_as_validation_state: str
    :ivar rpki_validation_state: The RPKI validation state for the prefix and origin AS that's
     listed in the AS path.
    :vartype rpki_validation_state: str
    :ivar trust_anchor: The authority which holds the Route Origin Authorization record for the
     prefix, if any.
    :vartype trust_anchor: str
    :ivar received_timestamp: The received timestamp associated with the prefix.
    :vartype received_timestamp: str
    """

    _validation = {
        'prefix': {'readonly': True},
        'next_hop': {'readonly': True},
        'as_path': {'readonly': True},
        'origin_as_validation_state': {'readonly': True},
        'rpki_validation_state': {'readonly': True},
        'trust_anchor': {'readonly': True},
        'received_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'prefix': {'key': 'prefix', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
        'origin_as_validation_state': {'key': 'originAsValidationState', 'type': 'str'},
        'rpki_validation_state': {'key': 'rpkiValidationState', 'type': 'str'},
        'trust_anchor': {'key': 'trustAnchor', 'type': 'str'},
        'received_timestamp': {'key': 'receivedTimestamp', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringReceivedRoute, self).__init__(**kwargs)
        self.prefix = None
        self.next_hop = None
        self.as_path = None
        self.origin_as_validation_state = None
        self.rpki_validation_state = None
        self.trust_anchor = None
        self.received_timestamp = None


class PeeringReceivedRouteListResult(msrest.serialization.Model):
    """The paginated list of received routes for the peering.

    :param value: The list of received routes for the peering.
    :type value: list[~azure.mgmt.peering.models.PeeringReceivedRoute]
    :param next_link: The link to fetch the next page of received routes for the peering.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringReceivedRoute]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringReceivedRouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringRegisteredAsn(Resource):
    """The customer's ASN that is registered by the peering service provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param asn: The customer's ASN from which traffic originates.
    :type asn: int
    :ivar peering_service_prefix_key: The peering service prefix key that is to be shared with the
     customer.
    :vartype peering_service_prefix_key: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'peering_service_prefix_key': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'asn': {'key': 'properties.asn', 'type': 'int'},
        'peering_service_prefix_key': {'key': 'properties.peeringServicePrefixKey', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringRegisteredAsn, self).__init__(**kwargs)
        self.asn = kwargs.get('asn', None)
        self.peering_service_prefix_key = None
        self.provisioning_state = None


class PeeringRegisteredAsnListResult(msrest.serialization.Model):
    """The paginated list of peering registered ASNs.

    :param value: The list of peering registered ASNs.
    :type value: list[~azure.mgmt.peering.models.PeeringRegisteredAsn]
    :param next_link: The link to fetch the next page of peering registered ASNs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringRegisteredAsn]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringRegisteredAsnListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringRegisteredPrefix(Resource):
    """The customer's prefix that is registered by the peering service provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param prefix: The customer's prefix from which traffic originates.
    :type prefix: str
    :ivar prefix_validation_state: The prefix validation state. Possible values include: "None",
     "Invalid", "Verified", "Failed", "Pending", "Warning", "Unknown".
    :vartype prefix_validation_state: str or ~azure.mgmt.peering.models.PrefixValidationState
    :ivar peering_service_prefix_key: The peering service prefix key that is to be shared with the
     customer.
    :vartype peering_service_prefix_key: str
    :ivar error_message: The error message associated with the validation state, if any.
    :vartype error_message: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'prefix_validation_state': {'readonly': True},
        'peering_service_prefix_key': {'readonly': True},
        'error_message': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'prefix_validation_state': {'key': 'properties.prefixValidationState', 'type': 'str'},
        'peering_service_prefix_key': {'key': 'properties.peeringServicePrefixKey', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringRegisteredPrefix, self).__init__(**kwargs)
        self.prefix = kwargs.get('prefix', None)
        self.prefix_validation_state = None
        self.peering_service_prefix_key = None
        self.error_message = None
        self.provisioning_state = None


class PeeringRegisteredPrefixListResult(msrest.serialization.Model):
    """The paginated list of peering registered prefixes.

    :param value: The list of peering registered prefixes.
    :type value: list[~azure.mgmt.peering.models.PeeringRegisteredPrefix]
    :param next_link: The link to fetch the next page of peering registered prefixes.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringRegisteredPrefix]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringRegisteredPrefixListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringService(Resource):
    """Peering Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param sku: The SKU that defines the type of the peering service.
    :type sku: ~azure.mgmt.peering.models.PeeringServiceSku
    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param peering_service_location: The PeeringServiceLocation of the Customer.
    :type peering_service_location: str
    :param peering_service_provider: The MAPS Provider Name.
    :type peering_service_provider: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'PeeringServiceSku'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_service_location': {'key': 'properties.peeringServiceLocation', 'type': 'str'},
        'peering_service_provider': {'key': 'properties.peeringServiceProvider', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringService, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.peering_service_location = kwargs.get('peering_service_location', None)
        self.peering_service_provider = kwargs.get('peering_service_provider', None)
        self.provisioning_state = None


class PeeringServiceCountry(Resource):
    """The peering service country.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceCountry, self).__init__(**kwargs)


class PeeringServiceCountryListResult(msrest.serialization.Model):
    """The paginated list of peering service countries.

    :param value: The list of peering service countries.
    :type value: list[~azure.mgmt.peering.models.Resource]
    :param next_link: The link to fetch the next page of peering service countries.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Resource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceCountryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringServiceListResult(msrest.serialization.Model):
    """The paginated list of peering services.

    :param value: The list of peering services.
    :type value: list[~azure.mgmt.peering.models.PeeringService]
    :param next_link: The link to fetch the next page of peering services.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringServiceLocation(Resource):
    """The peering service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param country: Country of the customer.
    :type country: str
    :param state: State of the customer.
    :type state: str
    :param azure_region: Azure region for the location.
    :type azure_region: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_region': {'key': 'properties.azureRegion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceLocation, self).__init__(**kwargs)
        self.country = kwargs.get('country', None)
        self.state = kwargs.get('state', None)
        self.azure_region = kwargs.get('azure_region', None)


class PeeringServiceLocationListResult(msrest.serialization.Model):
    """The paginated list of peering service locations.

    :param value: The list of peering service locations.
    :type value: list[~azure.mgmt.peering.models.PeeringServiceLocation]
    :param next_link: The link to fetch the next page of peering service locations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringServiceLocation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceLocationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringServicePrefix(Resource):
    """The peering service prefix class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param prefix: The prefix from which your traffic originates.
    :type prefix: str
    :ivar prefix_validation_state: The prefix validation state. Possible values include: "None",
     "Invalid", "Verified", "Failed", "Pending", "Warning", "Unknown".
    :vartype prefix_validation_state: str or ~azure.mgmt.peering.models.PrefixValidationState
    :ivar learned_type: The prefix learned type. Possible values include: "None",
     "ViaServiceProvider", "ViaSession".
    :vartype learned_type: str or ~azure.mgmt.peering.models.LearnedType
    :ivar error_message: The error message for validation state.
    :vartype error_message: str
    :ivar events: The list of events for peering service prefix.
    :vartype events: list[~azure.mgmt.peering.models.PeeringServicePrefixEvent]
    :param peering_service_prefix_key: The peering service prefix key.
    :type peering_service_prefix_key: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.peering.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'prefix_validation_state': {'readonly': True},
        'learned_type': {'readonly': True},
        'error_message': {'readonly': True},
        'events': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'prefix_validation_state': {'key': 'properties.prefixValidationState', 'type': 'str'},
        'learned_type': {'key': 'properties.learnedType', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[PeeringServicePrefixEvent]'},
        'peering_service_prefix_key': {'key': 'properties.peeringServicePrefixKey', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServicePrefix, self).__init__(**kwargs)
        self.prefix = kwargs.get('prefix', None)
        self.prefix_validation_state = None
        self.learned_type = None
        self.error_message = None
        self.events = None
        self.peering_service_prefix_key = kwargs.get('peering_service_prefix_key', None)
        self.provisioning_state = None


class PeeringServicePrefixEvent(msrest.serialization.Model):
    """The details of the event associated with a prefix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar event_timestamp: The timestamp of the event associated with a prefix.
    :vartype event_timestamp: ~datetime.datetime
    :ivar event_type: The type of the event associated with a prefix.
    :vartype event_type: str
    :ivar event_summary: The summary of the event associated with a prefix.
    :vartype event_summary: str
    :ivar event_level: The level of the event associated with a prefix.
    :vartype event_level: str
    :ivar event_description: The description of the event associated with a prefix.
    :vartype event_description: str
    """

    _validation = {
        'event_timestamp': {'readonly': True},
        'event_type': {'readonly': True},
        'event_summary': {'readonly': True},
        'event_level': {'readonly': True},
        'event_description': {'readonly': True},
    }

    _attribute_map = {
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'event_summary': {'key': 'eventSummary', 'type': 'str'},
        'event_level': {'key': 'eventLevel', 'type': 'str'},
        'event_description': {'key': 'eventDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServicePrefixEvent, self).__init__(**kwargs)
        self.event_timestamp = None
        self.event_type = None
        self.event_summary = None
        self.event_level = None
        self.event_description = None


class PeeringServicePrefixListResult(msrest.serialization.Model):
    """The paginated list of peering service prefixes.

    :param value: The list of peering service prefixes.
    :type value: list[~azure.mgmt.peering.models.PeeringServicePrefix]
    :param next_link: The link to fetch the next page of peering service prefixes.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringServicePrefix]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServicePrefixListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringServiceProvider(Resource):
    """PeeringService provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param service_provider_name: The name of the service provider.
    :type service_provider_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_provider_name': {'key': 'properties.serviceProviderName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceProvider, self).__init__(**kwargs)
        self.service_provider_name = kwargs.get('service_provider_name', None)


class PeeringServiceProviderListResult(msrest.serialization.Model):
    """The paginated list of peering service providers.

    :param value: The list of peering service providers.
    :type value: list[~azure.mgmt.peering.models.PeeringServiceProvider]
    :param next_link: The link to fetch the next page of peering service providers.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PeeringServiceProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceProviderListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PeeringServiceSku(msrest.serialization.Model):
    """The SKU that defines the type of the peering service.

    :param name: The name of the peering service SKU.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringServiceSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class PeeringSku(msrest.serialization.Model):
    """The SKU that defines the tier and kind of the peering.

    :param name: The name of the peering SKU.
    :type name: str
    :param tier: The tier of the peering SKU. Possible values include: "Basic", "Premium".
    :type tier: str or ~azure.mgmt.peering.models.Tier
    :param family: The family of the peering SKU. Possible values include: "Direct", "Exchange".
    :type family: str or ~azure.mgmt.peering.models.Family
    :param size: The size of the peering SKU. Possible values include: "Free", "Metered",
     "Unlimited".
    :type size: str or ~azure.mgmt.peering.models.Size
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeeringSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.family = kwargs.get('family', None)
        self.size = kwargs.get('size', None)


class ResourceTags(msrest.serialization.Model):
    """The resource tags.

    :param tags: A set of tags. Gets or sets the tags, a dictionary of descriptors arm object.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceTags, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class SubResource(msrest.serialization.Model):
    """The sub resource.

    :param id: The identifier of the referenced resource.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
